/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.jvm.PoolWriter;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.ToIntFunction;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class ClassWriter
extends ClassFile {
    protected static final Context.Key<ClassWriter> classWriterKey = new Context.Key();
    private final Options options;
    private boolean verbose;
    private boolean emitSourceFile;
    private boolean genCrt;
    private boolean debugstackmap;
    private Preview preview;
    private Target target;
    private Source source;
    private Types types;
    private Check check;
    public boolean multiModuleMode;
    private List<ToIntFunction<Symbol>> extraAttributeHooks = List.nil();
    static final int DATA_BUF_SIZE = 65520;
    static final int CLASS_BUF_SIZE = 131056;
    public ByteBuffer databuf = new ByteBuffer(65520);
    ByteBuffer poolbuf = new ByteBuffer(131056);
    final PoolWriter poolWriter;
    private final Log log;
    private final Names names;
    private final JavaFileManager fileManager;
    static final int SAME_FRAME_SIZE = 64;
    static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    static final int SAME_FRAME_EXTENDED = 251;
    static final int FULL_FRAME = 255;
    static final int MAX_LOCAL_LENGTH_DIFF = 4;
    private boolean dumpClassModifiers;
    private boolean dumpFieldModifiers;
    private boolean dumpInnerClassModifiers;
    private boolean dumpMethodModifiers;
    private static final String[] flagName = new String[]{"PUBLIC", "PRIVATE", "PROTECTED", "STATIC", "FINAL", "SUPER", "VOLATILE", "TRANSIENT", "NATIVE", "INTERFACE", "ABSTRACT", "STRICTFP"};
    AttributeWriter awriter = new AttributeWriter();

    public static ClassWriter instance(Context context) {
        ClassWriter classWriter = context.get(classWriterKey);
        if (classWriter == null) {
            classWriter = new ClassWriter(context);
        }
        return classWriter;
    }

    protected ClassWriter(Context context) {
        context.put(classWriterKey, this);
        this.log = Log.instance(context);
        this.names = Names.instance(context);
        this.options = Options.instance(context);
        this.preview = Preview.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.types = Types.instance(context);
        this.check = Check.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.poolWriter = Gen.instance((Context)context).poolWriter;
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.genCrt = this.options.isSet(Option.XJCOV);
        this.debugstackmap = this.options.isSet("debug.stackmap");
        this.emitSourceFile = this.options.isUnset(Option.G_CUSTOM) || this.options.isSet(Option.G_CUSTOM, "source");
        String string = this.options.get("debug.dumpmodifiers");
        if (string != null) {
            this.dumpClassModifiers = string.indexOf(99) != -1;
            this.dumpFieldModifiers = string.indexOf(102) != -1;
            this.dumpInnerClassModifiers = string.indexOf(105) != -1;
            this.dumpMethodModifiers = string.indexOf(109) != -1;
        }
    }

    public void addExtraAttributes(ToIntFunction<Symbol> toIntFunction) {
        this.extraAttributeHooks = this.extraAttributeHooks.prepend(toIntFunction);
    }

    public static String flagNames(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        long l2 = l & 0xFFFL;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                stringBuilder.append(" ");
                stringBuilder.append(flagName[n]);
            }
            l2 >>= 1;
            ++n;
        }
        return stringBuilder.toString();
    }

    void putChar(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 & 0xFF);
    }

    void putInt(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 24 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byteBuffer.elems[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 3] = (byte)(n2 & 0xFF);
    }

    public int writeAttr(Name name) {
        int n = this.poolWriter.putName(name);
        this.databuf.appendChar(n);
        this.databuf.appendInt(0);
        return this.databuf.length;
    }

    public void endAttr(int n) {
        this.putInt(this.databuf, n - 4, this.databuf.length - n);
    }

    int beginAttrs() {
        this.databuf.appendChar(0);
        return this.databuf.length;
    }

    void endAttrs(int n, int n2) {
        this.putChar(this.databuf, n - 2, n2);
    }

    int writeEnclosingMethodAttribute(Symbol.ClassSymbol classSymbol) {
        return this.writeEnclosingMethodAttribute(this.names.EnclosingMethod, classSymbol);
    }

    protected int writeEnclosingMethodAttribute(Name name, Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner.kind != Kinds.Kind.MTH && classSymbol.name != this.names.empty) {
            return 0;
        }
        int n = this.writeAttr(name);
        Symbol.ClassSymbol classSymbol2 = classSymbol.owner.enclClass();
        Symbol.MethodSymbol methodSymbol = classSymbol.owner.type == null || classSymbol.owner.kind != Kinds.Kind.MTH ? null : ((Symbol.MethodSymbol)classSymbol.owner).originalEnclosingMethod();
        this.databuf.appendChar(this.poolWriter.putClass(classSymbol2));
        this.databuf.appendChar(methodSymbol == null ? 0 : this.poolWriter.putNameAndType(methodSymbol));
        this.endAttr(n);
        return 1;
    }

    int writeFlagAttrs(long l) {
        int n = 0;
        if ((l & 0x20000L) != 0L) {
            int n2 = this.writeAttr(this.names.Deprecated);
            this.endAttr(n2);
            ++n;
        }
        return n;
    }

    int writeMemberAttrs(Symbol symbol, boolean bl) {
        long l;
        int n = 0;
        if (!bl) {
            n = this.writeFlagAttrs(symbol.flags());
        }
        if (((l = symbol.flags()) & 0x80001000L) != 4096L && (l & 0x20000000L) == 0L && (!this.types.isSameType(symbol.type, symbol.erasure(this.types)) || this.poolWriter.signatureGen.hasTypeVar(symbol.type.getThrownTypes()))) {
            int n2 = this.writeAttr(this.names.Signature);
            this.databuf.appendChar(this.poolWriter.putSignature(symbol));
            this.endAttr(n2);
            ++n;
        }
        n += this.writeJavaAnnotations(symbol.getRawAttributes());
        return n += this.writeTypeAnnotations(symbol.getRawTypeAttributes(), false);
    }

    int writeMethodParametersAttr(Symbol.MethodSymbol methodSymbol) {
        Type.MethodType methodType = methodSymbol.externalType(this.types).asMethodType();
        int n = methodType.argtypes.size();
        if (methodSymbol.params != null && n != 0) {
            int n2;
            int n3 = this.writeAttr(this.names.MethodParameters);
            this.databuf.appendByte(n);
            for (Symbol.VarSymbol varSymbol : methodSymbol.extraParams) {
                n2 = (int)varSymbol.flags() & 0x9010 | (int)methodSymbol.flags() & 0x1000;
                this.databuf.appendChar(this.poolWriter.putName(varSymbol.name));
                this.databuf.appendChar(n2);
            }
            for (Symbol.VarSymbol varSymbol : methodSymbol.params) {
                n2 = (int)varSymbol.flags() & 0x9010 | (int)methodSymbol.flags() & 0x1000;
                this.databuf.appendChar(this.poolWriter.putName(varSymbol.name));
                this.databuf.appendChar(n2);
            }
            for (Symbol.VarSymbol varSymbol : methodSymbol.capturedLocals) {
                n2 = (int)varSymbol.flags() & 0x9010 | (int)methodSymbol.flags() & 0x1000;
                this.databuf.appendChar(this.poolWriter.putName(varSymbol.name));
                this.databuf.appendChar(n2);
            }
            this.endAttr(n3);
            return 1;
        }
        return 0;
    }

    private void writeParamAnnotations(List<Symbol.VarSymbol> list, Attribute.RetentionPolicy retentionPolicy) {
        this.databuf.appendByte(list.length());
        for (Symbol.VarSymbol varSymbol : list) {
            ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
            for (Attribute.Compound compound : varSymbol.getRawAttributes()) {
                if (this.types.getRetention(compound) != retentionPolicy) continue;
                listBuffer.append(compound);
            }
            this.databuf.appendChar(listBuffer.length());
            for (Attribute.Compound compound : listBuffer) {
                this.writeCompoundAttribute(compound);
            }
        }
    }

    private void writeParamAnnotations(Symbol.MethodSymbol methodSymbol, Attribute.RetentionPolicy retentionPolicy) {
        this.databuf.appendByte(methodSymbol.params.length());
        this.writeParamAnnotations(methodSymbol.params, retentionPolicy);
    }

    int writeParameterAttrs(List<Symbol.VarSymbol> list) {
        boolean bl = false;
        boolean bl2 = false;
        if (list != null) {
            for (Symbol.VarSymbol varSymbol : list) {
                for (Attribute.Compound compound : varSymbol.getRawAttributes()) {
                    switch (this.types.getRetention(compound)) {
                        case SOURCE: {
                            break;
                        }
                        case CLASS: {
                            bl2 = true;
                            break;
                        }
                        case RUNTIME: {
                            bl = true;
                            break;
                        }
                    }
                }
            }
        }
        int n = 0;
        if (bl) {
            int n2 = this.writeAttr(this.names.RuntimeVisibleParameterAnnotations);
            this.writeParamAnnotations(list, Attribute.RetentionPolicy.RUNTIME);
            this.endAttr(n2);
            ++n;
        }
        if (bl2) {
            int n3 = this.writeAttr(this.names.RuntimeInvisibleParameterAnnotations);
            this.writeParamAnnotations(list, Attribute.RetentionPolicy.CLASS);
            this.endAttr(n3);
            ++n;
        }
        return n;
    }

    int writeJavaAnnotations(List<Attribute.Compound> list) {
        if (list.isEmpty()) {
            return 0;
        }
        ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
        ListBuffer<Attribute.Compound> listBuffer2 = new ListBuffer<Attribute.Compound>();
        for (Attribute.Compound compound : list) {
            switch (this.types.getRetention(compound)) {
                case SOURCE: {
                    break;
                }
                case CLASS: {
                    listBuffer2.append(compound);
                    break;
                }
                case RUNTIME: {
                    listBuffer.append(compound);
                    break;
                }
            }
        }
        int n = 0;
        if (listBuffer.length() != 0) {
            int n2 = this.writeAttr(this.names.RuntimeVisibleAnnotations);
            this.databuf.appendChar(listBuffer.length());
            for (Attribute.Compound compound : listBuffer) {
                this.writeCompoundAttribute(compound);
            }
            this.endAttr(n2);
            ++n;
        }
        if (listBuffer2.length() != 0) {
            int n3 = this.writeAttr(this.names.RuntimeInvisibleAnnotations);
            this.databuf.appendChar(listBuffer2.length());
            for (Attribute.Compound compound : listBuffer2) {
                this.writeCompoundAttribute(compound);
            }
            this.endAttr(n3);
            ++n;
        }
        return n;
    }

    int writeTypeAnnotations(List<Attribute.TypeCompound> list, boolean bl) {
        if (list.isEmpty()) {
            return 0;
        }
        ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Attribute.TypeCompound> listBuffer2 = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound typeCompound : list) {
            boolean bl2;
            if (typeCompound.hasUnknownPosition() && !(bl2 = typeCompound.tryFixPosition())) {
                PrintWriter object = this.log.getWriter(Log.WriterKind.ERROR);
                object.println("ClassWriter: Position UNKNOWN in type annotation: " + typeCompound);
                continue;
            }
            if (typeCompound.position.type.isLocal() != bl || !typeCompound.position.emitToClassfile()) continue;
            switch (this.types.getRetention(typeCompound)) {
                case SOURCE: {
                    break;
                }
                case CLASS: {
                    listBuffer2.append(typeCompound);
                    break;
                }
                case RUNTIME: {
                    listBuffer.append(typeCompound);
                    break;
                }
            }
        }
        int n = 0;
        if (listBuffer.length() != 0) {
            int n2 = this.writeAttr(this.names.RuntimeVisibleTypeAnnotations);
            this.databuf.appendChar(listBuffer.length());
            for (Attribute.TypeCompound typeCompound : listBuffer) {
                this.writeTypeAnnotation(typeCompound);
            }
            this.endAttr(n2);
            ++n;
        }
        if (listBuffer2.length() != 0) {
            int n3 = this.writeAttr(this.names.RuntimeInvisibleTypeAnnotations);
            this.databuf.appendChar(listBuffer2.length());
            for (Attribute.TypeCompound typeCompound : listBuffer2) {
                this.writeTypeAnnotation(typeCompound);
            }
            this.endAttr(n3);
            ++n;
        }
        return n;
    }

    void writeCompoundAttribute(Attribute.Compound compound) {
        this.databuf.appendChar(this.poolWriter.putDescriptor(compound.type));
        this.databuf.appendChar(compound.values.length());
        for (Pair<Symbol.MethodSymbol, Attribute> pair : compound.values) {
            this.databuf.appendChar(this.poolWriter.putName(((Symbol.MethodSymbol)pair.fst).name));
            ((Attribute)pair.snd).accept(this.awriter);
        }
    }

    void writeTypeAnnotation(Attribute.TypeCompound typeCompound) {
        this.writePosition(typeCompound.position);
        this.writeCompoundAttribute(typeCompound);
    }

    void writePosition(TypeAnnotationPosition typeAnnotationPosition) {
        this.databuf.appendByte(typeAnnotationPosition.type.targetTypeValue());
        switch (typeAnnotationPosition.type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                this.databuf.appendChar(typeAnnotationPosition.offset);
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                this.databuf.appendChar(typeAnnotationPosition.lvarOffset.length);
                for (int i = 0; i < typeAnnotationPosition.lvarOffset.length; ++i) {
                    this.databuf.appendChar(typeAnnotationPosition.lvarOffset[i]);
                    this.databuf.appendChar(typeAnnotationPosition.lvarLength[i]);
                    this.databuf.appendChar(typeAnnotationPosition.lvarIndex[i]);
                }
                break;
            }
            case EXCEPTION_PARAMETER: {
                this.databuf.appendChar(typeAnnotationPosition.getExceptionIndex());
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                this.databuf.appendByte(typeAnnotationPosition.parameter_index);
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                this.databuf.appendByte(typeAnnotationPosition.parameter_index);
                this.databuf.appendByte(typeAnnotationPosition.bound_index);
                break;
            }
            case CLASS_EXTENDS: {
                this.databuf.appendChar(typeAnnotationPosition.type_index);
                break;
            }
            case THROWS: {
                this.databuf.appendChar(typeAnnotationPosition.type_index);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                this.databuf.appendByte(typeAnnotationPosition.parameter_index);
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                this.databuf.appendChar(typeAnnotationPosition.offset);
                this.databuf.appendByte(typeAnnotationPosition.type_index);
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"jvm.ClassWriter: UNKNOWN target type should never occur!");
            }
            default: {
                throw new AssertionError((Object)("jvm.ClassWriter: Unknown target type for position: " + typeAnnotationPosition));
            }
        }
        this.databuf.appendByte(typeAnnotationPosition.location.size());
        List<Integer> list = TypeAnnotationPosition.getBinaryFromTypePath(typeAnnotationPosition.location);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.databuf.appendByte((byte)n);
        }
    }

    int writeModuleAttribute(Symbol.ClassSymbol classSymbol3) {
        List<Directive.UsesDirective> list;
        Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)classSymbol3.owner;
        int n = this.writeAttr(this.names.Module);
        this.databuf.appendChar(this.poolWriter.putModule(moduleSymbol));
        this.databuf.appendChar(Symbol.ModuleFlags.value(moduleSymbol.flags));
        this.databuf.appendChar(moduleSymbol.version != null ? this.poolWriter.putName(moduleSymbol.version) : 0);
        ListBuffer<Directive.RequiresDirective> listBuffer = new ListBuffer<Directive.RequiresDirective>();
        for (Directive.RequiresDirective list22 : moduleSymbol.requires) {
            if (list22.flags.contains((Object)Directive.RequiresFlag.EXTRA)) continue;
            listBuffer.add(list22);
        }
        this.databuf.appendChar(listBuffer.size());
        for (Directive.RequiresDirective requiresDirective : listBuffer) {
            this.databuf.appendChar(this.poolWriter.putModule(requiresDirective.module));
            this.databuf.appendChar(Directive.RequiresFlag.value(requiresDirective.flags));
            this.databuf.appendChar(requiresDirective.module.version != null ? this.poolWriter.putName(requiresDirective.module.version) : 0);
        }
        List<Directive.ExportsDirective> list3 = moduleSymbol.exports;
        this.databuf.appendChar(list3.size());
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            list = (Directive.ExportsDirective)iterator.next();
            this.databuf.appendChar(this.poolWriter.putPackage(((Directive.ExportsDirective)((Object)list)).packge));
            this.databuf.appendChar(Directive.ExportsFlag.value(((Directive.ExportsDirective)((Object)list)).flags));
            if (((Directive.ExportsDirective)((Object)list)).modules == null) {
                this.databuf.appendChar(0);
                continue;
            }
            this.databuf.appendChar(((Directive.ExportsDirective)((Object)list)).modules.size());
            for (Symbol.ModuleSymbol moduleSymbol2 : ((Directive.ExportsDirective)((Object)list)).modules) {
                this.databuf.appendChar(this.poolWriter.putModule(moduleSymbol2));
            }
        }
        List<Directive.OpensDirective> list2 = moduleSymbol.opens;
        this.databuf.appendChar(list2.size());
        for (Directive.OpensDirective opensDirective : list2) {
            this.databuf.appendChar(this.poolWriter.putPackage(opensDirective.packge));
            this.databuf.appendChar(Directive.OpensFlag.value(opensDirective.flags));
            if (opensDirective.modules == null) {
                this.databuf.appendChar(0);
                continue;
            }
            this.databuf.appendChar(opensDirective.modules.size());
            for (Symbol.ModuleSymbol moduleSymbol3 : opensDirective.modules) {
                this.databuf.appendChar(this.poolWriter.putModule(moduleSymbol3));
            }
        }
        list = moduleSymbol.uses;
        this.databuf.appendChar(list.size());
        for (Directive.UsesDirective usesDirective : list) {
            this.databuf.appendChar(this.poolWriter.putClass(usesDirective.service));
        }
        LinkedHashMap<Symbol.ClassSymbol, Set> linkedHashMap = new LinkedHashMap<Symbol.ClassSymbol, Set>();
        for (Directive.ProvidesDirective providesDirective : moduleSymbol.provides) {
            linkedHashMap.computeIfAbsent(providesDirective.service, classSymbol -> new LinkedHashSet()).addAll(providesDirective.impls);
        }
        this.databuf.appendChar(linkedHashMap.size());
        linkedHashMap.forEach((classSymbol2, set) -> {
            this.databuf.appendChar(this.poolWriter.putClass((Symbol.ClassSymbol)classSymbol2));
            this.databuf.appendChar(set.size());
            set.forEach(classSymbol -> this.databuf.appendChar(this.poolWriter.putClass((Symbol.ClassSymbol)classSymbol)));
        });
        this.endAttr(n);
        return 1;
    }

    void writeInnerClasses() {
        int n = this.writeAttr(this.names.InnerClasses);
        this.databuf.appendChar(this.poolWriter.innerClasses.size());
        for (Symbol.ClassSymbol classSymbol : this.poolWriter.innerClasses) {
            classSymbol.markAbstractIfNeeded(this.types);
            int n2 = this.adjustFlags(classSymbol.flags_field);
            if ((n2 & 0x200) != 0) {
                n2 |= 0x400;
            }
            n2 &= 0xFFFFF7FF;
            if (this.dumpInnerClassModifiers) {
                PrintWriter printWriter = this.log.getWriter(Log.WriterKind.ERROR);
                printWriter.println("INNERCLASS  " + classSymbol.name);
                printWriter.println("---" + ClassWriter.flagNames(n2));
            }
            this.databuf.appendChar(this.poolWriter.putClass(classSymbol));
            this.databuf.appendChar(classSymbol.owner.kind == Kinds.Kind.TYP && !classSymbol.name.isEmpty() ? this.poolWriter.putClass((Symbol.ClassSymbol)classSymbol.owner) : 0);
            this.databuf.appendChar(!classSymbol.name.isEmpty() ? this.poolWriter.putName(classSymbol.name) : 0);
            this.databuf.appendChar(n2);
        }
        this.endAttr(n);
    }

    int writeRecordAttribute(Symbol.ClassSymbol classSymbol) {
        int n = this.writeAttr(this.names.Record);
        Scope.WriteableScope writeableScope = classSymbol.members();
        this.databuf.appendChar(((List)classSymbol.getRecordComponents()).size());
        for (Symbol.VarSymbol varSymbol : classSymbol.getRecordComponents()) {
            this.databuf.appendChar(this.poolWriter.putName(varSymbol.name));
            this.databuf.appendChar(this.poolWriter.putDescriptor(varSymbol));
            int n2 = this.beginAttrs();
            int n3 = 0;
            this.endAttrs(n2, n3 += this.writeMemberAttrs(varSymbol, true));
        }
        this.endAttr(n);
        return 1;
    }

    int writeNestMembersIfNeeded(Symbol.ClassSymbol classSymbol) {
        ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
        this.listNested(classSymbol, listBuffer);
        LinkedHashSet<Symbol.ClassSymbol> linkedHashSet = new LinkedHashSet<Symbol.ClassSymbol>(listBuffer);
        if (classSymbol.owner.kind == Kinds.Kind.PCK && !linkedHashSet.isEmpty()) {
            int n = this.writeAttr(this.names.NestMembers);
            this.databuf.appendChar(linkedHashSet.size());
            for (Symbol.ClassSymbol classSymbol2 : linkedHashSet) {
                this.databuf.appendChar(this.poolWriter.putClass(classSymbol2));
            }
            this.endAttr(n);
            return 1;
        }
        return 0;
    }

    int writeNestHostIfNeeded(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner.kind != Kinds.Kind.PCK) {
            int n = this.writeAttr(this.names.NestHost);
            this.databuf.appendChar(this.poolWriter.putClass(classSymbol.outermostClass()));
            this.endAttr(n);
            return 1;
        }
        return 0;
    }

    private void listNested(Symbol symbol, ListBuffer<Symbol.ClassSymbol> listBuffer) {
        if (symbol.kind != Kinds.Kind.TYP) {
            return;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
        if (classSymbol.owner.kind != Kinds.Kind.PCK) {
            listBuffer.add(classSymbol);
        }
        if (classSymbol.members() != null) {
            for (Symbol symbol2 : symbol.members().getSymbols()) {
                this.listNested(symbol2, listBuffer);
            }
        }
        if (classSymbol.trans_local != null) {
            for (Symbol symbol2 : classSymbol.trans_local) {
                this.listNested(symbol2, listBuffer);
            }
        }
    }

    int writePermittedSubclassesIfNeeded(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.permitted.nonEmpty()) {
            int n = this.writeAttr(this.target.hasSealedClasses() ? this.names.PermittedSubclasses : this.names.FrgaalPermittedSubclasses);
            this.databuf.appendChar(classSymbol.permitted.size());
            for (Symbol symbol : classSymbol.permitted) {
                this.databuf.appendChar(this.poolWriter.putClass((Symbol.ClassSymbol)symbol));
            }
            this.endAttr(n);
            return 1;
        }
        return 0;
    }

    void writeBootstrapMethods() {
        int n = this.writeAttr(this.names.BootstrapMethods);
        this.databuf.appendChar(this.poolWriter.bootstrapMethods.size());
        for (PoolConstant.Dynamic.BsmKey bsmKey : this.poolWriter.bootstrapMethods.keySet()) {
            this.databuf.appendChar(this.poolWriter.putConstant(bsmKey.bsm));
            PoolConstant.LoadableConstant[] loadableConstantArray = bsmKey.staticArgs;
            this.databuf.appendChar(loadableConstantArray.length);
            for (PoolConstant.LoadableConstant loadableConstant : loadableConstantArray) {
                this.databuf.appendChar(this.poolWriter.putConstant(loadableConstant));
            }
        }
        this.endAttr(n);
    }

    void writeField(Symbol.VarSymbol varSymbol) {
        int n = this.adjustFlags(varSymbol.flags());
        this.databuf.appendChar(n);
        if (this.dumpFieldModifiers) {
            PrintWriter printWriter = this.log.getWriter(Log.WriterKind.ERROR);
            printWriter.println("FIELD  " + varSymbol.name);
            printWriter.println("---" + ClassWriter.flagNames(varSymbol.flags()));
        }
        this.databuf.appendChar(this.poolWriter.putName(varSymbol.name));
        this.databuf.appendChar(this.poolWriter.putDescriptor(varSymbol));
        int n2 = this.beginAttrs();
        int n3 = 0;
        if (varSymbol.getConstValue() != null) {
            int n4 = this.writeAttr(this.names.ConstantValue);
            this.databuf.appendChar(this.poolWriter.putConstant(varSymbol.getConstValue()));
            this.endAttr(n4);
            ++n3;
        }
        n3 += this.writeMemberAttrs(varSymbol, false);
        this.endAttrs(n2, n3 += this.writeExtraAttributes(varSymbol));
    }

    void writeMethod(Symbol.MethodSymbol methodSymbol) {
        int n;
        List<Type> list;
        int n2 = this.adjustFlags(methodSymbol.flags());
        this.databuf.appendChar(n2);
        if (this.dumpMethodModifiers) {
            PrintWriter printWriter = this.log.getWriter(Log.WriterKind.ERROR);
            printWriter.println("METHOD  " + methodSymbol.name);
            printWriter.println("---" + ClassWriter.flagNames(methodSymbol.flags()));
        }
        this.databuf.appendChar(this.poolWriter.putName(methodSymbol.name));
        this.databuf.appendChar(this.poolWriter.putDescriptor(methodSymbol));
        int n3 = this.beginAttrs();
        int n4 = 0;
        if (methodSymbol.code != null) {
            int n5 = this.writeAttr(this.names.Code);
            this.writeCode(methodSymbol.code);
            methodSymbol.code = null;
            this.endAttr(n5);
            ++n4;
        }
        if ((list = methodSymbol.erasure(this.types).getThrownTypes()).nonEmpty()) {
            n = this.writeAttr(this.names.Exceptions);
            this.databuf.appendChar(list.length());
            List<Type> list2 = list;
            while (list2.nonEmpty()) {
                this.databuf.appendChar(this.poolWriter.putClass((Type)list2.head));
                list2 = list2.tail;
            }
            this.endAttr(n);
            ++n4;
        }
        if (methodSymbol.defaultValue != null) {
            n = this.writeAttr(this.names.AnnotationDefault);
            methodSymbol.defaultValue.accept(this.awriter);
            this.endAttr(n);
            ++n4;
        }
        if (this.target.hasMethodParameters() && (this.options.isSet(Option.PARAMETERS) || methodSymbol.isConstructor() && (methodSymbol.flags_field & 0x2000000000000000L) != 0L) && !methodSymbol.isLambdaMethod()) {
            n4 += this.writeMethodParametersAttr(methodSymbol);
        }
        n4 += this.writeMemberAttrs(methodSymbol, false);
        if (!methodSymbol.isLambdaMethod()) {
            n4 += this.writeParameterAttrs(methodSymbol.params);
        }
        this.endAttrs(n3, n4 += this.writeExtraAttributes(methodSymbol));
    }

    void writeCode(Code code) {
        int n;
        int n2;
        int n3;
        int n4;
        this.databuf.appendChar(code.max_stack);
        this.databuf.appendChar(code.max_locals);
        this.databuf.appendInt(code.cp);
        this.databuf.appendBytes(code.code, 0, code.cp);
        this.databuf.appendChar(code.catchInfo.length());
        List<Object> list = code.catchInfo.toList();
        while (list.nonEmpty()) {
            for (n4 = 0; n4 < ((char[])list.head).length; ++n4) {
                this.databuf.appendChar(((char[])list.head)[n4]);
            }
            list = list.tail;
        }
        int n5 = this.beginAttrs();
        n4 = 0;
        if (code.lineInfo.nonEmpty()) {
            n3 = this.writeAttr(this.names.LineNumberTable);
            this.databuf.appendChar(code.lineInfo.length());
            List<Object> list2 = code.lineInfo.reverse();
            while (list2.nonEmpty()) {
                for (n2 = 0; n2 < ((char[])list2.head).length; ++n2) {
                    this.databuf.appendChar(((char[])list2.head)[n2]);
                }
                list2 = list2.tail;
            }
            this.endAttr(n3);
            ++n4;
        }
        if (this.genCrt && code.crt != null) {
            CRTable cRTable = code.crt;
            int n6 = this.writeAttr(this.names.CharacterRangeTable);
            n2 = this.beginAttrs();
            n = cRTable.writeCRT(this.databuf, code.lineMap, this.log);
            this.endAttrs(n2, n);
            this.endAttr(n6);
            ++n4;
        }
        if (code.varDebugInfo && code.varBufferSize > 0) {
            n3 = 0;
            int n7 = this.writeAttr(this.names.LocalVariableTable);
            this.databuf.appendChar(code.getLVTSize());
            for (n2 = 0; n2 < code.varBufferSize; ++n2) {
                Code.LocalVar localVar = code.varBuffer[n2];
                for (Code.LocalVar.Range object : localVar.aliveRanges) {
                    Assert.check(object.start_pc >= '\u0000' && object.start_pc <= code.cp);
                    this.databuf.appendChar(object.start_pc);
                    Assert.check(object.length > '\u0000' && object.start_pc + object.length <= code.cp);
                    this.databuf.appendChar(object.length);
                    Symbol.VarSymbol varSymbol = localVar.sym;
                    this.databuf.appendChar(this.poolWriter.putName(varSymbol.name));
                    this.databuf.appendChar(this.poolWriter.putDescriptor(varSymbol));
                    this.databuf.appendChar(localVar.reg);
                    if (!this.needsLocalVariableTypeEntry(localVar.sym.type)) continue;
                    ++n3;
                }
            }
            this.endAttr(n7);
            ++n4;
            if (n3 > 0) {
                n7 = this.writeAttr(this.names.LocalVariableTypeTable);
                this.databuf.appendChar(n3);
                n2 = 0;
                for (n = 0; n < code.varBufferSize; ++n) {
                    Code.LocalVar localVar = code.varBuffer[n];
                    Symbol.VarSymbol varSymbol = localVar.sym;
                    if (!this.needsLocalVariableTypeEntry(varSymbol.type)) continue;
                    for (Code.LocalVar.Range range : localVar.aliveRanges) {
                        this.databuf.appendChar(range.start_pc);
                        this.databuf.appendChar(range.length);
                        this.databuf.appendChar(this.poolWriter.putName(varSymbol.name));
                        this.databuf.appendChar(this.poolWriter.putSignature(varSymbol));
                        this.databuf.appendChar(localVar.reg);
                        ++n2;
                    }
                }
                Assert.check(n2 == n3);
                this.endAttr(n7);
                ++n4;
            }
        }
        if (code.stackMapBufferSize > 0) {
            if (this.debugstackmap) {
                System.out.println("Stack map for " + code.meth);
            }
            n3 = this.writeAttr(code.stackMap.getAttributeName(this.names));
            this.writeStackMap(code);
            this.endAttr(n3);
            ++n4;
        }
        this.endAttrs(n5, n4 += this.writeTypeAnnotations(code.meth.getRawTypeAttributes(), true));
    }

    private boolean needsLocalVariableTypeEntry(Type type) {
        return !this.types.isSameType(type, this.types.erasure(type)) && this.check.checkDenotable(type);
    }

    void writeStackMap(Code code) {
        int n = code.stackMapBufferSize;
        if (this.debugstackmap) {
            System.out.println(" nframes = " + n);
        }
        this.databuf.appendChar(n);
        switch (code.stackMap) {
            case CLDC: {
                for (int i = 0; i < n; ++i) {
                    int n2;
                    int n3;
                    if (this.debugstackmap) {
                        System.out.print("  " + i + ":");
                    }
                    Code.StackMapFrame stackMapFrame = code.stackMapBuffer[i];
                    if (this.debugstackmap) {
                        System.out.print(" pc=" + stackMapFrame.pc);
                    }
                    this.databuf.appendChar(stackMapFrame.pc);
                    int n4 = 0;
                    for (n3 = 0; n3 < stackMapFrame.locals.length; n3 += Code.width(stackMapFrame.locals[n3])) {
                        ++n4;
                    }
                    if (this.debugstackmap) {
                        System.out.print(" nlocals=" + n4);
                    }
                    this.databuf.appendChar(n4);
                    for (n3 = 0; n3 < stackMapFrame.locals.length; n3 += Code.width(stackMapFrame.locals[n3])) {
                        if (this.debugstackmap) {
                            System.out.print(" local[" + n3 + "]=");
                        }
                        this.writeStackMapType(stackMapFrame.locals[n3]);
                    }
                    n3 = 0;
                    for (n2 = 0; n2 < stackMapFrame.stack.length; n2 += Code.width(stackMapFrame.stack[n2])) {
                        ++n3;
                    }
                    if (this.debugstackmap) {
                        System.out.print(" nstack=" + n3);
                    }
                    this.databuf.appendChar(n3);
                    for (n2 = 0; n2 < stackMapFrame.stack.length; n2 += Code.width(stackMapFrame.stack[n2])) {
                        if (this.debugstackmap) {
                            System.out.print(" stack[" + n2 + "]=");
                        }
                        this.writeStackMapType(stackMapFrame.stack[n2]);
                    }
                    if (!this.debugstackmap) continue;
                    System.out.println();
                }
                break;
            }
            case JSR202: {
                Assert.checkNull(code.stackMapBuffer);
                for (int i = 0; i < n; ++i) {
                    if (this.debugstackmap) {
                        System.out.print("  " + i + ":");
                    }
                    StackMapTableFrame stackMapTableFrame = code.stackMapTableBuffer[i];
                    stackMapTableFrame.write(this);
                    if (!this.debugstackmap) continue;
                    System.out.println();
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected stackmap format value");
            }
        }
    }

    void writeStackMapType(Type type) {
        if (type == null) {
            if (this.debugstackmap) {
                System.out.print("empty");
            }
            this.databuf.appendByte(0);
        } else {
            switch (type.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case BOOLEAN: {
                    if (this.debugstackmap) {
                        System.out.print("int");
                    }
                    this.databuf.appendByte(1);
                    break;
                }
                case FLOAT: {
                    if (this.debugstackmap) {
                        System.out.print("float");
                    }
                    this.databuf.appendByte(2);
                    break;
                }
                case DOUBLE: {
                    if (this.debugstackmap) {
                        System.out.print("double");
                    }
                    this.databuf.appendByte(3);
                    break;
                }
                case LONG: {
                    if (this.debugstackmap) {
                        System.out.print("long");
                    }
                    this.databuf.appendByte(4);
                    break;
                }
                case BOT: {
                    if (this.debugstackmap) {
                        System.out.print("null");
                    }
                    this.databuf.appendByte(5);
                    break;
                }
                case CLASS: 
                case ARRAY: 
                case TYPEVAR: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + this.types.erasure((Type)type).tsym + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.poolWriter.putClass(this.types.erasure(type)));
                    break;
                }
                case UNINITIALIZED_THIS: {
                    if (this.debugstackmap) {
                        System.out.print("uninit_this");
                    }
                    this.databuf.appendByte(6);
                    break;
                }
                case UNINITIALIZED_OBJECT: {
                    UninitializedType uninitializedType = (UninitializedType)type;
                    this.databuf.appendByte(8);
                    if (this.debugstackmap) {
                        System.out.print("uninit_object@" + uninitializedType.offset);
                    }
                    this.databuf.appendChar(uninitializedType.offset);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    void writeFields(Scope scope) {
        List<Symbol.VarSymbol> list = List.nil();
        for (Symbol symbol : scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (symbol.kind != Kinds.Kind.VAR) continue;
            list = list.prepend((Symbol.VarSymbol)symbol);
        }
        while (list.nonEmpty()) {
            this.writeField((Symbol.VarSymbol)list.head);
            list = list.tail;
        }
    }

    void writeMethods(Scope scope) {
        List<Symbol.MethodSymbol> list = List.nil();
        for (Symbol symbol : scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (symbol.kind != Kinds.Kind.MTH || (symbol.flags() & 0x2000000000L) != 0L) continue;
            list = list.prepend((Symbol.MethodSymbol)symbol);
        }
        while (list.nonEmpty()) {
            this.writeMethod((Symbol.MethodSymbol)list.head);
            list = list.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFileObject writeClass(Symbol.ClassSymbol classSymbol) throws IOException, PoolOverflow, StringOverflow {
        JavaFileManager.Location location;
        Object object;
        String string = (classSymbol.owner.kind == Kinds.Kind.MDL ? classSymbol.name : classSymbol.flatname).toString();
        if (this.multiModuleMode) {
            object = classSymbol.owner.kind == Kinds.Kind.MDL ? (Symbol.ModuleSymbol)classSymbol.owner : classSymbol.packge().modle;
            location = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, ((Symbol.ModuleSymbol)object).name.toString());
        } else {
            location = StandardLocation.CLASS_OUTPUT;
        }
        object = this.fileManager.getJavaFileForOutput(location, string, JavaFileObject.Kind.CLASS, classSymbol.sourcefile);
        OutputStream outputStream = object.openOutputStream();
        try {
            this.writeClassFile(outputStream, classSymbol);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", object.getName());
            }
            outputStream.close();
            outputStream = null;
        }
        catch (Types.SignatureGenerator.InvalidSignatureException invalidSignatureException) {
            this.log.error(CompilerProperties.Errors.CannotGenerateClass(classSymbol, CompilerProperties.Fragments.IllegalSignature(classSymbol, invalidSignatureException.type())));
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                object.delete();
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public void writeClassFile(OutputStream outputStream, Symbol.ClassSymbol classSymbol) throws IOException, PoolOverflow, StringOverflow {
        void var10_33;
        void var10_30;
        void var10_29;
        void var10_25;
        void var10_19;
        List<Type> list;
        int n;
        Assert.check((classSymbol.flags() & 0x1000000L) == 0L);
        this.databuf.reset();
        this.poolbuf.reset();
        Type type = this.types.supertype(classSymbol.type);
        List<Type> list2 = this.types.interfaces(classSymbol.type);
        List<Type> list3 = classSymbol.type.getTypeArguments();
        if (classSymbol.owner.kind == Kinds.Kind.MDL) {
            n = 32768;
        } else {
            n = this.adjustFlags(classSymbol.flags() & 0xFFFFF7FFFFFFFFFFL);
            if ((n & 4) != 0) {
                n |= 1;
            }
            if (((n = n & 0x7E11 & 0xFFFFF7FF) & 0x200) == 0) {
                n |= 0x20;
            }
        }
        if (this.dumpClassModifiers) {
            list = this.log.getWriter(Log.WriterKind.ERROR);
            ((PrintWriter)((Object)list)).println();
            ((PrintWriter)((Object)list)).println("CLASSFILE  " + classSymbol.getQualifiedName());
            ((PrintWriter)((Object)list)).println("---" + ClassWriter.flagNames(n));
        }
        this.databuf.appendChar(n);
        if (classSymbol.owner.kind == Kinds.Kind.MDL) {
            list = ((Symbol.ModuleSymbol)classSymbol.owner).unnamedPackage;
            this.databuf.appendChar(this.poolWriter.putClass(new Symbol.ClassSymbol(0L, this.names.module_info, (Symbol)((Object)list))));
        } else {
            this.databuf.appendChar(this.poolWriter.putClass(classSymbol));
        }
        this.databuf.appendChar(type.hasTag(TypeTag.CLASS) ? this.poolWriter.putClass((Symbol.ClassSymbol)type.tsym) : 0);
        this.databuf.appendChar(list2.length());
        list = list2;
        while (list.nonEmpty()) {
            this.databuf.appendChar(this.poolWriter.putClass((Symbol.ClassSymbol)((Type)list.head).tsym));
            list = list.tail;
        }
        int n2 = 0;
        int n3 = 0;
        block6: for (Symbol symbol : classSymbol.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            switch (symbol.kind) {
                case VAR: {
                    ++n2;
                    continue block6;
                }
                case MTH: {
                    if ((symbol.flags() & 0x2000000000L) != 0L) continue block6;
                    ++n3;
                    continue block6;
                }
                case TYP: {
                    this.poolWriter.enterInner((Symbol.ClassSymbol)symbol);
                    continue block6;
                }
            }
            Assert.error();
        }
        if (classSymbol.trans_local != null) {
            for (Symbol.ClassSymbol classSymbol2 : classSymbol.trans_local) {
                this.poolWriter.enterInner(classSymbol2);
            }
        }
        this.databuf.appendChar(n2);
        this.writeFields(classSymbol.members());
        this.databuf.appendChar(n3);
        this.writeMethods(classSymbol.members());
        int n4 = this.beginAttrs();
        boolean bl = false;
        boolean bl2 = list3.length() != 0 || type.allparams().length() != 0;
        List<Type> list4 = list2;
        while (!bl2 && list4.nonEmpty()) {
            bl2 = ((Type)list4.head).allparams().length() != 0;
            list4 = list4.tail;
        }
        if (bl2) {
            void var10_16;
            int n5 = this.writeAttr(this.names.Signature);
            this.databuf.appendChar(this.poolWriter.putSignature(classSymbol));
            this.endAttr(n5);
            ++var10_16;
        }
        if (classSymbol.sourcefile != null && this.emitSourceFile) {
            void var10_17;
            int n6 = this.writeAttr(this.names.SourceFile);
            String string = PathFileObject.getSimpleName(classSymbol.sourcefile);
            this.databuf.appendChar(this.poolWriter.putName(this.names.fromString(string)));
            this.endAttr(n6);
            ++var10_17;
        }
        if (this.genCrt) {
            void var10_18;
            int n7 = this.writeAttr(this.names.SourceID);
            this.databuf.appendChar(this.poolWriter.putName(this.names.fromString(Long.toString(this.getLastModified(classSymbol.sourcefile)))));
            this.endAttr(n7);
            ++var10_18;
            n7 = this.writeAttr(this.names.CompilationID);
            this.databuf.appendChar(this.poolWriter.putName(this.names.fromString(Long.toString(System.currentTimeMillis()))));
            this.endAttr(n7);
            ++var10_19;
        }
        void var10_23 = var10_19 + this.writeFlagAttrs(classSymbol.flags());
        var10_23 = var10_23 + this.writeJavaAnnotations(classSymbol.getRawAttributes());
        var10_23 = var10_23 + this.writeTypeAnnotations(classSymbol.getRawTypeAttributes(), false);
        var10_23 = var10_23 + this.writeEnclosingMethodAttribute(classSymbol);
        if (classSymbol.owner.kind == Kinds.Kind.MDL) {
            void var10_25 = var10_23 + this.writeModuleAttribute(classSymbol);
            var10_25 = var10_25 + this.writeFlagAttrs(classSymbol.owner.flags() & 0xFFFFFFFFFFFDFFFFL);
        }
        void var10_27 = var10_25 + this.writeExtraClassAttributes(classSymbol);
        var10_27 = var10_27 + this.writeExtraAttributes(classSymbol);
        this.poolbuf.appendInt(-889275714);
        if (this.preview.isEnabled() && this.target == Target.DEFAULT && this.preview.usesPreview(classSymbol.sourcefile)) {
            this.poolbuf.appendChar(65535);
        } else {
            this.poolbuf.appendChar(this.target.minorVersion);
        }
        this.poolbuf.appendChar(this.target.majorVersion);
        if (classSymbol.owner.kind != Kinds.Kind.MDL && this.target.hasNestmateAccess()) {
            void var10_29 = var10_27 + this.writeNestMembersIfNeeded(classSymbol);
            var10_29 = var10_29 + this.writeNestHostIfNeeded(classSymbol);
        }
        if (classSymbol.isRecord()) {
            var10_30 = var10_29 + this.writeRecordAttribute(classSymbol);
        }
        void var10_31 = var10_30 + this.writePermittedSubclassesIfNeeded(classSymbol);
        if (!this.poolWriter.bootstrapMethods.isEmpty()) {
            void var10_32;
            this.writeBootstrapMethods();
            ++var10_32;
        }
        if (!this.poolWriter.innerClasses.isEmpty()) {
            this.writeInnerClasses();
            ++var10_33;
        }
        this.endAttrs(n4, (int)var10_33);
        outputStream.write(this.poolbuf.elems, 0, this.poolbuf.length);
        this.poolWriter.writePool(outputStream);
        this.poolWriter.reset();
        outputStream.write(this.databuf.elems, 0, this.databuf.length);
    }

    protected int writeExtraClassAttributes(Symbol.ClassSymbol classSymbol) {
        return 0;
    }

    protected int writeExtraAttributes(Symbol symbol) {
        int n = 0;
        for (ToIntFunction<Symbol> toIntFunction : this.extraAttributeHooks) {
            n += toIntFunction.applyAsInt(symbol);
        }
        return n;
    }

    int adjustFlags(long l) {
        int n = (int)l;
        if (this.target.obsoleteAccStrict()) {
            n &= 0xFFFFF7FF;
        }
        if ((l & 0x80000000L) != 0L) {
            n |= 0x40;
        }
        if ((l & 0x400000000L) != 0L) {
            n |= 0x80;
        }
        if ((l & 0x80000000000L) != 0L) {
            n &= 0xFFFFFBFF;
        }
        return n;
    }

    long getLastModified(FileObject fileObject) {
        long l = 0L;
        try {
            l = fileObject.getLastModified();
        }
        catch (SecurityException securityException) {
            throw new AssertionError((Object)("CRT: couldn't get source file modification date: " + securityException.getMessage()));
        }
        return l;
    }

    class AttributeWriter
    implements Attribute.Visitor {
        AttributeWriter() {
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            if (constant.type.getTag() == TypeTag.CLASS) {
                Assert.check(constant.value instanceof String);
                String string = (String)constant.value;
                ClassWriter.this.databuf.appendByte(115);
                ClassWriter.this.databuf.appendChar(ClassWriter.this.poolWriter.putName(ClassWriter.this.names.fromString(string)));
            } else {
                switch (constant.type.getTag()) {
                    case BYTE: {
                        ClassWriter.this.databuf.appendByte(66);
                        break;
                    }
                    case CHAR: {
                        ClassWriter.this.databuf.appendByte(67);
                        break;
                    }
                    case SHORT: {
                        ClassWriter.this.databuf.appendByte(83);
                        break;
                    }
                    case INT: {
                        ClassWriter.this.databuf.appendByte(73);
                        break;
                    }
                    case LONG: {
                        ClassWriter.this.databuf.appendByte(74);
                        break;
                    }
                    case FLOAT: {
                        ClassWriter.this.databuf.appendByte(70);
                        break;
                    }
                    case DOUBLE: {
                        ClassWriter.this.databuf.appendByte(68);
                        break;
                    }
                    case BOOLEAN: {
                        ClassWriter.this.databuf.appendByte(90);
                        break;
                    }
                    default: {
                        throw new AssertionError(constant.type);
                    }
                }
                ClassWriter.this.databuf.appendChar(ClassWriter.this.poolWriter.putConstant(constant.value));
            }
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            ClassWriter.this.databuf.appendByte(101);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.poolWriter.putDescriptor(enum_.value.type));
            ClassWriter.this.databuf.appendChar(ClassWriter.this.poolWriter.putName(enum_.value.name));
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            ClassWriter.this.databuf.appendByte(99);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.poolWriter.putDescriptor(clazz.classType));
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            ClassWriter.this.databuf.appendByte(64);
            ClassWriter.this.writeCompoundAttribute(compound);
        }

        @Override
        public void visitError(Attribute.Error error) {
            throw new AssertionError(error);
        }

        @Override
        public void visitArray(Attribute.Array array) {
            ClassWriter.this.databuf.appendByte(91);
            ClassWriter.this.databuf.appendChar(array.values.length);
            for (Attribute attribute : array.values) {
                attribute.accept(this);
            }
        }
    }

    static abstract class StackMapTableFrame {
        StackMapTableFrame() {
        }

        abstract int getFrameType();

        void write(ClassWriter classWriter) {
            int n = this.getFrameType();
            classWriter.databuf.appendByte(n);
            if (classWriter.debugstackmap) {
                System.out.print(" frame_type=" + n);
            }
        }

        static StackMapTableFrame getInstance(Code.StackMapFrame stackMapFrame, int n, Type[] typeArray, Types types) {
            Type[] typeArray2 = stackMapFrame.locals;
            Type[] typeArray3 = stackMapFrame.stack;
            int n2 = stackMapFrame.pc - n - 1;
            if (typeArray3.length == 1) {
                if (typeArray2.length == typeArray.length && StackMapTableFrame.compare(typeArray, typeArray2, types) == 0) {
                    return new SameLocals1StackItemFrame(n2, typeArray3[0]);
                }
            } else if (typeArray3.length == 0) {
                int n3 = StackMapTableFrame.compare(typeArray, typeArray2, types);
                if (n3 == 0) {
                    return new SameFrame(n2);
                }
                if (-4 < n3 && n3 < 0) {
                    Type[] typeArray4 = new Type[-n3];
                    int n4 = typeArray.length;
                    int n5 = 0;
                    while (n4 < typeArray2.length) {
                        typeArray4[n5] = typeArray2[n4];
                        ++n4;
                        ++n5;
                    }
                    return new AppendFrame(251 - n3, n2, typeArray4);
                }
                if (0 < n3 && n3 < 4) {
                    return new ChopFrame(251 - n3, n2);
                }
            }
            return new FullFrame(n2, typeArray2, typeArray3);
        }

        static boolean isInt(Type type) {
            return type.getTag().isStrictSubRangeOf(TypeTag.INT) || type.hasTag(TypeTag.BOOLEAN);
        }

        static boolean isSameType(Type type, Type type2, Types types) {
            if (type == null) {
                return type2 == null;
            }
            if (type2 == null) {
                return false;
            }
            if (StackMapTableFrame.isInt(type) && StackMapTableFrame.isInt(type2)) {
                return true;
            }
            if (type.hasTag(TypeTag.UNINITIALIZED_THIS)) {
                return type2.hasTag(TypeTag.UNINITIALIZED_THIS);
            }
            if (type.hasTag(TypeTag.UNINITIALIZED_OBJECT)) {
                if (type2.hasTag(TypeTag.UNINITIALIZED_OBJECT)) {
                    return ((UninitializedType)type).offset == ((UninitializedType)type2).offset;
                }
                return false;
            }
            if (type2.hasTag(TypeTag.UNINITIALIZED_THIS) || type2.hasTag(TypeTag.UNINITIALIZED_OBJECT)) {
                return false;
            }
            return types.isSameType(type, type2);
        }

        static int compare(Type[] typeArray, Type[] typeArray2, Types types) {
            int n = typeArray.length - typeArray2.length;
            if (n > 4 || n < -4) {
                return Integer.MAX_VALUE;
            }
            int n2 = n > 0 ? typeArray2.length : typeArray.length;
            for (int i = 0; i < n2; ++i) {
                if (StackMapTableFrame.isSameType(typeArray[i], typeArray2[i], types)) continue;
                return Integer.MAX_VALUE;
            }
            return n;
        }

        static class SameLocals1StackItemFrame
        extends StackMapTableFrame {
            final int offsetDelta;
            final Type stack;

            SameLocals1StackItemFrame(int n, Type type) {
                this.offsetDelta = n;
                this.stack = type;
            }

            @Override
            int getFrameType() {
                return this.offsetDelta < 64 ? 64 + this.offsetDelta : 247;
            }

            @Override
            void write(ClassWriter classWriter) {
                super.write(classWriter);
                if (this.getFrameType() == 247) {
                    classWriter.databuf.appendChar(this.offsetDelta);
                    if (classWriter.debugstackmap) {
                        System.out.print(" offset_delta=" + this.offsetDelta);
                    }
                }
                if (classWriter.debugstackmap) {
                    System.out.print(" stack[0]=");
                }
                classWriter.writeStackMapType(this.stack);
            }
        }

        static class SameFrame
        extends StackMapTableFrame {
            final int offsetDelta;

            SameFrame(int n) {
                this.offsetDelta = n;
            }

            @Override
            int getFrameType() {
                return this.offsetDelta < 64 ? this.offsetDelta : 251;
            }

            @Override
            void write(ClassWriter classWriter) {
                super.write(classWriter);
                if (this.getFrameType() == 251) {
                    classWriter.databuf.appendChar(this.offsetDelta);
                    if (classWriter.debugstackmap) {
                        System.out.print(" offset_delta=" + this.offsetDelta);
                    }
                }
            }
        }

        static class AppendFrame
        extends StackMapTableFrame {
            final int frameType;
            final int offsetDelta;
            final Type[] locals;

            AppendFrame(int n, int n2, Type[] typeArray) {
                this.frameType = n;
                this.offsetDelta = n2;
                this.locals = typeArray;
            }

            @Override
            int getFrameType() {
                return this.frameType;
            }

            @Override
            void write(ClassWriter classWriter) {
                super.write(classWriter);
                classWriter.databuf.appendChar(this.offsetDelta);
                if (classWriter.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                }
                for (int i = 0; i < this.locals.length; ++i) {
                    if (classWriter.debugstackmap) {
                        System.out.print(" locals[" + i + "]=");
                    }
                    classWriter.writeStackMapType(this.locals[i]);
                }
            }
        }

        static class ChopFrame
        extends StackMapTableFrame {
            final int frameType;
            final int offsetDelta;

            ChopFrame(int n, int n2) {
                this.frameType = n;
                this.offsetDelta = n2;
            }

            @Override
            int getFrameType() {
                return this.frameType;
            }

            @Override
            void write(ClassWriter classWriter) {
                super.write(classWriter);
                classWriter.databuf.appendChar(this.offsetDelta);
                if (classWriter.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                }
            }
        }

        static class FullFrame
        extends StackMapTableFrame {
            final int offsetDelta;
            final Type[] locals;
            final Type[] stack;

            FullFrame(int n, Type[] typeArray, Type[] typeArray2) {
                this.offsetDelta = n;
                this.locals = typeArray;
                this.stack = typeArray2;
            }

            @Override
            int getFrameType() {
                return 255;
            }

            @Override
            void write(ClassWriter classWriter) {
                int n;
                super.write(classWriter);
                classWriter.databuf.appendChar(this.offsetDelta);
                classWriter.databuf.appendChar(this.locals.length);
                if (classWriter.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                    System.out.print(" nlocals=" + this.locals.length);
                }
                for (n = 0; n < this.locals.length; ++n) {
                    if (classWriter.debugstackmap) {
                        System.out.print(" locals[" + n + "]=");
                    }
                    classWriter.writeStackMapType(this.locals[n]);
                }
                classWriter.databuf.appendChar(this.stack.length);
                if (classWriter.debugstackmap) {
                    System.out.print(" nstack=" + this.stack.length);
                }
                for (n = 0; n < this.stack.length; ++n) {
                    if (classWriter.debugstackmap) {
                        System.out.print(" stack[" + n + "]=");
                    }
                    classWriter.writeStackMapType(this.stack[n]);
                }
            }
        }
    }

    public static class StringOverflow
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        public final String value;

        public StringOverflow(String string) {
            this.value = string;
        }
    }

    public static class PoolOverflow
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
    }
}

