/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.PoolReader;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.tools.JavaFileObject;

public class ModuleNameReader {
    private static final int INITIAL_BUFFER_SIZE = 65520;
    private ByteBuffer buf = new ByteBuffer(65520);
    private int bp;
    private PoolReader reader;

    public String readModuleName(Path path) throws IOException, BadClassFile {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            String string = this.readModuleName(inputStream);
            return string;
        }
    }

    public String readModuleName(JavaFileObject javaFileObject) throws IOException, BadClassFile {
        try (InputStream inputStream = javaFileObject.openInputStream();){
            String string = this.readModuleName(inputStream);
            return string;
        }
    }

    public String readModuleName(InputStream inputStream) throws IOException, BadClassFile {
        this.bp = 0;
        this.buf.reset();
        this.buf.appendStream(inputStream);
        int n = this.nextInt();
        if (n != -889275714) {
            throw new BadClassFile("illegal.start.of.class.file");
        }
        char c = this.nextChar();
        char c2 = this.nextChar();
        if (c2 < '5') {
            throw new BadClassFile("bad major version number for module: " + c2);
        }
        this.reader = new PoolReader(this.buf);
        this.bp = this.reader.readPool(this.buf, this.bp);
        char c3 = this.nextChar();
        if (c3 != '\u8000') {
            throw new BadClassFile("invalid access flags for module: 0x" + Integer.toHexString(c3));
        }
        char c4 = this.nextChar();
        this.checkZero(this.nextChar(), "super_class");
        this.checkZero(this.nextChar(), "interface_count");
        this.checkZero(this.nextChar(), "fields_count");
        this.checkZero(this.nextChar(), "methods_count");
        int n2 = this.nextChar();
        for (int i = 0; i < n2; ++i) {
            char c5 = this.nextChar();
            int n3 = this.nextInt();
            if (this.reader.peekName(c5, this.utf8Mapper(false)).equals("Module") && n3 > 2) {
                return this.reader.peekModuleName(this.nextChar(), this.utf8Mapper(true));
            }
            this.bp += n3;
        }
        throw new BadClassFile("no Module attribute");
    }

    void checkZero(int n, String string) throws BadClassFile {
        if (n != 0) {
            throw new BadClassFile("invalid " + string + " for module: " + n);
        }
    }

    char nextChar() {
        char c = this.buf.getChar(this.bp);
        this.bp += 2;
        return c;
    }

    int nextInt() {
        int n = this.buf.getInt(this.bp);
        this.bp += 4;
        return n;
    }

    Name.NameMapper<String> utf8Mapper(boolean bl) {
        return bl ? (byArray, n, n2) -> Convert.utf2string(ClassFile.internalize(byArray, n, n2)) : Convert::utf2string;
    }

    public static class BadClassFile
    extends Exception {
        private static final long serialVersionUID = 0L;

        BadClassFile(String string) {
            super(string);
        }
    }
}

