/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.Objects;
import java.util.stream.Stream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface PoolConstant {
    default public Object poolKey(Types types) {
        return this;
    }

    public int poolTag();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class NameAndType
    implements PoolConstant {
        final Name name;
        final Type type;

        NameAndType(Name name, Type type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public int poolTag() {
            return 12;
        }

        @Override
        public Object poolKey(Types types) {
            return new Pair<Name, Types.UniqueType>(this.name, new Types.UniqueType(this.type, types));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Dynamic
    extends PoolConstant {
        public PoolConstant dynamicType();

        public Name name();

        public LoadableConstant[] staticArgs();

        public LoadableConstant bootstrapMethod();

        default public BsmKey bsmKey(Types types) {
            return new BsmKey(types, this.bootstrapMethod(), this.staticArgs());
        }

        @Override
        default public Object poolKey(Types types) {
            return new PoolKey(this.name(), this.bsmKey(types), this.dynamicType().poolKey(types));
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static class BsmKey {
            public final LoadableConstant bsm;
            public final LoadableConstant[] staticArgs;
            private final Object bsmKey;
            private final List<?> staticArgKeys;

            private BsmKey(Types types, LoadableConstant loadableConstant2, LoadableConstant[] loadableConstantArray) {
                this.bsm = loadableConstant2;
                this.bsmKey = loadableConstant2.poolKey(types);
                this.staticArgs = loadableConstantArray;
                this.staticArgKeys = Stream.of(loadableConstantArray).map(loadableConstant -> loadableConstant.poolKey(types)).collect(List.collector());
            }

            public int hashCode() {
                return this.bsmKey.hashCode() + this.staticArgKeys.hashCode();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object object) {
                if (!(object instanceof BsmKey)) return false;
                BsmKey bsmKey = (BsmKey)object;
                if (!Objects.equals(this.bsmKey, bsmKey.bsmKey)) return false;
                if (!Objects.equals(this.staticArgKeys, bsmKey.staticArgKeys)) return false;
                return true;
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static final class PoolKey {
            private final Name name;
            private final BsmKey bsmKey;
            private final Object dynamicType;

            public PoolKey(Name name, BsmKey bsmKey, Object object) {
                this.name = name;
                this.bsmKey = bsmKey;
                this.dynamicType = object;
            }

            public final String toString() {
                return "PoolKey[" + "name=" + Objects.toString(this.name) + ", bsmKey=" + Objects.toString(this.bsmKey) + ", dynamicType=" + Objects.toString(this.dynamicType) + "]";
            }

            public final int hashCode() {
                return 31 * (31 * (31 * 0 + Objects.hashCode(this.name)) + Objects.hashCode(this.bsmKey)) + Objects.hashCode(this.dynamicType);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean equals(Object object) {
                if (!(object instanceof PoolKey)) return false;
                PoolKey poolKey = (PoolKey)object;
                if (!Objects.equals(this.dynamicType, poolKey.dynamicType)) return false;
                if (!Objects.equals(this.bsmKey, poolKey.bsmKey)) return false;
                if (!Objects.equals(this.name, poolKey.name)) return false;
                return true;
            }

            public Name name() {
                return this.name;
            }

            public BsmKey bsmKey() {
                return this.bsmKey;
            }

            public Object dynamicType() {
                return this.dynamicType;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface LoadableConstant
    extends PoolConstant {
        public static LoadableConstant Int(int n) {
            return new BasicConstant(3, n);
        }

        public static LoadableConstant Float(float f) {
            return new BasicConstant(4, Float.valueOf(f));
        }

        public static LoadableConstant Long(long l) {
            return new BasicConstant(5, l);
        }

        public static LoadableConstant Double(double d) {
            return new BasicConstant(6, d);
        }

        public static LoadableConstant String(String string) {
            return new BasicConstant(8, string);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static class BasicConstant
        implements LoadableConstant {
            int tag;
            Object data;

            private BasicConstant(int n, Object object) {
                this.tag = n;
                this.data = object;
            }

            @Override
            public int poolTag() {
                return this.tag;
            }

            @Override
            public Object poolKey(Types types) {
                return this.data;
            }
        }
    }
}

