/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.jvm.Items;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

public abstract class StringConcat {
    private static final int MAX_INDY_CONCAT_ARG_SLOTS = 200;
    private static final char TAG_ARG = '\u0001';
    private static final char TAG_CONST = '\u0002';
    protected final Gen gen;
    protected final Symtab syms;
    protected final Names names;
    protected final TreeMaker make;
    protected final Types types;
    protected final Map<Type, Symbol> sbAppends;
    protected final Resolve rs;
    protected static final Context.Key<StringConcat> concatKey = new Context.Key();

    public static StringConcat instance(Context context) {
        StringConcat stringConcat = context.get(concatKey);
        if (stringConcat == null) {
            stringConcat = StringConcat.makeConcat(context);
        }
        return stringConcat;
    }

    private static StringConcat makeConcat(Context context) {
        Target target = Target.instance(context);
        String string = Options.instance(context).get("stringConcat");
        if (target.hasStringConcatFactory()) {
            if (string == null) {
                string = "indyWithConstants";
            }
        } else {
            if (string != null && !"inline".equals(string)) {
                Assert.error("StringConcatFactory-based string concat is requested on a platform that does not support it.");
            }
            string = "inline";
        }
        switch (string) {
            case "inline": {
                return new Inline(context);
            }
            case "indy": {
                return new IndyPlain(context);
            }
            case "indyWithConstants": {
                return new IndyConstants(context);
            }
        }
        Assert.error("Unknown stringConcat: " + string);
        throw new IllegalStateException("Unknown stringConcat: " + string);
    }

    protected StringConcat(Context context) {
        context.put(concatKey, this);
        this.gen = Gen.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.names = Names.instance(context);
        this.make = TreeMaker.instance(context);
        this.rs = Resolve.instance(context);
        this.sbAppends = new HashMap<Type, Symbol>();
    }

    public abstract Items.Item makeConcat(JCTree.JCAssignOp var1);

    public abstract Items.Item makeConcat(JCTree.JCBinary var1);

    protected List<JCTree> collectAll(JCTree jCTree) {
        return this.collect(jCTree, List.nil());
    }

    protected List<JCTree> collectAll(JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        return List.nil().appendList(this.collectAll(jCExpression)).appendList(this.collectAll(jCExpression2));
    }

    private List<JCTree> collect(JCTree jCTree, List<JCTree> list) {
        if ((jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.PLUS) && jCTree.type.constValue() == null) {
            JCTree.JCBinary jCBinary = (JCTree.JCBinary)jCTree;
            if (jCBinary.operator.kind == Kinds.Kind.MTH && jCBinary.operator.opcode == 256) {
                return list.appendList(this.collect(jCBinary.lhs, list)).appendList(this.collect(jCBinary.rhs, list));
            }
        }
        return list.append(jCTree);
    }

    private static class Inline
    extends StringConcat {
        public Inline(Context context) {
            super(context);
        }

        @Override
        public Items.Item makeConcat(JCTree.JCAssignOp jCAssignOp) {
            JCDiagnostic.DiagnosticPosition diagnosticPosition = jCAssignOp.pos();
            this.newStringBuilder(jCAssignOp);
            Items.Item item = this.gen.genExpr(jCAssignOp.lhs, jCAssignOp.lhs.type);
            if (item.width() > 0) {
                this.gen.getCode().emitop0(90 + 3 * (item.width() - 1));
            }
            item.load();
            this.appendString(jCAssignOp.lhs);
            List<JCTree> list = this.collectAll(jCAssignOp.rhs);
            for (JCTree jCTree : list) {
                this.gen.genExpr(jCTree, jCTree.type).load();
                this.appendString(jCTree);
            }
            this.builderToString(diagnosticPosition);
            return item;
        }

        @Override
        public Items.Item makeConcat(JCTree.JCBinary jCBinary) {
            JCDiagnostic.DiagnosticPosition diagnosticPosition = jCBinary.pos();
            this.newStringBuilder(jCBinary);
            List<JCTree> list = this.collectAll(jCBinary);
            for (JCTree jCTree : list) {
                this.gen.genExpr(jCTree, jCTree.type).load();
                this.appendString(jCTree);
            }
            this.builderToString(diagnosticPosition);
            return this.gen.getItems().makeStackItem(this.syms.stringType);
        }

        private JCDiagnostic.DiagnosticPosition newStringBuilder(JCTree jCTree) {
            JCDiagnostic.DiagnosticPosition diagnosticPosition = jCTree.pos();
            this.gen.getCode().emitop2(187, this.gen.makeRef(diagnosticPosition, this.syms.stringBuilderType), this.syms.stringBuilderType);
            this.gen.getCode().emitop0(89);
            this.gen.callMethod(diagnosticPosition, this.syms.stringBuilderType, this.names.init, List.nil(), false);
            return diagnosticPosition;
        }

        private void appendString(JCTree jCTree) {
            Type type = jCTree.type.baseType();
            if (!type.isPrimitive() && type.tsym != this.syms.stringType.tsym) {
                type = this.syms.objectType;
            }
            Assert.checkNull(type.constValue());
            Symbol symbol = (Symbol)this.sbAppends.get(type);
            if (symbol == null) {
                symbol = this.rs.resolveInternalMethod(jCTree.pos(), this.gen.getAttrEnv(), this.syms.stringBuilderType, this.names.append, List.of(type), null);
                this.sbAppends.put(type, symbol);
            }
            this.gen.getItems().makeMemberItem(symbol, false).invoke();
        }

        private void builderToString(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
            this.gen.callMethod(diagnosticPosition, this.syms.stringBuilderType, this.names.toString, List.nil(), false);
        }
    }

    private static class IndyPlain
    extends Indy {
        public IndyPlain(Context context) {
            super(context);
        }

        @Override
        protected void emit(JCDiagnostic.DiagnosticPosition diagnosticPosition, List<JCTree> list, boolean bl, Type type) {
            List<List<JCTree>> list2 = this.split(list);
            boolean bl2 = true;
            for (List<JCTree> list3 : list2) {
                Assert.check(!list3.isEmpty(), "Arguments list is empty");
                ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                for (JCTree jCTree : list3) {
                    Object object = jCTree.type.constValue();
                    if ("".equals(object)) continue;
                    Type type2 = jCTree.type;
                    if (type2 == this.syms.botType) {
                        type2 = this.types.boxedClass((Type)this.syms.voidType).type;
                    }
                    if (!bl2 || bl) {
                        this.gen.genExpr(jCTree, jCTree.type).load();
                    }
                    if (this.shouldConvertToStringEagerly(type2)) {
                        this.gen.callMethod(diagnosticPosition, this.syms.stringType, this.names.valueOf, List.of(this.syms.objectType), true);
                        type2 = this.syms.stringType;
                    }
                    listBuffer.add(type2);
                    bl2 = false;
                }
                this.doCall(type, diagnosticPosition, listBuffer.toList());
            }
            if (list2.size() > 1) {
                ListBuffer listBuffer = new ListBuffer();
                for (int i = 0; i < list2.size(); ++i) {
                    listBuffer.append(this.syms.stringType);
                }
                this.doCall(type, diagnosticPosition, listBuffer.toList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCall(Type type, JCDiagnostic.DiagnosticPosition diagnosticPosition, List<Type> list) {
            Type.MethodType methodType = new Type.MethodType(list, type, List.nil(), this.syms.methodClass);
            int n = this.make.pos;
            try {
                this.make.at(diagnosticPosition);
                List<Type> list2 = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType);
                Symbol.MethodSymbol methodSymbol = this.rs.resolveInternalMethod(diagnosticPosition, this.gen.getAttrEnv(), this.syms.stringConcatFactory, this.names.makeConcat, list2, null);
                Symbol.DynamicMethodSymbol dynamicMethodSymbol = new Symbol.DynamicMethodSymbol(this.names.makeConcat, this.syms.noSymbol, methodSymbol.asHandle(), (Type)methodType, List.nil().toArray(new PoolConstant.LoadableConstant[0]));
                Items.Item item = this.gen.getItems().makeDynamicItem(dynamicMethodSymbol);
                item.invoke();
            }
            finally {
                this.make.at(n);
            }
        }
    }

    private static final class IndyConstants
    extends Indy {
        public IndyConstants(Context context) {
            super(context);
        }

        @Override
        protected void emit(JCDiagnostic.DiagnosticPosition diagnosticPosition, List<JCTree> list, boolean bl, Type type) {
            List<List<JCTree>> list2 = this.split(list);
            boolean bl2 = true;
            for (List<JCTree> list3 : list2) {
                Assert.check(!list3.isEmpty(), "Arguments list is empty");
                StringBuilder stringBuilder = new StringBuilder(list3.size());
                ListBuffer<Object> listBuffer = new ListBuffer<Object>();
                ListBuffer<PoolConstant.LoadableConstant> listBuffer2 = new ListBuffer<PoolConstant.LoadableConstant>();
                for (JCTree jCTree : list3) {
                    Object object;
                    Object object2 = jCTree.type.constValue();
                    if ("".equals(object2)) continue;
                    if (jCTree.type == this.syms.botType) {
                        stringBuilder.append((String)null);
                        continue;
                    }
                    if (object2 != null) {
                        object = jCTree.type.stringValue();
                        if (((String)object).indexOf(2) != -1 || ((String)object).indexOf(1) != -1) {
                            stringBuilder.append('\u0002');
                            listBuffer2.add(PoolConstant.LoadableConstant.String((String)object));
                            continue;
                        }
                        stringBuilder.append((String)object);
                        continue;
                    }
                    stringBuilder.append('\u0001');
                    object = jCTree.type;
                    if (!bl2 || bl) {
                        this.gen.genExpr(jCTree, jCTree.type).load();
                    }
                    if (this.shouldConvertToStringEagerly((Type)object)) {
                        this.gen.callMethod(diagnosticPosition, this.syms.stringType, this.names.valueOf, List.of(this.syms.objectType), true);
                        object = this.syms.stringType;
                    }
                    listBuffer.add(object);
                    bl2 = false;
                }
                this.doCall(type, diagnosticPosition, stringBuilder.toString(), listBuffer2.toList(), listBuffer.toList());
            }
            if (list2.size() > 1) {
                List<JCTree> list3;
                ListBuffer listBuffer = new ListBuffer();
                list3 = new StringBuilder();
                for (int i = 0; i < list2.size(); ++i) {
                    listBuffer.append(this.syms.stringType);
                    ((StringBuilder)((Object)list3)).append('\u0001');
                }
                this.doCall(type, diagnosticPosition, ((StringBuilder)((Object)list3)).toString(), List.nil(), listBuffer.toList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCall(Type type, JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, List<PoolConstant.LoadableConstant> list, List<Type> list2) {
            Type.MethodType methodType = new Type.MethodType(list2, type, List.nil(), this.syms.methodClass);
            int n = this.make.pos;
            try {
                this.make.at(diagnosticPosition);
                ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                ListBuffer<PoolConstant.LoadableConstant> listBuffer2 = new ListBuffer<PoolConstant.LoadableConstant>();
                for (PoolConstant.LoadableConstant poolConstant2 : list) {
                    listBuffer2.add(poolConstant2);
                    listBuffer.add(this.syms.stringType);
                }
                List<Type> list3 = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType).append(this.syms.stringType).appendList(listBuffer);
                Symbol.MethodSymbol methodSymbol = this.rs.resolveInternalMethod(diagnosticPosition, this.gen.getAttrEnv(), this.syms.stringConcatFactory, this.names.makeConcatWithConstants, list3, null);
                Symbol.DynamicMethodSymbol dynamicMethodSymbol = new Symbol.DynamicMethodSymbol(this.names.makeConcatWithConstants, this.syms.noSymbol, methodSymbol.asHandle(), (Type)methodType, List.of(PoolConstant.LoadableConstant.String(string)).appendList(listBuffer2).toArray(new PoolConstant.LoadableConstant[listBuffer2.size()]));
                Items.Item item = this.gen.getItems().makeDynamicItem(dynamicMethodSymbol);
                item.invoke();
            }
            finally {
                this.make.at(n);
            }
        }
    }

    private static abstract class Indy
    extends StringConcat {
        public Indy(Context context) {
            super(context);
        }

        @Override
        public Items.Item makeConcat(JCTree.JCAssignOp jCAssignOp) {
            List<JCTree> list = this.collectAll(jCAssignOp.lhs, jCAssignOp.rhs);
            Items.Item item = this.gen.genExpr(jCAssignOp.lhs, jCAssignOp.lhs.type);
            item.duplicate();
            item.load();
            this.emit(jCAssignOp.pos(), list, false, jCAssignOp.type);
            return item;
        }

        @Override
        public Items.Item makeConcat(JCTree.JCBinary jCBinary) {
            List<JCTree> list = this.collectAll(jCBinary.lhs, jCBinary.rhs);
            this.emit(jCBinary.pos(), list, true, jCBinary.type);
            return this.gen.getItems().makeStackItem(this.syms.stringType);
        }

        protected abstract void emit(JCDiagnostic.DiagnosticPosition var1, List<JCTree> var2, boolean var3, Type var4);

        protected List<List<JCTree>> split(List<JCTree> list) {
            ListBuffer listBuffer = new ListBuffer();
            int n = 0;
            ListBuffer<JCTree> listBuffer2 = new ListBuffer<JCTree>();
            for (JCTree jCTree : list) {
                int n2;
                int n3 = n2 = jCTree.type.getTag() == TypeTag.LONG || jCTree.type.getTag() == TypeTag.DOUBLE ? 2 : 1;
                if (n + n2 >= 200) {
                    listBuffer.add(listBuffer2.toList());
                    listBuffer2.clear();
                    n = 0;
                }
                listBuffer2.add(jCTree);
                n += n2;
            }
            if (!listBuffer2.isEmpty()) {
                listBuffer.add(listBuffer2.toList());
            }
            return listBuffer.toList();
        }

        protected boolean shouldConvertToStringEagerly(Type type) {
            return !this.types.unboxedTypeOrType(type).isPrimitive() && type.tsym != this.syms.stringType.tsym;
        }
    }
}

