/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Closeables;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.DelegatingJavaFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformUtils;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import com.sun.tools.javac.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class Arguments {
    public static final Context.Key<Arguments> argsKey = new Context.Key();
    private String ownName;
    private Set<String> classNames;
    private Set<Path> files;
    private Map<Option, String> deferredFileManagerOptions;
    private Set<JavaFileObject> fileObjects;
    private boolean emptyAllowed;
    private final Options options;
    private JavaFileManager fileManager;
    private final Log log;
    private final Context context;
    private ErrorMode errorMode;
    private boolean errors;
    private final OptionHelper cmdLineHelper = new OptionHelper(){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option);
        }

        @Override
        public void put(String string, String string2) {
            Arguments.this.options.put(string, string2);
        }

        @Override
        public void remove(String string) {
            Arguments.this.options.remove(string);
        }

        @Override
        public boolean handleFileManagerOption(Option option, String string) {
            Arguments.this.options.put(option, string);
            Arguments.this.deferredFileManagerOptions.put(option, string);
            return true;
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }

        @Override
        public String getOwnName() {
            return Arguments.this.ownName;
        }

        @Override
        public void addFile(Path path) {
            Arguments.this.files.add(path);
        }

        @Override
        public void addClassName(String string) {
            Arguments.this.classNames.add(string);
        }
    };
    private final OptionHelper apiHelper = new OptionHelper.GrumpyHelper(null){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option);
        }

        @Override
        public void put(String string, String string2) {
            Arguments.this.options.put(string, string2);
        }

        @Override
        public void remove(String string) {
            Arguments.this.options.remove(string);
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }
    };

    public static Arguments instance(Context context) {
        Arguments arguments = context.get(argsKey);
        if (arguments == null) {
            arguments = new Arguments(context);
        }
        return arguments;
    }

    protected Arguments(Context context) {
        context.put(argsKey, this);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
        this.context = context;
    }

    public void init(String string, Iterable<String> iterable) {
        this.ownName = string;
        this.errorMode = ErrorMode.LOG;
        this.files = new LinkedHashSet<Path>();
        this.deferredFileManagerOptions = new LinkedHashMap<Option, String>();
        this.fileObjects = null;
        this.classNames = new LinkedHashSet<String>();
        this.processArgs(iterable, Option.getJavaCompilerOptions(), this.cmdLineHelper, true, false);
        if (this.errors) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", string);
        }
    }

    public void init(String string, Iterable<String> iterable, Iterable<String> iterable2, Iterable<? extends JavaFileObject> iterable3) {
        this.ownName = string;
        this.classNames = this.toSet(iterable2);
        this.fileObjects = this.toSet(iterable3);
        this.files = null;
        this.errorMode = ErrorMode.ILLEGAL_ARGUMENT;
        if (iterable != null) {
            this.processArgs(this.toList(iterable), Option.getJavacToolOptions(), this.apiHelper, false, true);
        }
        this.errorMode = ErrorMode.ILLEGAL_STATE;
    }

    public void init(String string) {
        this.ownName = string;
        this.errorMode = ErrorMode.LOG;
    }

    public Set<JavaFileObject> getFileObjects() {
        if (this.fileObjects == null) {
            this.fileObjects = new LinkedHashSet<JavaFileObject>();
        }
        if (this.files != null) {
            JavacFileManager javacFileManager = (JavacFileManager)this.getFileManager();
            for (JavaFileObject javaFileObject : javacFileManager.getJavaFileObjectsFromPaths((Collection<? extends Path>)this.files)) {
                this.fileObjects.add(javaFileObject);
            }
        }
        return this.fileObjects;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public boolean handleReleaseOptions(Predicate<Iterable<String>> predicate) {
        Object object;
        Object object2;
        String string = this.options.get(Option.RELEASE);
        this.checkOptionAllowed(string == null, option -> this.reportDiag(CompilerProperties.Errors.ReleaseBootclasspathConflict(option)), Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_APPEND, Option.XBOOTCLASSPATH_PREPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS, Option.SOURCE, Option.TARGET, Option.SYSTEM, Option.UPGRADE_MODULE_PATH);
        if (!(string != null || this.options.isSet(Option.BOOT_CLASS_PATH) || this.options.isSet(Option.XBOOTCLASSPATH) || this.options.isSet(Option.SYSTEM) || this.options.isSet("ignore.symbol.file"))) {
            object2 = Source.instance(this.context);
            object = Target.instance(this.context);
            this.setCtSymPaths((Source)((Object)object2), (Target)((Object)object));
        }
        if (string != null) {
            object2 = PlatformUtils.lookupPlatformDescription(string);
            if (object2 == null) {
                this.reportDiag(CompilerProperties.Errors.UnsupportedReleaseVersion(string));
                return false;
            }
            this.options.put(Option.SOURCE, object2.getSourceVersion());
            this.options.put(Option.TARGET, object2.getTargetVersion());
            this.context.put(PlatformDescription.class, object2);
            if (!predicate.test(object2.getAdditionalOptions())) {
                return false;
            }
            object = object2.getFileManager();
            DelegatingJavaFileManager.installReleaseFileManager(this.context, (JavaFileManager)object, this.getFileManager());
        }
        return true;
    }

    private void setCtSymPaths(Source source, Target target) {
        Arguments.setCtSymPaths(this.context, (StandardJavaFileManager)this.getFileManager(), source, target, new Path[0]);
    }

    public static void setCtSymPaths(Context context, StandardJavaFileManager standardJavaFileManager, Source source, Target target, Path ... pathArray) {
        block32: {
            String string2 = Arguments.targetNumericVersion(target);
            try {
                CtSymRoot ctSymRoot = Arguments.ctSymRoot();
                Closeables closeables = Closeables.instance(context);
                closeables.closeables = closeables.closeables.prepend(ctSymRoot);
                Path path = ctSymRoot.root;
                if (!Source.Feature.MODULES.allowedInSource(source, target)) {
                    ArrayList<Path> arrayList = new ArrayList<Path>();
                    arrayList.addAll(Arrays.asList(pathArray));
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                        for (Path path4 : directoryStream) {
                            if (!path4.getFileName().toString().contains(string2) || path4.getFileName().toString().contains("-")) continue;
                            DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(path4);
                            try {
                                for (Path path5 : directoryStream2) {
                                    arrayList.add(path5);
                                }
                            }
                            finally {
                                if (directoryStream2 == null) continue;
                                directoryStream2.close();
                            }
                        }
                    }
                    standardJavaFileManager.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, arrayList);
                    break block32;
                }
                HashMap<String, java.util.List> hashMap = new HashMap<String, java.util.List>();
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                    Iterator<Path> object = directoryStream.iterator();
                    while (object.hasNext()) {
                        Path path2 = object.next();
                        if (!path2.getFileName().toString().contains(string2) || path2.getFileName().toString().contains("-")) continue;
                        DirectoryStream<Path> directoryStream3 = Files.newDirectoryStream(path2);
                        try {
                            for (Path path3 : directoryStream3) {
                                String string3 = path3.getFileName().toString();
                                if (string3.endsWith("/")) {
                                    string3 = string3.substring(0, string3.length() - 1);
                                }
                                hashMap.computeIfAbsent(string3, string -> new ArrayList<Path>(Arrays.asList(pathArray))).add(path3);
                            }
                        }
                        finally {
                            if (directoryStream3 == null) continue;
                            directoryStream3.close();
                        }
                    }
                }
                standardJavaFileManager.handleOption("--system", Arrays.asList("none").iterator());
                for (Map.Entry entry : hashMap.entrySet()) {
                    standardJavaFileManager.setLocationForModule(StandardLocation.SYSTEM_MODULES, (String)entry.getKey(), (Collection)entry.getValue());
                }
            }
            catch (IOException | URISyntaxException exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    private static String targetNumericVersion(Target target) {
        return StringUtils.toUpperCase(Integer.toString(target.ordinal() - Target.JDK1_1.ordinal() + 1, 36));
    }

    public static CtSymRoot ctSymRoot() throws IOException, URISyntaxException {
        FileSystem fileSystem;
        Path path;
        URL uRL;
        CodeSource codeSource = Arguments.class.getProtectionDomain().getCodeSource();
        URL uRL2 = uRL = codeSource != null ? codeSource.getLocation() : null;
        if (uRL == null) {
            throw new IllegalStateException("Cannot find ct.sym data!");
        }
        Path path2 = Paths.get(uRL.toURI());
        boolean bl = Files.isRegularFile(path2, new LinkOption[0]);
        if (bl) {
            FileSystem fileSystem2 = FileSystems.newFileSystem(path2, (ClassLoader)null);
            path = fileSystem2.getPath("META-INF", "ct.sym");
            fileSystem = fileSystem2;
        } else {
            path = path2.resolve("META-INF").resolve("ct.sym");
            fileSystem = null;
        }
        return new CtSymRoot(path, fileSystem);
    }

    private boolean processArgs(Iterable<String> iterable2, Set<Option> set, OptionHelper optionHelper, boolean bl, boolean bl2) {
        if (!this.doProcessArgs(iterable2, set, optionHelper, bl, bl2)) {
            return false;
        }
        if (!this.handleReleaseOptions(iterable -> this.doProcessArgs((Iterable<String>)iterable, set, optionHelper, bl, bl2))) {
            return false;
        }
        this.options.notifyListeners();
        return true;
    }

    private boolean doProcessArgs(Iterable<String> iterable, Set<Option> set, OptionHelper optionHelper, boolean bl, boolean bl2) {
        JavaFileManager javaFileManager = bl2 ? this.getFileManager() : null;
        Iterator<String> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.isEmpty()) {
                this.reportDiag(CompilerProperties.Errors.InvalidFlag(string));
                return false;
            }
            Option option = null;
            if (string.startsWith("-")) {
                option = Option.lookup(string, set);
            } else if (bl && Option.SOURCEFILE.matches(string)) {
                option = Option.SOURCEFILE;
            }
            if (option != null) {
                try {
                    option.handleOption(optionHelper, string, iterator);
                    continue;
                }
                catch (Option.InvalidValueException invalidValueException) {
                    this.error(invalidValueException);
                    return false;
                }
            }
            if (javaFileManager != null && javaFileManager.handleOption(string, iterator)) continue;
            this.reportDiag(CompilerProperties.Errors.InvalidFlag(string));
            return false;
        }
        return true;
    }

    public boolean validate() {
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        JavaFileManager javaFileManager = this.getFileManager();
        if (this.options.isSet(Option.MODULE)) {
            if (!javaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                this.log.error(CompilerProperties.Errors.OutputDirMustBeSpecifiedWithDashMOption);
            } else if (!javaFileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                this.log.error(CompilerProperties.Errors.ModulesourcepathMustBeSpecifiedWithDashMOption);
            } else {
                object6 = Arrays.asList(this.options.get(Option.MODULE).split(","));
                try {
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        String string = object5.next();
                        object4 = javaFileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.MODULE_SOURCE_PATH, string);
                        if (object4 == null) {
                            this.log.error(CompilerProperties.Errors.ModuleNotFoundInModuleSourcePath(string));
                            continue;
                        }
                        object3 = javaFileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, string);
                        for (JavaFileObject object7 : javaFileManager.list((JavaFileManager.Location)object4, "", EnumSet.of(JavaFileObject.Kind.SOURCE), true)) {
                            object2 = javaFileManager.inferBinaryName((JavaFileManager.Location)object4, object7);
                            object = javaFileManager.getJavaFileForInput((JavaFileManager.Location)object3, (String)object2, JavaFileObject.Kind.CLASS);
                            if (object != null && object.getLastModified() >= object7.getLastModified()) continue;
                            if (this.fileObjects == null) {
                                this.fileObjects = new HashSet<JavaFileObject>();
                            }
                            this.fileObjects.add(object7);
                        }
                    }
                }
                catch (IOException iOException) {
                    this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
                    iOException.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
                    return false;
                }
            }
        }
        if (this.isEmpty()) {
            if (this.options.isSet(Option.HELP) || this.options.isSet(Option.X) || this.options.isSet(Option.HELP_LINT) || this.options.isSet(Option.VERSION) || this.options.isSet(Option.FULLVERSION) || this.options.isSet(Option.MODULE)) {
                return true;
            }
            if (!this.emptyAllowed) {
                if (!this.errors) {
                    if (JavaCompiler.explicitAnnotationProcessingRequested(this.options)) {
                        this.reportDiag(CompilerProperties.Errors.NoSourceFilesClasses);
                    } else {
                        this.reportDiag(CompilerProperties.Errors.NoSourceFiles);
                    }
                }
                return false;
            }
        }
        if (!this.checkDirectory(Option.D)) {
            return false;
        }
        if (!this.checkDirectory(Option.S)) {
            return false;
        }
        if (!this.checkDirectory(Option.H)) {
            return false;
        }
        if (javaFileManager instanceof StandardJavaFileManager && (object6 = (StandardJavaFileManager)javaFileManager).hasLocation(StandardLocation.CLASS_OUTPUT)) {
            object5 = object6.getLocationAsPaths(StandardLocation.CLASS_OUTPUT).iterator().next();
            if (object6.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                if (Files.exists(object5.resolve("module-info.class"), new LinkOption[0])) {
                    this.log.error(CompilerProperties.Errors.MultiModuleOutdirCannotBeExplodedModule((Path)object5));
                }
            } else {
                boolean bl22 = this.options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.PATH.option);
                if (bl22 && (object4 = object5.getParent()) != null && Files.exists(object4.resolve("module-info.class"), new LinkOption[0])) {
                    this.log.warning(Lint.LintCategory.PATH, CompilerProperties.Warnings.OutdirIsInExplodedModule((Path)object5));
                }
            }
        }
        object5 = (object6 = this.options.get(Option.SOURCE)) != null ? Source.lookup((String)object6) : Source.DEFAULT;
        String string = this.options.get(Option.TARGET);
        Object object7 = object4 = string != null ? Target.lookup(string) : Target.FRGAAL_DEFAULT;
        if (Character.isDigit(((Target)((Object)object4)).name.charAt(0)) && ((Enum)object4).compareTo(((Source)((Object)object5)).requiredTarget()) < 0 && string == null) {
            this.options.put("-target", ((Target)((Object)object4)).name);
        }
        if (this.options.isSet(Option.PREVIEW)) {
            if (object6 == null) {
                this.report(CompilerProperties.Errors.PreviewWithoutSourceOrRelease);
                return false;
            }
            if (object5 != Source.DEFAULT) {
                this.report(CompilerProperties.Errors.PreviewNotLatest((String)object6, Source.DEFAULT));
                return false;
            }
        }
        if ((object3 = this.options.get(Option.PROFILE)) != null) {
            Profile profile = Profile.lookup((String)object3);
            if (((Enum)object4).compareTo(Target.JDK1_8) <= 0 && !profile.isValid((Target)((Object)object4))) {
                this.reportDiag(CompilerProperties.Warnings.ProfileTargetConflict(profile, (Target)((Object)object4)));
            }
            if (this.options.get(Option.BOOT_CLASS_PATH) != null) {
                this.reportDiag(CompilerProperties.Errors.ProfileBootclasspathConflict);
            }
        }
        if (this.options.isSet(Option.SOURCE_PATH) && this.options.isSet(Option.MODULE_SOURCE_PATH)) {
            this.reportDiag(CompilerProperties.Errors.SourcepathModulesourcepathConflict);
        }
        if ((bl2 = this.options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.OPTIONS.option)) && ((Enum)object5).compareTo(Source.DEFAULT) < 0 && !this.options.isSet(Option.RELEASE) && javaFileManager instanceof BaseFileManager) {
            BaseFileManager bl3 = (BaseFileManager)javaFileManager;
            if (((Enum)object5).compareTo(Source.JDK8) <= 0) {
                if (bl3.isDefaultBootClassPath()) {
                    this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.SourceNoBootclasspath(((Source)((Object)object5)).name));
                }
            } else if (bl3.isDefaultSystemModulesPath()) {
                this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.SourceNoSystemModulesPath(((Source)((Object)object5)).name));
            }
        }
        boolean bl3 = false;
        if (((Enum)object5).compareTo(Source.MIN) < 0) {
            this.log.error(CompilerProperties.Errors.OptionRemovedSource(((Source)((Object)object5)).name, Source.MIN.name));
        } else if (object5 == Source.MIN && bl2) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.OptionObsoleteSource(((Source)((Object)object5)).name));
            boolean bl4 = true;
        }
        if (((Enum)object4).compareTo(Target.MIN) < 0) {
            this.log.error(CompilerProperties.Errors.OptionRemovedTarget((Target)((Object)object4), Target.MIN));
        } else if (object4 == Target.MIN && bl2) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.OptionObsoleteTarget((Target)((Object)object4)));
            bl = true;
        }
        object2 = object4;
        this.checkOptionAllowed(((Enum)object2).compareTo(Target.JDK1_8) <= 0, arg_0 -> this.lambda$validate$3((Target)((Object)object2), arg_0), Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH_PREPEND, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_APPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS, Option.PROFILE);
        this.checkOptionAllowed(((Enum)object2).compareTo(Target.JDK1_9) >= 0, arg_0 -> this.lambda$validate$4((Target)((Object)object2), arg_0), Option.MODULE_SOURCE_PATH, Option.UPGRADE_MODULE_PATH, Option.SYSTEM, Option.MODULE_PATH, Option.ADD_MODULES, Option.ADD_EXPORTS, Option.ADD_OPENS, Option.ADD_READS);
        if (bl2 && this.options.isSet(Option.PARAMETERS) && !((Target)((Object)object4)).hasMethodParameters()) {
            this.log.warning(CompilerProperties.Warnings.OptionParametersUnsupported((Target)((Object)object4), Target.JDK1_8));
        }
        if (javaFileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH) && !this.options.isSet(Option.PROC, "only") && !javaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
            this.log.error(CompilerProperties.Errors.NoOutputDir);
        }
        if (javaFileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH) && javaFileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH)) {
            this.log.error(CompilerProperties.Errors.ProcessorpathNoProcessormodulepath);
        }
        if (bl && bl2) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.OptionObsoleteSuppression);
        }
        object = Source.toSourceVersion((Source)((Object)object5));
        this.validateAddExports((SourceVersion)((Object)object));
        this.validateAddModules((SourceVersion)((Object)object));
        this.validateAddReads((SourceVersion)((Object)object));
        this.validateLimitModules((SourceVersion)((Object)object));
        this.validateDefaultModuleForCreatedFiles((SourceVersion)((Object)object));
        if (bl2 && this.options.isSet(Option.ADD_OPENS)) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.AddopensIgnored);
        }
        return !this.errors && this.log.nerrors == 0;
    }

    private void validateAddExports(SourceVersion sourceVersion) {
        String string = this.options.get(Option.ADD_EXPORTS);
        if (string != null) {
            Pattern pattern = Option.ADD_EXPORTS.getPattern();
            for (String string2 : string.split("\u0000")) {
                String string3;
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                String string4 = matcher.group(1);
                if (!SourceVersion.isName(string4, sourceVersion)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, string4));
                }
                if (!SourceVersion.isName(string3 = matcher.group(2), sourceVersion)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, string3));
                }
                String string5 = matcher.group(3);
                String[] stringArray = string5.split(",");
                int n = stringArray.length;
                block8: for (int i = 0; i < n; ++i) {
                    String string6;
                    switch (string6 = stringArray[i]) {
                        case "": 
                        case "ALL-UNNAMED": {
                            continue block8;
                        }
                        default: {
                            if (SourceVersion.isName(string6, sourceVersion)) continue block8;
                            this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, string6));
                        }
                    }
                }
            }
        }
    }

    private void validateAddReads(SourceVersion sourceVersion) {
        String string = this.options.get(Option.ADD_READS);
        if (string != null) {
            Pattern pattern = Option.ADD_READS.getPattern();
            for (String string2 : string.split("\u0000")) {
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                String string3 = matcher.group(1);
                if (!SourceVersion.isName(string3, sourceVersion)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_READS, string3));
                }
                String string4 = matcher.group(2);
                String[] stringArray = string4.split(",", -1);
                int n = stringArray.length;
                block8: for (int i = 0; i < n; ++i) {
                    String string5;
                    switch (string5 = stringArray[i]) {
                        case "": 
                        case "ALL-UNNAMED": {
                            continue block8;
                        }
                        default: {
                            if (SourceVersion.isName(string5, sourceVersion)) continue block8;
                            this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_READS, string5));
                        }
                    }
                }
            }
        }
    }

    private void validateAddModules(SourceVersion sourceVersion) {
        String string = this.options.get(Option.ADD_MODULES);
        if (string != null) {
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                String string2;
                switch (string2 = stringArray[i]) {
                    case "": 
                    case "ALL-SYSTEM": 
                    case "ALL-MODULE-PATH": {
                        continue block8;
                    }
                    default: {
                        if (SourceVersion.isName(string2, sourceVersion)) continue block8;
                        this.log.error(CompilerProperties.Errors.BadNameForOption(Option.ADD_MODULES, string2));
                    }
                }
            }
        }
    }

    private void validateLimitModules(SourceVersion sourceVersion) {
        String string = this.options.get(Option.LIMIT_MODULES);
        if (string != null) {
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            block6: for (int i = 0; i < n; ++i) {
                String string2;
                switch (string2 = stringArray[i]) {
                    case "": {
                        continue block6;
                    }
                    default: {
                        if (SourceVersion.isName(string2, sourceVersion)) continue block6;
                        this.log.error(CompilerProperties.Errors.BadNameForOption(Option.LIMIT_MODULES, string2));
                    }
                }
            }
        }
    }

    private void validateDefaultModuleForCreatedFiles(SourceVersion sourceVersion) {
        String string = this.options.get(Option.DEFAULT_MODULE_FOR_CREATED_FILES);
        if (string != null && !SourceVersion.isName(string, sourceVersion)) {
            this.log.error(CompilerProperties.Errors.BadNameForOption(Option.DEFAULT_MODULE_FOR_CREATED_FILES, string));
        }
    }

    public boolean isEmpty() {
        return !(this.files != null && !this.files.isEmpty() || this.fileObjects != null && !this.fileObjects.isEmpty() || this.classNames != null && !this.classNames.isEmpty());
    }

    public void allowEmpty() {
        this.emptyAllowed = true;
    }

    public Map<Option, String> getDeferredFileManagerOptions() {
        return this.deferredFileManagerOptions;
    }

    public Set<List<String>> getPluginOpts() {
        String string = this.options.get(Option.PLUGIN);
        if (string == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<List<String>> linkedHashSet = new LinkedHashSet<List<String>>();
        for (String string2 : string.split("\\x00")) {
            linkedHashSet.add(List.from(string2.split("\\s+")));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public List<String> getDocLintOpts() {
        String string = this.options.get(Option.XDOCLINT);
        String string2 = this.options.get(Option.XDOCLINT_CUSTOM);
        if (string == null && string2 == null) {
            return List.nil();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (string != null) {
            linkedHashSet.add("-Xmsgs");
        }
        if (string2 != null) {
            for (String string3 : string2.split("\\s+")) {
                if (string3.isEmpty()) continue;
                linkedHashSet.add("-Xmsgs:" + string3);
            }
        }
        if (linkedHashSet.equals(Collections.singleton("-Xmsgs:none"))) {
            return List.nil();
        }
        String string4 = this.options.get(Option.XDOCLINT_PACKAGE);
        if (string4 != null) {
            linkedHashSet.add("-XcheckPackage:" + string4);
        }
        return List.from(linkedHashSet.toArray(new String[linkedHashSet.size()]));
    }

    private boolean checkDirectory(Option option) {
        String string = this.options.get(option);
        if (string == null) {
            return true;
        }
        Path path = Paths.get(string, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            this.reportDiag(CompilerProperties.Errors.FileNotDirectory(string));
            return false;
        }
        return true;
    }

    void checkOptionAllowed(boolean bl, ErrorReporter errorReporter, Option ... optionArray) {
        if (!bl) {
            Stream.of(optionArray).filter(this.options::isSet).forEach(errorReporter::report);
        }
    }

    void reportDiag(JCDiagnostic.DiagnosticInfo diagnosticInfo) {
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                String string = this.log.localize(diagnosticInfo);
                throw new PropagatedException(new IllegalArgumentException(string));
            }
            case ILLEGAL_STATE: {
                String string = this.log.localize(diagnosticInfo);
                throw new PropagatedException(new IllegalStateException(string));
            }
            case LOG: {
                this.report(diagnosticInfo);
            }
        }
    }

    void error(Option.InvalidValueException invalidValueException) {
        String string = invalidValueException.getMessage();
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                throw new PropagatedException(new IllegalArgumentException(string, invalidValueException.getCause()));
            }
            case ILLEGAL_STATE: {
                throw new PropagatedException(new IllegalStateException(string, invalidValueException.getCause()));
            }
            case LOG: {
                this.log.printRawLines(string);
            }
        }
    }

    private void report(JCDiagnostic.DiagnosticInfo diagnosticInfo) {
        if (diagnosticInfo instanceof JCDiagnostic.Error) {
            JCDiagnostic.Error error = (JCDiagnostic.Error)diagnosticInfo;
            this.log.error(error);
        } else if (diagnosticInfo instanceof JCDiagnostic.Warning) {
            JCDiagnostic.Warning warning = (JCDiagnostic.Warning)diagnosticInfo;
            this.log.warning(warning);
        }
    }

    private JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = this.context.get(JavaFileManager.class);
        }
        return this.fileManager;
    }

    <T> ListBuffer<T> toList(Iterable<? extends T> iterable) {
        ListBuffer<T> listBuffer = new ListBuffer<T>();
        if (iterable != null) {
            for (T t : iterable) {
                listBuffer.add(t);
            }
        }
        return listBuffer;
    }

    <T> Set<T> toSet(Iterable<? extends T> iterable) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        if (iterable != null) {
            for (T t : iterable) {
                linkedHashSet.add(t);
            }
        }
        return linkedHashSet;
    }

    private /* synthetic */ void lambda$validate$4(Target target, Option option) {
        this.reportDiag(CompilerProperties.Errors.OptionNotAllowedWithTarget(option, target));
    }

    private /* synthetic */ void lambda$validate$3(Target target, Option option) {
        this.reportDiag(CompilerProperties.Errors.OptionNotAllowedWithTarget(option, target));
    }

    private static enum ErrorMode {
        ILLEGAL_ARGUMENT,
        ILLEGAL_STATE,
        LOG;

    }

    private static interface ErrorReporter {
        public void report(Option var1);
    }

    public static final class CtSymRoot
    implements Closeable {
        public final Path root;
        private final Closeable delegateCloseable;

        public CtSymRoot(Path path, Closeable closeable) {
            this.root = path;
            this.delegateCloseable = closeable;
        }

        @Override
        public void close() throws IOException {
            if (this.delegateCloseable != null) {
                this.delegateCloseable.close();
            }
        }
    }
}

