/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class DelegatingJavaFileManager
implements JavaFileManager {
    private final JavaFileManager releaseFM;
    private final JavaFileManager baseFM;

    public static void installReleaseFileManager(Context context, JavaFileManager javaFileManager, JavaFileManager javaFileManager2) {
        DelegatingJavaFileManager delegatingJavaFileManager;
        context.put(JavaFileManager.class, (JavaFileManager)null);
        if (javaFileManager2 instanceof StandardJavaFileManager) {
            StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)javaFileManager2;
            delegatingJavaFileManager = new DelegatingSJFM(javaFileManager, standardJavaFileManager);
        } else {
            delegatingJavaFileManager = new DelegatingJavaFileManager(javaFileManager, javaFileManager2);
        }
        DelegatingJavaFileManager delegatingJavaFileManager2 = delegatingJavaFileManager;
        context.put(JavaFileManager.class, delegatingJavaFileManager2);
    }

    private DelegatingJavaFileManager(JavaFileManager javaFileManager, JavaFileManager javaFileManager2) {
        this.releaseFM = javaFileManager;
        this.baseFM = javaFileManager2;
    }

    private JavaFileManager delegate(JavaFileManager.Location location) {
        if (this.releaseFM.hasLocation(location)) {
            return this.releaseFM;
        }
        return this.baseFM;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.delegate(location).getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        return this.delegate(location).list(location, string, set, bl);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        return this.delegate(location).inferBinaryName(location, javaFileObject);
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        return this.baseFM.isSameFile(fileObject, fileObject2);
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        return this.baseFM.handleOption(string, iterator);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.releaseFM.hasLocation(location) || this.baseFM.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        return this.delegate(location).getJavaFileForInput(location, string, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        return this.delegate(location).getJavaFileForOutput(location, string, kind, fileObject);
    }

    @Override
    public JavaFileObject getJavaFileForOutputForOriginatingFiles(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject ... fileObjectArray) throws IOException {
        return this.delegate(location).getJavaFileForOutputForOriginatingFiles(location, string, kind, fileObjectArray);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        return this.delegate(location).getFileForInput(location, string, string2);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        return this.delegate(location).getFileForOutput(location, string, string2, fileObject);
    }

    @Override
    public FileObject getFileForOutputForOriginatingFiles(JavaFileManager.Location location, String string, String string2, FileObject ... fileObjectArray) throws IOException {
        return this.delegate(location).getFileForOutputForOriginatingFiles(location, string, string2, fileObjectArray);
    }

    @Override
    public void flush() throws IOException {
        this.releaseFM.flush();
        this.baseFM.flush();
    }

    @Override
    public void close() throws IOException {
        this.releaseFM.close();
        this.baseFM.close();
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String string) throws IOException {
        return this.delegate(location).getLocationForModule(location, string);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject javaFileObject) throws IOException {
        return this.delegate(location).getLocationForModule(location, javaFileObject);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> clazz) throws IOException {
        return this.delegate(location).getServiceLoader(location, clazz);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        return this.delegate(location).inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return this.delegate(location).listLocationsForModules(location);
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fileObject) throws IOException {
        return this.delegate(location).contains(location, fileObject);
    }

    @Override
    public int isSupportedOption(String string) {
        return this.baseFM.isSupportedOption(string);
    }

    public JavaFileManager getBaseFileManager() {
        return this.baseFM;
    }

    private static final class DelegatingSJFM
    extends DelegatingJavaFileManager
    implements StandardJavaFileManager {
        private final StandardJavaFileManager baseSJFM;

        private DelegatingSJFM(JavaFileManager javaFileManager, StandardJavaFileManager standardJavaFileManager) {
            super(javaFileManager, standardJavaFileManager);
            this.baseSJFM = standardJavaFileManager;
        }

        @Override
        public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
            return this.baseSJFM.isSameFile(fileObject, fileObject2);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> iterable) {
            return this.baseSJFM.getJavaFileObjectsFromFiles(iterable);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Collection<? extends Path> collection) {
            return this.baseSJFM.getJavaFileObjectsFromPaths(collection);
        }

        @Override
        @Deprecated
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> iterable) {
            return this.baseSJFM.getJavaFileObjectsFromPaths(iterable);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... fileArray) {
            return this.baseSJFM.getJavaFileObjects(fileArray);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... pathArray) {
            return this.baseSJFM.getJavaFileObjects(pathArray);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> iterable) {
            return this.baseSJFM.getJavaFileObjectsFromStrings(iterable);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... stringArray) {
            return this.baseSJFM.getJavaFileObjects(stringArray);
        }

        @Override
        public void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
            this.baseSJFM.setLocation(location, iterable);
        }

        @Override
        public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> collection) throws IOException {
            this.baseSJFM.setLocationFromPaths(location, collection);
        }

        @Override
        public void setLocationForModule(JavaFileManager.Location location, String string, Collection<? extends Path> collection) throws IOException {
            this.baseSJFM.setLocationForModule(location, string, collection);
        }

        @Override
        public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
            return this.baseSJFM.getLocation(location);
        }

        @Override
        public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
            return this.baseSJFM.getLocationAsPaths(location);
        }

        @Override
        public Path asPath(FileObject fileObject) {
            return this.baseSJFM.asPath(fileObject);
        }

        @Override
        public void setPathFactory(StandardJavaFileManager.PathFactory pathFactory) {
            this.baseSJFM.setPathFactory(pathFactory);
        }
    }
}

