/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.DelegatingJavaFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileManager;

public class Main {
    String ownName;
    PrintWriter stdOut;
    PrintWriter stdErr;
    public Log log;
    boolean apiMode;
    private static final String ENV_OPT_NAME = "JDK_JAVAC_OPTIONS";
    private JavaFileManager fileManager;
    public static final String javacBundleName = "com.sun.tools.javac.resources.javac";

    public Main(String string) {
        this.ownName = string;
    }

    public Main(String string, PrintWriter printWriter) {
        this.ownName = string;
        this.stdOut = this.stdErr = printWriter;
    }

    public Main(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        this.ownName = string;
        this.stdOut = printWriter;
        this.stdErr = printWriter2;
    }

    void reportDiag(JCDiagnostic.DiagnosticInfo diagnosticInfo) {
        if (this.apiMode) {
            String string = this.log.localize(diagnosticInfo);
            throw new PropagatedException(new IllegalStateException(string));
        }
        this.reportHelper(diagnosticInfo);
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
    }

    void reportHelper(JCDiagnostic.DiagnosticInfo diagnosticInfo) {
        String string;
        String string2 = this.log.localize(diagnosticInfo);
        string2 = string2.startsWith(string = this.log.localize(CompilerProperties.Errors.Error)) ? string2 : string + string2;
        this.log.printRawLines(string2);
    }

    public Result compile(String[] stringArray) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        Result result = this.compile(stringArray, context);
        try {
            if (this.fileManager != null) {
                this.fileManager.close();
            }
        }
        catch (IOException iOException) {
            this.bugMessage(iOException);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(String[] stringArray, Context context) {
        List<String> list;
        Object object;
        JavaFileManager javaFileManager;
        JavaFileManager javaFileManager2;
        Object object2;
        boolean bl;
        java.util.List<String> list2;
        if (this.stdOut != null) {
            context.put(Log.outKey, this.stdOut);
        }
        if (this.stdErr != null) {
            context.put(Log.errKey, this.stdErr);
        }
        this.log = Log.instance(context);
        if (stringArray.length == 0) {
            OptionHelper.GrumpyHelper grumpyHelper = new OptionHelper.GrumpyHelper(this.log){

                @Override
                public String getOwnName() {
                    return Main.this.ownName;
                }

                @Override
                public void put(String string, String string2) {
                }
            };
            try {
                Option.HELP.process(grumpyHelper, "-help");
            }
            catch (Option.InvalidValueException invalidValueException) {
                // empty catch block
            }
            return Result.CMDERR;
        }
        try {
            list2 = CommandLine.parse(ENV_OPT_NAME, List.from(stringArray));
        }
        catch (CommandLine.UnmatchedQuote unmatchedQuote) {
            this.reportDiag(CompilerProperties.Errors.UnmatchedQuote(unmatchedQuote.variableName));
            return Result.CMDERR;
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            this.reportHelper(CompilerProperties.Errors.FileNotFound(iOException.getMessage()));
            return Result.SYSERR;
        }
        catch (IOException iOException) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
            iOException.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
            return Result.SYSERR;
        }
        Arguments arguments = Arguments.instance(context);
        arguments.init(this.ownName, list2);
        if (this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        Options options = Options.instance(context);
        boolean bl2 = options.isSet("stdout");
        if (bl2) {
            this.log.flush();
            this.log.setWriters(new PrintWriter(System.out, true));
        }
        boolean bl3 = bl = options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
        if (bl) {
            CacheFSInfo.preRegister(context);
        }
        boolean bl4 = true;
        this.fileManager = context.get(JavaFileManager.class);
        Object object3 = this.fileManager;
        if (object3 instanceof DelegatingJavaFileManager) {
            object2 = (DelegatingJavaFileManager)object3;
            javaFileManager2 = ((DelegatingJavaFileManager)object2).getBaseFileManager();
        } else {
            javaFileManager2 = javaFileManager = this.fileManager;
        }
        if (javaFileManager instanceof BaseFileManager) {
            object2 = (BaseFileManager)javaFileManager;
            ((BaseFileManager)object2).setContext(context);
            bl4 &= ((BaseFileManager)object2).handleOptions(arguments.getDeferredFileManagerOptions());
        }
        if ((object2 = options.get("showClass")) != null) {
            if (((String)object2).equals("showClass")) {
                object2 = "com.sun.tools.javac.Main";
            }
            this.showClass((String)object2);
        }
        if (!(bl4 &= arguments.validate()) || this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        if (arguments.isEmpty()) {
            return Result.OK;
        }
        if (options.isSet("debug.completionDeps")) {
            Dependencies.GraphDependencies.preRegister(context);
        }
        object3 = (BasicJavacTask)BasicJavacTask.instance(context);
        Set<List<String>> set = arguments.getPluginOpts();
        ((BasicJavacTask)object3).initPlugins(set);
        if (this.fileManager.isSupportedOption(Option.MULTIRELEASE.primaryName) == 1) {
            object = Target.instance(context);
            list = List.of(((Target)((Object)object)).multiReleaseValue());
            this.fileManager.handleOption(Option.MULTIRELEASE.primaryName, list.iterator());
        }
        object = JavaCompiler.instance(context);
        list = arguments.getDocLintOpts();
        if (!list.isEmpty()) {
            ((BasicJavacTask)object3).initDocLint(list);
        }
        if (options.get(Option.XSTDOUT) != null) {
            ((JavaCompiler)object).closeables = ((JavaCompiler)object).closeables.prepend(this.log.getWriter(Log.WriterKind.NOTICE));
        }
        boolean bl5 = options.isSet("printArgsToFile");
        try {
            ((JavaCompiler)object).compile(arguments.getFileObjects(), arguments.getClassNames(), null, List.nil());
            if (this.log.expectDiagKeys != null) {
                if (this.log.expectDiagKeys.isEmpty()) {
                    this.log.printRawLines("all expected diagnostics found");
                    Result result = Result.OK;
                    return result;
                }
                this.log.printRawLines("expected diagnostic keys not found: " + this.log.expectDiagKeys);
                Result result = Result.ERROR;
                return result;
            }
            Result result = ((JavaCompiler)object).errorCount() == 0 ? Result.OK : Result.ERROR;
            return result;
        }
        catch (OutOfMemoryError | StackOverflowError virtualMachineError) {
            this.resourceMessage(virtualMachineError);
            Result result = Result.SYSERR;
            return result;
        }
        catch (FatalError fatalError) {
            this.feMessage(fatalError, options);
            Result result = Result.SYSERR;
            return result;
        }
        catch (AnnotationProcessingError annotationProcessingError) {
            this.apMessage(annotationProcessingError);
            Result result = Result.SYSERR;
            return result;
        }
        catch (PropagatedException propagatedException) {
            throw propagatedException.getCause();
        }
        catch (IllegalAccessError illegalAccessError) {
            if (this.twoClassLoadersInUse(illegalAccessError)) {
                this.bugMessage(illegalAccessError);
            }
            bl5 = true;
            Result result = Result.ABNORMAL;
            return result;
        }
        catch (Throwable throwable) {
            if (object == null || ((JavaCompiler)object).errorCount() == 0 || options.isSet("dev")) {
                this.bugMessage(throwable);
            }
            bl5 = true;
            Result result = Result.ABNORMAL;
            return result;
        }
        finally {
            if (bl5) {
                this.printArgumentsToFile(stringArray);
            }
            if (object != null) {
                try {
                    ((JavaCompiler)object).close();
                }
                catch (ClientCodeException clientCodeException) {
                    throw new RuntimeException(clientCodeException.getCause());
                }
            }
        }
    }

    void printArgumentsToFile(String ... stringArray) {
        Path path = Paths.get(String.format("javac.%s.args", new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime())), new String[0]);
        String string = "";
        try {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                for (String string2 : stringArray) {
                    if ((string2 = string2.replaceAll("\\\\", "\\\\\\\\")).matches(".*\\s+.*")) {
                        string2 = "\"" + string2 + "\"";
                    }
                    string = string + string2 + '\n';
                }
                bufferedWriter.write(string);
            }
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.parameters.output", path.toAbsolutePath());
        }
        catch (IOException iOException) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.parameters.output.error", path.toAbsolutePath());
            System.err.println(string);
            System.err.println();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean twoClassLoadersInUse(IllegalAccessError illegalAccessError) {
        String string = illegalAccessError.getMessage();
        Pattern pattern = Pattern.compile("(?i)(?<=tried to access class )([a-z_$][a-z\\d_$]*\\.)*[a-z_$][a-z\\d_$]*");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
        }
        try {
            String string2 = matcher.group(0);
            Class<?> clazz = Class.forName(string2);
            ClassLoader classLoader = clazz.getClassLoader();
            ClassLoader classLoader2 = this.getClass().getClassLoader();
            if (classLoader2 != classLoader) {
                CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                CodeSource codeSource2 = this.getClass().getProtectionDomain().getCodeSource();
                if (codeSource != null && codeSource2 != null) {
                    this.log.printLines(CompilerProperties.Errors.TwoClassLoaders2(codeSource.getLocation(), codeSource2.getLocation()));
                    return true;
                }
                this.log.printLines(CompilerProperties.Errors.TwoClassLoaders1);
                return true;
            }
        }
        finally {
            return false;
        }
    }

    void bugMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void feMessage(Throwable throwable, Options options) {
        this.log.printRawLines(throwable.getMessage());
        if (throwable.getCause() != null && options.isSet("dev")) {
            throwable.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
        }
    }

    void ioMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void resourceMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.resource", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void apMessage(AnnotationProcessingError annotationProcessingError) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.proc.annotation.uncaught.exception", new Object[0]);
        annotationProcessingError.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void pluginMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.plugin.uncaught.exception", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void showClass(String string) {
        PrintWriter printWriter = this.log.getWriter(Log.WriterKind.NOTICE);
        printWriter.println("javac: show class: " + string);
        URL uRL = this.getClass().getResource('/' + string.replace('.', '/') + ".class");
        if (uRL != null) {
            printWriter.println("  " + uRL);
        }
        try (InputStream inputStream = this.getClass().getResourceAsStream('/' + string.replace('.', '/') + ".class");){
            byte[] byArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            try (Object object = new DigestInputStream(inputStream, messageDigest);){
                int n;
                byte[] byArray2 = new byte[8192];
                while ((n = ((FilterInputStream)object).read(byArray2)) > 0) {
                }
                byArray = messageDigest.digest();
            }
            object = new StringBuilder();
            for (byte by : byArray) {
                ((StringBuilder)object).append(String.format("%02x", by));
            }
            printWriter.println("  SHA-256 checksum: " + object);
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            printWriter.println("  cannot compute digest: " + exception);
        }
    }

    public static enum Result {
        OK(0),
        ERROR(1),
        CMDERR(2),
        SYSERR(3),
        ABNORMAL(4);

        public final int exitCode;

        private Result(int n2) {
            this.exitCode = n2;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

