/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.doclint.DocLint;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.platform.PlatformProvider;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.StringUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.SourceVersion;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum Option {
    G("-g", "opt.g", OptionKind.STANDARD, OptionGroup.BASIC),
    G_NONE("-g:none", "opt.g.none", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string) {
            optionHelper.put("-g:", "none");
        }
    }
    ,
    G_CUSTOM("-g:", "opt.g.lines.vars.source", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ANYOF, "lines", "vars", "source"),
    XLINT("-Xlint", "opt.Xlint", OptionKind.EXTENDED, OptionGroup.BASIC),
    XLINT_CUSTOM("-Xlint:", "opt.arg.Xlint", "opt.Xlint.custom", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ANYOF, Option.getXLintChoices()),
    XDOCLINT("-Xdoclint", "opt.Xdoclint", OptionKind.EXTENDED, OptionGroup.BASIC),
    XDOCLINT_CUSTOM("-Xdoclint:", "opt.Xdoclint.subopts", "opt.Xdoclint.custom", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public boolean matches(String string) {
            return DocLint.newDocLint().isValidOption(string.replace(2.XDOCLINT_CUSTOM.primaryName, "-Xmsgs:"));
        }

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) {
            String string3 = optionHelper.get(XDOCLINT_CUSTOM);
            String string4 = string3 == null ? string2 : string3 + " " + string2;
            optionHelper.put(2.XDOCLINT_CUSTOM.primaryName, string4);
        }
    }
    ,
    XDOCLINT_PACKAGE("-Xdoclint/package:", "opt.Xdoclint.package.args", "opt.Xdoclint.package.desc", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public boolean matches(String string) {
            return DocLint.newDocLint().isValidOption(string.replace(3.XDOCLINT_PACKAGE.primaryName, "-XcheckPackage:"));
        }

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) {
            String string3 = optionHelper.get(XDOCLINT_PACKAGE);
            String string4 = string3 == null ? string2 : string3 + "," + string2;
            optionHelper.put(3.XDOCLINT_PACKAGE.primaryName, string4);
        }
    }
    ,
    NOWARN("-nowarn", "opt.nowarn", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string) {
            optionHelper.put("-Xlint:none", string);
        }
    }
    ,
    VERBOSE("-verbose", "opt.verbose", OptionKind.STANDARD, OptionGroup.BASIC),
    DEPRECATION("-deprecation", "opt.deprecation", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string) {
            optionHelper.put("-Xlint:deprecation", string);
        }
    }
    ,
    CLASS_PATH("--class-path -classpath -cp", "opt.arg.path", "opt.classpath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    SOURCE_PATH("--source-path -sourcepath", "opt.arg.path", "opt.sourcepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    MODULE_SOURCE_PATH("--module-source-path", "opt.arg.mspath", "opt.modulesourcepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper optionHelper, String string3, String string4) throws InvalidValueException {
            if (string4.isEmpty()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(string3));
            }
            Pattern pattern = this.getPattern();
            String string5 = optionHelper.get(MODULE_SOURCE_PATH);
            if (string5 == null) {
                super.process(optionHelper, string3, string4);
            } else if (pattern.matcher(string4).matches()) {
                String string6 = string4.substring(0, string4.indexOf(61));
                boolean bl = Arrays.stream(string5.split("\u0000")).filter(string -> pattern.matcher((CharSequence)string).matches()).map(string -> string.substring(0, string.indexOf(61))).anyMatch(string2 -> string2.equals(string6));
                if (bl) {
                    throw optionHelper.newInvalidValueException(CompilerProperties.Errors.RepeatedValueForModuleSourcePath(string6));
                }
                super.process(optionHelper, string3, string5 + '\u0000' + string4);
            } else {
                boolean bl = Arrays.stream(string5.split("\u0000")).anyMatch(string -> !pattern.matcher((CharSequence)string).matches());
                if (bl) {
                    throw optionHelper.newInvalidValueException(CompilerProperties.Errors.MultipleValuesForModuleSourcePath);
                }
                super.process(optionHelper, string3, string5 + '\u0000' + string4);
            }
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("([\\p{Alnum}$_.]+)=(.*)");
        }
    }
    ,
    MODULE_PATH("--module-path -p", "opt.arg.path", "opt.modulepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    UPGRADE_MODULE_PATH("--upgrade-module-path", "opt.arg.path", "opt.upgrademodulepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    SYSTEM("--system", "opt.arg.jdk", "opt.system", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    PATCH_MODULE("--patch-module", "opt.arg.patch", "opt.patch", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper optionHelper, String string2, String string3) throws InvalidValueException {
            if (string3.isEmpty()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(string2));
            }
            if (this.getPattern().matcher(string3).matches()) {
                String string4 = optionHelper.get(PATCH_MODULE);
                if (string4 == null) {
                    super.process(optionHelper, string2, string3);
                } else {
                    String string5 = string3.substring(0, string3.indexOf(61));
                    boolean bl = Arrays.stream(string4.split("\u0000")).map(string -> string.substring(0, string.indexOf(61))).collect(Collectors.toSet()).contains(string5);
                    if (bl) {
                        throw optionHelper.newInvalidValueException(CompilerProperties.Errors.RepeatedValueForPatchModule(string5));
                    }
                    super.process(optionHelper, string2, string4 + '\u0000' + string3);
                }
            } else {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(string2, string3));
            }
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("([^/]+)=(,*[^,].*)");
        }
    }
    ,
    BOOT_CLASS_PATH("--boot-class-path -bootclasspath", "opt.arg.path", "opt.bootclasspath", OptionKind.STANDARD, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            optionHelper.remove("-Xbootclasspath/p:");
            optionHelper.remove("-Xbootclasspath/a:");
            super.process(optionHelper, string, string2);
        }
    }
    ,
    XBOOTCLASSPATH_PREPEND("-Xbootclasspath/p:", "opt.arg.path", "opt.Xbootclasspath.p", OptionKind.EXTENDED, OptionGroup.FILEMANAGER),
    XBOOTCLASSPATH_APPEND("-Xbootclasspath/a:", "opt.arg.path", "opt.Xbootclasspath.a", OptionKind.EXTENDED, OptionGroup.FILEMANAGER),
    XBOOTCLASSPATH("-Xbootclasspath:", "opt.arg.path", "opt.bootclasspath", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            optionHelper.remove("-Xbootclasspath/p:");
            optionHelper.remove("-Xbootclasspath/a:");
            super.process(optionHelper, "-bootclasspath", string2);
        }
    }
    ,
    EXTDIRS("-extdirs", "opt.arg.dirs", "opt.extdirs", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    DJAVA_EXT_DIRS("-Djava.ext.dirs=", "opt.arg.dirs", "opt.extdirs", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            EXTDIRS.process(optionHelper, "-extdirs", string2);
        }
    }
    ,
    ENDORSEDDIRS("-endorseddirs", "opt.arg.dirs", "opt.endorseddirs", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    DJAVA_ENDORSED_DIRS("-Djava.endorsed.dirs=", "opt.arg.dirs", "opt.endorseddirs", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            ENDORSEDDIRS.process(optionHelper, "-endorseddirs", string2);
        }
    }
    ,
    PROC("-proc:", "opt.proc.none.only", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ONEOF, "none", "only"),
    PROCESSOR("-processor", "opt.arg.class.list", "opt.processor", OptionKind.STANDARD, OptionGroup.BASIC),
    PROCESSOR_PATH("--processor-path -processorpath", "opt.arg.path", "opt.processorpath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    PROCESSOR_MODULE_PATH("--processor-module-path", "opt.arg.path", "opt.processormodulepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    PARAMETERS("-parameters", "opt.parameters", OptionKind.STANDARD, OptionGroup.BASIC),
    D("-d", "opt.arg.directory", "opt.d", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    S("-s", "opt.arg.directory", "opt.sourceDest", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    H("-h", "opt.arg.directory", "opt.headerDest", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    IMPLICIT("-implicit:", "opt.implicit", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ONEOF, "none", "class"),
    ENCODING("-encoding", "opt.arg.encoding", "opt.encoding", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    SOURCE("--source -source", "opt.arg.release", "opt.source", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            Source source = Source.lookup(string2);
            if (source == null) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.InvalidSource(string2));
            }
            super.process(optionHelper, string, string2);
        }

        @Override
        protected void help(Log log) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            for (Source source : Source.values()) {
                if (!source.isSupported()) continue;
                stringJoiner.add(source.name);
            }
            super.help(log, log.localize(Log.PrefixKind.JAVAC, this.descrKey, stringJoiner.toString()));
        }
    }
    ,
    TARGET("--target -target", "opt.arg.release", "opt.target", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            Target target = Target.lookup(string2);
            if (target == null) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.InvalidTarget(string2));
            }
            super.process(optionHelper, string, string2);
        }

        @Override
        protected void help(Log log) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            for (Target target : Target.values()) {
                if (!target.isSupported()) continue;
                stringJoiner.add(target.name);
            }
            super.help(log, log.localize(Log.PrefixKind.JAVAC, this.descrKey, stringJoiner.toString()));
        }
    }
    ,
    RELEASE("--release", "opt.arg.release", "opt.release", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        protected void help(Log log) {
            ServiceLoader<PlatformProvider> serviceLoader = ServiceLoader.load(PlatformProvider.class, Arguments.class.getClassLoader());
            Set set = StreamSupport.stream(serviceLoader.spliterator(), false).flatMap(platformProvider -> StreamSupport.stream(platformProvider.getSupportedPlatformNames().spliterator(), false)).collect(Collectors.toCollection(LinkedHashSet::new));
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            for (String string2 : set) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                string = ", ";
            }
            super.help(log, log.localize(Log.PrefixKind.JAVAC, this.descrKey, stringBuilder.toString()));
        }
    }
    ,
    PREVIEW("--enable-preview --enable-safe-preview", "opt.preview", OptionKind.STANDARD, OptionGroup.BASIC),
    PROFILE("-profile", "opt.arg.profile", "opt.profile", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            Profile profile = Profile.lookup(string2);
            if (profile == null) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.InvalidProfile(string2));
            }
            super.process(optionHelper, string, string2);
        }
    }
    ,
    VERSION("--version -version", "opt.version", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
            Log log = optionHelper.getLog();
            String string2 = optionHelper.getOwnName();
            log.printLines(Log.WriterKind.STDOUT, Log.PrefixKind.JAVAC, "version", string2, JavaCompiler.version());
            super.process(optionHelper, string);
        }
    }
    ,
    FULLVERSION("--full-version -fullversion", null, OptionKind.HIDDEN, OptionGroup.INFO){

        @Override
        public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
            Log log = optionHelper.getLog();
            String string2 = optionHelper.getOwnName();
            log.printLines(Log.WriterKind.STDOUT, Log.PrefixKind.JAVAC, "fullVersion", string2, JavaCompiler.fullVersion());
            super.process(optionHelper, string);
        }
    }
    ,
    HELP("--help -help -?", "opt.help", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
            Log log = optionHelper.getLog();
            String string2 = optionHelper.getOwnName();
            log.printLines(Log.WriterKind.STDOUT, Log.PrefixKind.JAVAC, "msg.usage.header", string2);
            Option.showHelp(log, OptionKind.STANDARD);
            log.printNewline(Log.WriterKind.STDOUT);
            super.process(optionHelper, string);
        }
    }
    ,
    A("-A", "opt.arg.key.equals.value", "opt.A", OptionKind.STANDARD, OptionGroup.BASIC, ArgKind.ADJACENT){

        @Override
        public boolean matches(String string) {
            return string.startsWith("-A");
        }

        @Override
        public boolean hasArg() {
            return false;
        }

        @Override
        public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
            int n = string.length();
            if (n == 2) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.EmptyAArgument);
            }
            int n2 = string.indexOf(61);
            String string2 = string.substring(2, n2 != -1 ? n2 : n);
            if (!JavacProcessingEnvironment.isValidOptionName(string2)) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.InvalidAKey(string));
            }
            optionHelper.put(string, string);
        }
    }
    ,
    DEFAULT_MODULE_FOR_CREATED_FILES("--default-module-for-created-files", "opt.arg.default.module.for.created.files", "opt.default.module.for.created.files", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            String string3 = optionHelper.get(DEFAULT_MODULE_FOR_CREATED_FILES);
            if (string3 != null) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.OptionTooMany(20.DEFAULT_MODULE_FOR_CREATED_FILES.primaryName));
            }
            if (string2.isEmpty()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(string));
            }
            if (!this.getPattern().matcher(string2).matches()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(string, string2));
            }
            optionHelper.put(20.DEFAULT_MODULE_FOR_CREATED_FILES.primaryName, string2);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("[^,].*");
        }
    }
    ,
    X("--help-extra -X", "opt.X", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
            Log log = optionHelper.getLog();
            Option.showHelp(log, OptionKind.EXTENDED);
            log.printNewline(Log.WriterKind.STDOUT);
            log.printLines(Log.WriterKind.STDOUT, Log.PrefixKind.JAVAC, "msg.usage.nonstandard.footer", new Object[0]);
            super.process(optionHelper, string);
        }
    }
    ,
    HELP_LINT("--help-lint", "opt.help.lint", OptionKind.EXTENDED, OptionGroup.INFO){
        private final String LINT_KEY_FORMAT = "    %-" + (28 - "        ".length()) + "s %s";

        @Override
        public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
            Log log = optionHelper.getLog();
            log.printRawLines(Log.WriterKind.STDOUT, log.localize(Log.PrefixKind.JAVAC, "opt.help.lint.header", new Object[0]));
            log.printRawLines(Log.WriterKind.STDOUT, String.format(this.LINT_KEY_FORMAT, "all", log.localize(Log.PrefixKind.JAVAC, "opt.Xlint.all", new Object[0])));
            for (Lint.LintCategory lintCategory : Lint.LintCategory.values()) {
                log.printRawLines(Log.WriterKind.STDOUT, String.format(this.LINT_KEY_FORMAT, lintCategory.option, log.localize(Log.PrefixKind.JAVAC, "opt.Xlint.desc." + lintCategory.option, new Object[0])));
            }
            log.printRawLines(Log.WriterKind.STDOUT, String.format(this.LINT_KEY_FORMAT, "none", log.localize(Log.PrefixKind.JAVAC, "opt.Xlint.none", new Object[0])));
            super.process(optionHelper, string);
        }
    }
    ,
    J("-J", "opt.arg.flag", "opt.J", OptionKind.STANDARD, OptionGroup.INFO, ArgKind.ADJACENT){

        @Override
        public void process(OptionHelper optionHelper, String string) {
            throw new AssertionError((Object)"the -J flag should be caught by the launcher.");
        }

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            throw optionHelper.newInvalidValueException(CompilerProperties.Errors.InvalidFlag(string + string2));
        }
    }
    ,
    MOREINFO("-moreinfo", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
            Type.moreInfo = true;
            super.process(optionHelper, string);
        }
    }
    ,
    WERROR("-Werror", "opt.Werror", OptionKind.STANDARD, OptionGroup.BASIC),
    PROMPT("-prompt", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    DOE("-doe", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    PRINTSOURCE("-printsource", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    WARNUNCHECKED("-warnunchecked", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string) {
            optionHelper.put("-Xlint:unchecked", string);
        }
    }
    ,
    XMAXERRS("-Xmaxerrs", "opt.arg.number", "opt.maxerrs", OptionKind.EXTENDED, OptionGroup.BASIC),
    XMAXWARNS("-Xmaxwarns", "opt.arg.number", "opt.maxwarns", OptionKind.EXTENDED, OptionGroup.BASIC),
    XSTDOUT("-Xstdout", "opt.arg.file", "opt.Xstdout", OptionKind.EXTENDED, OptionGroup.INFO){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            try {
                Log log = optionHelper.getLog();
                log.setWriters(new PrintWriter((Writer)new FileWriter(string2), true));
            }
            catch (IOException iOException) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.ErrorWritingFile(string2, iOException.getMessage()));
            }
            super.process(optionHelper, string, string2);
        }
    }
    ,
    XPRINT("-Xprint", "opt.print", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPRINTROUNDS("-XprintRounds", "opt.printRounds", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPRINTPROCESSORINFO("-XprintProcessorInfo", "opt.printProcessorInfo", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPREFER("-Xprefer:", "opt.prefer", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "source", "newer"),
    XXUSERPATHSFIRST("-XXuserPathsFirst", "opt.userpathsfirst", OptionKind.HIDDEN, OptionGroup.BASIC),
    XPKGINFO("-Xpkginfo:", "opt.pkginfo", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "always", "legacy", "nonempty"),
    O("-O", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    XJCOV("-Xjcov", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    PLUGIN("-Xplugin:", "opt.arg.plugin", "opt.plugin", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) {
            String string3 = optionHelper.get(PLUGIN);
            optionHelper.put(27.PLUGIN.primaryName, string3 == null ? string2 : string3 + '\u0000' + string2);
        }
    }
    ,
    XDIAGS("-Xdiags:", "opt.diags", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "compact", "verbose"),
    DEBUG("--debug", null, OptionKind.HIDDEN, OptionGroup.BASIC, ArgKind.REQUIRED){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            HiddenGroup.DEBUG.process(optionHelper, string, string2);
        }
    }
    ,
    SHOULDSTOP("--should-stop", null, OptionKind.HIDDEN, OptionGroup.BASIC, ArgKind.REQUIRED){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            HiddenGroup.SHOULDSTOP.process(optionHelper, string, string2);
        }
    }
    ,
    DIAGS("--diags", null, OptionKind.HIDDEN, OptionGroup.BASIC, ArgKind.REQUIRED){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            HiddenGroup.DIAGS.process(optionHelper, string, string2);
        }
    }
    ,
    XD("-XD", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public boolean matches(String string) {
            return string.startsWith(this.primaryName);
        }

        @Override
        public void process(OptionHelper optionHelper, String string) {
            this.process(optionHelper, string, string.substring(this.primaryName.length()));
        }

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) {
            int n = string2.indexOf(61);
            String string3 = n < 0 ? string2 : string2.substring(0, n);
            String string4 = n < 0 ? string2 : string2.substring(n + 1);
            optionHelper.put(string3, string4);
        }
    }
    ,
    ADD_EXPORTS("--add-exports", "opt.arg.addExports", "opt.addExports", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            if (string2.isEmpty()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(string));
            }
            if (!this.getPattern().matcher(string2).matches()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(string, string2));
            }
            String string3 = optionHelper.get(ADD_EXPORTS);
            optionHelper.put(32.ADD_EXPORTS.primaryName, string3 == null ? string2 : string3 + '\u0000' + string2);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("([^/]+)/([^=]+)=(,*[^,].*)");
        }
    }
    ,
    ADD_OPENS("--add-opens", null, null, OptionKind.HIDDEN, OptionGroup.BASIC),
    ADD_READS("--add-reads", "opt.arg.addReads", "opt.addReads", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            if (string2.isEmpty()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(string));
            }
            if (!this.getPattern().matcher(string2).matches()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(string, string2));
            }
            String string3 = optionHelper.get(ADD_READS);
            optionHelper.put(33.ADD_READS.primaryName, string3 == null ? string2 : string3 + '\u0000' + string2);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("([^=]+)=(,*[^,].*)");
        }
    }
    ,
    MODULE("--module -m", "opt.arg.m", "opt.m", OptionKind.STANDARD, OptionGroup.BASIC),
    ADD_MODULES("--add-modules", "opt.arg.addmods", "opt.addmods", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            if (string2.isEmpty()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(string));
            }
            if (!this.getPattern().matcher(string2).matches()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(string, string2));
            }
            String string3 = optionHelper.get(ADD_MODULES);
            optionHelper.put(34.ADD_MODULES.primaryName, string3 == null ? string2 : string3 + ',' + string2);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile(",*[^,].*");
        }
    }
    ,
    LIMIT_MODULES("--limit-modules", "opt.arg.limitmods", "opt.limitmods", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            if (string2.isEmpty()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(string));
            }
            if (!this.getPattern().matcher(string2).matches()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.BadValueForOption(string, string2));
            }
            optionHelper.put(35.LIMIT_MODULES.primaryName, string2);
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile(",*[^,].*");
        }
    }
    ,
    MODULE_VERSION("--module-version", "opt.arg.module.version", "opt.module.version", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            if (string2.isEmpty()) {
                throw optionHelper.newInvalidValueException(CompilerProperties.Errors.NoValueForOption(string));
            }
            super.process(optionHelper, string, string2);
        }
    }
    ,
    AT("@", "opt.arg.file", "opt.AT", OptionKind.STANDARD, OptionGroup.INFO, ArgKind.ADJACENT){

        @Override
        public void process(OptionHelper optionHelper, String string) {
            throw new AssertionError((Object)"the @ flag should be caught by CommandLine.");
        }
    }
    ,
    SOURCEFILE("sourcefile", null, OptionKind.HIDDEN, OptionGroup.INFO){

        @Override
        public boolean matches(String string) {
            if (string.endsWith(".java")) {
                return true;
            }
            int n = string.indexOf(47);
            if (n != -1) {
                return SourceVersion.isName(string.substring(0, n)) && SourceVersion.isName(string.substring(n + 1));
            }
            return SourceVersion.isName(string);
        }

        @Override
        public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
            if (string.endsWith(".java")) {
                try {
                    Path path = Paths.get(string, new String[0]);
                    if (!Files.exists(path, new LinkOption[0])) {
                        throw optionHelper.newInvalidValueException(CompilerProperties.Errors.FileNotFound(path.toString()));
                    }
                    if (!Files.isRegularFile(path, new LinkOption[0])) {
                        throw optionHelper.newInvalidValueException(CompilerProperties.Errors.FileNotFile(path));
                    }
                    optionHelper.addFile(path);
                }
                catch (InvalidPathException invalidPathException) {
                    throw optionHelper.newInvalidValueException(CompilerProperties.Errors.InvalidPath(string));
                }
            } else {
                optionHelper.addClassName(string);
            }
        }
    }
    ,
    MULTIRELEASE("--multi-release", "opt.arg.multi-release", "opt.multi-release", OptionKind.HIDDEN, OptionGroup.FILEMANAGER);

    public final String primaryName;
    public final String[] names;
    protected final String argsNameKey;
    protected final String descrKey;
    private final OptionKind kind;
    private final OptionGroup group;
    private final ArgKind argKind;
    private final ChoiceKind choiceKind;
    private final Set<String> choices;
    private static final String SMALL_INDENT = "  ";
    private static final String LARGE_INDENT = "        ";
    private static final int DEFAULT_SYNOPSIS_WIDTH = 28;
    private static final int DEFAULT_MAX_LINE_LENGTH = 80;
    private static final String COMPACT_FORMAT = "  %-28s %s";

    public static Option lookup(String string) {
        return Option.lookup(string, EnumSet.allOf(Option.class));
    }

    public static Option lookup(String string, Set<Option> set) {
        for (Option option : set) {
            if (!option.matches(string)) continue;
            return option;
        }
        return null;
    }

    private static void showHelp(Log log, OptionKind optionKind) {
        Comparator<Option> comparator = new Comparator<Option>(){
            final Collator collator = Collator.getInstance(Locale.US);
            {
                this.collator.setStrength(0);
            }

            @Override
            public int compare(Option option, Option option2) {
                return this.collator.compare(option.primaryName, option2.primaryName);
            }
        };
        Option.getJavaCompilerOptions().stream().filter(option -> option.kind == optionKind).sorted(comparator).forEach(option -> option.help(log));
    }

    private Option(String string2, String string3, OptionKind optionKind, OptionGroup optionGroup) {
        this(string2, null, string3, optionKind, optionGroup, null, null, ArgKind.NONE);
    }

    private Option(String string2, String string3, OptionKind optionKind, OptionGroup optionGroup, ArgKind argKind) {
        this(string2, null, string3, optionKind, optionGroup, null, null, argKind);
    }

    private Option(String string2, String string3, String string4, OptionKind optionKind, OptionGroup optionGroup) {
        this(string2, string3, string4, optionKind, optionGroup, null, null, ArgKind.REQUIRED);
    }

    private Option(String string2, String string3, String string4, OptionKind optionKind, OptionGroup optionGroup, ArgKind argKind) {
        this(string2, string3, string4, optionKind, optionGroup, null, null, argKind);
    }

    private Option(String string2, String string3, String string4, OptionKind optionKind, OptionGroup optionGroup, ChoiceKind choiceKind, Set<String> set) {
        this(string2, string3, string4, optionKind, optionGroup, choiceKind, set, ArgKind.REQUIRED);
    }

    private Option(String string2, String string3, OptionKind optionKind, OptionGroup optionGroup, ChoiceKind choiceKind, String ... stringArray) {
        this(string2, null, string3, optionKind, optionGroup, choiceKind, new LinkedHashSet<String>(Arrays.asList(stringArray)), ArgKind.REQUIRED);
    }

    private Option(String string2, String string3, String string4, OptionKind optionKind, OptionGroup optionGroup, ChoiceKind choiceKind, Set<String> set, ArgKind argKind) {
        this.names = string2.trim().split("\\s+");
        Assert.check(this.names.length >= 1);
        this.primaryName = this.names[0];
        this.argsNameKey = string3;
        this.descrKey = string4;
        this.kind = optionKind;
        this.group = optionGroup;
        this.choiceKind = choiceKind;
        this.choices = set;
        this.argKind = argKind;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public OptionKind getKind() {
        return this.kind;
    }

    public ArgKind getArgKind() {
        return this.argKind;
    }

    public boolean hasArg() {
        return this.argKind != ArgKind.NONE;
    }

    public boolean hasSeparateArg() {
        return this.getArgKind() == ArgKind.REQUIRED && !this.primaryName.endsWith(":") && !this.primaryName.endsWith("=");
    }

    public boolean matches(String string) {
        for (String string2 : this.names) {
            if (!this.matches(string, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String string, String string2) {
        boolean bl;
        if (string2.startsWith("--")) {
            return string.equals(string2) || this.hasArg() && string.startsWith(string2 + "=");
        }
        boolean bl2 = bl = this.argKind == ArgKind.ADJACENT || string2.endsWith(":") || string2.endsWith("=");
        if (!bl) {
            return string.equals(string2);
        }
        if (!string.startsWith(string2)) {
            return false;
        }
        if (this.choices != null) {
            String string3 = string.substring(string2.length());
            if (this.choiceKind == ChoiceKind.ONEOF) {
                return this.choices.contains(string3);
            }
            for (String string4 : string3.split(",+")) {
                if (this.choices.contains(string4)) continue;
                return false;
            }
        }
        return true;
    }

    public void handleOption(OptionHelper optionHelper, String string, Iterator<String> iterator) throws InvalidValueException {
        if (this.hasArg()) {
            String string2;
            String string3;
            int n = Option.findSeparator(string);
            if (this.getArgKind() == ArgKind.ADJACENT) {
                string3 = this.primaryName;
                string2 = string.substring(this.primaryName.length());
            } else if (n > 0) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
            } else {
                if (!iterator.hasNext()) {
                    throw optionHelper.newInvalidValueException(CompilerProperties.Errors.ReqArg(this.primaryName));
                }
                string3 = string;
                string2 = iterator.next();
            }
            this.process(optionHelper, string3, string2);
        } else {
            if ((this == HELP || this == X || this == HELP_LINT || this == VERSION || this == FULLVERSION) && optionHelper.get(this) != null) {
                return;
            }
            this.process(optionHelper, string);
        }
    }

    public void process(OptionHelper optionHelper, String string) throws InvalidValueException {
        if (this.argKind == ArgKind.NONE) {
            this.process(optionHelper, this.primaryName, string);
        } else {
            int n = Option.findSeparator(string);
            this.process(optionHelper, this.primaryName, string.substring(n + 1));
        }
    }

    public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
        if (this.choices != null) {
            if (this.choiceKind == ChoiceKind.ONEOF) {
                String string32;
                for (String string32 : this.choices) {
                    optionHelper.remove(this.primaryName + string32);
                }
                String string4 = this.primaryName + string2;
                optionHelper.put(string4, string4);
                string32 = this.primaryName.substring(0, this.primaryName.length() - 1);
                optionHelper.put(string32, string2);
            } else {
                for (String string5 : string2.split(",+")) {
                    String string6 = this.primaryName + string5;
                    optionHelper.put(string6, string6);
                }
            }
        }
        optionHelper.put(this.primaryName, string2);
        if (this.group == OptionGroup.FILEMANAGER) {
            optionHelper.handleFileManagerOption(this, string2);
        }
    }

    public Pattern getPattern() {
        throw new UnsupportedOperationException();
    }

    private static int findSeparator(String string) {
        for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ':': 
                case '=': {
                    return i;
                }
            }
        }
        return -1;
    }

    protected void help(Log log) {
        this.help(log, log.localize(Log.PrefixKind.JAVAC, this.descrKey, new Object[0]));
    }

    protected void help(Log log, String string2) {
        String string3 = Arrays.stream(this.names).map(string -> this.helpSynopsis((String)string, log)).collect(Collectors.joining(", "));
        if (string3.length() < 28 && !string2.contains("\n") && SMALL_INDENT.length() + 28 + 1 + string2.length() <= 80) {
            log.printRawLines(Log.WriterKind.STDOUT, String.format(COMPACT_FORMAT, string3, string2));
            return;
        }
        if (string3.length() <= 80) {
            log.printRawLines(Log.WriterKind.STDOUT, SMALL_INDENT + string3);
        } else {
            for (String string4 : this.names) {
                log.printRawLines(Log.WriterKind.STDOUT, SMALL_INDENT + this.helpSynopsis(string4, log));
            }
        }
        log.printRawLines(Log.WriterKind.STDOUT, LARGE_INDENT + string2.replace("\n", "\n        "));
    }

    private String helpSynopsis(String string, Log log) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (this.argsNameKey == null) {
            if (this.choices != null) {
                if (!string.endsWith(":")) {
                    stringBuilder.append(" ");
                }
                String string2 = "{";
                for (String string3 : this.choices) {
                    stringBuilder.append(string2);
                    stringBuilder.append(string3);
                    string2 = ",";
                }
                stringBuilder.append("}");
            }
        } else {
            if (!string.matches(".*[=:]$") && this.argKind != ArgKind.ADJACENT) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(log.localize(Log.PrefixKind.JAVAC, this.argsNameKey, new Object[0]));
        }
        return stringBuilder.toString();
    }

    private static Set<String> getXLintChoices() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("all");
        for (Lint.LintCategory lintCategory : Lint.LintCategory.values()) {
            linkedHashSet.add(lintCategory.option);
            linkedHashSet.add("-" + lintCategory.option);
        }
        linkedHashSet.add("none");
        return linkedHashSet;
    }

    static Set<Option> getJavaCompilerOptions() {
        return EnumSet.allOf(Option.class);
    }

    public static Set<Option> getJavacFileManagerOptions() {
        return Option.getOptions(OptionGroup.FILEMANAGER);
    }

    public static Set<Option> getJavacToolOptions() {
        return Option.getOptions(OptionGroup.BASIC);
    }

    private static Set<Option> getOptions(OptionGroup optionGroup) {
        return Arrays.stream(Option.values()).filter(option -> option.group == optionGroup).collect(Collectors.toCollection(() -> EnumSet.noneOf(Option.class)));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum OptionKind {
        STANDARD,
        EXTENDED,
        HIDDEN;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum OptionGroup {
        BASIC,
        FILEMANAGER,
        INFO,
        OPERAND;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum ArgKind {
        NONE,
        REQUIRED,
        ADJACENT;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum ChoiceKind {
        ONEOF,
        ANYOF;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class InvalidValueException
    extends Exception {
        private static final long serialVersionUID = -1L;

        public InvalidValueException(String string) {
            super(string);
        }

        public InvalidValueException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum PkgInfo {
        ALWAYS,
        LEGACY,
        NONEMPTY;


        public static PkgInfo get(Options options) {
            String string = options.get(XPKGINFO);
            return string == null ? LEGACY : PkgInfo.valueOf(StringUtils.toUpperCase(string));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum HiddenGroup {
        DIAGS("diags"),
        DEBUG("debug"),
        SHOULDSTOP("should-stop");

        final String text;

        private HiddenGroup(String string2) {
            this.text = string2;
        }

        public void process(OptionHelper optionHelper, String string, String string2) throws InvalidValueException {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(";")) {
                string3 = this.text + "." + string3.trim();
                XD.process(optionHelper, string3, string3);
            }
        }
    }
}

