/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.TextTree;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.ReferenceParser;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocTreeMaker;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.tools.Diagnostic;

public class DocCommentParser {
    private final ParserFactory fac;
    private final JCDiagnostic.Factory diags;
    private final DiagnosticSource diagSource;
    private final Tokens.Comment comment;
    private final DocTreeMaker m;
    private final Names names;
    private final boolean isFileContent;
    private char[] buf;
    private int bp;
    private int buflen;
    private char ch;
    private int textStart = -1;
    private int lastNonWhite = -1;
    private boolean newline = true;
    private final Map<Name, TagParser> tagParsers;

    public DocCommentParser(ParserFactory parserFactory, DiagnosticSource diagnosticSource, Tokens.Comment comment, boolean bl) {
        this.fac = parserFactory;
        this.diags = parserFactory.log.diags;
        this.diagSource = diagnosticSource;
        this.comment = comment;
        this.names = parserFactory.names;
        this.isFileContent = bl;
        this.m = parserFactory.docTreeMaker;
        this.tagParsers = this.createTagParsers();
    }

    public DocCommentParser(ParserFactory parserFactory, DiagnosticSource diagnosticSource, Tokens.Comment comment) {
        this(parserFactory, diagnosticSource, comment, false);
    }

    public DocCommentParser(ParserFactory parserFactory) {
        this(parserFactory, null, null, false);
    }

    public DCTree.DCDocComment parse() {
        List list;
        String string = this.comment.getText();
        this.buf = new char[string.length() + 1];
        string.getChars(0, string.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.nextChar();
        List list2 = this.isFileContent ? this.blockContent(Phase.PREAMBLE) : List.nil();
        List<DCTree> list3 = this.blockContent(Phase.BODY);
        List<DCTree> list4 = this.blockTags();
        List<Object> list5 = list = this.isFileContent ? this.blockContent(Phase.POSTAMBLE) : List.nil();
        int n = !list2.isEmpty() ? ((DCTree)list2.head).pos : (!list3.isEmpty() ? ((DCTree)list3.head).pos : (!list4.isEmpty() ? ((DCTree)list4.head).pos : (!list.isEmpty() ? ((DCTree)list.head).pos : 0)));
        return this.m.at(n).newDocCommentTree(this.comment, list3, list4, list2, list);
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                this.newline = true;
            }
        }
    }

    protected List<DCTree> blockContent() {
        return this.blockContent(Phase.BODY);
    }

    protected List<DCTree> blockContent(Phase phase) {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        this.textStart = -1;
        block12: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block12;
                }
                case '&': {
                    this.entity(listBuffer);
                    continue block12;
                }
                case '<': {
                    this.newline = false;
                    if (this.isFileContent) {
                        switch (phase) {
                            case PREAMBLE: {
                                if (!this.isEndPreamble()) break;
                                listBuffer.add(this.html());
                                if (this.textStart == -1) {
                                    this.textStart = this.bp;
                                    this.lastNonWhite = -1;
                                }
                                this.newline = true;
                                break block12;
                            }
                            case BODY: {
                                if (!this.isEndBody()) break;
                                this.addPendingText(listBuffer, this.lastNonWhite);
                                break block12;
                            }
                        }
                    }
                    this.addPendingText(listBuffer, this.bp - 1);
                    listBuffer.add(this.html());
                    if (phase == Phase.PREAMBLE || phase == Phase.POSTAMBLE || this.textStart != -1) continue block12;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block12;
                }
                case '{': {
                    this.inlineTag(listBuffer);
                    continue block12;
                }
                case '@': {
                    if (this.newline) {
                        this.addPendingText(listBuffer, this.lastNonWhite);
                        break block12;
                    }
                }
                default: {
                    this.newline = false;
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.lastNonWhite = this.bp;
                    this.nextChar();
                    continue block12;
                }
            }
        }
        if (this.lastNonWhite != -1) {
            this.addPendingText(listBuffer, this.lastNonWhite);
        }
        return listBuffer.toList();
    }

    protected List<DCTree> blockTags() {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        while (this.bp < this.buflen && this.ch == '@') {
            listBuffer.add(this.blockTag());
        }
        return listBuffer.toList();
    }

    protected DCTree blockTag() {
        int n = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tagParser = this.tagParsers.get(name);
                if (tagParser == null) {
                    List<DCTree> list = this.blockContent();
                    return this.m.at(n).newUnknownBlockTagTree((javax.lang.model.element.Name)name, list);
                }
                if (tagParser.allowsBlock()) {
                    return tagParser.parse(n, TagParser.Kind.BLOCK);
                }
                return this.erroneous("dc.bad.inline.tag", n);
            }
            this.blockContent();
            return this.erroneous("dc.no.tag.name", n);
        }
        catch (ParseException parseException) {
            this.blockContent();
            return this.erroneous(parseException.getMessage(), n, parseException.pos);
        }
    }

    protected void inlineTag(ListBuffer<DCTree> listBuffer) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            this.addPendingText(listBuffer, this.bp - 2);
            listBuffer.add(this.inlineTag());
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        } else {
            if (this.textStart == -1) {
                this.textStart = this.bp - 1;
            }
            this.lastNonWhite = this.bp;
        }
    }

    protected DCTree inlineTag() {
        int n = this.bp - 1;
        try {
            this.nextChar();
            if (!this.isIdentifierStart(this.ch)) {
                return this.erroneous("dc.no.tag.name", n);
            }
            Name name = this.readTagName();
            TagParser tagParser = this.tagParsers.get(name);
            if (tagParser == null) {
                this.skipWhitespace();
                DCTree.DCText dCText = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                this.nextChar();
                return ((DCTree.DCEndPosTree)((Object)this.m.at(n).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(dCText)))).setEndPos(this.bp);
            }
            if (!tagParser.retainWhiteSpace) {
                this.skipWhitespace();
            }
            if (tagParser.allowsInline()) {
                DCTree.DCEndPosTree dCEndPosTree = (DCTree.DCEndPosTree)tagParser.parse(n, TagParser.Kind.INLINE);
                return dCEndPosTree.setEndPos(this.bp);
            }
            DCTree.DCText dCText = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
            this.nextChar();
            return ((DCTree.DCEndPosTree)((Object)this.m.at(n).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(dCText)))).setEndPos(this.bp);
        }
        catch (ParseException parseException) {
            return this.erroneous(parseException.getMessage(), n, parseException.pos);
        }
    }

    private DCTree.DCText inlineText(WhitespaceRetentionPolicy whitespaceRetentionPolicy) throws ParseException {
        switch (whitespaceRetentionPolicy) {
            case REMOVE_ALL: {
                this.skipWhitespace();
                break;
            }
            case REMOVE_FIRST_SPACE: {
                if (this.ch != ' ') break;
                this.nextChar();
                break;
            }
        }
        int n = this.bp;
        int n2 = 1;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    ++n2;
                    break;
                }
                case '}': {
                    if (--n2 == 0) {
                        return this.m.at(n).newTextTree(this.newString(n, this.bp));
                    }
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                default: {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                }
            }
            this.nextChar();
        }
        throw new ParseException("dc.unterminated.inline.tag");
    }

    protected DCTree.DCReference reference(boolean bl) throws ParseException {
        int n = this.bp;
        int n2 = 0;
        block10: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    if (n2 != 0) break;
                    break block10;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++n2;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --n2;
                    break;
                }
                case '}': {
                    if (this.bp == n) {
                        return null;
                    }
                    this.newline = false;
                    break block10;
                }
                case '@': {
                    if (this.newline) break block10;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (n2 > 0) {
            throw new ParseException("dc.unterminated.signature");
        }
        String string = this.newString(n, this.bp);
        try {
            ReferenceParser.Reference reference = new ReferenceParser(this.fac).parse(string);
            return (DCTree.DCReference)this.m.at(n).newReferenceTree(string, reference.moduleName, reference.qualExpr, reference.member, reference.paramTypes).setEndPos(this.bp);
        }
        catch (ReferenceParser.ParseException parseException) {
            throw new ParseException(n + parseException.pos, parseException.getMessage());
        }
    }

    protected DCTree.DCIdentifier identifier() throws ParseException {
        this.skipWhitespace();
        int n = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            Name name = this.readJavaIdentifier();
            return this.m.at(n).newIdentifierTree(name);
        }
        throw new ParseException("dc.identifier.expected");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText quotedString() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return this.m.at(n).newTextTree(this.newString(n, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
            }
            this.nextChar();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText inlineWord() {
        int n = this.bp;
        int n2 = 0;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': {
                    this.newline = true;
                }
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return this.m.at(n).newTextTree(this.newString(n, this.bp));
                }
                case '@': {
                    if (this.newline) {
                        return null;
                    }
                }
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    if (n2 == 0) return this.m.at(n).newTextTree(this.newString(n, this.bp));
                    if (--n2 != 0) break;
                    return this.m.at(n).newTextTree(this.newString(n, this.bp));
                }
            }
            this.newline = false;
            this.nextChar();
        }
        return null;
    }

    private List<DCTree> inlineContent() {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        this.skipWhitespace();
        int n = this.bp;
        int n2 = 1;
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(listBuffer);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(listBuffer, this.bp - 1);
                    listBuffer.add(this.html());
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '{': {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.newline = false;
                    this.nextChar();
                    if (this.ch == '@') {
                        this.addPendingText(listBuffer, this.bp - 2);
                        listBuffer.add(this.inlineTag());
                        this.textStart = this.bp;
                        this.lastNonWhite = -1;
                        continue block9;
                    }
                    ++n2;
                    continue block9;
                }
                case '}': {
                    this.newline = false;
                    if (--n2 == 0) {
                        this.addPendingText(listBuffer, this.bp - 1);
                        this.nextChar();
                        return listBuffer.toList();
                    }
                    this.nextChar();
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.nextChar();
                    continue block9;
                }
            }
        }
        return List.of(this.erroneous("dc.unterminated.inline.tag", n));
    }

    protected void entity(ListBuffer<DCTree> listBuffer) {
        this.newline = false;
        this.addPendingText(listBuffer, this.bp - 1);
        listBuffer.add(this.entity());
        if (this.textStart == -1) {
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        }
    }

    protected DCTree entity() {
        int n = this.bp;
        this.nextChar();
        Name name = null;
        if (this.ch == '#') {
            int n2 = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.bp < this.buflen && this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = this.names.fromChars(this.buf, n2, this.bp - n2);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.bp < this.buflen && this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = this.names.fromChars(this.buf, n2, this.bp - n2);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name == null) {
            return this.erroneous("dc.bad.entity", n);
        }
        if (this.ch != ';') {
            return this.erroneous("dc.missing.semicolon", n);
        }
        this.nextChar();
        return this.m.at(n).newEntityTree(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEndPreamble() {
        int n = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.isIdentifierStart(this.ch)) {
                String string;
                switch (string = StringUtils.toLowerCase(this.readIdentifier().toString())) {
                    case "body": {
                        while (this.bp < this.buflen && this.ch != '>') {
                            this.nextChar();
                        }
                        if (this.ch == '>') {
                            this.nextChar();
                        }
                        while (this.bp < this.buflen && this.isWhitespace(this.ch)) {
                            this.nextChar();
                        }
                        if (this.ch == '<') {
                            this.nextChar();
                            if (this.isIdentifierStart(this.ch) && (string = StringUtils.toLowerCase(this.readIdentifier().toString())).equals("main")) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        boolean bl = true;
                        return bl;
                    }
                    case "main": {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = n;
            this.ch = this.buf[this.bp];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEndBody() {
        int n = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.ch == '/') {
                this.nextChar();
                if (this.isIdentifierStart(this.ch)) {
                    String string;
                    switch (string = StringUtils.toLowerCase(this.readIdentifier().toString())) {
                        case "body": 
                        case "main": {
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = n;
            this.ch = this.buf[this.bp];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean peek(String string) {
        int n = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.ch == '/') {
                if (string.charAt(0) != this.ch) {
                    boolean bl = false;
                    return bl;
                }
                string = string.substring(1);
                this.nextChar();
            }
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                boolean bl = StringUtils.toLowerCase(name.toString()).equals(string);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = n;
            this.ch = this.buf[this.bp];
        }
    }

    private DCTree html() {
        int n = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            Name name = this.readIdentifier();
            List<DCTree> list = this.htmlAttrs();
            if (list != null) {
                boolean bl = false;
                if (this.ch == '/') {
                    this.nextChar();
                    bl = true;
                }
                if (this.ch == '>') {
                    this.nextChar();
                    Object t = ((DCTree.DCEndPosTree)((Object)this.m.at(n).newStartElementTree((javax.lang.model.element.Name)name, list, bl))).setEndPos(this.bp);
                    return t;
                }
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    return this.m.at(n).newEndElementTree(name).setEndPos(this.bp);
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int n2 = 0;
                        while (this.bp < this.buflen && this.ch == '-') {
                            ++n2;
                            this.nextChar();
                        }
                        if (n2 >= 2 && this.ch == '>') {
                            this.nextChar();
                            return this.m.at(n).newCommentTree(this.newString(n, this.bp));
                        }
                        this.nextChar();
                    }
                }
            } else if (this.isIdentifierStart(this.ch) && this.peek("doctype")) {
                this.readIdentifier();
                this.nextChar();
                this.skipWhitespace();
                int n3 = this.bp;
                while (this.bp < this.buflen) {
                    if (this.ch == '>') {
                        int n4 = this.bp;
                        this.nextChar();
                        return this.m.at(n3).newDocTypeTree(this.newString(n3, n4));
                    }
                    this.nextChar();
                }
            }
        }
        this.bp = n + 1;
        this.ch = this.buf[this.bp];
        return this.erroneous("dc.malformed.html", n);
    }

    protected List<DCTree> htmlAttrs() {
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        this.skipWhitespace();
        block0: while (this.bp < this.buflen && this.isIdentifierStart(this.ch)) {
            Object object;
            int n = this.bp;
            Name name = this.readAttributeName();
            this.skipWhitespace();
            List list = null;
            AttributeTree.ValueKind valueKind = AttributeTree.ValueKind.EMPTY;
            if (this.ch == '=') {
                object = new ListBuffer();
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    this.newline = false;
                    valueKind = this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                    char c = this.ch;
                    this.nextChar();
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && this.ch != c) {
                        if (this.newline && this.ch == '@') {
                            listBuffer.add(this.erroneous("dc.unterminated.string", n));
                            break block0;
                        }
                        this.attrValueChar((ListBuffer<DCTree>)object);
                    }
                    this.addPendingText((ListBuffer<DCTree>)object, this.bp - 1);
                    this.nextChar();
                } else {
                    valueKind = AttributeTree.ValueKind.UNQUOTED;
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        this.attrValueChar((ListBuffer<DCTree>)object);
                    }
                    this.addPendingText((ListBuffer<DCTree>)object, this.bp - 1);
                }
                this.skipWhitespace();
                list = ((ListBuffer)object).toList();
            }
            object = this.m.at(n).newAttributeTree((javax.lang.model.element.Name)name, valueKind, (java.util.List)list);
            listBuffer.add(object);
        }
        return listBuffer.toList();
    }

    protected void attrValueChar(ListBuffer<DCTree> listBuffer) {
        switch (this.ch) {
            case '&': {
                this.entity(listBuffer);
                break;
            }
            case '{': {
                this.inlineTag(listBuffer);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected void addPendingText(ListBuffer<DCTree> listBuffer, int n) {
        if (this.textStart != -1) {
            if (this.textStart <= n) {
                listBuffer.add(this.m.at(this.textStart).newTextTree(this.newString(this.textStart, n + 1)));
            }
            this.textStart = -1;
        }
    }

    protected DCTree.DCErroneous erroneous(String string, int n) {
        return this.erroneous(string, n, -1);
    }

    protected DCTree.DCErroneous erroneous(String string, int n, int n2) {
        int n3;
        block4: for (n3 = this.bp - 1; n3 > n; --n3) {
            switch (this.buf[n3]) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
        }
        if (n2 == -1) {
            n2 = n3;
        }
        int n4 = n3 + 1;
        this.textStart = -1;
        JCDiagnostic.DiagnosticPosition diagnosticPosition = DCTree.createDiagnosticPosition(this.comment, n, n2, n4);
        JCDiagnostic jCDiagnostic = this.diags.error(null, this.diagSource, diagnosticPosition, string, new Object[0]);
        return ((DCTree.DCErroneous)this.m.at(n).newErroneousTree(this.newString(n, n4), (Diagnostic)jCDiagnostic)).setPrefPos(n2);
    }

    protected boolean isIdentifierStart(char c) {
        return Character.isUnicodeIdentifierStart(c);
    }

    protected Name readIdentifier() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected Name readAttributeName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '-')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected Name readTagName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == ':')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    protected Name readJavaIdentifier() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected Name readSystemPropertyName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.') {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected boolean isDecimalDigit(char c) {
        return '0' <= c && c <= '9';
    }

    protected boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    protected boolean isHorizontalWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    protected void skipWhitespace() {
        while (this.bp < this.buflen && this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    String newString(int n, int n2) {
        return new String(this.buf, n, n2 - n);
    }

    private Map<Name, TagParser> createTagParsers() {
        TagParser[] tagParserArray = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.AUTHOR){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newAuthorTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.CODE, true){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCText dCText = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(n).newCodeTree(dCText);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.DEPRECATED){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newDeprecatedTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.DOC_ROOT){

            @Override
            public DCTree parse(int n) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newDocRootTree();
                }
                int n2 = DocCommentParser.this.bp;
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException(n2, "dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.EXCEPTION){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(false);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newExceptionTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.HIDDEN){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newHiddenTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INDEX){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCText dCText;
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                DCTree.DCText dCText2 = dCText = DocCommentParser.this.ch == '\"' ? DocCommentParser.this.quotedString() : DocCommentParser.this.inlineWord();
                if (dCText == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                List list = List.nil();
                if (DocCommentParser.this.ch != '}') {
                    list = DocCommentParser.this.inlineContent();
                } else {
                    DocCommentParser.this.nextChar();
                }
                return DocCommentParser.this.m.at(n).newIndexTree((DocTree)dCText, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INHERIT_DOC){

            @Override
            public DCTree parse(int n) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newInheritDocTree();
                }
                int n2 = DocCommentParser.this.bp;
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException(n2, "dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                List list = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(n).newLinkTree((ReferenceTree)dCReference, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK_PLAIN){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                List list = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(n).newLinkPlainTree((ReferenceTree)dCReference, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LITERAL, true){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCText dCText = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(n).newLiteralTree(dCText);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PARAM){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                boolean bl = false;
                if (DocCommentParser.this.ch == '<') {
                    bl = true;
                    DocCommentParser.this.nextChar();
                }
                DCTree.DCIdentifier dCIdentifier = DocCommentParser.this.identifier();
                if (bl) {
                    if (DocCommentParser.this.ch != '>') {
                        throw new ParseException(DocCommentParser.this.bp, "dc.gt.expected");
                    }
                    DocCommentParser.this.nextChar();
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newParamTree(bl, (IdentifierTree)dCIdentifier, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PROVIDES){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newProvidesTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.EITHER, DocTree.Kind.RETURN){

            @Override
            public DCTree parse(int n, TagParser.Kind kind) {
                List list;
                switch (kind) {
                    case BLOCK: {
                        list = DocCommentParser.this.blockContent();
                        break;
                    }
                    case INLINE: {
                        list = DocCommentParser.this.inlineContent();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(kind.toString());
                    }
                }
                return DocCommentParser.this.m.at(n).newReturnTree(kind == TagParser.Kind.INLINE, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SEE){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                switch (DocCommentParser.this.ch) {
                    case '\"': {
                        DCTree.DCText dCText = DocCommentParser.this.quotedString();
                        if (dCText == null) break;
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch != '@' && (DocCommentParser.this.ch != '\u001a' || DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1)) break;
                        return DocCommentParser.this.m.at(n).newSeeTree(List.of(dCText));
                    }
                    case '<': {
                        List<DCTree> list = DocCommentParser.this.blockContent();
                        if (list == null) break;
                        return DocCommentParser.this.m.at(n).newSeeTree(list);
                    }
                    case '@': {
                        if (!DocCommentParser.this.newline) break;
                        throw new ParseException("dc.no.content");
                    }
                    case '\u001a': {
                        if (DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1) break;
                        throw new ParseException("dc.no.content");
                    }
                    default: {
                        if (!DocCommentParser.this.isJavaIdentifierStart(DocCommentParser.this.ch) && DocCommentParser.this.ch != '#') break;
                        DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                        List<DCTree> list = DocCommentParser.this.blockContent();
                        return DocCommentParser.this.m.at(n).newSeeTree(list.prepend(dCReference));
                    }
                }
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_DATA){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSerialDataTree(list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_FIELD){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCIdentifier dCIdentifier = DocCommentParser.this.identifier();
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(false);
                List<DCTree> list = null;
                if (DocCommentParser.this.isWhitespace(DocCommentParser.this.ch)) {
                    DocCommentParser.this.skipWhitespace();
                    list = DocCommentParser.this.blockContent();
                }
                return DocCommentParser.this.m.at(n).newSerialFieldTree((IdentifierTree)dCIdentifier, (ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSerialTree(list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SINCE){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSinceTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SNIPPET){

            @Override
            DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                List<DCTree> list = this.tagAttrs();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newSnippetTree(list, (TextTree)null);
                }
                if (DocCommentParser.this.ch == ':') {
                    DocCommentParser.this.newline = false;
                    DocCommentParser.this.nextChar();
                    while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.isHorizontalWhitespace(DocCommentParser.this.ch)) {
                        DocCommentParser.this.nextChar();
                    }
                    if (!DocCommentParser.this.newline) {
                        if (DocCommentParser.this.bp >= DocCommentParser.this.buf.length - 1) {
                            throw new ParseException("dc.no.content");
                        }
                        throw new ParseException("dc.unexpected.content");
                    }
                    DocCommentParser.this.nextChar();
                    DCTree.DCText dCText = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.RETAIN_ALL);
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newSnippetTree(list, (TextTree)dCText);
                }
                if (DocCommentParser.this.bp >= DocCommentParser.this.buf.length - 1) {
                    throw new ParseException("dc.no.content");
                }
                throw new ParseException("dc.unexpected.content");
            }

            private List<DCTree> tagAttrs() {
                ListBuffer<Object> listBuffer = new ListBuffer<Object>();
                DocCommentParser.this.skipWhitespace();
                while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.isIdentifierStart(DocCommentParser.this.ch)) {
                    Object object;
                    int n = DocCommentParser.this.bp;
                    Name name = DocCommentParser.this.readAttributeName();
                    DocCommentParser.this.skipWhitespace();
                    List list = null;
                    AttributeTree.ValueKind valueKind = AttributeTree.ValueKind.EMPTY;
                    if (DocCommentParser.this.ch == '=') {
                        object = new ListBuffer();
                        DocCommentParser.this.nextChar();
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch == '\'' || DocCommentParser.this.ch == '\"') {
                            DocCommentParser.this.newline = false;
                            valueKind = DocCommentParser.this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                            char c = DocCommentParser.this.ch;
                            DocCommentParser.this.nextChar();
                            DocCommentParser.this.textStart = DocCommentParser.this.bp;
                            while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.ch != c) {
                                DocCommentParser.this.nextChar();
                            }
                            DocCommentParser.this.addPendingText((ListBuffer<DCTree>)object, DocCommentParser.this.bp - 1);
                            DocCommentParser.this.nextChar();
                        } else {
                            valueKind = AttributeTree.ValueKind.UNQUOTED;
                            DocCommentParser.this.textStart = DocCommentParser.this.bp;
                            while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.ch != '}' && DocCommentParser.this.ch != ':' && !DocCommentParser.this.isUnquotedAttrValueTerminator(DocCommentParser.this.ch)) {
                                DocCommentParser.this.nextChar();
                            }
                            DocCommentParser.this.addPendingText((ListBuffer<DCTree>)object, DocCommentParser.this.bp - 1);
                        }
                        DocCommentParser.this.skipWhitespace();
                        list = ((ListBuffer)object).toList();
                    }
                    object = DocCommentParser.this.m.at(n).newAttributeTree((javax.lang.model.element.Name)name, valueKind, (java.util.List)list);
                    listBuffer.add(object);
                }
                return listBuffer.toList();
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SUMMARY){

            @Override
            public DCTree parse(int n) throws ParseException {
                List list = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(n).newSummaryTree((java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SYSTEM_PROPERTY){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                Name name = DocCommentParser.this.readSystemPropertyName();
                if (name == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch != '}') {
                    DocCommentParser.this.nextChar();
                    throw new ParseException("dc.unexpected.content");
                }
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(n).newSystemPropertyTree(name);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.THROWS){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(false);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newThrowsTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.USES){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newUsesTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.VALUE){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newValueTree(dCReference);
                }
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.VERSION){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newVersionTree(list);
            }
        }};
        HashMap<Name, TagParser> hashMap = new HashMap<Name, TagParser>();
        for (TagParser tagParser : tagParserArray) {
            hashMap.put(this.names.fromString(tagParser.getTreeKind().tagName), tagParser);
        }
        return hashMap;
    }

    private static enum WhitespaceRetentionPolicy {
        RETAIN_ALL,
        REMOVE_FIRST_SPACE,
        REMOVE_ALL;

    }

    private static enum Phase {
        PREAMBLE,
        BODY,
        POSTAMBLE;

    }

    private static abstract class TagParser {
        final Kind kind;
        final DocTree.Kind treeKind;
        final boolean retainWhiteSpace;

        TagParser(Kind kind, DocTree.Kind kind2) {
            this.kind = kind;
            this.treeKind = kind2;
            this.retainWhiteSpace = false;
        }

        TagParser(Kind kind, DocTree.Kind kind2, boolean bl) {
            this.kind = kind;
            this.treeKind = kind2;
            this.retainWhiteSpace = bl;
        }

        boolean allowsBlock() {
            return this.kind != Kind.INLINE;
        }

        boolean allowsInline() {
            return this.kind != Kind.BLOCK;
        }

        DocTree.Kind getTreeKind() {
            return this.treeKind;
        }

        DCTree parse(int n, Kind kind) throws ParseException {
            if (kind != this.kind && this.kind != Kind.EITHER) {
                throw new IllegalArgumentException(kind.toString());
            }
            return this.parse(n);
        }

        DCTree parse(int n) throws ParseException {
            throw new UnsupportedOperationException();
        }

        static enum Kind {
            INLINE,
            BLOCK,
            EITHER;

        }
    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;
        final int pos;

        ParseException(String string) {
            this(-1, string);
        }

        ParseException(int n, String string) {
            super(string);
            this.pos = n;
        }
    }
}

