/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.ModuleTree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.parser.LazyDocCommentTable;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.IntHashTable;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JavacParser
implements Parser {
    private static final int infixPrecedenceLevels = 10;
    private final boolean parseModuleInfo;
    protected Lexer S;
    protected TreeMaker F;
    private Log log;
    private Source source;
    private Target target;
    private Preview preview;
    private Names names;
    protected final AbstractEndPosTable endPosTable;
    private List<JCTree.JCAnnotation> typeAnnotationsPushedBack = List.nil();
    private boolean permitTypeAnnotationsPushBack = false;
    boolean allowStringFolding;
    boolean keepDocComments;
    boolean keepLineMap;
    boolean allowThisIdent;
    boolean allowYieldStatement;
    boolean allowRecords;
    boolean allowSealedTypes;
    JCTree.JCVariableDecl receiverParam;
    protected static final int EXPR = 1;
    protected static final int TYPE = 2;
    protected static final int NOPARAMS = 4;
    protected static final int TYPEARG = 8;
    protected static final int DIAMOND = 16;
    protected static final int NOLAMBDA = 32;
    protected int mode = 0;
    protected int lastmode = 0;
    protected Tokens.Token token;
    private JCTree.JCErroneous errorTree;
    private static final int RECOVERY_THRESHOLD = 50;
    private int errorPos = -1;
    private int count = 0;
    private final DocCommentTable docComments;
    ArrayList<JCTree.JCExpression[]> odStackSupply = new ArrayList();
    ArrayList<Tokens.Token[]> opStackSupply = new ArrayList();
    protected Predicate<Tokens.TokenKind> LAX_IDENTIFIER = tokenKind -> tokenKind == Tokens.TokenKind.IDENTIFIER || tokenKind == Tokens.TokenKind.UNDERSCORE || tokenKind == Tokens.TokenKind.ASSERT || tokenKind == Tokens.TokenKind.ENUM;
    private static final JCDiagnostic.Fragment[][] decisionTable = new JCDiagnostic.Fragment[][]{{null, CompilerProperties.Fragments.VarAndExplicitNotAllowed, CompilerProperties.Fragments.VarAndImplicitNotAllowed}, {CompilerProperties.Fragments.VarAndExplicitNotAllowed, null, CompilerProperties.Fragments.ImplicitAndExplicitNotAllowed}, {CompilerProperties.Fragments.VarAndImplicitNotAllowed, CompilerProperties.Fragments.ImplicitAndExplicitNotAllowed, null}};

    protected JavacParser(ParserFactory parserFactory, Lexer lexer, boolean bl, boolean bl2, boolean bl3) {
        this(parserFactory, lexer, bl, bl2, bl3, false);
    }

    protected JavacParser(ParserFactory parserFactory, Lexer lexer, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.S = lexer;
        this.nextToken();
        this.F = parserFactory.F;
        this.log = parserFactory.log;
        this.names = parserFactory.names;
        this.source = parserFactory.source;
        this.target = parserFactory.target;
        this.preview = parserFactory.preview;
        this.allowStringFolding = parserFactory.options.getBoolean("allowStringFolding", true);
        this.keepDocComments = bl;
        this.parseModuleInfo = bl4;
        this.docComments = this.newDocCommentTable(bl, parserFactory);
        this.keepLineMap = bl2;
        this.errorTree = this.F.Erroneous();
        this.endPosTable = this.newEndPosTable(bl3);
        this.allowYieldStatement = Source.Feature.SWITCH_EXPRESSION.allowedInSource(this.source, this.target);
        this.allowRecords = Source.Feature.RECORDS.allowedInSource(this.source, this.target);
        this.allowSealedTypes = Source.Feature.SEALED_CLASSES.allowedInSource(this.source, this.target);
    }

    protected AbstractEndPosTable newEndPosTable(boolean bl) {
        return bl ? new SimpleEndPosTable(this) : new EmptyEndPosTable(this);
    }

    protected DocCommentTable newDocCommentTable(boolean bl, ParserFactory parserFactory) {
        return bl ? new LazyDocCommentTable(parserFactory) : null;
    }

    protected void selectExprMode() {
        this.mode = this.mode & 0x20 | 1;
    }

    protected void selectTypeMode() {
        this.mode = this.mode & 0x20 | 2;
    }

    public Tokens.Token token() {
        return this.token;
    }

    public void nextToken() {
        this.S.nextToken();
        this.token = this.S.token();
    }

    protected boolean peekToken(Predicate<Tokens.TokenKind> predicate) {
        return this.peekToken(0, predicate);
    }

    protected boolean peekToken(int n, Predicate<Tokens.TokenKind> predicate) {
        return predicate.test(this.S.token((int)(n + 1)).kind);
    }

    protected boolean peekToken(Predicate<Tokens.TokenKind> predicate, Predicate<Tokens.TokenKind> predicate2) {
        return this.peekToken(0, predicate, predicate2);
    }

    protected boolean peekToken(int n, Predicate<Tokens.TokenKind> predicate, Predicate<Tokens.TokenKind> predicate2) {
        return predicate.test(this.S.token((int)(n + 1)).kind) && predicate2.test(this.S.token((int)(n + 2)).kind);
    }

    protected boolean peekToken(Predicate<Tokens.TokenKind> predicate, Predicate<Tokens.TokenKind> predicate2, Predicate<Tokens.TokenKind> predicate3) {
        return this.peekToken(0, predicate, predicate2, predicate3);
    }

    protected boolean peekToken(int n, Predicate<Tokens.TokenKind> predicate, Predicate<Tokens.TokenKind> predicate2, Predicate<Tokens.TokenKind> predicate3) {
        return predicate.test(this.S.token((int)(n + 1)).kind) && predicate2.test(this.S.token((int)(n + 2)).kind) && predicate3.test(this.S.token((int)(n + 3)).kind);
    }

    protected boolean peekToken(Predicate<Tokens.TokenKind> ... predicateArray) {
        return this.peekToken(0, predicateArray);
    }

    protected boolean peekToken(int n, Predicate<Tokens.TokenKind> ... predicateArray) {
        for (Predicate<Tokens.TokenKind> predicate : predicateArray) {
            if (predicate.test(this.S.token((int)(++n)).kind)) continue;
            return false;
        }
        return true;
    }

    protected void skip(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        while (true) {
            switch (this.token.kind) {
                case SEMI: {
                    this.nextToken();
                    return;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case MONKEYS_AT: 
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case IMPORT: {
                    if (!bl) break;
                    return;
                }
                case LBRACE: 
                case RBRACE: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case TRANSIENT: 
                case NATIVE: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case LT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (!bl2) break;
                    return;
                }
                case UNDERSCORE: 
                case IDENTIFIER: {
                    if (!bl3) break;
                    return;
                }
                case CASE: 
                case DEFAULT: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: 
                case THIS: 
                case SUPER: 
                case NEW: {
                    if (!bl4) break;
                    return;
                }
                case ASSERT: {
                    if (!bl4) break;
                    return;
                }
            }
            this.nextToken();
        }
    }

    protected JCTree.JCErroneous syntaxError(int n, JCDiagnostic.Error error) {
        return this.syntaxError(n, List.nil(), error);
    }

    protected JCTree.JCErroneous syntaxError(int n, List<JCTree> list, JCDiagnostic.Error error) {
        JCTree jCTree;
        this.setErrorEndPos(n);
        JCTree.JCErroneous jCErroneous = this.F.at(n).Erroneous(list);
        this.reportSyntaxError(jCErroneous, error);
        if (list != null && (jCTree = list.last()) != null) {
            this.storeEnd(jCTree, n);
        }
        return this.toP(jCErroneous);
    }

    protected void reportSyntaxError(int n, JCDiagnostic.Error error) {
        JCDiagnostic.SimpleDiagnosticPosition simpleDiagnosticPosition = new JCDiagnostic.SimpleDiagnosticPosition(n);
        this.reportSyntaxError(simpleDiagnosticPosition, error);
    }

    protected void reportSyntaxError(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Error error) {
        int n = diagnosticPosition.getPreferredPosition();
        if (n > this.S.errPos() || n == -1) {
            if (this.token.kind == Tokens.TokenKind.EOF) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, diagnosticPosition, CompilerProperties.Errors.PrematureEof);
            } else {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, diagnosticPosition, error);
            }
        }
        this.S.errPos(n);
        if (this.token.pos == this.errorPos && this.token.kind != Tokens.TokenKind.EOF) {
            Assert.check(this.count++ < 50);
        } else {
            this.count = 0;
            this.errorPos = this.token.pos;
        }
    }

    public void accept(Tokens.TokenKind tokenKind) {
        this.accept(tokenKind, CompilerProperties.Errors::Expected);
    }

    public void accept(Tokens.TokenKind tokenKind, Function<Tokens.TokenKind, JCDiagnostic.Error> function) {
        if (this.token.kind == tokenKind) {
            this.nextToken();
        } else {
            this.setErrorEndPos(this.token.pos);
            this.reportSyntaxError(this.S.prevToken().endPos, function.apply(tokenKind));
        }
    }

    JCTree.JCExpression illegal(int n) {
        this.setErrorEndPos(n);
        if ((this.mode & 1) != 0) {
            return this.syntaxError(n, CompilerProperties.Errors.IllegalStartOfExpr);
        }
        return this.syntaxError(n, CompilerProperties.Errors.IllegalStartOfType);
    }

    JCTree.JCExpression illegal() {
        return this.illegal(this.token.pos);
    }

    protected void checkNoMods(long l) {
        this.checkNoMods(this.token.pos, l);
    }

    protected void checkNoMods(int n, long l) {
        if (l != 0L) {
            long l2 = l & -l;
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, n, CompilerProperties.Errors.ModNotAllowedHere(Flags.asFlagSet(l2)));
        }
    }

    protected void attach(JCTree jCTree, Tokens.Comment comment) {
        if (this.keepDocComments && comment != null) {
            this.docComments.putComment(jCTree, comment);
        }
    }

    protected void setErrorEndPos(int n) {
        this.endPosTable.setErrorEndPos(n);
    }

    protected void storeEnd(JCTree jCTree, int n) {
        this.endPosTable.storeEnd(jCTree, n);
    }

    protected <T extends JCTree> T to(T t) {
        return this.endPosTable.to(t);
    }

    protected <T extends JCTree> T toP(T t) {
        return this.endPosTable.toP(t);
    }

    public int getStartPos(JCTree jCTree) {
        return TreeInfo.getStartPos(jCTree);
    }

    public int getEndPos(JCTree jCTree) {
        return this.endPosTable.getEndPos(jCTree);
    }

    public Name ident() {
        return this.ident(false);
    }

    protected Name ident(boolean bl) {
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        if (this.token.kind == Tokens.TokenKind.ASSERT) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.AssertAsIdentifier);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.ENUM) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.EnumAsIdentifier);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.THIS) {
            if (this.allowThisIdent) {
                this.checkSourceLevel(Source.Feature.TYPE_ANNOTATIONS);
                Name name = this.token.name();
                this.nextToken();
                return name;
            }
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.ThisAsIdentifier);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.UNDERSCORE) {
            if (Source.Feature.UNDERSCORE_IDENTIFIER.allowedInSource(this.source, this.target)) {
                this.log.warning(this.token.pos, CompilerProperties.Warnings.UnderscoreAsIdentifier);
            } else {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.UnderscoreAsIdentifier);
            }
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        this.accept(Tokens.TokenKind.IDENTIFIER);
        if (bl && this.token.kind == Tokens.TokenKind.CLASS) {
            this.nextToken();
            return this.names._class;
        }
        return this.names.error;
    }

    public JCTree.JCExpression qualident(boolean bl) {
        JCTree.JCExpression jCExpression = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        while (this.token.kind == Tokens.TokenKind.DOT) {
            int n = this.token.pos;
            this.nextToken();
            List<JCTree.JCAnnotation> list = null;
            if (bl) {
                list = this.typeAnnotationsOpt();
            }
            jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.ident()));
            if (list == null || !list.nonEmpty()) continue;
            jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list.head).pos).AnnotatedType(list, jCExpression));
        }
        return jCExpression;
    }

    JCTree.JCExpression literal(Name name) {
        return this.literal(name, this.token.pos);
    }

    JCTree.JCExpression literal(Name name, int n) {
        JCTree.JCExpression jCExpression = this.errorTree;
        switch (this.token.kind) {
            case INTLITERAL: {
                try {
                    jCExpression = this.F.at(n).Literal(TypeTag.INT, Convert.string2int(this.strval(name), this.token.radix()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.IntNumberTooLarge(this.strval(name)));
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    jCExpression = this.F.at(n).Literal(TypeTag.LONG, Convert.string2long(this.strval(name), this.token.radix()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.IntNumberTooLarge(this.strval(name)));
                }
                break;
            }
            case FLOATLITERAL: {
                Float f;
                String string = this.token.radix() == 16 ? "0x" + this.token.stringVal() : this.token.stringVal();
                try {
                    f = Float.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    f = Float.valueOf(Float.NaN);
                }
                if (f.floatValue() == 0.0f && !this.isZero(string)) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.FpNumberTooSmall);
                    break;
                }
                if (f.floatValue() == Float.POSITIVE_INFINITY) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.FpNumberTooLarge);
                    break;
                }
                jCExpression = this.F.at(n).Literal(TypeTag.FLOAT, f);
                break;
            }
            case DOUBLELITERAL: {
                Double d;
                String string = this.token.radix() == 16 ? "0x" + this.token.stringVal() : this.token.stringVal();
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    d = Double.NaN;
                }
                if (d == 0.0 && !this.isZero(string)) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.FpNumberTooSmall);
                    break;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.FpNumberTooLarge);
                    break;
                }
                jCExpression = this.F.at(n).Literal(TypeTag.DOUBLE, d);
                break;
            }
            case CHARLITERAL: {
                jCExpression = this.F.at(n).Literal(TypeTag.CHAR, this.token.stringVal().charAt(0) + '\u0000');
                break;
            }
            case STRINGLITERAL: {
                jCExpression = this.F.at(n).Literal(TypeTag.CLASS, this.token.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: {
                jCExpression = this.F.at(n).Literal(TypeTag.BOOLEAN, this.token.kind == Tokens.TokenKind.TRUE ? 1 : 0);
                break;
            }
            case NULL: {
                jCExpression = this.F.at(n).Literal(TypeTag.BOT, null);
                break;
            }
            default: {
                Assert.error();
            }
        }
        if (jCExpression == this.errorTree) {
            jCExpression = this.F.at(n).Erroneous();
        }
        this.storeEnd(jCExpression, this.token.endPos);
        this.nextToken();
        return jCExpression;
    }

    boolean isZero(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length > 1 && Character.toLowerCase(cArray[1]) == 'x' ? 16 : 10;
        int n3 = n = n2 == 16 ? 2 : 0;
        while (n < cArray.length && (cArray[n] == '0' || cArray[n] == '.')) {
            ++n;
        }
        return n >= cArray.length || Character.digit(cArray[n], n2) <= 0;
    }

    String strval(Name name) {
        String string = this.token.stringVal();
        return name.isEmpty() ? string : name + string;
    }

    @Override
    public JCTree.JCExpression parseExpression() {
        return this.term(1);
    }

    public JCTree.JCPattern parsePattern(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, boolean bl, boolean bl2) {
        JCTree.JCPattern jCPattern;
        if (this.token.kind == Tokens.TokenKind.LPAREN && jCExpression == null) {
            int n2 = this.token.pos;
            this.accept(Tokens.TokenKind.LPAREN);
            JCTree.JCPattern jCPattern2 = this.parsePattern(this.token.pos, null, null, true, false);
            this.accept(Tokens.TokenKind.RPAREN);
            jCPattern = this.toP(this.F.at(n2).ParenthesizedPattern(jCPattern2));
        } else {
            JCTree.JCExpression jCExpression2;
            JCTree.JCModifiers jCModifiers2 = jCModifiers = jCModifiers != null ? jCModifiers : this.optFinal(0L);
            if (jCExpression == null) {
                boolean bl3 = this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.var;
                jCExpression2 = this.unannotatedType(bl, 34);
                if (bl3) {
                    jCExpression2 = null;
                }
            } else {
                jCExpression2 = jCExpression;
            }
            if (this.token.kind == Tokens.TokenKind.LPAREN) {
                JCTree jCTree;
                this.checkSourceLevel(Source.Feature.RECORD_PATTERNS);
                ListBuffer<JCTree.JCPattern> listBuffer = new ListBuffer<JCTree.JCPattern>();
                if (!this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) {
                    do {
                        this.nextToken();
                        jCTree = this.parsePattern(this.token.pos, null, null, true, false);
                        listBuffer.append((JCTree.JCPattern)jCTree);
                    } while (this.token.kind == Tokens.TokenKind.COMMA);
                } else {
                    this.nextToken();
                }
                this.accept(Tokens.TokenKind.RPAREN);
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
                    if (!bl2 || this.token.name() != this.names.when) {
                        jCTree = this.to(this.F.at(this.token.pos).VarDef(this.F.Modifiers(0L), this.token.name(), jCExpression2, null));
                        this.nextToken();
                    } else {
                        jCTree = null;
                    }
                } else {
                    jCTree = null;
                }
                jCPattern = this.toP(this.F.at(n).RecordPattern(jCExpression2, listBuffer.toList(), (JCTree.JCVariableDecl)jCTree));
            } else {
                JCTree.JCVariableDecl jCVariableDecl = this.toP(this.F.at(this.token.pos).VarDef(jCModifiers, this.ident(), jCExpression2, null));
                jCPattern = this.toP(this.F.at(n).BindingPattern(jCVariableDecl));
            }
        }
        return jCPattern;
    }

    @Override
    public JCTree.JCExpression parseType() {
        return this.parseType(false);
    }

    public JCTree.JCExpression parseType(boolean bl) {
        List<JCTree.JCAnnotation> list = this.typeAnnotationsOpt();
        return this.parseType(bl, list);
    }

    public JCTree.JCExpression parseType(boolean bl, List<JCTree.JCAnnotation> list) {
        JCTree.JCExpression jCExpression = this.unannotatedType(bl);
        if (list.nonEmpty()) {
            jCExpression = this.insertAnnotationsToMostInner(jCExpression, list, false);
        }
        return jCExpression;
    }

    public JCTree.JCExpression unannotatedType(boolean bl) {
        return this.unannotatedType(bl, 2);
    }

    public JCTree.JCExpression unannotatedType(boolean bl, int n) {
        JCTree.JCExpression jCExpression = this.term(n);
        Name name = this.restrictedTypeName(jCExpression, !bl);
        if (!(name == null || bl && name == this.names.var)) {
            this.syntaxError(jCExpression.pos, CompilerProperties.Errors.RestrictedTypeNotAllowedHere(name));
        }
        return jCExpression;
    }

    protected JCTree.JCExpression term(int n) {
        int n2 = this.mode;
        this.mode = n;
        JCTree.JCExpression jCExpression = this.term();
        this.lastmode = this.mode;
        this.mode = n2;
        return jCExpression;
    }

    JCTree.JCExpression term() {
        JCTree.JCExpression jCExpression = this.term1();
        if ((this.mode & 1) != 0 && (this.token.kind == Tokens.TokenKind.EQ || Tokens.TokenKind.PLUSEQ.compareTo(this.token.kind) <= 0 && this.token.kind.compareTo(Tokens.TokenKind.GTGTGTEQ) <= 0)) {
            return this.termRest(jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCExpression termRest(JCTree.JCExpression jCExpression) {
        switch (this.token.kind) {
            case EQ: {
                int n = this.token.pos;
                this.nextToken();
                this.selectExprMode();
                JCTree.JCExpression jCExpression2 = this.term();
                return this.toP(this.F.at(n).Assign(jCExpression, jCExpression2));
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int n = this.token.pos;
                Tokens.TokenKind tokenKind = this.token.kind;
                this.nextToken();
                this.selectExprMode();
                JCTree.JCExpression jCExpression3 = this.term();
                return this.F.at(n).Assignop(JavacParser.optag(tokenKind), jCExpression, jCExpression3);
            }
        }
        return jCExpression;
    }

    JCTree.JCExpression term1() {
        JCTree.JCExpression jCExpression = this.term2();
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.QUES) {
            this.selectExprMode();
            return this.term1Rest(jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCExpression term1Rest(JCTree.JCExpression jCExpression) {
        if (this.token.kind == Tokens.TokenKind.QUES) {
            int n = this.token.pos;
            this.nextToken();
            JCTree.JCExpression jCExpression2 = this.term();
            this.accept(Tokens.TokenKind.COLON);
            JCTree.JCExpression jCExpression3 = this.term1();
            return this.F.at(n).Conditional(jCExpression, jCExpression2, jCExpression3);
        }
        return jCExpression;
    }

    JCTree.JCExpression term2() {
        JCTree.JCExpression jCExpression = this.term3();
        if ((this.mode & 1) != 0 && JavacParser.prec(this.token.kind) >= 4) {
            this.selectExprMode();
            return this.term2Rest(jCExpression, 4);
        }
        return jCExpression;
    }

    JCTree.JCExpression term2Rest(JCTree.JCExpression jCExpression, int n) {
        JCTree.JCExpression[] jCExpressionArray = this.newOdStack();
        Tokens.Token[] tokenArray = this.newOpStack();
        int n2 = 0;
        jCExpressionArray[0] = jCExpression;
        int n3 = this.token.pos;
        Tokens.Token token = Tokens.DUMMY;
        while (JavacParser.prec(this.token.kind) >= n) {
            tokenArray[n2] = token;
            if (this.token.kind == Tokens.TokenKind.INSTANCEOF) {
                JCTree jCTree;
                int n4 = this.token.pos;
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.LPAREN) {
                    this.checkSourceLevel(this.token.pos, Source.Feature.PATTERN_SWITCH);
                    jCTree = this.parsePattern(this.token.pos, null, null, false, false);
                } else {
                    int n5 = this.token.pos;
                    JCTree.JCModifiers jCModifiers = this.optFinal(0L);
                    int n6 = this.token.pos;
                    JCTree.JCExpression jCExpression2 = this.unannotatedType(false);
                    if (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
                        this.checkSourceLevel(this.token.pos, Source.Feature.PATTERN_MATCHING_IN_INSTANCEOF);
                        jCTree = this.parsePattern(n5, jCModifiers, jCExpression2, false, false);
                    } else if (this.token.kind == Tokens.TokenKind.LPAREN) {
                        jCTree = this.parsePattern(n5, jCModifiers, jCExpression2, false, false);
                    } else {
                        this.checkNoMods(n6, jCModifiers.flags & 0xFFFFFFFFFFFDFFFFL);
                        if (jCModifiers.annotations.nonEmpty()) {
                            this.checkSourceLevel(((JCTree.JCAnnotation)jCModifiers.annotations.head).pos, Source.Feature.TYPE_ANNOTATIONS);
                            List<JCTree.JCAnnotation> list = jCModifiers.annotations.map(jCAnnotation -> {
                                JCTree.JCAnnotation jCAnnotation2 = this.F.at(jCAnnotation.pos).TypeAnnotation(jCAnnotation.annotationType, jCAnnotation.args);
                                this.endPosTable.replaceTree((JCTree)jCAnnotation, jCAnnotation2);
                                return jCAnnotation2;
                            });
                            jCExpression2 = this.insertAnnotationsToMostInner(jCExpression2, list, false);
                        }
                        jCTree = jCExpression2;
                    }
                }
                jCExpressionArray[n2] = this.F.at(n4).TypeTest(jCExpressionArray[n2], jCTree);
            } else {
                token = this.token;
                this.nextToken();
                jCExpressionArray[++n2] = this.term3();
            }
            while (n2 > 0 && JavacParser.prec(token.kind) >= JavacParser.prec(this.token.kind)) {
                jCExpressionArray[n2 - 1] = this.F.at(token.pos).Binary(JavacParser.optag(token.kind), jCExpressionArray[n2 - 1], jCExpressionArray[n2]);
                token = tokenArray[--n2];
            }
        }
        Assert.check(n2 == 0);
        jCExpression = jCExpressionArray[0];
        if (jCExpression.hasTag(JCTree.Tag.PLUS)) {
            jCExpression = this.foldStrings(jCExpression);
        }
        this.odStackSupply.add(jCExpressionArray);
        this.opStackSupply.add(tokenArray);
        return jCExpression;
    }

    protected JCTree.JCExpression foldStrings(JCTree.JCExpression jCExpression) {
        Object object;
        if (!this.allowStringFolding) {
            return jCExpression;
        }
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCLiteral> listBuffer2 = new ListBuffer<JCTree.JCLiteral>();
        boolean bl = false;
        JCTree.JCExpression jCExpression2 = jCExpression;
        while (jCExpression2.hasTag(JCTree.Tag.PLUS)) {
            object = (JCTree.JCBinary)jCExpression2;
            bl |= this.foldIfNeeded(((JCTree.JCBinary)object).rhs, listBuffer2, listBuffer, false);
            jCExpression2 = ((JCTree.JCBinary)object).lhs;
        }
        if (bl |= this.foldIfNeeded(jCExpression2, listBuffer2, listBuffer, true)) {
            object = listBuffer.toList();
            JCTree.JCExpression jCExpression3 = (JCTree.JCExpression)((List)object).head;
            for (JCTree.JCExpression jCExpression4 : ((List)object).tail) {
                jCExpression3 = this.F.at(jCExpression4.getStartPosition()).Binary(JavacParser.optag(Tokens.TokenKind.PLUS), jCExpression3, jCExpression4);
                this.storeEnd(jCExpression3, this.getEndPos(jCExpression4));
            }
            return jCExpression3;
        }
        return jCExpression;
    }

    private boolean foldIfNeeded(JCTree.JCExpression jCExpression, ListBuffer<JCTree.JCLiteral> listBuffer, ListBuffer<JCTree.JCExpression> listBuffer2, boolean bl) {
        JCTree.JCLiteral jCLiteral = this.stringLiteral(jCExpression);
        if (jCLiteral != null) {
            listBuffer.prepend(jCLiteral);
            return bl && this.merge(listBuffer, listBuffer2);
        }
        boolean bl2 = this.merge(listBuffer, listBuffer2);
        listBuffer.clear();
        listBuffer2.prepend(jCExpression);
        return bl2;
    }

    boolean merge(ListBuffer<JCTree.JCLiteral> listBuffer, ListBuffer<JCTree.JCExpression> listBuffer2) {
        if (listBuffer.isEmpty()) {
            return false;
        }
        if (listBuffer.size() == 1) {
            listBuffer2.prepend(listBuffer.first());
            return false;
        }
        JCTree.JCLiteral jCLiteral2 = this.F.at(listBuffer.first().getStartPosition()).Literal(TypeTag.CLASS, listBuffer.stream().map(jCLiteral -> (String)jCLiteral.getValue()).collect(Collectors.joining()));
        this.storeEnd(jCLiteral2, listBuffer.last().getEndPosition(this.endPosTable));
        listBuffer2.prepend(jCLiteral2);
        return true;
    }

    private JCTree.JCLiteral stringLiteral(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.LITERAL)) {
            JCTree.JCLiteral jCLiteral = (JCTree.JCLiteral)jCTree;
            if (jCLiteral.typetag == TypeTag.CLASS) {
                return jCLiteral;
            }
        }
        return null;
    }

    private JCTree.JCExpression[] newOdStack() {
        if (this.odStackSupply.isEmpty()) {
            return new JCTree.JCExpression[11];
        }
        return this.odStackSupply.remove(this.odStackSupply.size() - 1);
    }

    private Tokens.Token[] newOpStack() {
        if (this.opStackSupply.isEmpty()) {
            return new Tokens.Token[11];
        }
        return this.opStackSupply.remove(this.opStackSupply.size() - 1);
    }

    protected JCTree.JCExpression term3() {
        JCTree.JCExpression jCExpression;
        int n = this.token.pos;
        List<JCTree.JCExpression> list = this.typeArgumentsOpt(1);
        block0 : switch (this.token.kind) {
            case QUES: {
                if ((this.mode & 2) != 0 && (this.mode & 0xC) == 8) {
                    this.selectTypeMode();
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case PLUSPLUS: 
            case SUBSUB: 
            case BANG: 
            case TILDE: 
            case PLUS: 
            case SUB: {
                if (list == null && (this.mode & 1) != 0) {
                    Tokens.TokenKind tokenKind = this.token.kind;
                    this.nextToken();
                    this.selectExprMode();
                    if (tokenKind == Tokens.TokenKind.SUB && (this.token.kind == Tokens.TokenKind.INTLITERAL || this.token.kind == Tokens.TokenKind.LONGLITERAL) && this.token.radix() == 10) {
                        this.selectExprMode();
                        jCExpression = this.literal(this.names.hyphen, n);
                        break;
                    }
                    JCTree.JCExpression jCExpression2 = this.term3();
                    return this.F.at(n).Unary(JavacParser.unoptag(tokenKind), jCExpression2);
                }
                return this.illegal();
            }
            case LPAREN: {
                if (list == null && (this.mode & 1) != 0) {
                    ParensResult parensResult = this.analyzeParens();
                    switch (parensResult) {
                        case CAST: {
                            this.accept(Tokens.TokenKind.LPAREN);
                            this.selectTypeMode();
                            int n2 = n;
                            JCTree.JCExpression jCExpression3 = this.parseType();
                            List<JCTree.JCExpression> list2 = List.of(jCExpression3);
                            while (this.token.kind == Tokens.TokenKind.AMP) {
                                this.checkSourceLevel(Source.Feature.INTERSECTION_TYPES_IN_CAST);
                                this.accept(Tokens.TokenKind.AMP);
                                list2 = list2.prepend(this.parseType());
                            }
                            if (list2.length() > 1) {
                                jCExpression3 = this.toP(this.F.at(n2).TypeIntersection(list2.reverse()));
                            }
                            this.accept(Tokens.TokenKind.RPAREN);
                            this.selectExprMode();
                            JCTree.JCExpression jCExpression4 = this.term3();
                            return this.F.at(n).TypeCast(jCExpression3, jCExpression4);
                        }
                        case IMPLICIT_LAMBDA: 
                        case EXPLICIT_LAMBDA: {
                            jCExpression = this.lambdaExpressionOrStatement(true, parensResult == ParensResult.EXPLICIT_LAMBDA, n);
                            break block0;
                        }
                    }
                    this.accept(Tokens.TokenKind.LPAREN);
                    this.selectExprMode();
                    jCExpression = this.termRest(this.term1Rest(this.term2Rest(this.term3(), 4)));
                    this.accept(Tokens.TokenKind.RPAREN);
                    jCExpression = this.toP(this.F.at(n).Parens(jCExpression));
                    break;
                }
                return this.illegal();
            }
            case THIS: {
                if ((this.mode & 1) != 0) {
                    this.selectExprMode();
                    jCExpression = this.to(this.F.at(n).Ident(this.names._this));
                    this.nextToken();
                    jCExpression = list == null ? this.argumentsOpt(null, jCExpression) : this.arguments(list, jCExpression);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if ((this.mode & 1) != 0) {
                    this.selectExprMode();
                    jCExpression = this.to(this.F.at(n).Ident(this.names._super));
                    jCExpression = this.superSuffix(list, jCExpression);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                if (list == null && (this.mode & 1) != 0) {
                    this.selectExprMode();
                    jCExpression = this.literal(this.names.empty);
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (list != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.selectExprMode();
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.LT) {
                        list = this.typeArguments(false);
                    }
                    jCExpression = this.creator(n, list);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case MONKEYS_AT: {
                List<JCTree.JCAnnotation> list3 = this.typeAnnotationsOpt();
                if (list3.isEmpty()) {
                    throw new AssertionError((Object)"Expected type annotations, but found none!");
                }
                JCTree.JCExpression jCExpression5 = this.term3();
                if ((this.mode & 2) == 0) {
                    switch (jCExpression5.getTag()) {
                        case REFERENCE: {
                            JCTree.JCMemberReference jCMemberReference = (JCTree.JCMemberReference)jCExpression5;
                            jCMemberReference.expr = this.toP(this.F.at(n).AnnotatedType(list3, jCMemberReference.expr));
                            jCExpression = jCMemberReference;
                            break block0;
                        }
                        case SELECT: {
                            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCExpression5;
                            if (jCFieldAccess.name != this.names._class) {
                                return this.illegal();
                            }
                            this.log.error(this.token.pos, CompilerProperties.Errors.NoAnnotationsOnDotClass);
                            return jCExpression5;
                        }
                    }
                    return this.illegal(((JCTree.JCAnnotation)list3.head).pos);
                }
                jCExpression = this.insertAnnotationsToMostInner(jCExpression5, list3, false);
                break;
            }
            case ENUM: 
            case UNDERSCORE: 
            case IDENTIFIER: 
            case ASSERT: {
                if (list != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0 && (this.mode & 0x20) == 0 && this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.ARROW)) {
                    jCExpression = this.lambdaExpressionOrStatement(false, false, n);
                } else {
                    jCExpression = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
                    block40: while (true) {
                        n = this.token.pos;
                        List<JCTree.JCAnnotation> list4 = this.typeAnnotationsOpt();
                        if (!list4.isEmpty() && this.token.kind != Tokens.TokenKind.LBRACKET && this.token.kind != Tokens.TokenKind.ELLIPSIS) {
                            return this.illegal(((JCTree.JCAnnotation)list4.head).pos);
                        }
                        switch (this.token.kind) {
                            case LBRACKET: {
                                this.nextToken();
                                if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                                    this.nextToken();
                                    jCExpression = this.bracketsOpt(jCExpression);
                                    jCExpression = this.toP(this.F.at(n).TypeArray(jCExpression));
                                    if (list4.nonEmpty()) {
                                        jCExpression = this.toP(this.F.at(n).AnnotatedType(list4, jCExpression));
                                    }
                                    jCExpression = this.bracketsSuffix(jCExpression);
                                    break block40;
                                }
                                if ((this.mode & 1) != 0) {
                                    this.selectExprMode();
                                    JCTree.JCExpression jCExpression6 = this.term();
                                    if (!list4.isEmpty()) {
                                        jCExpression = this.illegal(((JCTree.JCAnnotation)list4.head).pos);
                                    }
                                    jCExpression = this.to(this.F.at(n).Indexed(jCExpression, jCExpression6));
                                }
                                this.accept(Tokens.TokenKind.RBRACKET);
                                break block40;
                            }
                            case LPAREN: {
                                if ((this.mode & 1) != 0) {
                                    this.selectExprMode();
                                    jCExpression = this.arguments(list, jCExpression);
                                    if (!list4.isEmpty()) {
                                        jCExpression = this.illegal(((JCTree.JCAnnotation)list4.head).pos);
                                    }
                                    list = null;
                                }
                                break block40;
                            }
                            case DOT: {
                                this.nextToken();
                                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && list != null) {
                                    return this.illegal();
                                }
                                int n3 = this.mode;
                                this.mode &= 0xFFFFFFFB;
                                list = this.typeArgumentsOpt(1);
                                this.mode = n3;
                                if ((this.mode & 1) != 0) {
                                    switch (this.token.kind) {
                                        case CLASS: {
                                            if (list != null) {
                                                return this.illegal();
                                            }
                                            this.selectExprMode();
                                            jCExpression = this.to(this.F.at(n).Select(jCExpression, this.names._class));
                                            this.nextToken();
                                            break block40;
                                        }
                                        case THIS: {
                                            if (list != null) {
                                                return this.illegal();
                                            }
                                            this.selectExprMode();
                                            jCExpression = this.to(this.F.at(n).Select(jCExpression, this.names._this));
                                            this.nextToken();
                                            break block40;
                                        }
                                        case SUPER: {
                                            this.selectExprMode();
                                            jCExpression = this.to(this.F.at(n).Select(jCExpression, this.names._super));
                                            jCExpression = this.superSuffix(list, jCExpression);
                                            list = null;
                                            break block40;
                                        }
                                        case NEW: {
                                            if (list != null) {
                                                return this.illegal();
                                            }
                                            this.selectExprMode();
                                            int n4 = this.token.pos;
                                            this.nextToken();
                                            if (this.token.kind == Tokens.TokenKind.LT) {
                                                list = this.typeArguments(false);
                                            }
                                            jCExpression = this.innerCreator(n4, list, jCExpression);
                                            list = null;
                                            break block40;
                                        }
                                    }
                                }
                                List<JCTree.JCAnnotation> list5 = null;
                                if ((this.mode & 2) != 0 && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                                    list5 = this.typeAnnotationsOpt();
                                }
                                jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.ident()));
                                if (this.token.pos <= this.endPosTable.errorEndPos && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                                    if (list != null) {
                                        this.illegal();
                                    }
                                    return this.toP(jCExpression);
                                }
                                if (list5 == null || !list5.nonEmpty()) continue block40;
                                jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list5.head).pos).AnnotatedType(list5, jCExpression));
                                continue block40;
                            }
                            case ELLIPSIS: {
                                if (this.permitTypeAnnotationsPushBack) {
                                    this.typeAnnotationsPushedBack = list4;
                                    break block40;
                                }
                                if (list4.nonEmpty()) {
                                    this.illegal(((JCTree.JCAnnotation)list4.head).pos);
                                }
                                break block40;
                            }
                            case LT: {
                                if ((this.mode & 2) == 0 && this.isUnboundMemberRef()) {
                                    int n5 = this.token.pos;
                                    this.accept(Tokens.TokenKind.LT);
                                    ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                                    listBuffer.append(this.typeArgument());
                                    while (this.token.kind == Tokens.TokenKind.COMMA) {
                                        this.nextToken();
                                        listBuffer.append(this.typeArgument());
                                    }
                                    this.accept(Tokens.TokenKind.GT);
                                    jCExpression = this.toP(this.F.at(n5).TypeApply(jCExpression, listBuffer.toList()));
                                    while (this.token.kind == Tokens.TokenKind.DOT) {
                                        this.nextToken();
                                        this.selectTypeMode();
                                        jCExpression = this.toP(this.F.at(this.token.pos).Select(jCExpression, this.ident()));
                                        jCExpression = this.typeArgumentsOpt(jCExpression);
                                    }
                                    jCExpression = this.bracketsOpt(jCExpression);
                                    if (this.token.kind != Tokens.TokenKind.COLCOL) {
                                        jCExpression = this.illegal();
                                    }
                                    this.selectExprMode();
                                    return this.term3Rest(jCExpression, list);
                                }
                                break block40;
                            }
                        }
                        break;
                    }
                }
                if (list != null) {
                    this.illegal();
                }
                jCExpression = this.typeArgumentsOpt(jCExpression);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (list != null) {
                    this.illegal();
                }
                jCExpression = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (list != null) {
                    this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.DOT) {
                        JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = this.toP(this.F.at(n).TypeIdent(TypeTag.VOID));
                        jCExpression = this.bracketsSuffix(jCPrimitiveTypeTree);
                        break;
                    }
                    return this.illegal(n);
                }
                JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = this.to(this.F.at(n).TypeIdent(TypeTag.VOID));
                this.nextToken();
                return jCPrimitiveTypeTree;
            }
            case SWITCH: {
                this.checkSourceLevel(Source.Feature.SWITCH_EXPRESSION);
                this.allowYieldStatement = true;
                int n6 = this.token.pos;
                this.nextToken();
                JCTree.JCExpression jCExpression7 = this.parExpression();
                this.accept(Tokens.TokenKind.LBRACE);
                ListBuffer<JCTree.JCCase> listBuffer = new ListBuffer<JCTree.JCCase>();
                block43: while (true) {
                    n = this.token.pos;
                    switch (this.token.kind) {
                        case CASE: 
                        case DEFAULT: {
                            listBuffer.appendList(this.switchExpressionStatementGroup());
                            continue block43;
                        }
                        case EOF: 
                        case RBRACE: {
                            JCTree.JCSwitchExpression jCSwitchExpression = this.to(this.F.at(n6).SwitchExpression(jCExpression7, listBuffer.toList()));
                            jCSwitchExpression.endpos = this.token.pos;
                            this.accept(Tokens.TokenKind.RBRACE);
                            return jCSwitchExpression;
                        }
                    }
                    this.nextToken();
                    this.syntaxError(n, CompilerProperties.Errors.Expected3(Tokens.TokenKind.CASE, Tokens.TokenKind.DEFAULT, Tokens.TokenKind.RBRACE));
                }
            }
            default: {
                return this.illegal();
            }
        }
        return this.term3Rest(jCExpression, list);
    }

    private List<JCTree.JCCase> switchExpressionStatementGroup() {
        CaseTree.CaseKind caseKind;
        List<JCTree.JCStatement> list;
        ListBuffer<JCTree.JCCase> listBuffer = new ListBuffer<JCTree.JCCase>();
        int n = this.token.pos;
        ListBuffer<JCTree.JCCaseLabel> listBuffer2 = new ListBuffer<JCTree.JCCaseLabel>();
        if (this.token.kind == Tokens.TokenKind.DEFAULT) {
            this.nextToken();
            listBuffer2.append(this.toP(this.F.at(n).DefaultCaseLabel()));
        } else {
            this.accept(Tokens.TokenKind.CASE);
            while (true) {
                list = this.parseCaseLabel();
                listBuffer2.append((JCTree.JCCaseLabel)((Object)list));
                if (this.token.kind != Tokens.TokenKind.COMMA) break;
                this.checkSourceLevel(Source.Feature.SWITCH_MULTIPLE_CASE_LABELS);
                this.nextToken();
            }
        }
        list = null;
        JCTree jCTree = null;
        switch (this.token.kind) {
            case ARROW: {
                this.checkSourceLevel(Source.Feature.SWITCH_RULE);
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.THROW || this.token.kind == Tokens.TokenKind.LBRACE) {
                    list = List.of(this.parseStatement());
                    jCTree = (JCTree)list.head;
                    caseKind = JCTree.JCCase.RULE;
                    break;
                }
                JCTree.JCExpression jCExpression = this.parseExpression();
                list = List.of((JCTree.JCStatement)this.to(this.F.at(jCExpression).Yield(jCExpression)));
                jCTree = jCExpression;
                caseKind = JCTree.JCCase.RULE;
                this.accept(Tokens.TokenKind.SEMI);
                break;
            }
            default: {
                this.accept(Tokens.TokenKind.COLON, tokenKind -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.COLON, Tokens.TokenKind.ARROW));
                list = this.blockStatements();
                caseKind = JCTree.JCCase.STATEMENT;
            }
        }
        listBuffer.append(this.toP(this.F.at(n).Case(caseKind, listBuffer2.toList(), list, jCTree)));
        return listBuffer.toList();
    }

    JCTree.JCExpression term3Rest(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list) {
        block21: {
            List<JCTree.JCAnnotation> list2;
            if (list != null) {
                this.illegal();
            }
            while (true) {
                int n;
                int n2 = this.token.pos;
                list2 = this.typeAnnotationsOpt();
                if (this.token.kind == Tokens.TokenKind.LBRACKET) {
                    this.nextToken();
                    if ((this.mode & 2) != 0) {
                        n = this.mode;
                        this.selectTypeMode();
                        if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                            this.nextToken();
                            jCExpression = this.bracketsOpt(jCExpression);
                            jCExpression = this.toP(this.F.at(n2).TypeArray(jCExpression));
                            if (this.token.kind == Tokens.TokenKind.COLCOL) {
                                this.selectExprMode();
                                continue;
                            }
                            if (list2.nonEmpty()) {
                                jCExpression = this.toP(this.F.at(n2).AnnotatedType(list2, jCExpression));
                            }
                            return jCExpression;
                        }
                        this.mode = n;
                    }
                    if ((this.mode & 1) != 0) {
                        this.selectExprMode();
                        JCTree.JCExpression jCExpression2 = this.term();
                        jCExpression = this.to(this.F.at(n2).Indexed(jCExpression, jCExpression2));
                    }
                    this.accept(Tokens.TokenKind.RBRACKET);
                    continue;
                }
                if (this.token.kind == Tokens.TokenKind.DOT) {
                    this.nextToken();
                    list = this.typeArgumentsOpt(1);
                    if (this.token.kind == Tokens.TokenKind.SUPER && (this.mode & 1) != 0) {
                        this.selectExprMode();
                        jCExpression = this.to(this.F.at(n2).Select(jCExpression, this.names._super));
                        this.nextToken();
                        jCExpression = this.arguments(list, jCExpression);
                        list = null;
                        continue;
                    }
                    if (this.token.kind == Tokens.TokenKind.NEW && (this.mode & 1) != 0) {
                        if (list != null) {
                            return this.illegal();
                        }
                        this.selectExprMode();
                        n = this.token.pos;
                        this.nextToken();
                        if (this.token.kind == Tokens.TokenKind.LT) {
                            list = this.typeArguments(false);
                        }
                        jCExpression = this.innerCreator(n, list, jCExpression);
                        list = null;
                        continue;
                    }
                    List<JCTree.JCAnnotation> list3 = null;
                    if ((this.mode & 2) != 0 && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                        list3 = this.typeAnnotationsOpt();
                    }
                    jCExpression = this.toP(this.F.at(n2).Select(jCExpression, this.ident(true)));
                    if (this.token.pos > this.endPosTable.errorEndPos || this.token.kind != Tokens.TokenKind.MONKEYS_AT) {
                        if (list3 != null && list3.nonEmpty()) {
                            jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list3.head).pos).AnnotatedType(list3, jCExpression));
                        }
                        jCExpression = this.argumentsOpt(list, this.typeArgumentsOpt(jCExpression));
                        list = null;
                        continue;
                    }
                    break block21;
                }
                if ((this.mode & 1) == 0 || this.token.kind != Tokens.TokenKind.COLCOL) break;
                this.selectExprMode();
                if (list != null) {
                    return this.illegal();
                }
                this.accept(Tokens.TokenKind.COLCOL);
                jCExpression = this.memberReferenceSuffix(n2, jCExpression);
            }
            if (!list2.isEmpty()) {
                if (this.permitTypeAnnotationsPushBack) {
                    this.typeAnnotationsPushedBack = list2;
                } else {
                    return this.illegal(((JCTree.JCAnnotation)list2.head).pos);
                }
            }
        }
        while ((this.token.kind == Tokens.TokenKind.PLUSPLUS || this.token.kind == Tokens.TokenKind.SUBSUB) && (this.mode & 1) != 0) {
            this.selectExprMode();
            jCExpression = this.to(this.F.at(this.token.pos).Unary(this.token.kind == Tokens.TokenKind.PLUSPLUS ? JCTree.Tag.POSTINC : JCTree.Tag.POSTDEC, jCExpression));
            this.nextToken();
        }
        return this.toP(jCExpression);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isUnboundMemberRef() {
        int n = 0;
        int n2 = 0;
        Tokens.Token token = this.S.token(n);
        while (true) {
            block0 : switch (token.kind) {
                case MONKEYS_AT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case SUPER: 
                case LBRACKET: 
                case DOT: 
                case QUES: 
                case EXTENDS: 
                case RBRACKET: 
                case COMMA: {
                    break;
                }
                case LPAREN: {
                    Tokens.TokenKind tokenKind;
                    int n3 = 0;
                    while (true) {
                        tokenKind = this.S.token((int)n).kind;
                        switch (tokenKind) {
                            case EOF: {
                                return false;
                            }
                            case LPAREN: {
                                ++n3;
                                break;
                            }
                            case RPAREN: {
                                if (--n3 == 0) break block0;
                            }
                        }
                        ++n;
                    }
                }
                case LT: {
                    ++n2;
                    break;
                }
                case GTGTGT: {
                    --n2;
                }
                case GTGT: {
                    --n2;
                }
                case GT: {
                    if (--n2 != 0) break;
                    Tokens.TokenKind tokenKind = this.S.token((int)(n + 1)).kind;
                    if (tokenKind == Tokens.TokenKind.DOT) return true;
                    if (tokenKind == Tokens.TokenKind.LBRACKET) return true;
                    if (tokenKind == Tokens.TokenKind.COLCOL) return true;
                    return false;
                }
                default: {
                    return false;
                }
            }
            token = this.S.token(++n);
        }
    }

    ParensResult analyzeParens() {
        int n = 0;
        boolean bl = false;
        ParensResult parensResult = ParensResult.PARENS;
        int n2 = 0;
        while (true) {
            Tokens.TokenKind tokenKind = this.S.token((int)n2).kind;
            switch (tokenKind) {
                case COMMA: {
                    bl = true;
                }
                case SUPER: 
                case DOT: 
                case EXTENDS: 
                case AMP: {
                    break;
                }
                case QUES: {
                    if (!this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.EXTENDS) && !this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.SUPER)) break;
                    bl = true;
                    break;
                }
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) {
                        return ParensResult.CAST;
                    }
                    if (!this.peekToken(n2, this.LAX_IDENTIFIER)) break;
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case LPAREN: {
                    if (n2 != 0) {
                        return ParensResult.PARENS;
                    }
                    if (!this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) break;
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case RPAREN: {
                    if (bl) {
                        return ParensResult.CAST;
                    }
                    switch (this.S.token((int)(n2 + 1)).kind) {
                        case ENUM: 
                        case BYTE: 
                        case SHORT: 
                        case CHAR: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case BOOLEAN: 
                        case VOID: 
                        case UNDERSCORE: 
                        case IDENTIFIER: 
                        case SWITCH: 
                        case THIS: 
                        case SUPER: 
                        case NEW: 
                        case ASSERT: 
                        case INTLITERAL: 
                        case LONGLITERAL: 
                        case FLOATLITERAL: 
                        case DOUBLELITERAL: 
                        case CHARLITERAL: 
                        case STRINGLITERAL: 
                        case TRUE: 
                        case FALSE: 
                        case NULL: 
                        case LPAREN: 
                        case BANG: 
                        case TILDE: {
                            return ParensResult.CAST;
                        }
                    }
                    return parensResult;
                }
                case ENUM: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case ASSERT: {
                    if (this.peekToken(n2, this.LAX_IDENTIFIER)) {
                        return ParensResult.EXPLICIT_LAMBDA;
                    }
                    if (this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.ARROW)) {
                        return (this.mode & 0x20) == 0 ? ParensResult.IMPLICIT_LAMBDA : ParensResult.PARENS;
                    }
                    if (n == 0 && this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.COMMA)) {
                        parensResult = ParensResult.IMPLICIT_LAMBDA;
                    }
                    bl = false;
                    break;
                }
                case FINAL: 
                case ELLIPSIS: {
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case MONKEYS_AT: {
                    bl = true;
                    n2 = this.skipAnnotation(n2);
                    break;
                }
                case LBRACKET: {
                    if (this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, this.LAX_IDENTIFIER)) {
                        return ParensResult.EXPLICIT_LAMBDA;
                    }
                    if (this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN) || this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.AMP)) {
                        return ParensResult.CAST;
                    }
                    if (this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET)) {
                        bl = true;
                        ++n2;
                        break;
                    }
                    return ParensResult.PARENS;
                }
                case LT: {
                    ++n;
                    break;
                }
                case GTGTGT: {
                    --n;
                }
                case GTGT: {
                    --n;
                }
                case GT: {
                    if (--n == 0) {
                        if (this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN) || this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.AMP)) {
                            return ParensResult.CAST;
                        }
                        if (this.peekToken(n2, this.LAX_IDENTIFIER, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.COMMA) || this.peekToken(n2, this.LAX_IDENTIFIER, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.ARROW) || this.peekToken(n2, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.ELLIPSIS)) {
                            return ParensResult.EXPLICIT_LAMBDA;
                        }
                        bl = true;
                        break;
                    }
                    if (n >= 0) break;
                    return ParensResult.PARENS;
                }
                default: {
                    return parensResult;
                }
            }
            ++n2;
        }
    }

    private int skipAnnotation(int n) {
        ++n;
        while (this.peekToken(n, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.DOT)) {
            n += 2;
        }
        if (this.peekToken(n, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.LPAREN)) {
            ++n;
            int n2 = 0;
            while (true) {
                Tokens.TokenKind tokenKind = this.S.token((int)n).kind;
                switch (tokenKind) {
                    case EOF: {
                        return n;
                    }
                    case LPAREN: {
                        ++n2;
                        break;
                    }
                    case RPAREN: {
                        if (--n2 != 0) break;
                        return n;
                    }
                }
                ++n;
            }
        }
        return n;
    }

    JCTree.JCExpression lambdaExpressionOrStatement(boolean bl, boolean bl2, int n) {
        List<JCTree.JCVariableDecl> list;
        List<JCTree.JCVariableDecl> list2 = list = bl2 ? this.formalParameters(true, false) : this.implicitParameters(bl);
        if (bl2) {
            LambdaClassifier lambdaClassifier = new LambdaClassifier();
            for (JCTree.JCVariableDecl jCVariableDecl : list) {
                Name name;
                if (jCVariableDecl.vartype != null && (name = this.restrictedTypeName(jCVariableDecl.vartype, false)) != null && jCVariableDecl.vartype.hasTag(JCTree.Tag.TYPEARRAY)) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, jCVariableDecl.pos, Source.Feature.VAR_SYNTAX_IMPLICIT_LAMBDAS.allowedInSource(this.source, this.target) ? CompilerProperties.Errors.RestrictedTypeNotAllowedArray(name) : CompilerProperties.Errors.RestrictedTypeNotAllowedHere(name));
                }
                lambdaClassifier.addParameter(jCVariableDecl);
                if (lambdaClassifier.result() != LambdaParameterKind.ERROR) continue;
                break;
            }
            if (lambdaClassifier.diagFragment != null) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, n, CompilerProperties.Errors.InvalidLambdaParameterDeclaration(lambdaClassifier.diagFragment));
            }
            for (JCTree.JCVariableDecl jCVariableDecl : list) {
                if (jCVariableDecl.vartype == null || this.restrictedTypeName(jCVariableDecl.vartype, true) == null) continue;
                this.checkSourceLevel(jCVariableDecl.pos, Source.Feature.VAR_SYNTAX_IMPLICIT_LAMBDAS);
                jCVariableDecl.startPos = TreeInfo.getStartPos(jCVariableDecl.vartype);
                jCVariableDecl.vartype = null;
            }
        }
        return this.lambdaExpressionOrStatementRest(list, n);
    }

    JCTree.JCExpression lambdaExpressionOrStatementRest(List<JCTree.JCVariableDecl> list, int n) {
        this.checkSourceLevel(Source.Feature.LAMBDA);
        this.accept(Tokens.TokenKind.ARROW);
        return this.token.kind == Tokens.TokenKind.LBRACE ? this.lambdaStatement(list, n, this.token.pos) : this.lambdaExpression(list, n);
    }

    JCTree.JCExpression lambdaStatement(List<JCTree.JCVariableDecl> list, int n, int n2) {
        JCTree.JCBlock jCBlock = this.block(n2, 0L);
        return this.toP(this.F.at(n).Lambda(list, jCBlock));
    }

    JCTree.JCExpression lambdaExpression(List<JCTree.JCVariableDecl> list, int n) {
        JCTree.JCExpression jCExpression = this.parseExpression();
        return this.toP(this.F.at(n).Lambda(list, jCExpression));
    }

    JCTree.JCExpression superSuffix(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        this.nextToken();
        if (this.token.kind == Tokens.TokenKind.LPAREN || list != null) {
            jCExpression = this.arguments(list, jCExpression);
        } else if (this.token.kind == Tokens.TokenKind.COLCOL) {
            if (list != null) {
                return this.illegal();
            }
            jCExpression = this.memberReferenceSuffix(jCExpression);
        } else {
            int n = this.token.pos;
            this.accept(Tokens.TokenKind.DOT);
            list = this.token.kind == Tokens.TokenKind.LT ? this.typeArguments(false) : null;
            jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.ident()));
            jCExpression = this.argumentsOpt(list, jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCPrimitiveTypeTree basicType() {
        JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = this.to(this.F.at(this.token.pos).TypeIdent(JavacParser.typetag(this.token.kind)));
        this.nextToken();
        return jCPrimitiveTypeTree;
    }

    JCTree.JCExpression argumentsOpt(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.LPAREN || list != null) {
            this.selectExprMode();
            return this.arguments(list, jCExpression);
        }
        return jCExpression;
    }

    List<JCTree.JCExpression> arguments() {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            this.nextToken();
            if (this.token.kind != Tokens.TokenKind.RPAREN) {
                listBuffer.append(this.parseExpression());
                while (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                    listBuffer.append(this.parseExpression());
                }
            }
            this.accept(Tokens.TokenKind.RPAREN, tokenKind -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.RPAREN, Tokens.TokenKind.COMMA));
        } else {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected(Tokens.TokenKind.LPAREN));
        }
        return listBuffer.toList();
    }

    JCTree.JCExpression arguments(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        int n = this.token.pos;
        List<JCTree.JCExpression> list2 = this.arguments();
        JCTree.JCExpression jCExpression2 = this.F.at(n).Apply(list, jCExpression, list2);
        if (jCExpression.hasTag(JCTree.Tag.IDENT) && this.isInvalidUnqualifiedMethodIdentifier(((JCTree.JCIdent)jCExpression).pos, ((JCTree.JCIdent)jCExpression).name)) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, jCExpression, CompilerProperties.Errors.InvalidYield);
            jCExpression2 = this.F.Erroneous(List.of(jCExpression2));
        }
        return this.toP(jCExpression2);
    }

    boolean isInvalidUnqualifiedMethodIdentifier(int n, Name name) {
        if (name == this.names.yield) {
            if (this.allowYieldStatement) {
                return true;
            }
            this.log.warning(n, CompilerProperties.Warnings.InvalidYield);
        }
        return false;
    }

    JCTree.JCExpression typeArgumentsOpt(JCTree.JCExpression jCExpression) {
        if (this.token.kind == Tokens.TokenKind.LT && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.selectTypeMode();
            return this.typeArguments(jCExpression, false);
        }
        return jCExpression;
    }

    List<JCTree.JCExpression> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<JCTree.JCExpression> typeArgumentsOpt(int n) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            if ((this.mode & n) == 0 || (this.mode & 4) != 0) {
                this.illegal();
            }
            this.mode = n;
            return this.typeArguments(false);
        }
        return null;
    }

    List<JCTree.JCExpression> typeArguments(boolean bl) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.GT && bl) {
                this.checkSourceLevel(Source.Feature.DIAMOND);
                this.mode |= 0x10;
                this.nextToken();
                return List.nil();
            }
            ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
            listBuffer.append((this.mode & 1) == 0 ? this.typeArgument() : this.parseType());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                listBuffer.append((this.mode & 1) == 0 ? this.typeArgument() : this.parseType());
            }
            switch (this.token.kind) {
                case GTGTEQ: 
                case GTGTGTEQ: 
                case GTGTGT: 
                case GTGT: 
                case GTEQ: {
                    this.token = this.S.split();
                    break;
                }
                case GT: {
                    this.nextToken();
                    break;
                }
                default: {
                    listBuffer.append(this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected2(Tokens.TokenKind.GT, Tokens.TokenKind.COMMA)));
                }
            }
            return listBuffer.toList();
        }
        return List.of(this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected(Tokens.TokenKind.LT)));
    }

    JCTree.JCExpression typeArgument() {
        JCTree.JCExpression jCExpression;
        List<JCTree.JCAnnotation> list = this.typeAnnotationsOpt();
        if (this.token.kind != Tokens.TokenKind.QUES) {
            return this.parseType(false, list);
        }
        int n = this.token.pos;
        this.nextToken();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            JCTree.TypeBoundKind typeBoundKind = this.to(this.F.at(n).TypeBoundKind(BoundKind.EXTENDS));
            this.nextToken();
            JCTree.JCExpression jCExpression2 = this.parseType();
            jCExpression = this.F.at(n).Wildcard(typeBoundKind, jCExpression2);
        } else if (this.token.kind == Tokens.TokenKind.SUPER) {
            JCTree.TypeBoundKind typeBoundKind = this.to(this.F.at(n).TypeBoundKind(BoundKind.SUPER));
            this.nextToken();
            JCTree.JCExpression jCExpression3 = this.parseType();
            jCExpression = this.F.at(n).Wildcard(typeBoundKind, jCExpression3);
        } else if (this.LAX_IDENTIFIER.test(this.token.kind)) {
            JCTree.TypeBoundKind typeBoundKind = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
            JCTree.JCExpression jCExpression4 = this.toP(this.F.at(n).Wildcard(typeBoundKind, null));
            JCTree.JCIdent jCIdent = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
            JCTree.JCErroneous jCErroneous = this.F.at(n).Erroneous(List.of(jCExpression4, jCIdent));
            this.reportSyntaxError(jCErroneous, CompilerProperties.Errors.Expected3(Tokens.TokenKind.GT, Tokens.TokenKind.EXTENDS, Tokens.TokenKind.SUPER));
            jCExpression = jCErroneous;
        } else {
            JCTree.TypeBoundKind typeBoundKind = this.toP(this.F.at(n).TypeBoundKind(BoundKind.UNBOUND));
            jCExpression = this.toP(this.F.at(n).Wildcard(typeBoundKind, null));
        }
        if (!list.isEmpty()) {
            jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list.head).pos).AnnotatedType(list, jCExpression));
        }
        return jCExpression;
    }

    JCTree.JCTypeApply typeArguments(JCTree.JCExpression jCExpression, boolean bl) {
        int n = this.token.pos;
        List<JCTree.JCExpression> list = this.typeArguments(bl);
        return this.toP(this.F.at(n).TypeApply(jCExpression, list));
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression jCExpression, List<JCTree.JCAnnotation> list) {
        List<JCTree.JCAnnotation> list2 = this.typeAnnotationsOpt();
        if (this.token.kind == Tokens.TokenKind.LBRACKET) {
            int n = this.token.pos;
            this.nextToken();
            jCExpression = this.bracketsOptCont(jCExpression, n, list2);
        } else if (!list2.isEmpty()) {
            if (this.permitTypeAnnotationsPushBack) {
                this.typeAnnotationsPushedBack = list2;
            } else {
                return this.illegal(((JCTree.JCAnnotation)list2.head).pos);
            }
        }
        if (!list.isEmpty()) {
            jCExpression = this.toP(this.F.at(this.token.pos).AnnotatedType(list, jCExpression));
        }
        return jCExpression;
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression jCExpression) {
        return this.bracketsOpt(jCExpression, List.nil());
    }

    private JCTree.JCExpression bracketsOptCont(JCTree.JCExpression jCExpression, int n, List<JCTree.JCAnnotation> list) {
        this.accept(Tokens.TokenKind.RBRACKET);
        jCExpression = this.bracketsOpt(jCExpression);
        jCExpression = this.toP(this.F.at(n).TypeArray(jCExpression));
        if (list.nonEmpty()) {
            jCExpression = this.toP(this.F.at(n).AnnotatedType(list, jCExpression));
        }
        return jCExpression;
    }

    JCTree.JCExpression bracketsSuffix(JCTree.JCExpression jCExpression) {
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.DOT) {
            this.selectExprMode();
            int n = this.token.pos;
            this.nextToken();
            this.accept(Tokens.TokenKind.CLASS);
            if (this.token.pos == this.endPosTable.errorEndPos) {
                Name name;
                if (this.LAX_IDENTIFIER.test(this.token.kind)) {
                    name = this.token.name();
                    this.nextToken();
                } else {
                    name = this.names.error;
                }
                jCExpression = this.F.at(n).Erroneous(List.of(this.toP(this.F.at(n).Select(jCExpression, name))));
            } else {
                JCTree.Tag tag = jCExpression.getTag();
                if (tag == JCTree.Tag.TYPEARRAY && TreeInfo.containsTypeAnnotation(jCExpression) || tag == JCTree.Tag.ANNOTATED_TYPE) {
                    this.syntaxError(this.token.pos, CompilerProperties.Errors.NoAnnotationsOnDotClass);
                }
                jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.names._class));
            }
        } else if ((this.mode & 2) != 0) {
            if (this.token.kind != Tokens.TokenKind.COLCOL) {
                this.selectTypeMode();
            }
        } else if (this.token.kind != Tokens.TokenKind.COLCOL) {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.DotClassExpected);
        }
        return jCExpression;
    }

    JCTree.JCExpression memberReferenceSuffix(JCTree.JCExpression jCExpression) {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.COLCOL);
        return this.memberReferenceSuffix(n, jCExpression);
    }

    JCTree.JCExpression memberReferenceSuffix(int n, JCTree.JCExpression jCExpression) {
        Name name;
        MemberReferenceTree.ReferenceMode referenceMode;
        this.checkSourceLevel(Source.Feature.METHOD_REFERENCES);
        this.selectExprMode();
        List<JCTree.JCExpression> list = null;
        if (this.token.kind == Tokens.TokenKind.LT) {
            list = this.typeArguments(false);
        }
        if (this.token.kind == Tokens.TokenKind.NEW) {
            referenceMode = MemberReferenceTree.ReferenceMode.NEW;
            name = this.names.init;
            this.nextToken();
        } else {
            referenceMode = MemberReferenceTree.ReferenceMode.INVOKE;
            name = this.ident();
        }
        return this.toP(this.F.at(jCExpression.getStartPosition()).Reference(referenceMode, name, jCExpression, list));
    }

    JCTree.JCExpression creator(int n, List<JCTree.JCExpression> list) {
        List<JCTree.JCAnnotation> list2 = this.typeAnnotationsOpt();
        switch (this.token.kind) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (list != null) break;
                if (list2.isEmpty()) {
                    return this.arrayCreatorRest(n, this.basicType());
                }
                return this.arrayCreatorRest(n, this.toP(this.F.at(((JCTree.JCAnnotation)list2.head).pos).AnnotatedType(list2, this.basicType())));
            }
        }
        JCTree.JCExpression jCExpression = this.qualident(true);
        int n2 = this.mode;
        this.selectTypeMode();
        boolean bl = false;
        int n3 = -1;
        if (this.token.kind == Tokens.TokenKind.LT) {
            n3 = this.token.pos;
            jCExpression = this.typeArguments(jCExpression, true);
            boolean bl2 = bl = (this.mode & 0x10) != 0;
        }
        while (this.token.kind == Tokens.TokenKind.DOT) {
            if (bl) {
                this.illegal();
            }
            int n4 = this.token.pos;
            this.nextToken();
            List<JCTree.JCAnnotation> list3 = this.typeAnnotationsOpt();
            jCExpression = this.toP(this.F.at(n4).Select(jCExpression, this.ident()));
            if (list3 != null && list3.nonEmpty()) {
                jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list3.head).pos).AnnotatedType(list3, jCExpression));
            }
            if (this.token.kind != Tokens.TokenKind.LT) continue;
            n3 = this.token.pos;
            jCExpression = this.typeArguments(jCExpression, true);
            bl = (this.mode & 0x10) != 0;
        }
        this.mode = n2;
        if (this.token.kind == Tokens.TokenKind.LBRACKET || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            if (list2.nonEmpty()) {
                jCExpression = this.insertAnnotationsToMostInner(jCExpression, list2, false);
            }
            JCTree.JCExpression jCExpression2 = this.arrayCreatorRest(n, jCExpression);
            if (bl) {
                this.reportSyntaxError(n3, CompilerProperties.Errors.CannotCreateArrayWithDiamond);
                return this.toP(this.F.at(n).Erroneous(List.of(jCExpression2)));
            }
            if (list != null) {
                int n5 = n;
                if (!list.isEmpty() && ((JCTree.JCExpression)list.head).pos != -1) {
                    n5 = ((JCTree.JCExpression)list.head).pos;
                }
                this.setErrorEndPos(this.S.prevToken().endPos);
                JCTree.JCErroneous jCErroneous = this.F.at(n5).Erroneous(list.prepend(jCExpression2));
                this.reportSyntaxError(jCErroneous, CompilerProperties.Errors.CannotCreateArrayWithTypeArguments);
                return this.toP(jCErroneous);
            }
            return jCExpression2;
        }
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            if (list2.nonEmpty()) {
                jCExpression = this.insertAnnotationsToMostInner(jCExpression, list2, false);
            }
            return this.classCreatorRest(n, null, list, jCExpression);
        }
        this.setErrorEndPos(this.token.pos);
        this.reportSyntaxError(this.token.pos, CompilerProperties.Errors.Expected2(Tokens.TokenKind.LPAREN, Tokens.TokenKind.LBRACKET));
        jCExpression = this.toP(this.F.at(n).NewClass(null, list, jCExpression, List.nil(), null));
        return this.toP(this.F.at(n).Erroneous(List.of(jCExpression)));
    }

    JCTree.JCExpression innerCreator(int n, List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        List<JCTree.JCAnnotation> list2 = this.typeAnnotationsOpt();
        JCTree.JCExpression jCExpression2 = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        if (list2.nonEmpty()) {
            jCExpression2 = this.toP(this.F.at(((JCTree.JCAnnotation)list2.head).pos).AnnotatedType(list2, jCExpression2));
        }
        if (this.token.kind == Tokens.TokenKind.LT) {
            int n2 = this.mode;
            jCExpression2 = this.typeArguments(jCExpression2, true);
            this.mode = n2;
        }
        return this.classCreatorRest(n, jCExpression, list, jCExpression2);
    }

    JCTree.JCExpression arrayCreatorRest(int n, JCTree.JCExpression jCExpression) {
        int n2;
        List<JCTree.JCExpression> list;
        List<JCTree.JCAnnotation> list2 = this.typeAnnotationsOpt();
        this.accept(Tokens.TokenKind.LBRACKET);
        if (this.token.kind == Tokens.TokenKind.RBRACKET) {
            this.accept(Tokens.TokenKind.RBRACKET);
            jCExpression = this.bracketsOpt(jCExpression, list2);
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)this.arrayInitializer(n, jCExpression);
                if (list2.nonEmpty()) {
                    JCTree.JCAnnotatedType jCAnnotatedType = (JCTree.JCAnnotatedType)jCExpression;
                    assert (jCAnnotatedType.annotations == list2);
                    jCNewArray.annotations = jCAnnotatedType.annotations;
                    jCNewArray.elemtype = jCAnnotatedType.underlyingType;
                }
                return jCNewArray;
            }
            JCTree.JCExpression jCExpression2 = this.toP(this.F.at(n).NewArray(jCExpression, List.nil(), null));
            return this.syntaxError(this.token.pos, List.of(jCExpression2), CompilerProperties.Errors.ArrayDimensionMissing);
        }
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<List<JCTree.JCAnnotation>> listBuffer2 = new ListBuffer<List<JCTree.JCAnnotation>>();
        listBuffer2.append(list2);
        listBuffer.append(this.parseExpression());
        this.accept(Tokens.TokenKind.RBRACKET);
        while (this.token.kind == Tokens.TokenKind.LBRACKET || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            list = this.typeAnnotationsOpt();
            n2 = this.token.pos;
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                jCExpression = this.bracketsOptCont(jCExpression, n2, list);
                continue;
            }
            listBuffer2.append(list);
            listBuffer.append(this.parseExpression());
            this.accept(Tokens.TokenKind.RBRACKET);
        }
        list = null;
        n2 = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            list = this.arrayInitializerElements(n, jCExpression);
        }
        JCTree.JCNewArray jCNewArray = this.toP(this.F.at(n).NewArray(jCExpression, listBuffer.toList(), list));
        jCNewArray.dimAnnotations = listBuffer2.toList();
        if (list != null) {
            return this.syntaxError(n2, List.of(jCNewArray), CompilerProperties.Errors.IllegalArrayCreationBothDimensionAndInitialization);
        }
        return jCNewArray;
    }

    JCTree.JCNewClass classCreatorRest(int n, JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression2) {
        List<JCTree.JCExpression> list2 = this.arguments();
        JCTree.JCClassDecl jCClassDecl = null;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            int n2 = this.token.pos;
            List<JCTree> list3 = this.classInterfaceOrRecordBody(this.names.empty, false, false);
            JCTree.JCModifiers jCModifiers = this.F.at(-1).Modifiers(0L);
            jCClassDecl = this.toP(this.F.at(n2).AnonymousClassDef(jCModifiers, list3));
        }
        return this.toP(this.F.at(n).NewClass(jCExpression, list, jCExpression2, list2, jCClassDecl));
    }

    JCTree.JCExpression arrayInitializer(int n, JCTree.JCExpression jCExpression) {
        List<JCTree.JCExpression> list = this.arrayInitializerElements(n, jCExpression);
        return this.toP(this.F.at(n).NewArray(jCExpression, List.nil(), list));
    }

    List<JCTree.JCExpression> arrayInitializerElements(int n, JCTree.JCExpression jCExpression) {
        this.accept(Tokens.TokenKind.LBRACE);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
        } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
            listBuffer.append(this.variableInitializer());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.RBRACE) break;
                listBuffer.append(this.variableInitializer());
            }
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return listBuffer.toList();
    }

    public JCTree.JCExpression variableInitializer() {
        return this.token.kind == Tokens.TokenKind.LBRACE ? this.arrayInitializer(this.token.pos, null) : this.parseExpression();
    }

    JCTree.JCExpression parExpression() {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.LPAREN);
        JCTree.JCExpression jCExpression = this.parseExpression();
        this.accept(Tokens.TokenKind.RPAREN);
        return this.toP(this.F.at(n).Parens(jCExpression));
    }

    JCTree.JCBlock block(int n, long l) {
        this.accept(Tokens.TokenKind.LBRACE);
        List<JCTree.JCStatement> list = this.blockStatements();
        JCTree.JCBlock jCBlock = this.F.at(n).Block(l, list);
        while (this.token.kind == Tokens.TokenKind.CASE || this.token.kind == Tokens.TokenKind.DEFAULT) {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.Orphaned(this.token.kind));
            this.switchBlockStatementGroups();
        }
        jCBlock.endpos = this.token.pos;
        this.accept(Tokens.TokenKind.RBRACE);
        return this.toP(jCBlock);
    }

    public JCTree.JCBlock block() {
        return this.block(this.token.pos, 0L);
    }

    List<JCTree.JCStatement> blockStatements() {
        int n = -1;
        ListBuffer<JCTree.JCStatement> listBuffer = new ListBuffer<JCTree.JCStatement>();
        List<JCTree.JCStatement> list;
        while (!(list = this.blockStatement()).isEmpty()) {
            if (this.token.pos == n) {
                return listBuffer.toList();
            }
            if (this.token.pos <= this.endPosTable.errorEndPos) {
                this.skip(false, true, true, true);
                n = this.token.pos;
            }
            listBuffer.addAll((Collection<JCTree.JCStatement>)list);
        }
        return listBuffer.toList();
    }

    JCTree.JCStatement parseStatementAsBlock() {
        int n = this.token.pos;
        List<JCTree.JCStatement> list = this.blockStatement();
        if (list.isEmpty()) {
            JCTree.JCErroneous jCErroneous = this.syntaxError(n, CompilerProperties.Errors.IllegalStartOfStmt);
            return this.toP(this.F.at(n).Exec(jCErroneous));
        }
        JCTree.JCStatement jCStatement = (JCTree.JCStatement)list.head;
        JCDiagnostic.Error error = null;
        switch (jCStatement.getTag()) {
            case CLASSDEF: {
                error = CompilerProperties.Errors.ClassNotAllowed;
                break;
            }
            case VARDEF: {
                error = CompilerProperties.Errors.VariableNotAllowed;
            }
        }
        if (error != null) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, jCStatement, error);
            List<JCTree.JCBlock> list2 = List.of(this.F.at(jCStatement.pos).Block(0L, list));
            return this.toP(this.F.at(n).Exec(this.F.at(jCStatement.pos).Erroneous(list2)));
        }
        return jCStatement;
    }

    List<JCTree.JCStatement> blockStatement() {
        Tokens.Token token;
        int n = this.token.pos;
        switch (this.token.kind) {
            case EOF: 
            case RBRACE: 
            case CASE: 
            case DEFAULT: {
                return List.nil();
            }
            case SEMI: 
            case LBRACE: 
            case SYNCHRONIZED: 
            case IF: 
            case FOR: 
            case WHILE: 
            case DO: 
            case TRY: 
            case SWITCH: 
            case RETURN: 
            case THROW: 
            case BREAK: 
            case CONTINUE: 
            case ELSE: 
            case FINALLY: 
            case CATCH: 
            case ASSERT: {
                return List.of(this.parseSimpleStatement());
            }
            case FINAL: 
            case MONKEYS_AT: {
                Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                JCTree.JCModifiers jCModifiers = this.modifiersOpt();
                if (this.token.kind == Tokens.TokenKind.INTERFACE || this.token.kind == Tokens.TokenKind.CLASS || this.token.kind == Tokens.TokenKind.ENUM || this.isRecordStart()) {
                    return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(jCModifiers, comment));
                }
                JCTree.JCExpression jCExpression = this.parseType(true);
                return this.localVariableDeclarations(jCModifiers, jCExpression);
            }
            case ABSTRACT: 
            case STRICTFP: {
                Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                JCTree.JCModifiers jCModifiers = this.modifiersOpt();
                return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(jCModifiers, comment));
            }
            case CLASS: 
            case INTERFACE: {
                Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), comment));
            }
            case ENUM: {
                if (!this.allowRecords) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.LocalEnum);
                }
                Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), comment));
            }
            case IDENTIFIER: {
                if (this.token.name() == this.names.yield && this.allowYieldStatement) {
                    boolean bl;
                    token = this.S.token(1);
                    switch (token.kind) {
                        case IDENTIFIER: 
                        case SWITCH: 
                        case THIS: 
                        case SUPER: 
                        case NEW: 
                        case INTLITERAL: 
                        case LONGLITERAL: 
                        case FLOATLITERAL: 
                        case DOUBLELITERAL: 
                        case CHARLITERAL: 
                        case STRINGLITERAL: 
                        case TRUE: 
                        case FALSE: 
                        case NULL: 
                        case PLUS: 
                        case SUB: {
                            bl = true;
                            break;
                        }
                        case PLUSPLUS: 
                        case SUBSUB: {
                            bl = this.S.token((int)2).kind != Tokens.TokenKind.SEMI;
                            break;
                        }
                        case BANG: 
                        case TILDE: {
                            bl = this.S.token((int)1).kind != Tokens.TokenKind.SEMI;
                            break;
                        }
                        case LPAREN: {
                            Tokens.Token token2;
                            int n2 = 2;
                            int n3 = 1;
                            boolean bl2 = false;
                            while (true) {
                                token2 = this.S.token(n2);
                                if (token2.kind == Tokens.TokenKind.EOF || n3 == 0) break;
                                switch (token2.kind) {
                                    case LPAREN: {
                                        ++n3;
                                        break;
                                    }
                                    case RPAREN: {
                                        --n3;
                                        break;
                                    }
                                    case COMMA: {
                                        if (n3 != 1) break;
                                        bl2 = true;
                                    }
                                }
                                ++n2;
                            }
                            bl = !bl2 && n2 != 3 || token2.kind == Tokens.TokenKind.ARROW;
                            break;
                        }
                        case SEMI: {
                            bl = true;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    if (!bl) break;
                    this.nextToken();
                    JCTree.JCExpression jCExpression = this.term(1);
                    this.accept(Tokens.TokenKind.SEMI);
                    return List.of((JCTree.JCStatement)this.toP(this.F.at(n).Yield(jCExpression)));
                }
                if (this.isNonSealedClassStart(true)) {
                    this.log.error(this.token.pos, CompilerProperties.Errors.SealedOrNonSealedLocalClassesNotAllowed);
                    this.nextToken();
                    this.nextToken();
                    this.nextToken();
                    return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.token.comment(Tokens.Comment.CommentStyle.JAVADOC)));
                }
                if (!this.isSealedClassStart(true)) break;
                this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
                this.log.error(this.token.pos, CompilerProperties.Errors.SealedOrNonSealedLocalClassesNotAllowed);
                this.nextToken();
                return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.token.comment(Tokens.Comment.CommentStyle.JAVADOC)));
            }
        }
        if (this.isRecordStart() && this.allowRecords) {
            Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
            return List.of(this.recordDeclaration(this.F.at(n).Modifiers(0L), comment));
        }
        token = this.token;
        JCTree.JCExpression jCExpression = this.term(3);
        if (this.token.kind == Tokens.TokenKind.COLON && jCExpression.hasTag(JCTree.Tag.IDENT)) {
            this.nextToken();
            JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
            return List.of(this.F.at(n).Labelled(token.name(), jCStatement));
        }
        if ((this.lastmode & 2) != 0 && this.LAX_IDENTIFIER.test(this.token.kind)) {
            n = this.token.pos;
            JCTree.JCModifiers jCModifiers = this.F.at(-1).Modifiers(0L);
            this.F.at(n);
            return this.localVariableDeclarations(jCModifiers, jCExpression);
        }
        jCExpression = this.checkExprStat(jCExpression);
        this.accept(Tokens.TokenKind.SEMI);
        JCTree.JCExpressionStatement jCExpressionStatement = this.toP(this.F.at(n).Exec(jCExpression));
        return List.of(jCExpressionStatement);
    }

    private List<JCTree.JCStatement> localVariableDeclarations(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression) {
        ListBuffer listBuffer = this.variableDeclarators(jCModifiers, jCExpression, new ListBuffer(), true);
        this.accept(Tokens.TokenKind.SEMI);
        this.storeEnd((JCTree)listBuffer.last(), this.S.prevToken().endPos);
        return listBuffer.toList();
    }

    public JCTree.JCStatement parseSimpleStatement() {
        int n = this.token.pos;
        switch (this.token.kind) {
            case LBRACE: {
                return this.block();
            }
            case IF: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                JCTree.JCStatement jCStatement2 = null;
                if (this.token.kind == Tokens.TokenKind.ELSE) {
                    this.nextToken();
                    jCStatement2 = this.parseStatementAsBlock();
                }
                return this.F.at(n).If(jCExpression, jCStatement, jCStatement2);
            }
            case FOR: {
                List<Object> list;
                this.nextToken();
                this.accept(Tokens.TokenKind.LPAREN);
                List<Object> list2 = list = this.token.kind == Tokens.TokenKind.SEMI ? List.nil() : this.forInit();
                if (list.length() == 1 && ((JCTree.JCStatement)list.head).hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)list.head).init == null && this.token.kind == Tokens.TokenKind.COLON) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                    this.accept(Tokens.TokenKind.COLON);
                    JCTree.JCExpression jCExpression = this.parseExpression();
                    this.accept(Tokens.TokenKind.RPAREN);
                    JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                    return this.F.at(n).ForeachLoop(jCVariableDecl, jCExpression, jCStatement);
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCExpression jCExpression = this.token.kind == Tokens.TokenKind.SEMI ? null : this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                List<JCTree.JCExpressionStatement> list3 = this.token.kind == Tokens.TokenKind.RPAREN ? List.nil() : this.forUpdate();
                this.accept(Tokens.TokenKind.RPAREN);
                JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                return this.F.at(n).ForLoop(list, jCExpression, list3, jCStatement);
            }
            case WHILE: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                return this.F.at(n).WhileLoop(jCExpression, jCStatement);
            }
            case DO: {
                this.nextToken();
                JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                this.accept(Tokens.TokenKind.WHILE);
                JCTree.JCExpression jCExpression = this.parExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCDoWhileLoop jCDoWhileLoop = this.toP(this.F.at(n).DoLoop(jCStatement, jCExpression));
                return jCDoWhileLoop;
            }
            case TRY: {
                this.nextToken();
                List<Object> list = List.nil();
                if (this.token.kind == Tokens.TokenKind.LPAREN) {
                    this.nextToken();
                    list = this.resources();
                    this.accept(Tokens.TokenKind.RPAREN);
                }
                JCTree.JCBlock jCBlock = this.block();
                ListBuffer<JCTree.JCCatch> listBuffer = new ListBuffer<JCTree.JCCatch>();
                JCTree.JCBlock jCBlock2 = null;
                if (this.token.kind == Tokens.TokenKind.CATCH || this.token.kind == Tokens.TokenKind.FINALLY) {
                    while (this.token.kind == Tokens.TokenKind.CATCH) {
                        listBuffer.append(this.catchClause());
                    }
                    if (this.token.kind == Tokens.TokenKind.FINALLY) {
                        this.nextToken();
                        jCBlock2 = this.block();
                    }
                } else if (list.isEmpty()) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, n, CompilerProperties.Errors.TryWithoutCatchFinallyOrResourceDecls);
                }
                return this.F.at(n).Try(list, jCBlock, listBuffer.toList(), jCBlock2);
            }
            case SWITCH: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                this.accept(Tokens.TokenKind.LBRACE);
                List<JCTree.JCCase> list = this.switchBlockStatementGroups();
                JCTree.JCSwitch jCSwitch = this.to(this.F.at(n).Switch(jCExpression, list));
                jCSwitch.endpos = this.token.endPos;
                this.accept(Tokens.TokenKind.RBRACE);
                return jCSwitch;
            }
            case SYNCHRONIZED: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCBlock jCBlock = this.block();
                return this.F.at(n).Synchronized(jCExpression, jCBlock);
            }
            case RETURN: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.token.kind == Tokens.TokenKind.SEMI ? null : this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCReturn jCReturn = this.toP(this.F.at(n).Return(jCExpression));
                return jCReturn;
            }
            case THROW: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCThrow jCThrow = this.toP(this.F.at(n).Throw(jCExpression));
                return jCThrow;
            }
            case BREAK: {
                this.nextToken();
                Name name = this.LAX_IDENTIFIER.test(this.token.kind) ? this.ident() : null;
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCBreak jCBreak = this.toP(this.F.at(n).Break(name));
                return jCBreak;
            }
            case CONTINUE: {
                this.nextToken();
                Name name = this.LAX_IDENTIFIER.test(this.token.kind) ? this.ident() : null;
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCContinue jCContinue = this.toP(this.F.at(n).Continue(name));
                return jCContinue;
            }
            case SEMI: {
                this.nextToken();
                return this.toP(this.F.at(n).Skip());
            }
            case ELSE: {
                int n2 = this.token.pos;
                this.nextToken();
                return this.doRecover(n2, BasicErrorRecoveryAction.BLOCK_STMT, CompilerProperties.Errors.ElseWithoutIf);
            }
            case FINALLY: {
                int n3 = this.token.pos;
                this.nextToken();
                return this.doRecover(n3, BasicErrorRecoveryAction.BLOCK_STMT, CompilerProperties.Errors.FinallyWithoutTry);
            }
            case CATCH: {
                return this.doRecover(this.token.pos, BasicErrorRecoveryAction.CATCH_CLAUSE, CompilerProperties.Errors.CatchWithoutTry);
            }
            case ASSERT: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parseExpression();
                JCTree.JCExpression jCExpression2 = null;
                if (this.token.kind == Tokens.TokenKind.COLON) {
                    this.nextToken();
                    jCExpression2 = this.parseExpression();
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCAssert jCAssert = this.toP(this.F.at(n).Assert(jCExpression, jCExpression2));
                return jCAssert;
            }
        }
        Assert.error();
        return null;
    }

    @Override
    public JCTree.JCStatement parseStatement() {
        return this.parseStatementAsBlock();
    }

    private JCTree.JCStatement doRecover(int n, ErrorRecoveryAction errorRecoveryAction, JCDiagnostic.Error error) {
        int n2 = this.S.errPos();
        JCTree jCTree = errorRecoveryAction.doRecover(this);
        this.S.errPos(n2);
        return this.toP(this.F.Exec(this.syntaxError(n, List.of(jCTree), error)));
    }

    protected JCTree.JCCatch catchClause() {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.CATCH);
        this.accept(Tokens.TokenKind.LPAREN);
        JCTree.JCModifiers jCModifiers = this.optFinal(0x200000000L);
        List<JCTree.JCExpression> list = this.catchTypes();
        JCTree.JCExpression jCExpression = list.size() > 1 ? (JCTree.JCExpression)this.toP(this.F.at(((JCTree.JCExpression)list.head).getStartPosition()).TypeUnion(list)) : (JCTree.JCExpression)list.head;
        JCTree.JCVariableDecl jCVariableDecl = this.variableDeclaratorId(jCModifiers, jCExpression);
        this.accept(Tokens.TokenKind.RPAREN);
        JCTree.JCBlock jCBlock = this.block();
        return this.F.at(n).Catch(jCVariableDecl, jCBlock);
    }

    List<JCTree.JCExpression> catchTypes() {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.add(this.parseType());
        while (this.token.kind == Tokens.TokenKind.BAR) {
            this.nextToken();
            listBuffer.add(this.parseType());
        }
        return listBuffer.toList();
    }

    List<JCTree.JCCase> switchBlockStatementGroups() {
        ListBuffer<JCTree.JCCase> listBuffer = new ListBuffer<JCTree.JCCase>();
        block4: while (true) {
            int n = this.token.pos;
            switch (this.token.kind) {
                case CASE: 
                case DEFAULT: {
                    listBuffer.appendList(this.switchBlockStatementGroup());
                    continue block4;
                }
                case EOF: 
                case RBRACE: {
                    return listBuffer.toList();
                }
            }
            this.nextToken();
            this.syntaxError(n, CompilerProperties.Errors.Expected3(Tokens.TokenKind.CASE, Tokens.TokenKind.DEFAULT, Tokens.TokenKind.RBRACE));
        }
    }

    protected List<JCTree.JCCase> switchBlockStatementGroup() {
        int n = this.token.pos;
        ListBuffer<JCTree.JCCase> listBuffer = new ListBuffer<JCTree.JCCase>();
        switch (this.token.kind) {
            case CASE: {
                List<JCTree.JCStatement> list;
                CaseTree.CaseKind caseKind;
                this.nextToken();
                ListBuffer<JCTree.JCCaseLabel> listBuffer2 = new ListBuffer<JCTree.JCCaseLabel>();
                while (true) {
                    listBuffer2.append(this.parseCaseLabel());
                    if (this.token.kind != Tokens.TokenKind.COMMA) break;
                    this.nextToken();
                    this.checkSourceLevel(Source.Feature.SWITCH_MULTIPLE_CASE_LABELS);
                }
                JCTree jCTree = null;
                if (this.token.kind == Tokens.TokenKind.ARROW) {
                    this.checkSourceLevel(Source.Feature.SWITCH_RULE);
                    this.accept(Tokens.TokenKind.ARROW);
                    caseKind = JCTree.JCCase.RULE;
                    JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                    if (!(jCStatement.hasTag(JCTree.Tag.EXEC) || jCStatement.hasTag(JCTree.Tag.BLOCK) || jCStatement.hasTag(JCTree.Tag.THROW))) {
                        this.log.error(jCStatement.pos(), CompilerProperties.Errors.SwitchCaseUnexpectedStatement);
                    }
                    list = List.of(jCStatement);
                    jCTree = (JCTree)list.head;
                } else {
                    this.accept(Tokens.TokenKind.COLON, tokenKind -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.COLON, Tokens.TokenKind.ARROW));
                    caseKind = JCTree.JCCase.STATEMENT;
                    list = this.blockStatements();
                }
                JCTree.JCCase jCCase = this.F.at(n).Case(caseKind, listBuffer2.toList(), list, jCTree);
                if (list.isEmpty()) {
                    this.storeEnd(jCCase, this.S.prevToken().endPos);
                }
                return listBuffer.append(jCCase).toList();
            }
            case DEFAULT: {
                List<JCTree.JCStatement> list;
                CaseTree.CaseKind caseKind;
                this.nextToken();
                JCTree.JCCaseLabel jCCaseLabel = this.toP(this.F.at(n).DefaultCaseLabel());
                JCTree jCTree = null;
                if (this.token.kind == Tokens.TokenKind.ARROW) {
                    this.checkSourceLevel(Source.Feature.SWITCH_RULE);
                    this.accept(Tokens.TokenKind.ARROW);
                    caseKind = JCTree.JCCase.RULE;
                    JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                    if (!(jCStatement.hasTag(JCTree.Tag.EXEC) || jCStatement.hasTag(JCTree.Tag.BLOCK) || jCStatement.hasTag(JCTree.Tag.THROW))) {
                        this.log.error(jCStatement.pos(), CompilerProperties.Errors.SwitchCaseUnexpectedStatement);
                    }
                    list = List.of(jCStatement);
                    jCTree = (JCTree)list.head;
                } else {
                    this.accept(Tokens.TokenKind.COLON, tokenKind -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.COLON, Tokens.TokenKind.ARROW));
                    caseKind = JCTree.JCCase.STATEMENT;
                    list = this.blockStatements();
                }
                JCTree.JCCase jCCase = this.F.at(n).Case(caseKind, List.of(jCCaseLabel), list, jCTree);
                if (list.isEmpty()) {
                    this.storeEnd(jCCase, this.S.prevToken().endPos);
                }
                return listBuffer.append(jCCase).toList();
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    private JCTree.JCCaseLabel parseCaseLabel() {
        int n = this.token.pos;
        if (this.token.kind != Tokens.TokenKind.DEFAULT) {
            boolean bl;
            int n2 = 0;
            while (this.S.token((int)n2).kind == Tokens.TokenKind.LPAREN) {
                ++n2;
            }
            JCTree.JCModifiers jCModifiers = this.optFinal(0L);
            boolean bl2 = bl = jCModifiers.flags != 0L || jCModifiers.annotations.nonEmpty() || this.analyzePattern(n2) == PatternResult.PATTERN;
            if (bl) {
                this.checkSourceLevel(this.token.pos, Source.Feature.PATTERN_SWITCH);
                JCTree.JCPattern jCPattern = this.parsePattern(n, jCModifiers, null, false, true);
                JCTree.JCExpression jCExpression = null;
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.when) {
                    this.nextToken();
                    jCExpression = this.term(33);
                }
                return this.toP(this.F.at(n).PatternCaseLabel(jCPattern, jCExpression));
            }
            JCTree.JCExpression jCExpression = this.term(33);
            return this.toP(this.F.at(n).ConstantCaseLabel(jCExpression));
        }
        this.checkSourceLevel(this.token.pos, Source.Feature.PATTERN_SWITCH);
        this.nextToken();
        JCTree.JCCaseLabel jCCaseLabel = this.toP(this.F.at(n).DefaultCaseLabel());
        return jCCaseLabel;
    }

    PatternResult analyzePattern(int n) {
        int n2 = 0;
        int n3 = 0;
        PatternResult patternResult = PatternResult.EXPRESSION;
        while (true) {
            Tokens.TokenKind tokenKind2 = this.S.token((int)n).kind;
            switch (tokenKind2) {
                case ENUM: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case ASSERT: {
                    if (n2 != 0 || !this.peekToken(n, this.LAX_IDENTIFIER)) break;
                    if (n3 == 0) {
                        return PatternResult.PATTERN;
                    }
                    patternResult = PatternResult.PATTERN;
                    break;
                }
                case SUPER: 
                case DOT: 
                case QUES: 
                case EXTENDS: 
                case COMMA: {
                    break;
                }
                case LT: {
                    ++n2;
                    break;
                }
                case GTGTGT: {
                    --n2;
                }
                case GTGT: {
                    --n2;
                }
                case GT: {
                    if (--n2 == 0) {
                        return this.peekToken(n, this.LAX_IDENTIFIER) || this.peekToken(n, (Tokens.TokenKind tokenKind) -> tokenKind == Tokens.TokenKind.LPAREN) ? PatternResult.PATTERN : PatternResult.EXPRESSION;
                    }
                    if (n2 >= 0) break;
                    return PatternResult.EXPRESSION;
                }
                case MONKEYS_AT: {
                    n = this.skipAnnotation(n);
                    break;
                }
                case LBRACKET: {
                    if (this.peekToken(n, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, this.LAX_IDENTIFIER)) {
                        return PatternResult.PATTERN;
                    }
                    if (this.peekToken(n, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET)) {
                        ++n;
                        break;
                    }
                    return PatternResult.EXPRESSION;
                }
                case LPAREN: {
                    if (this.S.token((int)(n + 1)).kind == Tokens.TokenKind.RPAREN) {
                        return n3 != 0 && this.S.token((int)(n + 2)).kind == Tokens.TokenKind.ARROW ? PatternResult.EXPRESSION : PatternResult.PATTERN;
                    }
                    ++n3;
                    break;
                }
                case RPAREN: {
                    --n3;
                    break;
                }
                case ARROW: {
                    return n3 > 0 ? PatternResult.EXPRESSION : patternResult;
                }
                default: {
                    return patternResult;
                }
            }
            ++n;
        }
    }

    <T extends ListBuffer<? super JCTree.JCExpressionStatement>> T moreStatementExpressions(int n, JCTree.JCExpression jCExpression, T t) {
        t.append((JCTree.JCExpressionStatement)this.toP(this.F.at(n).Exec(this.checkExprStat(jCExpression))));
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            n = this.token.pos;
            JCTree.JCExpression jCExpression2 = this.parseExpression();
            t.append((JCTree.JCExpressionStatement)this.toP(this.F.at(n).Exec(this.checkExprStat(jCExpression2))));
        }
        return t;
    }

    List<JCTree.JCStatement> forInit() {
        ListBuffer listBuffer = new ListBuffer();
        int n = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.FINAL || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.parseType(true), listBuffer, true).toList();
        }
        JCTree.JCExpression jCExpression = this.term(3);
        if ((this.lastmode & 2) != 0 && this.LAX_IDENTIFIER.test(this.token.kind)) {
            return this.variableDeclarators(this.modifiersOpt(), jCExpression, listBuffer, true).toList();
        }
        if ((this.lastmode & 2) != 0 && this.token.kind == Tokens.TokenKind.COLON) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, n, CompilerProperties.Errors.BadInitializer("for-loop"));
            return List.of(this.F.at(n).VarDef(this.modifiersOpt(), this.names.error, jCExpression, null));
        }
        return this.moreStatementExpressions(n, jCExpression, listBuffer).toList();
    }

    List<JCTree.JCExpressionStatement> forUpdate() {
        return this.moreStatementExpressions(this.token.pos, this.parseExpression(), new ListBuffer()).toList();
    }

    protected List<JCTree.JCAnnotation> annotationsOpt(JCTree.Tag tag) {
        if (this.token.kind != Tokens.TokenKind.MONKEYS_AT) {
            return List.nil();
        }
        ListBuffer<JCTree.JCAnnotation> listBuffer = new ListBuffer<JCTree.JCAnnotation>();
        int n = this.mode;
        while (this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            int n2 = this.token.pos;
            this.nextToken();
            listBuffer.append(this.annotation(n2, tag));
        }
        this.lastmode = this.mode;
        this.mode = n;
        List<JCTree.JCAnnotation> list = listBuffer.toList();
        return list;
    }

    List<JCTree.JCAnnotation> typeAnnotationsOpt() {
        List<JCTree.JCAnnotation> list = this.annotationsOpt(JCTree.Tag.TYPE_ANNOTATION);
        return list;
    }

    protected JCTree.JCModifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    protected JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers jCModifiers) {
        int n;
        long l;
        ListBuffer<JCTree.JCAnnotation> listBuffer = new ListBuffer<JCTree.JCAnnotation>();
        if (jCModifiers == null) {
            l = 0L;
            n = this.token.pos;
        } else {
            l = jCModifiers.flags;
            listBuffer.appendList(jCModifiers.annotations);
            n = jCModifiers.pos;
        }
        if (this.token.deprecatedFlag()) {
            l |= 0x20000L;
        }
        block21: while (true) {
            long l2;
            switch (this.token.kind) {
                case PRIVATE: {
                    l2 = 2L;
                    break;
                }
                case PROTECTED: {
                    l2 = 4L;
                    break;
                }
                case PUBLIC: {
                    l2 = 1L;
                    break;
                }
                case STATIC: {
                    l2 = 8L;
                    break;
                }
                case TRANSIENT: {
                    l2 = 128L;
                    break;
                }
                case FINAL: {
                    l2 = 16L;
                    break;
                }
                case ABSTRACT: {
                    l2 = 1024L;
                    break;
                }
                case NATIVE: {
                    l2 = 256L;
                    break;
                }
                case VOLATILE: {
                    l2 = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    l2 = 32L;
                    break;
                }
                case STRICTFP: {
                    l2 = 2048L;
                    break;
                }
                case MONKEYS_AT: {
                    l2 = 8192L;
                    break;
                }
                case DEFAULT: {
                    this.checkSourceLevel(Source.Feature.DEFAULT_METHODS);
                    l2 = 0x80000000000L;
                    break;
                }
                case ERROR: {
                    l2 = 0L;
                    this.nextToken();
                    break;
                }
                case IDENTIFIER: {
                    if (this.isNonSealedClassStart(false)) {
                        l2 = Long.MIN_VALUE;
                        this.nextToken();
                        this.nextToken();
                        break;
                    }
                    if (!this.isSealedClassStart(false)) break block21;
                    this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
                    l2 = 0x4000000000000000L;
                    break;
                }
                default: {
                    break block21;
                }
            }
            if ((l & l2) != 0L) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.RepeatedModifier);
            }
            int n2 = this.token.pos;
            this.nextToken();
            if (l2 == 8192L && this.token.kind != Tokens.TokenKind.INTERFACE) {
                JCTree.JCAnnotation jCAnnotation = this.annotation(n2, JCTree.Tag.ANNOTATION);
                if (l == 0L && listBuffer.isEmpty()) {
                    n = jCAnnotation.pos;
                }
                listBuffer.append(jCAnnotation);
                l2 = 0L;
            }
            l |= l2;
        }
        switch (this.token.kind) {
            case ENUM: {
                l |= 0x4000L;
                break;
            }
            case INTERFACE: {
                l |= 0x200L;
                break;
            }
        }
        if ((l & 0xC000080000002DFFL) == 0L && listBuffer.isEmpty()) {
            n = -1;
        }
        JCTree.JCModifiers jCModifiers2 = this.F.at(n).Modifiers(l, listBuffer.toList());
        if (n != -1) {
            this.storeEnd(jCModifiers2, this.S.prevToken().endPos);
        }
        return jCModifiers2;
    }

    JCTree.JCAnnotation annotation(int n, JCTree.Tag tag) {
        JCTree.JCAnnotation jCAnnotation;
        if (tag == JCTree.Tag.TYPE_ANNOTATION) {
            this.checkSourceLevel(Source.Feature.TYPE_ANNOTATIONS);
        }
        JCTree.JCExpression jCExpression = this.qualident(false);
        List<JCTree.JCExpression> list = this.annotationFieldValuesOpt();
        if (tag == JCTree.Tag.ANNOTATION) {
            jCAnnotation = this.F.at(n).Annotation(jCExpression, list);
        } else if (tag == JCTree.Tag.TYPE_ANNOTATION) {
            jCAnnotation = this.F.at(n).TypeAnnotation(jCExpression, list);
        } else {
            throw new AssertionError((Object)("Unhandled annotation kind: " + (Object)((Object)tag)));
        }
        this.storeEnd(jCAnnotation, this.S.prevToken().endPos);
        return jCAnnotation;
    }

    List<JCTree.JCExpression> annotationFieldValuesOpt() {
        return this.token.kind == Tokens.TokenKind.LPAREN ? this.annotationFieldValues() : List.nil();
    }

    List<JCTree.JCExpression> annotationFieldValues() {
        this.accept(Tokens.TokenKind.LPAREN);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind != Tokens.TokenKind.RPAREN) {
            listBuffer.append(this.annotationFieldValue());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                listBuffer.append(this.annotationFieldValue());
            }
        }
        this.accept(Tokens.TokenKind.RPAREN);
        return listBuffer.toList();
    }

    JCTree.JCExpression annotationFieldValue() {
        if (this.LAX_IDENTIFIER.test(this.token.kind)) {
            this.selectExprMode();
            JCTree.JCExpression jCExpression = this.term1();
            if (jCExpression.hasTag(JCTree.Tag.IDENT) && this.token.kind == Tokens.TokenKind.EQ) {
                int n = this.token.pos;
                this.accept(Tokens.TokenKind.EQ);
                JCTree.JCExpression jCExpression2 = this.annotationValue();
                return this.toP(this.F.at(n).Assign(jCExpression, jCExpression2));
            }
            return jCExpression;
        }
        return this.annotationValue();
    }

    JCTree.JCExpression annotationValue() {
        switch (this.token.kind) {
            case MONKEYS_AT: {
                int n = this.token.pos;
                this.nextToken();
                return this.annotation(n, JCTree.Tag.ANNOTATION);
            }
            case LBRACE: {
                int n = this.token.pos;
                this.accept(Tokens.TokenKind.LBRACE);
                ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                if (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
                    listBuffer.append(this.annotationValue());
                    while (this.token.kind == Tokens.TokenKind.COMMA) {
                        this.nextToken();
                        if (this.token.kind == Tokens.TokenKind.RBRACE) break;
                        listBuffer.append(this.annotationValue());
                    }
                }
                this.accept(Tokens.TokenKind.RBRACE, tokenKind -> CompilerProperties.Errors.AnnotationMissingElementValue);
                return this.toP(this.F.at(n).NewArray(null, List.nil(), listBuffer.toList()));
            }
        }
        this.selectExprMode();
        return this.term1();
    }

    public <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclarators(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, T t, boolean bl) {
        return this.variableDeclaratorsRest(this.token.pos, jCModifiers, jCExpression, this.ident(), false, null, t, bl);
    }

    protected <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclaratorsRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, boolean bl, Tokens.Comment comment, T t, boolean bl2) {
        JCTree.JCVariableDecl jCVariableDecl = this.variableDeclaratorRest(n, jCModifiers, jCExpression, name, bl, comment, bl2, false);
        t.append((JCTree.JCVariableDecl)jCVariableDecl);
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.storeEnd(t.last(), this.token.endPos);
            this.nextToken();
            t.append((JCTree.JCVariableDecl)this.variableDeclarator(jCModifiers, jCExpression, bl, comment, bl2));
        }
        return t;
    }

    JCTree.JCVariableDecl variableDeclarator(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, boolean bl, Tokens.Comment comment, boolean bl2) {
        return this.variableDeclaratorRest(this.token.pos, jCModifiers, jCExpression, this.ident(), bl, comment, bl2, true);
    }

    JCTree.JCVariableDecl variableDeclaratorRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, boolean bl, Tokens.Comment comment, boolean bl2, boolean bl3) {
        Object object;
        boolean bl4 = false;
        jCExpression = this.bracketsOpt(jCExpression);
        JCTree.JCExpression jCExpression2 = null;
        if (this.token.kind == Tokens.TokenKind.EQ) {
            this.nextToken();
            jCExpression2 = this.variableInitializer();
        } else if (bl) {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected(Tokens.TokenKind.EQ));
        }
        JCTree jCTree = TreeInfo.innermostType(jCExpression, true);
        int n2 = -1;
        if (jCTree.hasTag(JCTree.Tag.IDENT) && this.restrictedTypeNameStartingAtSource((Name)(object = ((JCTree.JCIdent)jCTree).name), n, !bl3 && bl2) != null) {
            if (object != this.names.var) {
                this.reportSyntaxError(jCTree.pos, CompilerProperties.Errors.RestrictedTypeNotAllowedHere((Name)object));
            } else if (jCExpression.hasTag(JCTree.Tag.TYPEARRAY) && !bl3) {
                this.reportSyntaxError(jCTree.pos, CompilerProperties.Errors.RestrictedTypeNotAllowedArray((Name)object));
            } else {
                bl4 = true;
                if (bl3) {
                    this.reportSyntaxError(jCTree.pos, CompilerProperties.Errors.RestrictedTypeNotAllowedCompound((Name)object));
                }
                if ((n2 = TreeInfo.getStartPos(jCModifiers)) == -1) {
                    n2 = TreeInfo.getStartPos(jCExpression);
                }
                jCExpression = null;
            }
        }
        object = this.toP(this.F.at(n).VarDef(jCModifiers, name, jCExpression, jCExpression2, bl4));
        this.attach((JCTree)object, comment);
        ((JCTree.JCVariableDecl)object).startPos = n2;
        return object;
    }

    Name restrictedTypeName(JCTree.JCExpression jCExpression, boolean bl) {
        switch (jCExpression.getTag()) {
            case IDENT: {
                return this.restrictedTypeNameStartingAtSource(((JCTree.JCIdent)jCExpression).name, jCExpression.pos, bl) != null ? ((JCTree.JCIdent)jCExpression).name : null;
            }
            case TYPEARRAY: {
                return this.restrictedTypeName(((JCTree.JCArrayTypeTree)jCExpression).elemtype, bl);
            }
        }
        return null;
    }

    Source restrictedTypeNameStartingAtSource(Name name, int n, boolean bl) {
        if (name == this.names.var) {
            if (Source.Feature.LOCAL_VARIABLE_TYPE_INFERENCE.allowedInSource(this.source, this.target)) {
                return Source.JDK10;
            }
            if (bl) {
                this.log.warning(n, CompilerProperties.Warnings.RestrictedTypeNotAllowed(name, Source.JDK10));
            }
        }
        if (name == this.names.yield) {
            if (this.allowYieldStatement) {
                return Source.JDK14;
            }
            if (bl) {
                this.log.warning(n, CompilerProperties.Warnings.RestrictedTypeNotAllowed(name, Source.JDK14));
            }
        }
        if (name == this.names.record) {
            if (this.allowRecords) {
                return Source.JDK14;
            }
            if (bl) {
                this.log.warning(n, CompilerProperties.Warnings.RestrictedTypeNotAllowedPreview(name, Source.JDK14));
            }
        }
        if (name == this.names.sealed) {
            if (this.allowSealedTypes) {
                return Source.JDK15;
            }
            if (bl) {
                this.log.warning(n, CompilerProperties.Warnings.RestrictedTypeNotAllowedPreview(name, Source.JDK15));
            }
        }
        if (name == this.names.permits) {
            if (this.allowSealedTypes) {
                return Source.JDK15;
            }
            if (bl) {
                this.log.warning(n, CompilerProperties.Warnings.RestrictedTypeNotAllowedPreview(name, Source.JDK15));
            }
        }
        return null;
    }

    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression) {
        return this.variableDeclaratorId(jCModifiers, jCExpression, false, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, boolean bl, boolean bl2) {
        boolean bl3;
        Name name;
        int n;
        block10: {
            n = this.token.pos;
            if (bl && this.token.kind == Tokens.TokenKind.UNDERSCORE) {
                this.log.error(n, CompilerProperties.Errors.UnderscoreAsIdentifierInLambda);
                name = this.token.name();
                this.nextToken();
            } else {
                if (this.allowThisIdent || !bl || this.LAX_IDENTIFIER.test(this.token.kind) || jCModifiers.flags != 0x200000000L || jCModifiers.annotations.nonEmpty()) {
                    JCTree.JCExpression jCExpression2 = this.qualident(false);
                    if (jCExpression2.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)jCExpression2).name != this.names._this) {
                        name = ((JCTree.JCIdent)jCExpression2).name;
                        break block10;
                    } else {
                        if (!this.allowThisIdent) return this.toP(this.F.at(n).ReceiverVarDef(jCModifiers, jCExpression2, jCExpression));
                        if ((jCModifiers.flags & 0x400000000L) != 0L) {
                            this.log.error(this.token.pos, CompilerProperties.Errors.VarargsAndReceiver);
                        }
                        if (this.token.kind == Tokens.TokenKind.LBRACKET) {
                            this.log.error(this.token.pos, CompilerProperties.Errors.ArrayAndReceiver);
                        }
                        if (!jCExpression2.hasTag(JCTree.Tag.SELECT)) return this.toP(this.F.at(n).ReceiverVarDef(jCModifiers, jCExpression2, jCExpression));
                        if (((JCTree.JCFieldAccess)jCExpression2).name == this.names._this) return this.toP(this.F.at(n).ReceiverVarDef(jCModifiers, jCExpression2, jCExpression));
                        this.log.error(this.token.pos, CompilerProperties.Errors.WrongReceiver);
                        return this.toP(this.F.at(n).ReceiverVarDef(jCModifiers, jCExpression2, jCExpression));
                    }
                }
                name = this.names.empty;
            }
        }
        if ((jCModifiers.flags & 0x400000000L) != 0L && this.token.kind == Tokens.TokenKind.LBRACKET) {
            this.log.error(this.token.pos, CompilerProperties.Errors.VarargsAndOldArraySyntax);
        }
        if (bl2 && this.token.kind == Tokens.TokenKind.LBRACKET) {
            this.log.error(this.token.pos, CompilerProperties.Errors.RecordComponentAndOldArraySyntax);
        }
        jCExpression = this.bracketsOpt(jCExpression);
        TreeMaker treeMaker = this.F.at(n);
        if (jCExpression != null && jCExpression.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)jCExpression).name == this.names.var) {
            bl3 = true;
            return this.toP(treeMaker.VarDef(jCModifiers, name, jCExpression, null, bl3));
        }
        bl3 = false;
        return this.toP(treeMaker.VarDef(jCModifiers, name, jCExpression, null, bl3));
    }

    List<JCTree> resources() {
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        listBuffer.append(this.resource());
        while (this.token.kind == Tokens.TokenKind.SEMI) {
            this.storeEnd((JCTree)listBuffer.last(), this.token.endPos);
            int n = this.token.pos;
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.RPAREN) break;
            listBuffer.append(this.resource());
        }
        return listBuffer.toList();
    }

    protected JCTree resource() {
        int n = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.FINAL || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            JCTree.JCModifiers jCModifiers = this.optFinal(16L);
            JCTree.JCExpression jCExpression = this.parseType(true);
            return this.variableDeclaratorRest(this.token.pos, jCModifiers, jCExpression, this.ident(), true, null, true, false);
        }
        JCTree.JCExpression jCExpression = this.term(3);
        if ((this.lastmode & 2) != 0 && this.LAX_IDENTIFIER.test(this.token.kind)) {
            JCTree.JCModifiers jCModifiers = this.toP(this.F.at(n).Modifiers(16L));
            return this.variableDeclaratorRest(this.token.pos, jCModifiers, jCExpression, this.ident(), true, null, true, false);
        }
        this.checkSourceLevel(Source.Feature.EFFECTIVELY_FINAL_VARIABLES_IN_TRY_WITH_RESOURCES);
        if (!jCExpression.hasTag(JCTree.Tag.IDENT) && !jCExpression.hasTag(JCTree.Tag.SELECT)) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.TryWithResourcesExprNeedsVar);
        }
        return jCExpression;
    }

    @Override
    public JCTree.JCCompilationUnit parseCompilationUnit() {
        Object object;
        Object object2;
        int n;
        Tokens.Token token = this.token;
        JCTree.JCModifiers jCModifiers = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        if (this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            jCModifiers = this.modifiersOpt();
        }
        if (this.token.kind == Tokens.TokenKind.PACKAGE) {
            n = this.token.pos;
            List<JCTree.JCAnnotation> list = List.nil();
            bl3 = true;
            if (jCModifiers != null) {
                this.checkNoMods(jCModifiers.flags & 0xFFFFFFFFFFFDFFFFL);
                list = jCModifiers.annotations;
                jCModifiers = null;
            }
            this.nextToken();
            object2 = this.qualident(false);
            this.accept(Tokens.TokenKind.SEMI);
            object = this.toP(this.F.at(n).PackageDecl(list, (JCTree.JCExpression)object2));
            this.attach((JCTree)object, token.comment(Tokens.Comment.CommentStyle.JAVADOC));
            bl = true;
            listBuffer.append((JCTree)object);
        }
        n = 1;
        boolean bl4 = true;
        while (this.token.kind != Tokens.TokenKind.EOF) {
            if (this.token.pos <= this.endPosTable.errorEndPos) {
                this.skip(n != 0, false, false, false);
                if (this.token.kind == Tokens.TokenKind.EOF) break;
            }
            if (n != 0 && jCModifiers == null && this.token.kind == Tokens.TokenKind.IMPORT) {
                bl2 = true;
                listBuffer.append(this.importDeclaration());
                continue;
            }
            object2 = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
            if (bl4 && !bl2 && !bl3) {
                object2 = token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                bl = true;
            }
            if (jCModifiers != null || this.token.kind != Tokens.TokenKind.SEMI) {
                jCModifiers = this.modifiersOpt(jCModifiers);
            }
            if (bl4 && this.token.kind == Tokens.TokenKind.IDENTIFIER) {
                object = ModuleTree.ModuleKind.STRONG;
                if (this.token.name() == this.names.open) {
                    object = ModuleTree.ModuleKind.OPEN;
                    this.nextToken();
                }
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.module) {
                    if (jCModifiers != null) {
                        this.checkNoMods(jCModifiers.flags & 0xFFFFFFFFFFFDFFFFL);
                    }
                    listBuffer.append(this.moduleDecl(jCModifiers, (ModuleTree.ModuleKind)((Object)object), (Tokens.Comment)object2));
                    bl = true;
                    break;
                }
                if (object != ModuleTree.ModuleKind.STRONG) {
                    this.reportSyntaxError(this.token.pos, CompilerProperties.Errors.ExpectedModule);
                }
            }
            if ((object = this.typeDeclaration(jCModifiers, (Tokens.Comment)object2)) instanceof JCTree.JCExpressionStatement) {
                JCTree.JCExpressionStatement jCExpressionStatement = (JCTree.JCExpressionStatement)object;
                object = jCExpressionStatement.expr;
            }
            listBuffer.append((JCTree)object);
            if (object instanceof JCTree.JCClassDecl) {
                n = 0;
            }
            jCModifiers = null;
            bl4 = false;
        }
        object2 = this.F.at(token.pos).TopLevel(listBuffer.toList());
        if (!bl) {
            this.attach((JCTree)object2, token.comment(Tokens.Comment.CommentStyle.JAVADOC));
        }
        if (listBuffer.isEmpty()) {
            this.storeEnd((JCTree)object2, this.S.prevToken().endPos);
        }
        if (this.keepDocComments) {
            ((JCTree.JCCompilationUnit)object2).docComments = this.docComments;
        }
        if (this.keepLineMap) {
            ((JCTree.JCCompilationUnit)object2).lineMap = this.S.getLineMap();
        }
        this.endPosTable.setParser(null);
        ((JCTree.JCCompilationUnit)object2).endPositions = this.endPosTable;
        return object2;
    }

    JCTree.JCModuleDecl moduleDecl(JCTree.JCModifiers jCModifiers, ModuleTree.ModuleKind moduleKind, Tokens.Comment comment) {
        int n = this.token.pos;
        this.checkSourceLevel(Source.Feature.MODULES);
        this.nextToken();
        JCTree.JCExpression jCExpression = this.qualident(false);
        List<JCTree.JCDirective> list = null;
        this.accept(Tokens.TokenKind.LBRACE);
        list = this.moduleDirectiveList();
        this.accept(Tokens.TokenKind.RBRACE);
        this.accept(Tokens.TokenKind.EOF);
        JCTree.JCModuleDecl jCModuleDecl = this.toP(this.F.at(n).ModuleDef(jCModifiers, moduleKind, jCExpression, list));
        this.attach(jCModuleDecl, comment);
        return jCModuleDecl;
    }

    List<JCTree.JCDirective> moduleDirectiveList() {
        ListBuffer<JCTree.JCDirective> listBuffer = new ListBuffer<JCTree.JCDirective>();
        while (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
            List<JCTree.JCExpression> list;
            int n = this.token.pos;
            if (this.token.name() == this.names.requires) {
                this.nextToken();
                boolean bl = false;
                boolean bl2 = false;
                block5: while (true) {
                    switch (this.token.kind) {
                        case IDENTIFIER: {
                            if (this.token.name() != this.names.transitive || bl) break block5;
                            list = this.S.token(1);
                            if (((Tokens.Token)((Object)list)).kind == Tokens.TokenKind.SEMI || ((Tokens.Token)((Object)list)).kind == Tokens.TokenKind.DOT) break block5;
                            bl = true;
                            break;
                        }
                        case STATIC: {
                            if (bl2) {
                                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.RepeatedModifier);
                            }
                            bl2 = true;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    this.nextToken();
                }
                list = this.qualident(false);
                this.accept(Tokens.TokenKind.SEMI);
                listBuffer.append(this.toP(this.F.at(n).Requires(bl, bl2, (JCTree.JCExpression)((Object)list))));
                continue;
            }
            if (this.token.name() == this.names.exports || this.token.name() == this.names.opens) {
                boolean bl = this.token.name() == this.names.exports;
                this.nextToken();
                JCTree.JCExpression jCExpression = this.qualident(false);
                list = null;
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.to) {
                    this.nextToken();
                    list = this.qualidentList(false);
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCDirective jCDirective = bl ? this.F.at(n).Exports(jCExpression, list) : this.F.at(n).Opens(jCExpression, list);
                listBuffer.append(this.toP(jCDirective));
                continue;
            }
            if (this.token.name() == this.names.provides) {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.qualident(false);
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.with) {
                    this.nextToken();
                    List<JCTree.JCExpression> list2 = this.qualidentList(false);
                    this.accept(Tokens.TokenKind.SEMI);
                    listBuffer.append(this.toP(this.F.at(n).Provides(jCExpression, list2)));
                    continue;
                }
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.ExpectedStr("'" + this.names.with + "'"));
                this.skip(false, false, false, false);
                continue;
            }
            if (this.token.name() == this.names.uses) {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.qualident(false);
                this.accept(Tokens.TokenKind.SEMI);
                listBuffer.append(this.toP(this.F.at(n).Uses(jCExpression)));
                continue;
            }
            this.setErrorEndPos(n);
            this.reportSyntaxError(n, CompilerProperties.Errors.InvalidModuleDirective);
            break;
        }
        return listBuffer.toList();
    }

    protected JCTree importDeclaration() {
        int n = this.token.pos;
        this.nextToken();
        boolean bl = false;
        if (this.token.kind == Tokens.TokenKind.STATIC) {
            bl = true;
            this.nextToken();
        }
        JCTree.JCExpression jCExpression = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        do {
            int n2 = this.token.pos;
            this.accept(Tokens.TokenKind.DOT);
            if (this.token.kind == Tokens.TokenKind.STAR) {
                jCExpression = this.to(this.F.at(n2).Select(jCExpression, this.names.asterisk));
                this.nextToken();
                break;
            }
            jCExpression = this.toP(this.F.at(n2).Select(jCExpression, this.ident()));
        } while (this.token.kind == Tokens.TokenKind.DOT);
        this.accept(Tokens.TokenKind.SEMI);
        return this.toP(this.F.at(n).Import(jCExpression, bl));
    }

    JCTree typeDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        if (jCModifiers == null && this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            return this.toP(this.F.at(n).Skip());
        }
        return this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(jCModifiers), comment);
    }

    protected JCTree.JCStatement classOrRecordOrInterfaceOrEnumDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        List<JCTree> list;
        if (this.token.kind == Tokens.TokenKind.CLASS) {
            return this.classDeclaration(jCModifiers, comment);
        }
        if (this.isRecordStart()) {
            return this.recordDeclaration(jCModifiers, comment);
        }
        if (this.token.kind == Tokens.TokenKind.INTERFACE) {
            return this.interfaceDeclaration(jCModifiers, comment);
        }
        if (this.token.kind == Tokens.TokenKind.ENUM) {
            return this.enumDeclaration(jCModifiers, comment);
        }
        int n = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.record) {
            this.checkSourceLevel(Source.Feature.RECORDS);
            JCTree.JCErroneous jCErroneous = this.syntaxError(this.token.pos, List.of(jCModifiers), CompilerProperties.Errors.RecordHeaderExpected);
            return this.toP(this.F.Exec(jCErroneous));
        }
        if (this.LAX_IDENTIFIER.test(this.token.kind)) {
            list = List.of(jCModifiers, this.toP(this.F.at(n).Ident(this.ident())));
            this.setErrorEndPos(this.token.pos);
        } else {
            list = List.of(jCModifiers);
        }
        JCTree.JCErroneous jCErroneous = this.parseModuleInfo ? this.syntaxError(n, list, CompilerProperties.Errors.ExpectedModuleOrOpen) : (this.allowRecords ? this.syntaxError(n, list, CompilerProperties.Errors.Expected4(Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE, Tokens.TokenKind.ENUM, "record")) : this.syntaxError(n, list, CompilerProperties.Errors.Expected3(Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE, Tokens.TokenKind.ENUM)));
        return this.toP(this.F.Exec(jCErroneous));
    }

    protected JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.CLASS);
        Name name = this.typeName();
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt();
        JCTree.JCExpression jCExpression = null;
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            jCExpression = this.parseType();
        }
        List<JCTree.JCExpression> list2 = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            list2 = this.typeList();
        }
        List<JCTree.JCExpression> list3 = this.permitsClause(jCModifiers, "class");
        List<JCTree> list4 = this.classInterfaceOrRecordBody(name, false, false);
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, list, jCExpression, list2, list3, list4));
        this.attach(jCClassDecl, comment);
        return jCClassDecl;
    }

    protected JCTree.JCClassDecl recordDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        this.nextToken();
        jCModifiers.flags |= 0x2000000000000000L;
        Name name = this.typeName();
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt();
        List<JCTree.JCVariableDecl> list2 = this.formalParameters(false, true);
        List<JCTree.JCExpression> list3 = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            list3 = this.typeList();
        }
        List<JCTree> list4 = this.classInterfaceOrRecordBody(name, false, true);
        ArrayList<JCTree.JCVariableDecl> arrayList = new ArrayList<JCTree.JCVariableDecl>();
        for (JCTree.JCVariableDecl jCTree : list2) {
            arrayList.add(jCTree);
        }
        for (JCTree jCTree : list4) {
            if (!jCTree.hasTag(JCTree.Tag.METHODDEF)) continue;
            JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
            if (jCMethodDecl.name != this.names.init || !jCMethodDecl.params.isEmpty() || (jCMethodDecl.mods.flags & 0x8000000000000L) == 0L) continue;
            ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
            for (JCTree.JCVariableDecl jCVariableDecl : list2) {
                listBuffer.add(this.F.at(jCVariableDecl).VarDef(this.F.Modifiers(0x201000000L | jCVariableDecl.mods.flags & 0x400000000L, jCVariableDecl.mods.annotations), jCVariableDecl.name, jCVariableDecl.vartype, null));
            }
            jCMethodDecl.params = listBuffer.toList();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)arrayList.get(i);
            list4 = list4.prepend(jCVariableDecl);
        }
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, list, null, list3, list4));
        this.attach(jCClassDecl, comment);
        return jCClassDecl;
    }

    Name typeName() {
        int n = this.token.pos;
        Name name = this.ident();
        Source source = this.restrictedTypeNameStartingAtSource(name, n, true);
        if (source != null) {
            this.reportSyntaxError(n, CompilerProperties.Errors.RestrictedTypeNotAllowed(name, source));
        }
        return name;
    }

    protected JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.INTERFACE);
        Name name = this.typeName();
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt();
        List<JCTree.JCExpression> list2 = List.nil();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            list2 = this.typeList();
        }
        List<JCTree.JCExpression> list3 = this.permitsClause(jCModifiers, "interface");
        List<JCTree> list4 = this.classInterfaceOrRecordBody(name, true, false);
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, list, null, list2, list3, list4));
        this.attach(jCClassDecl, comment);
        return jCClassDecl;
    }

    List<JCTree.JCExpression> permitsClause(JCTree.JCModifiers jCModifiers, String string) {
        if (this.allowSealedTypes && this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.permits) {
            this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
            if ((jCModifiers.flags & 0x4000000000000000L) == 0L) {
                this.log.error(this.token.pos, CompilerProperties.Errors.InvalidPermitsClause(CompilerProperties.Fragments.ClassIsNotSealed(string)));
            }
            this.nextToken();
            return this.qualidentList(false);
        }
        return List.nil();
    }

    protected JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.ENUM);
        Name name = this.typeName();
        int n2 = this.token.pos;
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt(true);
        if (list == null || !list.isEmpty()) {
            int n3 = list == null ? n2 : ((JCTree.JCTypeParameter)list.head).pos;
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, n3, CompilerProperties.Errors.EnumCantBeGeneric);
        }
        List<JCTree.JCExpression> list2 = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            list2 = this.typeList();
        }
        List<JCTree> list3 = this.enumBody(name);
        jCModifiers.flags |= 0x4000L;
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, List.nil(), null, list2, list3));
        this.attach(jCClassDecl, comment);
        return jCClassDecl;
    }

    List<JCTree> enumBody(Name name) {
        this.accept(Tokens.TokenKind.LBRACE);
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.SEMI) {
                bl = true;
                this.nextToken();
            } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
                this.reportSyntaxError(this.S.prevToken().endPos, CompilerProperties.Errors.Expected2(Tokens.TokenKind.RBRACE, Tokens.TokenKind.SEMI));
                bl3 = true;
            }
        }
        while (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.EOF) {
            EnumeratorEstimate enumeratorEstimate;
            if (this.token.kind == Tokens.TokenKind.SEMI) {
                this.accept(Tokens.TokenKind.SEMI);
                bl = true;
                if (this.token.kind == Tokens.TokenKind.RBRACE || this.token.kind == Tokens.TokenKind.EOF) break;
            }
            if ((enumeratorEstimate = this.estimateEnumeratorOrMember(name)) == EnumeratorEstimate.UNKNOWN) {
                EnumeratorEstimate enumeratorEstimate2 = enumeratorEstimate = bl ? EnumeratorEstimate.MEMBER : EnumeratorEstimate.ENUMERATOR;
            }
            if (enumeratorEstimate == EnumeratorEstimate.ENUMERATOR) {
                bl3 = false;
                if (bl && !bl2) {
                    this.reportSyntaxError(this.token.pos, CompilerProperties.Errors.EnumConstantNotExpected);
                    bl2 = true;
                }
                listBuffer.append(this.enumeratorDeclaration(name));
                if (this.token.pos <= this.endPosTable.errorEndPos) {
                    this.skip(false, true, true, false);
                    continue;
                }
                if (this.token.kind == Tokens.TokenKind.RBRACE || this.token.kind == Tokens.TokenKind.SEMI || this.token.kind == Tokens.TokenKind.EOF) continue;
                if (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                    continue;
                }
                this.setErrorEndPos(this.token.pos);
                this.reportSyntaxError(this.S.prevToken().endPos, CompilerProperties.Errors.Expected3(Tokens.TokenKind.COMMA, Tokens.TokenKind.RBRACE, Tokens.TokenKind.SEMI));
                bl3 = true;
                continue;
            }
            if (!(bl || bl2 || bl3)) {
                this.reportSyntaxError(this.token.pos, CompilerProperties.Errors.EnumConstantExpected);
                bl2 = true;
            }
            bl3 = false;
            listBuffer.appendList(this.classOrInterfaceOrRecordBodyDeclaration(name, false, false));
            if (this.token.pos > this.endPosTable.errorEndPos) continue;
            this.skip(false, true, true, false);
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return listBuffer.toList();
    }

    private EnumeratorEstimate estimateEnumeratorOrMember(Name name) {
        if (!(this.token.kind != Tokens.TokenKind.IDENTIFIER || this.token.name() == name || this.allowRecords && this.isRecordStart())) {
            Tokens.Token token = this.S.token(1);
            switch (token.kind) {
                case SEMI: 
                case LBRACE: 
                case LPAREN: 
                case COMMA: {
                    return EnumeratorEstimate.ENUMERATOR;
                }
            }
        }
        switch (this.token.kind) {
            case MONKEYS_AT: 
            case LT: 
            case IDENTIFIER: {
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.allowRecords && this.isRecordStart()) {
                    return EnumeratorEstimate.MEMBER;
                }
                return EnumeratorEstimate.UNKNOWN;
            }
        }
        return EnumeratorEstimate.MEMBER;
    }

    JCTree enumeratorDeclaration(Name name) {
        Object object;
        JCTree jCTree;
        Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
        int n = 16409;
        if (this.token.deprecatedFlag()) {
            n |= 0x20000;
        }
        int n2 = this.token.pos;
        List<JCTree.JCAnnotation> list = this.annotationsOpt(JCTree.Tag.ANNOTATION);
        JCTree.JCModifiers jCModifiers = this.F.at(list.isEmpty() ? -1 : n2).Modifiers(n, list);
        List<JCTree.JCExpression> list2 = this.typeArgumentsOpt();
        int n3 = this.token.pos;
        Name name2 = this.ident();
        int n4 = this.token.pos;
        List<Object> list3 = this.token.kind == Tokens.TokenKind.LPAREN ? this.arguments() : List.nil();
        JCTree.JCClassDecl jCClassDecl = null;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            jCTree = this.F.at(-1).Modifiers(16384L);
            object = this.classInterfaceOrRecordBody(this.names.empty, false, false);
            jCClassDecl = this.toP(this.F.at(n3).AnonymousClassDef((JCTree.JCModifiers)jCTree, (List<JCTree>)object));
        }
        if (list3.isEmpty() && jCClassDecl == null) {
            n4 = n3;
        }
        jCTree = this.F.at(n3).Ident(name);
        object = this.F.at(n4).NewClass(null, list2, (JCTree.JCExpression)jCTree, list3, jCClassDecl);
        if (n4 != n3) {
            this.storeEnd((JCTree)object, this.S.prevToken().endPos);
        }
        jCTree = this.F.at(n3).Ident(name);
        JCTree.JCVariableDecl jCVariableDecl = this.toP(this.F.at(n2).VarDef(jCModifiers, name2, (JCTree.JCExpression)jCTree, (JCTree.JCExpression)object));
        this.attach(jCVariableDecl, comment);
        return jCVariableDecl;
    }

    List<JCTree.JCExpression> typeList() {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.append(this.parseType());
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            listBuffer.append(this.parseType());
        }
        return listBuffer.toList();
    }

    List<JCTree> classInterfaceOrRecordBody(Name name, boolean bl, boolean bl2) {
        this.accept(Tokens.TokenKind.LBRACE);
        if (this.token.pos <= this.endPosTable.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                this.nextToken();
            } else {
                return List.nil();
            }
        }
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        while (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.EOF) {
            listBuffer.appendList(this.classOrInterfaceOrRecordBodyDeclaration(name, bl, bl2));
            if (this.token.pos > this.endPosTable.errorEndPos) continue;
            this.skip(false, true, true, false);
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return listBuffer.toList();
    }

    protected List<JCTree> classOrInterfaceOrRecordBodyDeclaration(Name name, boolean bl, boolean bl2) {
        List<JCTree> list;
        JCTree.JCExpression jCExpression;
        boolean bl3;
        List<JCTree.JCAnnotation> list2;
        if (this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            return List.nil();
        }
        Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
        int n = this.token.pos;
        JCTree.JCModifiers jCModifiers = this.modifiersOpt();
        if (this.token.kind == Tokens.TokenKind.CLASS || this.allowRecords && this.isRecordStart() || this.token.kind == Tokens.TokenKind.INTERFACE || this.token.kind == Tokens.TokenKind.ENUM) {
            return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(jCModifiers, comment));
        }
        if (this.token.kind == Tokens.TokenKind.LBRACE && (jCModifiers.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && jCModifiers.annotations.isEmpty()) {
            if (bl) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.InitializerNotAllowed);
            } else if (bl2 && (jCModifiers.flags & 8L) == 0L) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.InstanceInitializerNotAllowedInRecords);
            }
            return List.of(this.block(n, jCModifiers.flags));
        }
        n = this.token.pos;
        List<JCTree.JCTypeParameter> list3 = this.typeParametersOpt();
        if (list3.nonEmpty() && jCModifiers.pos == -1) {
            jCModifiers.pos = n;
            this.storeEnd(jCModifiers, n);
        }
        if ((list2 = this.annotationsOpt(JCTree.Tag.ANNOTATION)).nonEmpty()) {
            this.checkSourceLevel(((JCTree.JCAnnotation)list2.head).pos, Source.Feature.ANNOTATIONS_AFTER_TYPE_PARAMS);
            jCModifiers.annotations = jCModifiers.annotations.appendList(list2);
            if (jCModifiers.pos == -1) {
                jCModifiers.pos = ((JCTree.JCAnnotation)jCModifiers.annotations.head).pos;
            }
        }
        Tokens.Token token = this.token;
        n = this.token.pos;
        boolean bl4 = bl3 = this.token.kind == Tokens.TokenKind.VOID;
        if (bl3) {
            jCExpression = this.to(this.F.at(n).TypeIdent(TypeTag.VOID));
            this.nextToken();
        } else {
            jCExpression = this.unannotatedType(false);
        }
        if ((this.token.kind == Tokens.TokenKind.LPAREN && !bl || bl2 && this.token.kind == Tokens.TokenKind.LBRACE) && jCExpression.hasTag(JCTree.Tag.IDENT)) {
            if (bl || token.name() != name) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, n, CompilerProperties.Errors.InvalidMethDeclRetTypeReq);
            } else if (list2.nonEmpty()) {
                this.illegal(((JCTree.JCAnnotation)list2.head).pos);
            }
            if (bl2 && this.token.kind == Tokens.TokenKind.LBRACE) {
                jCModifiers.flags |= 0x8000000000000L;
            }
            return List.of(this.methodDeclaratorRest(n, jCModifiers, null, this.names.init, list3, bl, true, bl2, comment));
        }
        if (bl2 && jCExpression.hasTag(JCTree.Tag.IDENT) && this.token.kind == Tokens.TokenKind.THROWS) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.InvalidCanonicalConstructorInRecord(CompilerProperties.Fragments.Compact, name, CompilerProperties.Fragments.ThrowsClauseNotAllowedForCanonicalConstructor(CompilerProperties.Fragments.Compact)));
            this.skip(false, true, false, false);
            return List.of(this.methodDeclaratorRest(n, jCModifiers, null, this.names.init, list3, bl, true, bl2, comment));
        }
        n = this.token.pos;
        Name name2 = this.ident();
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            return List.of(this.methodDeclaratorRest(n, jCModifiers, jCExpression, name2, list3, bl, bl3, false, comment));
        }
        if (!bl3 && list3.isEmpty()) {
            if (!bl2 || bl2 && (jCModifiers.flags & 8L) != 0L) {
                List<JCTree> list4 = this.variableDeclaratorsRest(n, jCModifiers, jCExpression, name2, bl, comment, new ListBuffer(), false).toList();
                this.accept(Tokens.TokenKind.SEMI);
                this.storeEnd((JCTree)list4.last(), this.S.prevToken().endPos);
                return list4;
            }
            int n2 = n;
            this.variableDeclaratorsRest(n, jCModifiers, jCExpression, name2, bl, comment, new ListBuffer(), false).toList();
            this.accept(Tokens.TokenKind.SEMI);
            return List.of(this.syntaxError(n2, null, CompilerProperties.Errors.RecordCannotDeclareInstanceFields));
        }
        n = this.token.pos;
        if (bl3 || list3.nonEmpty()) {
            JCTree.JCMethodDecl jCMethodDecl = this.toP(this.F.at(n).MethodDef(jCModifiers, name2, jCExpression, list3, List.nil(), List.nil(), null, null));
            this.attach(jCMethodDecl, comment);
            list = List.of(jCMethodDecl);
        } else {
            list = List.nil();
        }
        return List.of(this.syntaxError(this.token.pos, list, CompilerProperties.Errors.Expected(Tokens.TokenKind.LPAREN)));
    }

    protected boolean isRecordStart() {
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.record && (this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.IDENTIFIER, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.LPAREN) || this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.IDENTIFIER, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.EOF) || this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.IDENTIFIER, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.LT))) {
            this.checkSourceLevel(Source.Feature.RECORDS);
            return true;
        }
        return false;
    }

    protected boolean isNonSealedClassStart(boolean bl) {
        if (this.isNonSealedIdentifier(this.token, 0)) {
            Tokens.Token token = this.S.token(3);
            return this.allowedAfterSealedOrNonSealed(token, bl, true);
        }
        return false;
    }

    protected boolean isNonSealedIdentifier(Tokens.Token token, int n) {
        if (token.name() == this.names.non && this.peekToken(n, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.SUB, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.IDENTIFIER)) {
            Tokens.Token token2 = this.S.token(n + 1);
            Tokens.Token token3 = this.S.token(n + 2);
            if (token.endPos == token2.pos && token2.endPos == token3.pos && token3.name() == this.names.sealed) {
                this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
                return true;
            }
        }
        return false;
    }

    protected boolean isSealedClassStart(boolean bl) {
        Tokens.Token token;
        if (this.token.name() == this.names.sealed && this.allowedAfterSealedOrNonSealed(token = this.S.token(1), bl, false)) {
            this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
            return true;
        }
        return false;
    }

    private boolean allowedAfterSealedOrNonSealed(Tokens.Token token, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl) {
            switch (token.kind) {
                case MONKEYS_AT: {
                    Tokens.Token token2 = this.S.token(2);
                    if (token2.kind != Tokens.TokenKind.INTERFACE || bl2) {
                        bl3 = true;
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case FINAL: 
                case ABSTRACT: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case STRICTFP: {
                    bl3 = true;
                    break;
                }
                default: {
                    bl3 = false;
                    break;
                }
            }
        } else {
            switch (token.kind) {
                case MONKEYS_AT: {
                    Tokens.Token token3 = this.S.token(2);
                    if (token3.kind != Tokens.TokenKind.INTERFACE || bl2) {
                        bl3 = true;
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case STRICTFP: {
                    bl3 = true;
                    break;
                }
                case IDENTIFIER: {
                    if (this.isNonSealedIdentifier(token, bl2 ? 3 : 1) || token.name() == this.names.sealed) {
                        bl3 = true;
                        break;
                    }
                    bl3 = false;
                    break;
                }
                default: {
                    bl3 = false;
                }
            }
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JCTree methodDeclaratorRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, List<JCTree.JCTypeParameter> list, boolean bl, boolean bl2, boolean bl3, Tokens.Comment comment) {
        if (bl) {
            if ((jCModifiers.flags & 8L) != 0L) {
                this.checkSourceLevel(Source.Feature.STATIC_INTERFACE_METHODS);
            }
            if ((jCModifiers.flags & 2L) != 0L) {
                this.checkSourceLevel(Source.Feature.PRIVATE_INTERFACE_METHODS);
            }
        }
        JCTree.JCVariableDecl jCVariableDecl = this.receiverParam;
        try {
            JCTree.JCExpression jCExpression2;
            this.receiverParam = null;
            List<JCTree.JCVariableDecl> list2 = List.nil();
            List<JCTree.JCExpression> list3 = List.nil();
            if (!bl3 || name != this.names.init || this.token.kind == Tokens.TokenKind.LPAREN) {
                list2 = this.formalParameters();
                if (!bl2) {
                    jCExpression = this.bracketsOpt(jCExpression);
                }
                if (this.token.kind == Tokens.TokenKind.THROWS) {
                    this.nextToken();
                    list3 = this.qualidentList(true);
                }
            }
            JCTree.JCBlock jCBlock = null;
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                jCBlock = this.block();
                jCExpression2 = null;
            } else {
                if (this.token.kind == Tokens.TokenKind.DEFAULT) {
                    this.accept(Tokens.TokenKind.DEFAULT);
                    jCExpression2 = this.annotationValue();
                } else {
                    jCExpression2 = null;
                }
                this.accept(Tokens.TokenKind.SEMI);
                if (this.token.pos <= this.endPosTable.errorEndPos) {
                    this.skip(false, true, false, false);
                    if (this.token.kind == Tokens.TokenKind.LBRACE) {
                        jCBlock = this.block();
                    }
                }
            }
            JCTree.JCMethodDecl jCMethodDecl = this.toP(this.F.at(n).MethodDef(jCModifiers, name, jCExpression, list, this.receiverParam, list2, list3, jCBlock, jCExpression2));
            this.attach(jCMethodDecl, comment);
            JCTree.JCMethodDecl jCMethodDecl2 = jCMethodDecl;
            return jCMethodDecl2;
        }
        finally {
            this.receiverParam = jCVariableDecl;
        }
    }

    List<JCTree.JCExpression> qualidentList(boolean bl) {
        JCTree.JCExpression jCExpression;
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        List<Object> list = bl ? this.typeAnnotationsOpt() : List.nil();
        JCTree.JCExpression jCExpression2 = this.qualident(bl);
        if (!list.isEmpty()) {
            jCExpression = this.insertAnnotationsToMostInner(jCExpression2, list, false);
            listBuffer.append(jCExpression);
        } else {
            listBuffer.append(jCExpression2);
        }
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            list = bl ? this.typeAnnotationsOpt() : List.nil();
            jCExpression2 = this.qualident(bl);
            if (!list.isEmpty()) {
                jCExpression = this.insertAnnotationsToMostInner(jCExpression2, list, false);
                listBuffer.append(jCExpression);
                continue;
            }
            listBuffer.append(jCExpression2);
        }
        return listBuffer.toList();
    }

    protected List<JCTree.JCTypeParameter> typeParametersOpt() {
        return this.typeParametersOpt(false);
    }

    protected List<JCTree.JCTypeParameter> typeParametersOpt(boolean bl) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            ListBuffer<JCTree.JCTypeParameter> listBuffer = new ListBuffer<JCTree.JCTypeParameter>();
            this.nextToken();
            if (bl && this.token.kind == Tokens.TokenKind.GT) {
                this.accept(Tokens.TokenKind.GT);
                return null;
            }
            listBuffer.append(this.typeParameter());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                listBuffer.append(this.typeParameter());
            }
            this.accept(Tokens.TokenKind.GT);
            return listBuffer.toList();
        }
        return List.nil();
    }

    JCTree.JCTypeParameter typeParameter() {
        int n = this.token.pos;
        List<JCTree.JCAnnotation> list = this.typeAnnotationsOpt();
        Name name = this.typeName();
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            listBuffer.append(this.parseType());
            while (this.token.kind == Tokens.TokenKind.AMP) {
                this.nextToken();
                listBuffer.append(this.parseType());
            }
        }
        return this.toP(this.F.at(n).TypeParameter(name, listBuffer.toList(), list));
    }

    List<JCTree.JCVariableDecl> formalParameters() {
        return this.formalParameters(false, false);
    }

    List<JCTree.JCVariableDecl> formalParameters(boolean bl, boolean bl2) {
        ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
        this.accept(Tokens.TokenKind.LPAREN);
        if (this.token.kind != Tokens.TokenKind.RPAREN) {
            this.allowThisIdent = !bl && !bl2;
            JCTree.JCVariableDecl jCVariableDecl = this.formalParameter(bl, bl2);
            if (jCVariableDecl.nameexpr != null) {
                this.receiverParam = jCVariableDecl;
            } else {
                listBuffer.append(jCVariableDecl);
            }
            this.allowThisIdent = false;
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                if ((jCVariableDecl.mods.flags & 0x400000000L) != 0L) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, jCVariableDecl, CompilerProperties.Errors.VarargsMustBeLast);
                }
                this.nextToken();
                jCVariableDecl = this.formalParameter(bl, bl2);
                listBuffer.append(jCVariableDecl);
            }
        }
        if (this.token.kind == Tokens.TokenKind.RPAREN) {
            this.nextToken();
        } else {
            this.setErrorEndPos(this.token.pos);
            this.reportSyntaxError(this.S.prevToken().endPos, CompilerProperties.Errors.Expected3(Tokens.TokenKind.COMMA, Tokens.TokenKind.RPAREN, Tokens.TokenKind.LBRACKET));
        }
        return listBuffer.toList();
    }

    List<JCTree.JCVariableDecl> implicitParameters(boolean bl) {
        if (bl) {
            this.accept(Tokens.TokenKind.LPAREN);
        }
        ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
        if (this.token.kind != Tokens.TokenKind.RPAREN && this.token.kind != Tokens.TokenKind.ARROW) {
            listBuffer.append(this.implicitParameter());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                listBuffer.append(this.implicitParameter());
            }
        }
        if (bl) {
            this.accept(Tokens.TokenKind.RPAREN);
        }
        return listBuffer.toList();
    }

    JCTree.JCModifiers optFinal(long l) {
        JCTree.JCModifiers jCModifiers = this.modifiersOpt();
        this.checkNoMods(jCModifiers.flags & 0xFFFFFFFFFFFDFFEFL);
        jCModifiers.flags |= l;
        return jCModifiers;
    }

    private JCTree.JCExpression insertAnnotationsToMostInner(JCTree.JCExpression jCExpression, List<JCTree.JCAnnotation> list, boolean bl) {
        int n = this.getEndPos(jCExpression);
        JCTree.JCExpression jCExpression2 = jCExpression;
        JCTree.JCArrayTypeTree jCArrayTypeTree = null;
        while (TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.TYPEARRAY)) {
            jCArrayTypeTree = (JCTree.JCArrayTypeTree)TreeInfo.typeIn(jCExpression2);
            jCExpression2 = jCArrayTypeTree.elemtype;
        }
        if (bl) {
            jCExpression2 = this.to(this.F.at(this.token.pos).TypeArray(jCExpression2));
            n = this.getEndPos(jCExpression2);
        }
        JCTree.JCExpression jCExpression3 = jCExpression2;
        if (list.nonEmpty()) {
            JCTree.JCExpression jCExpression4 = jCExpression2;
            while (TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.SELECT) || TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.TYPEAPPLY)) {
                while (TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.SELECT)) {
                    jCExpression4 = jCExpression2;
                    jCExpression2 = ((JCTree.JCFieldAccess)TreeInfo.typeIn(jCExpression2)).getExpression();
                }
                while (TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.TYPEAPPLY)) {
                    jCExpression4 = jCExpression2;
                    jCExpression2 = ((JCTree.JCTypeApply)TreeInfo.typeIn((JCTree.JCExpression)jCExpression2)).clazz;
                }
            }
            jCExpression2 = this.F.at(((JCTree.JCAnnotation)list.head).pos).AnnotatedType(list, jCExpression2);
            if (TreeInfo.typeIn(jCExpression4).hasTag(JCTree.Tag.TYPEAPPLY)) {
                ((JCTree.JCTypeApply)TreeInfo.typeIn((JCTree.JCExpression)jCExpression4)).clazz = jCExpression2;
            } else if (TreeInfo.typeIn(jCExpression4).hasTag(JCTree.Tag.SELECT)) {
                ((JCTree.JCFieldAccess)TreeInfo.typeIn((JCTree.JCExpression)jCExpression4)).selected = jCExpression2;
            } else {
                jCExpression3 = jCExpression2;
            }
        }
        if (jCArrayTypeTree == null) {
            return jCExpression3;
        }
        jCArrayTypeTree.elemtype = jCExpression3;
        this.storeEnd(jCExpression, n);
        return jCExpression;
    }

    protected JCTree.JCVariableDecl formalParameter(boolean bl, boolean bl2) {
        JCTree.JCModifiers jCModifiers;
        JCTree.JCModifiers jCModifiers2 = jCModifiers = !bl2 ? this.optFinal(0x200000000L) : this.modifiersOpt();
        if (bl2 && jCModifiers.flags != 0L) {
            this.log.error(jCModifiers.pos, CompilerProperties.Errors.RecordCantDeclareFieldModifiers);
        }
        if (bl2) {
            jCModifiers.flags |= 0x2000000001000012L;
        }
        this.permitTypeAnnotationsPushBack = true;
        JCTree.JCExpression jCExpression = this.parseType(bl);
        this.permitTypeAnnotationsPushBack = false;
        if (this.token.kind == Tokens.TokenKind.ELLIPSIS) {
            List<JCTree.JCAnnotation> list = this.typeAnnotationsPushedBack;
            this.typeAnnotationsPushedBack = List.nil();
            jCModifiers.flags |= 0x400000000L;
            jCExpression = this.insertAnnotationsToMostInner(jCExpression, list, true);
            this.nextToken();
        } else {
            if (this.typeAnnotationsPushedBack.nonEmpty()) {
                this.reportSyntaxError(((JCTree.JCAnnotation)this.typeAnnotationsPushedBack.head).pos, CompilerProperties.Errors.IllegalStartOfType);
            }
            this.typeAnnotationsPushedBack = List.nil();
        }
        return this.variableDeclaratorId(jCModifiers, jCExpression, bl, bl2);
    }

    protected JCTree.JCVariableDecl implicitParameter() {
        JCTree.JCModifiers jCModifiers = this.F.at(this.token.pos).Modifiers(0x200000000L);
        return this.variableDeclaratorId(jCModifiers, null, true, false);
    }

    protected JCTree.JCExpression checkExprStat(JCTree.JCExpression jCExpression) {
        if (!TreeInfo.isExpressionStatement(jCExpression)) {
            JCTree.JCErroneous jCErroneous = this.F.at(jCExpression.pos).Erroneous(List.of(jCExpression));
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, jCErroneous, CompilerProperties.Errors.NotStmt);
            return jCErroneous;
        }
        return jCExpression;
    }

    static int prec(Tokens.TokenKind tokenKind) {
        JCTree.Tag tag = JavacParser.optag(tokenKind);
        return tag != JCTree.Tag.NO_TAG ? TreeInfo.opPrec(tag) : -1;
    }

    static int earlier(int n, int n2) {
        if (n == -1) {
            return n2;
        }
        if (n2 == -1) {
            return n;
        }
        return n < n2 ? n : n2;
    }

    static JCTree.Tag optag(Tokens.TokenKind tokenKind) {
        switch (tokenKind) {
            case BARBAR: {
                return JCTree.Tag.OR;
            }
            case AMPAMP: {
                return JCTree.Tag.AND;
            }
            case BAR: {
                return JCTree.Tag.BITOR;
            }
            case BAREQ: {
                return JCTree.Tag.BITOR_ASG;
            }
            case CARET: {
                return JCTree.Tag.BITXOR;
            }
            case CARETEQ: {
                return JCTree.Tag.BITXOR_ASG;
            }
            case AMP: {
                return JCTree.Tag.BITAND;
            }
            case AMPEQ: {
                return JCTree.Tag.BITAND_ASG;
            }
            case EQEQ: {
                return JCTree.Tag.EQ;
            }
            case BANGEQ: {
                return JCTree.Tag.NE;
            }
            case LT: {
                return JCTree.Tag.LT;
            }
            case GT: {
                return JCTree.Tag.GT;
            }
            case LTEQ: {
                return JCTree.Tag.LE;
            }
            case GTEQ: {
                return JCTree.Tag.GE;
            }
            case LTLT: {
                return JCTree.Tag.SL;
            }
            case LTLTEQ: {
                return JCTree.Tag.SL_ASG;
            }
            case GTGT: {
                return JCTree.Tag.SR;
            }
            case GTGTEQ: {
                return JCTree.Tag.SR_ASG;
            }
            case GTGTGT: {
                return JCTree.Tag.USR;
            }
            case GTGTGTEQ: {
                return JCTree.Tag.USR_ASG;
            }
            case PLUS: {
                return JCTree.Tag.PLUS;
            }
            case PLUSEQ: {
                return JCTree.Tag.PLUS_ASG;
            }
            case SUB: {
                return JCTree.Tag.MINUS;
            }
            case SUBEQ: {
                return JCTree.Tag.MINUS_ASG;
            }
            case STAR: {
                return JCTree.Tag.MUL;
            }
            case STAREQ: {
                return JCTree.Tag.MUL_ASG;
            }
            case SLASH: {
                return JCTree.Tag.DIV;
            }
            case SLASHEQ: {
                return JCTree.Tag.DIV_ASG;
            }
            case PERCENT: {
                return JCTree.Tag.MOD;
            }
            case PERCENTEQ: {
                return JCTree.Tag.MOD_ASG;
            }
            case INSTANCEOF: {
                return JCTree.Tag.TYPETEST;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    static JCTree.Tag unoptag(Tokens.TokenKind tokenKind) {
        switch (tokenKind) {
            case PLUS: {
                return JCTree.Tag.POS;
            }
            case SUB: {
                return JCTree.Tag.NEG;
            }
            case BANG: {
                return JCTree.Tag.NOT;
            }
            case TILDE: {
                return JCTree.Tag.COMPL;
            }
            case PLUSPLUS: {
                return JCTree.Tag.PREINC;
            }
            case SUBSUB: {
                return JCTree.Tag.PREDEC;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    static TypeTag typetag(Tokens.TokenKind tokenKind) {
        switch (tokenKind) {
            case BYTE: {
                return TypeTag.BYTE;
            }
            case CHAR: {
                return TypeTag.CHAR;
            }
            case SHORT: {
                return TypeTag.SHORT;
            }
            case INT: {
                return TypeTag.INT;
            }
            case LONG: {
                return TypeTag.LONG;
            }
            case FLOAT: {
                return TypeTag.FLOAT;
            }
            case DOUBLE: {
                return TypeTag.DOUBLE;
            }
            case BOOLEAN: {
                return TypeTag.BOOLEAN;
            }
        }
        return TypeTag.NONE;
    }

    void checkSourceLevel(Source.Feature feature) {
        this.checkSourceLevel(this.token.pos, feature);
    }

    protected void checkSourceLevel(int n, Source.Feature feature) {
        if (this.preview.isPreview(feature) && !this.preview.isEnabled()) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, n, this.preview.disabledError(feature));
        } else if (!feature.allowedInSource(this.source, this.target)) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, n, feature.error(this.source.name));
        } else if (this.preview.isPreview(feature)) {
            this.preview.warnPreview(n, feature);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static abstract class AbstractEndPosTable
    implements EndPosTable {
        protected JavacParser parser;
        public int errorEndPos = -1;

        public AbstractEndPosTable(JavacParser javacParser) {
            this.parser = javacParser;
        }

        protected abstract <T extends JCTree> T to(T var1);

        protected abstract <T extends JCTree> T toP(T var1);

        public void setErrorEndPos(int n) {
            if (n > this.errorEndPos) {
                this.errorEndPos = n;
            }
        }

        public void setParser(JavacParser javacParser) {
            this.parser = javacParser;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static class SimpleEndPosTable
    extends AbstractEndPosTable {
        private final IntHashTable endPosMap = new IntHashTable();

        SimpleEndPosTable(JavacParser javacParser) {
            super(javacParser);
        }

        @Override
        public void storeEnd(JCTree jCTree, int n) {
            this.endPosMap.put(jCTree, this.errorEndPos > n ? this.errorEndPos : n);
        }

        @Override
        protected <T extends JCTree> T to(T t) {
            this.storeEnd(t, this.parser.token.endPos);
            return t;
        }

        @Override
        protected <T extends JCTree> T toP(T t) {
            this.storeEnd(t, this.parser.S.prevToken().endPos);
            return t;
        }

        @Override
        public int getEndPos(JCTree jCTree) {
            int n = this.endPosMap.get(jCTree);
            return n == -1 ? -1 : n;
        }

        @Override
        public int replaceTree(JCTree jCTree, JCTree jCTree2) {
            int n = this.endPosMap.remove(jCTree);
            if (n != -1) {
                this.storeEnd(jCTree2, n);
                return n;
            }
            return -1;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static class EmptyEndPosTable
    extends AbstractEndPosTable {
        EmptyEndPosTable(JavacParser javacParser) {
            super(javacParser);
        }

        @Override
        public void storeEnd(JCTree jCTree, int n) {
        }

        @Override
        protected <T extends JCTree> T to(T t) {
            return t;
        }

        @Override
        protected <T extends JCTree> T toP(T t) {
            return t;
        }

        @Override
        public int getEndPos(JCTree jCTree) {
            return -1;
        }

        @Override
        public int replaceTree(JCTree jCTree, JCTree jCTree2) {
            return -1;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum ParensResult {
        CAST,
        EXPLICIT_LAMBDA,
        IMPLICIT_LAMBDA,
        PARENS;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class LambdaClassifier {
        LambdaParameterKind kind;
        JCDiagnostic.Fragment diagFragment;
        List<JCTree.JCVariableDecl> params;

        LambdaClassifier() {
        }

        void addParameter(JCTree.JCVariableDecl jCVariableDecl) {
            if (jCVariableDecl.vartype != null && jCVariableDecl.name != ((JavacParser)JavacParser.this).names.empty) {
                if (JavacParser.this.restrictedTypeName(jCVariableDecl.vartype, false) != null) {
                    this.reduce(LambdaParameterKind.VAR);
                } else {
                    this.reduce(LambdaParameterKind.EXPLICIT);
                }
            }
            if (jCVariableDecl.vartype == null && jCVariableDecl.name != ((JavacParser)JavacParser.this).names.empty || jCVariableDecl.vartype != null && jCVariableDecl.name == ((JavacParser)JavacParser.this).names.empty) {
                this.reduce(LambdaParameterKind.IMPLICIT);
            }
        }

        private void reduce(LambdaParameterKind lambdaParameterKind) {
            if (this.kind == null) {
                this.kind = lambdaParameterKind;
            } else if (this.kind != lambdaParameterKind && this.kind != LambdaParameterKind.ERROR) {
                LambdaParameterKind lambdaParameterKind2 = this.kind;
                this.kind = LambdaParameterKind.ERROR;
                boolean bl = lambdaParameterKind2.index == LambdaParameterKind.VAR.index || lambdaParameterKind.index == LambdaParameterKind.VAR.index;
                this.diagFragment = Source.Feature.VAR_SYNTAX_IMPLICIT_LAMBDAS.allowedInSource(JavacParser.this.source, JavacParser.this.target) || !bl ? decisionTable[lambdaParameterKind2.index][lambdaParameterKind.index] : null;
            }
        }

        LambdaParameterKind result() {
            return this.kind;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum LambdaParameterKind {
        VAR(0),
        EXPLICIT(1),
        IMPLICIT(2),
        ERROR(-1);

        private final int index;

        private LambdaParameterKind(int n2) {
            this.index = n2;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum BasicErrorRecoveryAction implements ErrorRecoveryAction
    {
        BLOCK_STMT{

            @Override
            public JCTree doRecover(JavacParser javacParser) {
                return javacParser.parseStatementAsBlock();
            }
        }
        ,
        CATCH_CLAUSE{

            @Override
            public JCTree doRecover(JavacParser javacParser) {
                return javacParser.catchClause();
            }
        };

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface ErrorRecoveryAction {
        public JCTree doRecover(JavacParser var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum PatternResult {
        EXPRESSION,
        PATTERN;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum EnumeratorEstimate {
        ENUMERATOR,
        MEMBER,
        UNKNOWN;

    }
}

