/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.regex.Pattern;

public class JavadocTokenizer
extends JavaTokenizer {
    final ScannerFactory fac;

    protected JavadocTokenizer(ScannerFactory scannerFactory, CharBuffer charBuffer) {
        super(scannerFactory, charBuffer);
        this.fac = scannerFactory;
    }

    protected JavadocTokenizer(ScannerFactory scannerFactory, char[] cArray, int n) {
        super(scannerFactory, cArray, n);
        this.fac = scannerFactory;
    }

    @Override
    protected Tokens.Comment processComment(int n, int n2, Tokens.Comment.CommentStyle commentStyle) {
        char[] cArray = this.getRawCharacters(n, n2);
        return new JavadocComment(commentStyle, this.fac, cArray, n);
    }

    @Override
    public Position.LineMap getLineMap() {
        char[] cArray = this.getRawCharacters();
        return Position.makeLineMap(cArray, cArray.length, true);
    }

    protected static class JavadocComment
    extends JavaTokenizer.BasicComment {
        private static final Pattern DEPRECATED_PATTERN = Pattern.compile("(?sm).*^\\s*@deprecated( |$).*");
        private String docComment = null;
        private final StringBuilder sb;
        OffsetMap offsetMap = new OffsetMap();

        JavadocComment(Tokens.Comment.CommentStyle commentStyle, ScannerFactory scannerFactory, char[] cArray, int n) {
            super(commentStyle, scannerFactory, cArray, n);
            this.sb = new StringBuilder();
        }

        protected void put(char c) {
            this.offsetMap.add(this.sb.length(), this.offsetPosition());
            this.sb.append(c);
        }

        protected void putCodePoint(int n) {
            this.offsetMap.add(this.sb.length(), this.offsetPosition());
            this.sb.appendCodePoint(n);
        }

        protected void put() {
            if (this.isSurrogate()) {
                this.putCodePoint(this.getCodepoint());
            } else {
                this.put(this.get());
            }
        }

        @Override
        public String getText() {
            if (!this.scanned && this.cs == Tokens.Comment.CommentStyle.JAVADOC) {
                this.scanDocComment();
            }
            return this.docComment;
        }

        @Override
        public int getSourcePos(int n) {
            if (n == -1) {
                return -1;
            }
            if (n < 0 || n > this.docComment.length()) {
                throw new StringIndexOutOfBoundsException(String.valueOf(n));
            }
            return this.offsetMap.getSourcePos(n);
        }

        @Override
        protected void scanDocComment() {
            try {
                int n;
                boolean bl = true;
                this.accept("/*");
                this.skip('*');
                if (this.is('/')) {
                    this.docComment = "";
                    return;
                }
                if (this.isOneOf('\n', '\r')) {
                    this.accept('\r');
                    this.accept('\n');
                    bl = false;
                }
                block4: while (this.isAvailable()) {
                    n = this.position();
                    this.skipWhitespace();
                    if (this.is('*')) {
                        this.skip('*');
                        if (this.accept('/')) {
                            break;
                        }
                    } else if (!bl) {
                        this.reset(n);
                    }
                    while (this.isAvailable()) {
                        if (this.accept("*/")) break block4;
                        if (this.isOneOf('\n', '\r')) {
                            this.put('\n');
                            this.accept('\r');
                            this.accept('\n');
                            break;
                        }
                        if (this.is('\f')) {
                            this.next();
                            break;
                        }
                        this.put();
                        this.next();
                    }
                    bl = false;
                }
                if (this.sb.length() > 0) {
                    for (n = this.sb.length() - 1; n > -1 && this.sb.charAt(n) == '*'; --n) {
                    }
                    this.sb.setLength(n + 1);
                    this.docComment = this.sb.toString();
                } else {
                    this.docComment = "";
                }
            }
            finally {
                this.scanned = true;
                if (this.docComment != null && DEPRECATED_PATTERN.matcher(this.docComment).matches()) {
                    this.deprecatedFlag = true;
                }
            }
        }
    }

    static class OffsetMap {
        private static final int SB_OFFSET = 0;
        private static final int POS_OFFSET = 1;
        private static final int NOFFSETS = 2;
        private int[] map = new int[128];
        private int size = 0;

        OffsetMap() {
        }

        boolean shouldAdd(int n, int n2) {
            return n - this.lastSBOffset() != n2 - this.lastPosOffset();
        }

        void add(int n, int n2) {
            if (this.size == 0 || this.shouldAdd(n, n2)) {
                this.ensure(2);
                this.map[this.size + 0] = n;
                this.map[this.size + 1] = n2;
                this.size += 2;
            }
        }

        private int lastSBOffset() {
            return this.size == 0 ? 0 : this.map[this.size - 2 + 0];
        }

        private int lastPosOffset() {
            return this.size == 0 ? 0 : this.map[this.size - 2 + 1];
        }

        private void ensure(int n) {
            int n2;
            n += this.size;
            for (n2 = this.map.length; n > n2; n2 <<= 1) {
            }
            if (n2 < this.map.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 != this.map.length) {
                this.map = Arrays.copyOf(this.map, n2);
            }
        }

        int getSourcePos(int n) {
            int n2;
            if (this.size == 0) {
                return -1;
            }
            int n3 = 0;
            int n4 = this.size / 2;
            while (n3 < n4 - 1) {
                n2 = (n3 + n4) / 2;
                int n5 = n2 * 2;
                if (this.map[n5 + 0] < n) {
                    n3 = n2;
                    continue;
                }
                if (this.map[n5 + 0] == n) {
                    return this.map[n5 + 1];
                }
                n4 = n2;
            }
            n2 = n3 * 2;
            return this.map[n2 + 1] + (n - this.map[n2 + 0]);
        }
    }
}

