/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.LayoutCharacters;
import com.sun.tools.javac.util.Log;
import java.util.Arrays;

public class UnicodeReader {
    private final char[] buffer;
    private final int length;
    private int position;
    private int width;
    private char character;
    private int codepoint;
    private boolean wasBackslash;
    private boolean wasUnicodeEscape;
    private final Log log;

    protected UnicodeReader(ScannerFactory scannerFactory, char[] cArray, int n) {
        this.buffer = cArray;
        this.length = n;
        this.position = 0;
        this.width = 0;
        this.character = '\u0000';
        this.codepoint = 0;
        this.wasBackslash = false;
        this.wasUnicodeEscape = false;
        this.log = scannerFactory.log;
        this.nextCodePoint();
    }

    protected int length() {
        return this.length;
    }

    protected boolean isAvailable() {
        return this.position < this.length;
    }

    private void nextCodeUnit() {
        int n = this.position + this.width;
        if (this.length <= n) {
            this.character = (char)26;
        } else {
            this.character = this.buffer[n];
            ++this.width;
        }
    }

    private void nextUnicodeInputCharacter() {
        this.position += this.width;
        this.width = 0;
        this.nextCodeUnit();
        if (this.character == '\\' && (!this.wasBackslash || this.wasUnicodeEscape)) {
            switch (this.unicodeEscape()) {
                case BACKSLASH: {
                    this.wasUnicodeEscape = false;
                    this.wasBackslash = !this.wasBackslash;
                    break;
                }
                case VALID_ESCAPE: {
                    this.wasUnicodeEscape = true;
                    this.wasBackslash = this.character == '\\' && !this.wasBackslash;
                    break;
                }
                case BROKEN_ESCAPE: {
                    this.nextUnicodeInputCharacter();
                }
            }
        } else {
            this.wasBackslash = false;
            this.wasUnicodeEscape = false;
        }
        this.codepoint = this.character;
    }

    private void nextCodePoint() {
        this.nextUnicodeInputCharacter();
        if (this.isASCII() || !Character.isHighSurrogate(this.character)) {
            return;
        }
        char c = this.character;
        int n = this.position;
        int n2 = this.width;
        this.nextUnicodeInputCharacter();
        char c2 = this.character;
        if (Character.isLowSurrogate(c2)) {
            this.position = n;
            this.width += n2;
            this.codepoint = Character.toCodePoint(c, c2);
        } else {
            this.position = n;
            this.width = n2;
            this.character = c;
            this.codepoint = c;
        }
    }

    private UnicodeEscapeResult unicodeEscape() {
        int n;
        int n2;
        int n3 = this.position + this.width;
        this.character = (char)92;
        this.width = 1;
        for (n2 = n3; n2 < this.length && this.buffer[n2] == 'u'; ++n2) {
        }
        if (n2 == n3) {
            return UnicodeEscapeResult.BACKSLASH;
        }
        int n4 = 0;
        for (int i = 0; i < 4 && (n4 = n4 << 4 | (n = n2 < this.length ? Character.digit(this.buffer[n2], 16) : -1)) >= 0; ++i) {
            ++n2;
        }
        this.width = n2 - this.position;
        if (n4 >= 0) {
            this.character = (char)n4;
            return UnicodeEscapeResult.VALID_ESCAPE;
        }
        this.log.error(n2, CompilerProperties.Errors.IllegalUnicodeEsc);
        return UnicodeEscapeResult.BROKEN_ESCAPE;
    }

    protected int position() {
        return this.position;
    }

    protected void reset(int n) {
        this.position = n;
        this.width = 0;
        this.wasBackslash = false;
        this.wasUnicodeEscape = false;
        this.nextCodePoint();
    }

    protected char get() {
        return this.character;
    }

    protected int getCodepoint() {
        return this.codepoint;
    }

    protected boolean isSurrogate() {
        return 65535 < this.codepoint;
    }

    protected boolean isASCII() {
        return this.character <= '\u007f';
    }

    protected char next() {
        this.nextCodePoint();
        return this.character;
    }

    protected boolean is(char c) {
        return this.character == c;
    }

    protected boolean isOneOf(char c, char c2) {
        return this.is(c) || this.is(c2);
    }

    protected boolean isOneOf(char c, char c2, char c3) {
        return this.is(c) || this.is(c2) || this.is(c3);
    }

    protected boolean isOneOf(char c, char c2, char c3, char c4, char c5, char c6) {
        return this.is(c) || this.is(c2) || this.is(c3) || this.is(c4) || this.is(c5) || this.is(c6);
    }

    protected boolean inRange(char c, char c2) {
        return c <= this.character && this.character <= c2;
    }

    protected boolean accept(char c) {
        if (this.is(c)) {
            this.next();
            return true;
        }
        return false;
    }

    protected boolean acceptOneOf(char c, char c2) {
        if (this.isOneOf(c, c2)) {
            this.next();
            return true;
        }
        return false;
    }

    protected boolean acceptOneOf(char c, char c2, char c3) {
        if (this.isOneOf(c, c2, c3)) {
            this.next();
            return true;
        }
        return false;
    }

    protected void skip(char c) {
        while (this.accept(c)) {
        }
    }

    protected void skipWhitespace() {
        while (this.acceptOneOf(' ', '\t', '\f')) {
        }
    }

    protected void skipToEOLN() {
        while (this.isAvailable() && !this.isOneOf('\r', '\n')) {
            this.next();
        }
    }

    protected boolean accept(String string) {
        if (string.length() == 0 || !this.is(string.charAt(0))) {
            return false;
        }
        int n = this.position;
        this.nextCodePoint();
        for (int i = 1; i < string.length(); ++i) {
            if (!this.is(string.charAt(i))) {
                this.reset(n);
                return false;
            }
            this.nextCodePoint();
        }
        return true;
    }

    protected int digit(int n, int n2) {
        int n3;
        if (this.inRange('0', '9')) {
            int n4 = this.character - 48;
            return n4 < n2 ? n4 : -1;
        }
        int n5 = n3 = this.isSurrogate() ? Character.digit(this.codepoint, n2) : Character.digit(this.character, n2);
        if (n3 >= 0 && !this.isASCII()) {
            this.log.error(this.position(), CompilerProperties.Errors.IllegalNonasciiDigit);
            this.character = "0123456789abcdef".charAt(n3);
        }
        return n3;
    }

    public char[] getRawCharacters() {
        return this.length == this.buffer.length ? this.buffer : Arrays.copyOf(this.buffer, this.length);
    }

    public char[] getRawCharacters(int n, int n2) {
        return Arrays.copyOfRange(this.buffer, n, n2);
    }

    private static enum UnicodeEscapeResult {
        BACKSLASH,
        VALID_ESCAPE,
        BROKEN_ESCAPE;

    }

    static class PositionTrackingReader
    extends UnicodeReader {
        private final int offset;
        private int column;

        protected PositionTrackingReader(ScannerFactory scannerFactory, char[] cArray, int n) {
            super(scannerFactory, cArray, cArray.length);
            this.offset = n;
            this.column = 0;
        }

        @Override
        protected char next() {
            super.next();
            this.column = this.isOneOf('\n', '\r', '\f') ? 0 : (this.is('\t') ? LayoutCharacters.tabulate(this.column) : ++this.column);
            return this.get();
        }

        protected int column() {
            return this.column;
        }

        protected int offsetPosition() {
            return this.position() + this.offset;
        }
    }
}

