/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.platform;

import com.sun.source.util.Plugin;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformProvider;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JDKPlatformProvider
implements PlatformProvider {
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final Set<String> SUPPORTED_JAVA_PLATFORM_VERSIONS;
    public static final Comparator<String> NUMERICAL_COMPARATOR;

    @Override
    public Iterable<String> getSupportedPlatformNames() {
        return SUPPORTED_JAVA_PLATFORM_VERSIONS;
    }

    @Override
    public PlatformDescription getPlatform(String string, String string2) {
        return new PlatformDescriptionImpl(string);
    }

    private static String targetNumericVersion(Target target) {
        return Integer.toString(target.ordinal() - Target.JDK1_1.ordinal() + 1);
    }

    static {
        NUMERICAL_COMPARATOR = (string, string2) -> {
            int n;
            int n2;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = Integer.MAX_VALUE;
            }
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = Integer.MAX_VALUE;
            }
            return n2 != n ? n2 - n : string.compareTo((String)string2);
        };
        SUPPORTED_JAVA_PLATFORM_VERSIONS = new TreeSet<String>(NUMERICAL_COMPARATOR);
        try (Arguments.CtSymRoot ctSymRoot = Arguments.ctSymRoot();
             DirectoryStream<Path> directoryStream = Files.newDirectoryStream(ctSymRoot.root);){
            for (Path path : directoryStream) {
                if (path.getFileName().toString().contains("-")) continue;
                for (char c : path.getFileName().toString().toCharArray()) {
                    if (c == '/') continue;
                    String string3 = Character.toString(c);
                    Target target = Target.lookup("" + Integer.parseInt(string3, 36));
                    if (target == null) continue;
                    SUPPORTED_JAVA_PLATFORM_VERSIONS.add(JDKPlatformProvider.targetNumericVersion(target));
                }
            }
        }
        catch (IOException | URISyntaxException | ProviderNotFoundException exception) {
            // empty catch block
        }
    }

    static class PlatformDescriptionImpl
    implements PlatformDescription {
        private final List<Closeable> closeables = new ArrayList<Closeable>();
        private final String sourceVersion;
        private final String ctSymVersion;

        PlatformDescriptionImpl(String string) {
            this.sourceVersion = string;
            this.ctSymVersion = StringUtils.toUpperCase(Integer.toString(Integer.parseInt(string), 36));
        }

        @Override
        public JavaFileManager getFileManager() {
            Context context = new Context();
            PrintWriter printWriter = new PrintWriter(System.err, true);
            context.put(Log.errKey, printWriter);
            CacheFSInfo.preRegister(context);
            JavacFileManager javacFileManager = new JavacFileManager(context, true, null){

                @Override
                public boolean hasLocation(JavaFileManager.Location location) {
                    return super.hasExplicitLocation(location);
                }

                @Override
                public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
                    if (kind == JavaFileObject.Kind.CLASS) {
                        String string2 = string.replace('.', '/');
                        JavaFileObject javaFileObject = (JavaFileObject)this.getFileForInput(location, "", string2 + ".sig");
                        if (javaFileObject == null) {
                            javaFileObject = (JavaFileObject)this.getFileForInput(location, "", string2 + ".class");
                        }
                        if (javaFileObject != null) {
                            return new SigJavaFileObject(javaFileObject);
                        }
                        return null;
                    }
                    return super.getJavaFileForInput(location, string, kind);
                }

                @Override
                public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, final Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
                    EnumSet<JavaFileObject.Kind> enumSet = EnumSet.copyOf(set);
                    enumSet.add(JavaFileObject.Kind.OTHER);
                    final Iterable<JavaFileObject> iterable = super.list(location, string, enumSet, bl);
                    return () -> new Iterator<JavaFileObject>(){
                        private final Iterator<JavaFileObject> original;
                        private JavaFileObject next;
                        {
                            this.original = iterable.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next == null) {
                                while (this.original.hasNext()) {
                                    JavaFileObject javaFileObject = this.original.next();
                                    if (javaFileObject.getKind() == JavaFileObject.Kind.OTHER && javaFileObject.getName().endsWith(".sig")) {
                                        this.next = new SigJavaFileObject(javaFileObject);
                                        break;
                                    }
                                    if (!set.contains((Object)javaFileObject.getKind())) continue;
                                    this.next = javaFileObject;
                                    break;
                                }
                            }
                            return this.next != null;
                        }

                        @Override
                        public JavaFileObject next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            JavaFileObject javaFileObject = this.next;
                            this.next = null;
                            return javaFileObject;
                        }
                    };
                }

                @Override
                public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
                    if (javaFileObject instanceof SigJavaFileObject) {
                        SigJavaFileObject sigJavaFileObject = (SigJavaFileObject)javaFileObject;
                        javaFileObject = sigJavaFileObject.getDelegate();
                    }
                    return super.inferBinaryName(location, javaFileObject);
                }
            };
            javacFileManager.handleOption(Option.MULTIRELEASE, this.sourceVersion);
            try {
                Arguments.CtSymRoot ctSymRoot = Arguments.ctSymRoot();
                this.closeables.add(ctSymRoot);
                Path path2 = ctSymRoot.root;
                boolean bl = Source.Feature.MODULES.allowedInSource(Source.lookup(this.sourceVersion), Target.lookup(this.sourceVersion));
                Path path3 = path2.resolve(this.ctSymVersion).resolve("system-modules");
                if (!bl) {
                    ArrayList<Path> arrayList = new ArrayList<Path>();
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);){
                        for (Path path4 : directoryStream) {
                            if (!path4.getFileName().toString().contains(this.ctSymVersion) || path4.getFileName().toString().contains("-")) continue;
                            DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(path4);
                            try {
                                for (Path path8 : directoryStream2) {
                                    arrayList.add(path8);
                                }
                            }
                            finally {
                                if (directoryStream2 == null) continue;
                                directoryStream2.close();
                            }
                        }
                    }
                    javacFileManager.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, arrayList);
                } else {
                    if (Files.isRegularFile(path3, new LinkOption[0])) {
                        javacFileManager.handleOption("--system", Arrays.asList("none").iterator());
                        Path path6 = FileSystems.getFileSystem(URI.create("jrt:/")).getPath("modules", new String[0]);
                        try (Stream<String> stream = Files.lines(path3, StandardCharsets.UTF_8);){
                            stream.map(string -> path6.resolve((String)string)).filter(path -> Files.exists(path, new LinkOption[0])).forEach(path -> PlatformDescriptionImpl.setModule(javacFileManager, path));
                        }
                    }
                    HashMap<String, List> hashMap = new HashMap<String, List>();
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2);){
                        Iterator<Path> object = directoryStream.iterator();
                        while (object.hasNext()) {
                            Path path5 = object.next();
                            if (!path5.getFileName().toString().contains(this.ctSymVersion) || path5.getFileName().toString().contains("-")) continue;
                            DirectoryStream<Path> directoryStream3 = Files.newDirectoryStream(path5);
                            try {
                                for (Path path6 : directoryStream3) {
                                    String string2 = path6.getFileName().toString();
                                    if (string2.endsWith("/")) {
                                        string2 = string2.substring(0, string2.length() - 1);
                                    }
                                    hashMap.computeIfAbsent(string2, string -> new ArrayList()).add(path6);
                                }
                            }
                            finally {
                                if (directoryStream3 == null) continue;
                                directoryStream3.close();
                            }
                        }
                    }
                    javacFileManager.handleOption("--system", Arrays.asList("none").iterator());
                    for (Map.Entry entry : hashMap.entrySet()) {
                        javacFileManager.setLocationForModule(StandardLocation.SYSTEM_MODULES, (String)entry.getKey(), (Collection)entry.getValue());
                    }
                }
                return javacFileManager;
            }
            catch (IOException | URISyntaxException exception) {
                throw new IllegalStateException(exception);
            }
        }

        private static void setModule(StandardJavaFileManager standardJavaFileManager, Path path) {
            try {
                standardJavaFileManager.setLocationForModule(StandardLocation.SYSTEM_MODULES, path.getFileName().toString(), Collections.singleton(path));
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public String getTargetVersion() {
            return this.sourceVersion;
        }

        @Override
        public List<PlatformDescription.PluginInfo<Processor>> getAnnotationProcessors() {
            return Collections.emptyList();
        }

        @Override
        public List<PlatformDescription.PluginInfo<Plugin>> getPlugins() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getAdditionalOptions() {
            return Collections.emptyList();
        }

        @Override
        public void close() throws IOException {
            for (Closeable closeable : this.closeables) {
                closeable.close();
            }
            this.closeables.clear();
        }

        private static class SigJavaFileObject
        extends ForwardingJavaFileObject<JavaFileObject> {
            public SigJavaFileObject(JavaFileObject javaFileObject) {
                super(javaFileObject);
            }

            @Override
            public JavaFileObject.Kind getKind() {
                return JavaFileObject.Kind.CLASS;
            }

            @Override
            public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
                return super.isNameCompatible(string + ".sig", JavaFileObject.Kind.OTHER);
            }

            public JavaFileObject getDelegate() {
                return (JavaFileObject)this.fileObject;
            }
        }
    }
}

