/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.tools.javac.util.StringUtils;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor14;
import javax.lang.model.util.SimpleElementVisitor14;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_19)
public class PrintingProcessor
extends AbstractProcessor {
    PrintWriter writer = new PrintWriter(System.out);

    public void setWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getRootElements()) {
            this.print(element);
        }
        return true;
    }

    void print(Element element) {
        ((PrintingElementVisitor)new PrintingElementVisitor(this.writer, this.processingEnv.getElementUtils()).visit(element)).flush();
    }

    public static class PrintingElementVisitor
    extends SimpleElementVisitor14<PrintingElementVisitor, Boolean> {
        int indentation;
        final PrintWriter writer;
        final Elements elementUtils;
        private static final String[] spaces = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              ", "                ", "                  ", "                    "};

        public PrintingElementVisitor(Writer writer, Elements elements) {
            this.writer = new PrintWriter(writer);
            this.elementUtils = elements;
            this.indentation = 0;
        }

        @Override
        protected PrintingElementVisitor defaultAction(Element element, Boolean bl) {
            if (bl != null && bl.booleanValue()) {
                this.writer.println();
            }
            this.printDocComment(element);
            this.printModifiers(element);
            return this;
        }

        @Override
        public PrintingElementVisitor visitRecordComponent(RecordComponentElement recordComponentElement, Boolean bl) {
            return this;
        }

        @Override
        public PrintingElementVisitor visitExecutable(ExecutableElement executableElement, Boolean bl) {
            ElementKind elementKind = executableElement.getKind();
            if (elementKind != ElementKind.STATIC_INIT && elementKind != ElementKind.INSTANCE_INIT) {
                Element element = executableElement.getEnclosingElement();
                if (elementKind == ElementKind.CONSTRUCTOR && element != null && NestingKind.ANONYMOUS == new SimpleElementVisitor14<NestingKind, Void>(){

                    @Override
                    public NestingKind visitType(TypeElement typeElement, Void void_) {
                        return typeElement.getNestingKind();
                    }
                }.visit(element)) {
                    return this;
                }
                this.defaultAction((Element)executableElement, true);
                this.printFormalTypeParameters(executableElement, true);
                switch (elementKind) {
                    case CONSTRUCTOR: {
                        this.writer.print(executableElement.getEnclosingElement().getSimpleName());
                        break;
                    }
                    case METHOD: {
                        this.writer.print(executableElement.getReturnType().toString());
                        this.writer.print(" ");
                        this.writer.print(executableElement.getSimpleName().toString());
                    }
                }
                this.writer.print("(");
                this.printParameters(executableElement);
                this.writer.print(")");
                AnnotationValue annotationValue = executableElement.getDefaultValue();
                if (annotationValue != null) {
                    this.writer.print(" default " + annotationValue);
                }
                this.printThrows(executableElement);
                this.writer.println(";");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitType(TypeElement typeElement, Boolean bl) {
            Object object2;
            ElementKind elementKind = typeElement.getKind();
            NestingKind nestingKind = typeElement.getNestingKind();
            if (NestingKind.ANONYMOUS == nestingKind) {
                List<ExecutableElement> object3;
                this.writer.print("new ");
                object2 = typeElement.getInterfaces();
                if (!object2.isEmpty()) {
                    this.writer.print(object2.get(0));
                } else {
                    this.writer.print(typeElement.getSuperclass());
                }
                this.writer.print("(");
                if (object2.isEmpty() && !(object3 = ElementFilter.constructorsIn(typeElement.getEnclosedElements())).isEmpty()) {
                    this.printParameters(object3.get(0));
                }
                this.writer.print(")");
            } else {
                TypeElement typeElement2;
                if (nestingKind == NestingKind.TOP_LEVEL && !(object2 = this.elementUtils.getPackageOf(typeElement)).isUnnamed()) {
                    this.writer.print("package " + object2.getQualifiedName() + ";\n");
                }
                this.defaultAction((Element)typeElement, true);
                switch (elementKind) {
                    case ANNOTATION_TYPE: {
                        this.writer.print("@interface");
                        break;
                    }
                    default: {
                        this.writer.print(StringUtils.toLowerCase(elementKind.toString()));
                    }
                }
                this.writer.print(" ");
                this.writer.print(typeElement.getSimpleName());
                this.printFormalTypeParameters(typeElement, false);
                if (elementKind == ElementKind.RECORD) {
                    this.writer.print("(");
                    this.writer.print(typeElement.getRecordComponents().stream().map(recordComponentElement -> this.annotationsToString((Element)recordComponentElement) + recordComponentElement.asType().toString() + " " + recordComponentElement.getSimpleName()).collect(Collectors.joining(", ")));
                    this.writer.print(")");
                }
                if (elementKind == ElementKind.CLASS && (object2 = typeElement.getSuperclass()).getKind() != TypeKind.NONE && (typeElement2 = (TypeElement)((DeclaredType)object2).asElement()).getSuperclass().getKind() != TypeKind.NONE) {
                    this.writer.print(" extends " + object2);
                }
                this.printInterfaces(typeElement);
                this.printPermittedSubclasses(typeElement);
            }
            this.writer.println(" {");
            ++this.indentation;
            if (elementKind == ElementKind.ENUM) {
                Element element2;
                object2 = new ArrayList<Element>(typeElement.getEnclosedElements());
                ArrayList<Element> arrayList = new ArrayList<Element>();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    element2 = (Element)iterator.next();
                    if (element2.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    arrayList.add(element2);
                }
                if (!arrayList.isEmpty()) {
                    int n;
                    for (n = 0; n < arrayList.size() - 1; ++n) {
                        this.visit((Element)arrayList.get(n), true);
                        this.writer.print(",");
                    }
                    this.visit((Element)arrayList.get(n), true);
                    this.writer.println(";\n");
                    object2.removeAll(arrayList);
                }
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    element2 = (Element)iterator.next();
                    this.visit(element2);
                }
            } else {
                for (Element element3 : elementKind != ElementKind.RECORD ? typeElement.getEnclosedElements() : typeElement.getEnclosedElements().stream().filter(element -> this.elementUtils.getOrigin((Element)element) == Elements.Origin.EXPLICIT).collect(Collectors.toList())) {
                    this.visit(element3);
                }
            }
            --this.indentation;
            this.indent();
            this.writer.println("}");
            return this;
        }

        @Override
        public PrintingElementVisitor visitVariable(VariableElement variableElement, Boolean bl) {
            ElementKind elementKind = variableElement.getKind();
            this.defaultAction((Element)variableElement, bl);
            if (elementKind == ElementKind.ENUM_CONSTANT) {
                this.writer.print(variableElement.getSimpleName());
            } else {
                this.writer.print(variableElement.asType().toString() + " " + variableElement.getSimpleName());
                Object object = variableElement.getConstantValue();
                if (object != null) {
                    this.writer.print(" = ");
                    this.writer.print(this.elementUtils.getConstantExpression(object));
                }
                this.writer.println(";");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitTypeParameter(TypeParameterElement typeParameterElement, Boolean bl) {
            this.writer.print(typeParameterElement.getSimpleName());
            return this;
        }

        @Override
        public PrintingElementVisitor visitPackage(PackageElement packageElement, Boolean bl) {
            this.defaultAction((Element)packageElement, false);
            if (!packageElement.isUnnamed()) {
                this.writer.println("package " + packageElement.getQualifiedName() + ";");
            } else {
                this.writer.println("// Unnamed package");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitModule(ModuleElement moduleElement, Boolean bl) {
            this.defaultAction((Element)moduleElement, false);
            if (!moduleElement.isUnnamed()) {
                if (moduleElement.isOpen()) {
                    this.writer.print("open ");
                }
                this.writer.println("module " + moduleElement.getQualifiedName() + " {");
                ++this.indentation;
                for (ModuleElement.Directive directive : moduleElement.getDirectives()) {
                    this.printDirective(directive);
                }
                --this.indentation;
                this.writer.println("}");
            } else {
                this.writer.println("// Unnamed module");
            }
            return this;
        }

        private void printDirective(ModuleElement.Directive directive) {
            this.indent();
            new PrintDirective(this.writer).visit(directive);
            this.writer.println(";");
        }

        public void flush() {
            this.writer.flush();
        }

        private void printDocComment(Element element) {
            String string = this.elementUtils.getDocComment(element);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
                this.indent();
                this.writer.println("/**");
                while (stringTokenizer.hasMoreTokens()) {
                    this.indent();
                    this.writer.print(" *");
                    this.writer.println(stringTokenizer.nextToken());
                }
                this.indent();
                this.writer.println(" */");
            }
        }

        private void printModifiers(Element element) {
            ElementKind elementKind = element.getKind();
            if (elementKind == ElementKind.PARAMETER || elementKind == ElementKind.RECORD_COMPONENT) {
                this.writer.print(this.annotationsToString(element));
            } else {
                this.printAnnotations(element);
                this.indent();
            }
            if (elementKind == ElementKind.ENUM_CONSTANT || elementKind == ElementKind.RECORD_COMPONENT) {
                return;
            }
            LinkedHashSet<Modifier> linkedHashSet = new LinkedHashSet<Modifier>();
            linkedHashSet.addAll(element.getModifiers());
            switch (elementKind) {
                case ANNOTATION_TYPE: 
                case INTERFACE: {
                    linkedHashSet.remove((Object)Modifier.ABSTRACT);
                    break;
                }
                case ENUM: {
                    linkedHashSet.remove((Object)Modifier.FINAL);
                    linkedHashSet.remove((Object)Modifier.ABSTRACT);
                    linkedHashSet.remove((Object)Modifier.SEALED);
                    break;
                }
                case RECORD: {
                    linkedHashSet.remove((Object)Modifier.FINAL);
                    break;
                }
                case METHOD: 
                case FIELD: {
                    Element element2 = element.getEnclosingElement();
                    if (element2 == null || !element2.getKind().isInterface()) break;
                    linkedHashSet.remove((Object)Modifier.PUBLIC);
                    linkedHashSet.remove((Object)Modifier.ABSTRACT);
                    linkedHashSet.remove((Object)Modifier.STATIC);
                    linkedHashSet.remove((Object)Modifier.FINAL);
                }
            }
            if (!linkedHashSet.isEmpty()) {
                this.writer.print(linkedHashSet.stream().map(Modifier::toString).collect(Collectors.joining(" ", "", " ")));
            }
        }

        private void printFormalTypeParameters(Parameterizable parameterizable, boolean bl) {
            List<? extends TypeParameterElement> list = parameterizable.getTypeParameters();
            if (!list.isEmpty()) {
                this.writer.print(list.stream().map(typeParameterElement -> this.annotationsToString((Element)typeParameterElement) + typeParameterElement.toString()).collect(Collectors.joining(", ", "<", ">")));
                if (bl) {
                    this.writer.print(" ");
                }
            }
        }

        private String annotationsToString(Element element) {
            List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
            return list.isEmpty() ? "" : list.stream().map((Function<AnnotationMirror, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljavax/lang/model/element/AnnotationMirror;)Ljava/lang/String;)()).collect(Collectors.joining(" ", "", " "));
        }

        private void printAnnotations(Element element) {
            List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                if (this.printedContainerAnnotation(element, annotationMirror)) continue;
                this.indent();
                this.writer.println(annotationMirror);
            }
        }

        private boolean printedContainerAnnotation(Element element, AnnotationMirror annotationMirror) {
            Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> set;
            if (this.elementUtils.getOrigin(element, annotationMirror) == Elements.Origin.MANDATED && (set = annotationMirror.getElementValues().entrySet()).size() == 1) {
                List<ExecutableElement> list;
                DeclaredType declaredType = annotationMirror.getAnnotationType();
                Element element2 = declaredType.asElement();
                Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry = set.iterator().next();
                AnnotationValue annotationValue = entry.getValue();
                if (element2.getKind() == ElementKind.ANNOTATION_TYPE && (list = ElementFilter.methodsIn(element2.getEnclosedElements())).size() == 1) {
                    ExecutableElement executableElement = list.get(0);
                    TypeMirror typeMirror = executableElement.getReturnType();
                    if ("value".equals(executableElement.getSimpleName().toString()) && typeMirror.getKind() == TypeKind.ARRAY) {
                        return (Boolean)new SimpleAnnotationValueVisitor14<Boolean, Void>(Boolean.valueOf(false)){

                            @Override
                            public Boolean visitArray(List<? extends AnnotationValue> list, Void void_) {
                                if (list.size() < 2) {
                                    return false;
                                }
                                for (AnnotationValue annotationValue : list) {
                                    this.indent();
                                    writer.println(annotationValue.toString());
                                }
                                return true;
                            }
                        }.visit(annotationValue);
                    }
                }
            }
            return false;
        }

        private void printParameters(ExecutableElement executableElement) {
            List<? extends VariableElement> list = executableElement.getParameters();
            int n = list.size();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    for (VariableElement variableElement : list) {
                        this.printModifiers(variableElement);
                        if (executableElement.isVarArgs()) {
                            TypeMirror typeMirror = variableElement.asType();
                            if (typeMirror.getKind() != TypeKind.ARRAY) {
                                throw new AssertionError((Object)("Var-args parameter is not an array type: " + typeMirror));
                            }
                            this.writer.print(((ArrayType)ArrayType.class.cast(typeMirror)).getComponentType());
                            this.writer.print("...");
                        } else {
                            this.writer.print(variableElement.asType());
                        }
                        this.writer.print(" " + variableElement.getSimpleName());
                    }
                    break;
                }
                default: {
                    int n2 = 1;
                    for (VariableElement variableElement : list) {
                        if (n2 == 2) {
                            ++this.indentation;
                        }
                        if (n2 > 1) {
                            this.indent();
                        }
                        this.printModifiers(variableElement);
                        if (n2 == n && executableElement.isVarArgs()) {
                            TypeMirror typeMirror = variableElement.asType();
                            if (typeMirror.getKind() != TypeKind.ARRAY) {
                                throw new AssertionError((Object)("Var-args parameter is not an array type: " + typeMirror));
                            }
                            this.writer.print(((ArrayType)ArrayType.class.cast(typeMirror)).getComponentType());
                            this.writer.print("...");
                        } else {
                            this.writer.print(variableElement.asType());
                        }
                        this.writer.print(" " + variableElement.getSimpleName());
                        if (n2 < n) {
                            this.writer.println(",");
                        }
                        ++n2;
                    }
                    if (list.size() < 2) break;
                    --this.indentation;
                }
            }
        }

        private void printInterfaces(TypeElement typeElement) {
            List<? extends TypeMirror> list;
            ElementKind elementKind = typeElement.getKind();
            if (elementKind != ElementKind.ANNOTATION_TYPE && !(list = typeElement.getInterfaces()).isEmpty()) {
                this.writer.print(elementKind.isClass() ? " implements " : " extends ");
                this.writer.print(list.stream().map(TypeMirror::toString).collect(Collectors.joining(", ")));
            }
        }

        private void printPermittedSubclasses(TypeElement typeElement) {
            List<? extends TypeMirror> list = typeElement.getPermittedSubclasses();
            if (!list.isEmpty()) {
                this.writer.print(" permits ");
                this.writer.print(list.stream().map(typeMirror -> typeMirror.toString()).collect(Collectors.joining(", ")));
            }
        }

        private void printThrows(ExecutableElement executableElement) {
            List<? extends TypeMirror> list = executableElement.getThrownTypes();
            int n = list.size();
            if (n != 0) {
                this.writer.print(" throws");
                int n2 = 1;
                for (TypeMirror typeMirror : list) {
                    if (n2 == 1) {
                        this.writer.print(" ");
                    }
                    if (n2 == 2) {
                        ++this.indentation;
                    }
                    if (n2 >= 2) {
                        this.indent();
                    }
                    this.writer.print(typeMirror);
                    if (n2 != n) {
                        this.writer.println(", ");
                    }
                    ++n2;
                }
                if (n >= 2) {
                    --this.indentation;
                }
            }
        }

        private void indent() {
            int n = this.indentation;
            if (n < 0) {
                return;
            }
            int n2 = spaces.length - 1;
            while (n > n2) {
                this.writer.print(spaces[n2]);
                n -= n2;
            }
            this.writer.print(spaces[n]);
        }

        private static class PrintDirective
        implements ModuleElement.DirectiveVisitor<Void, Void> {
            private final PrintWriter writer;

            PrintDirective(PrintWriter printWriter) {
                this.writer = printWriter;
            }

            @Override
            public Void visitExports(ModuleElement.ExportsDirective exportsDirective, Void void_) {
                this.writer.print("exports ");
                this.writer.print(exportsDirective.getPackage().getQualifiedName());
                this.printModuleList(exportsDirective.getTargetModules());
                return null;
            }

            @Override
            public Void visitOpens(ModuleElement.OpensDirective opensDirective, Void void_) {
                this.writer.print("opens ");
                this.writer.print(opensDirective.getPackage().getQualifiedName());
                this.printModuleList(opensDirective.getTargetModules());
                return null;
            }

            @Override
            public Void visitProvides(ModuleElement.ProvidesDirective providesDirective, Void void_) {
                this.writer.print("provides ");
                this.writer.print(providesDirective.getService().getQualifiedName());
                this.writer.print(" with ");
                this.printNameableList(providesDirective.getImplementations());
                return null;
            }

            @Override
            public Void visitRequires(ModuleElement.RequiresDirective requiresDirective, Void void_) {
                this.writer.print("requires ");
                if (requiresDirective.isStatic()) {
                    this.writer.print("static ");
                }
                if (requiresDirective.isTransitive()) {
                    this.writer.print("transitive ");
                }
                this.writer.print(requiresDirective.getDependency().getQualifiedName());
                return null;
            }

            @Override
            public Void visitUses(ModuleElement.UsesDirective usesDirective, Void void_) {
                this.writer.print("uses ");
                this.writer.print(usesDirective.getService().getQualifiedName());
                return null;
            }

            private void printModuleList(List<? extends ModuleElement> list) {
                if (list != null) {
                    this.writer.print(" to ");
                    this.printNameableList(list);
                }
            }

            private void printNameableList(List<? extends QualifiedNameable> list) {
                this.writer.print(list.stream().map(QualifiedNameable::getQualifiedName).collect(Collectors.joining(", ")));
            }
        }
    }
}

