/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.function.ToIntFunction;
import javax.tools.JavaFileObject;

public class TreeInfo {
    public static final int notExpression = -1;
    public static final int noPrec = 0;
    public static final int assignPrec = 1;
    public static final int assignopPrec = 2;
    public static final int condPrec = 3;
    public static final int orPrec = 4;
    public static final int andPrec = 5;
    public static final int bitorPrec = 6;
    public static final int bitxorPrec = 7;
    public static final int bitandPrec = 8;
    public static final int eqPrec = 9;
    public static final int ordPrec = 10;
    public static final int shiftPrec = 11;
    public static final int addPrec = 12;
    public static final int mulPrec = 13;
    public static final int prefixPrec = 14;
    public static final int postfixPrec = 15;
    public static final int precCount = 16;

    public static List<JCTree.JCExpression> args(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case APPLY: {
                return ((JCTree.JCMethodInvocation)jCTree).args;
            }
            case NEWCLASS: {
                return ((JCTree.JCNewClass)jCTree).args;
            }
        }
        return null;
    }

    public static boolean isConstructor(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.METHODDEF)) {
            Name name = ((JCTree.JCMethodDecl)jCTree).name;
            return name == name.table.names.init;
        }
        return false;
    }

    public static boolean isCanonicalConstructor(JCTree jCTree) {
        return TreeInfo.isConstructor(jCTree) && (((JCTree.JCMethodDecl)jCTree).sym.flags_field & 0x2000000000000000L) != 0L;
    }

    public static boolean isCompactConstructor(JCTree jCTree) {
        return TreeInfo.isCanonicalConstructor(jCTree) && (((JCTree.JCMethodDecl)jCTree).sym.flags_field & 0x8000000000000L) != 0L;
    }

    public static boolean isReceiverParam(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.VARDEF)) {
            return ((JCTree.JCVariableDecl)jCTree).nameexpr != null;
        }
        return false;
    }

    public static boolean hasConstructors(List<JCTree> list) {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            if (TreeInfo.isConstructor((JCTree)list2.head)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public static Name getConstructorInvocationName(List<? extends JCTree> list, Names names) {
        for (JCTree jCTree : list) {
            if (!jCTree.hasTag(JCTree.Tag.EXEC)) continue;
            JCTree.JCExpressionStatement jCExpressionStatement = (JCTree.JCExpressionStatement)jCTree;
            if (!jCExpressionStatement.expr.hasTag(JCTree.Tag.APPLY)) continue;
            JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)jCExpressionStatement.expr;
            Name name = TreeInfo.name(jCMethodInvocation.meth);
            if (name != names._this && name != names._super) continue;
            return name;
        }
        return names.empty;
    }

    public static boolean isMultiCatch(JCTree.JCCatch jCCatch) {
        return jCCatch.param.vartype.hasTag(JCTree.Tag.TYPEUNION);
    }

    public static boolean isSyntheticInit(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.EXEC)) {
            JCTree.JCExpressionStatement jCExpressionStatement = (JCTree.JCExpressionStatement)jCTree;
            if (jCExpressionStatement.expr.hasTag(JCTree.Tag.ASSIGN)) {
                JCTree.JCAssign jCAssign = (JCTree.JCAssign)jCExpressionStatement.expr;
                if (jCAssign.lhs.hasTag(JCTree.Tag.SELECT)) {
                    Name name;
                    JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCAssign.lhs;
                    if (jCFieldAccess.sym != null && (jCFieldAccess.sym.flags() & 0x1000L) != 0L && (name = TreeInfo.name(jCFieldAccess.selected)) != null && name == name.table.names._this) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Name calledMethodName(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.EXEC)) {
            JCTree.JCExpressionStatement jCExpressionStatement = (JCTree.JCExpressionStatement)jCTree;
            if (jCExpressionStatement.expr.hasTag(JCTree.Tag.APPLY)) {
                Name name = TreeInfo.name(((JCTree.JCMethodInvocation)jCExpressionStatement.expr).meth);
                return name;
            }
        }
        return null;
    }

    public static boolean isSelfCall(JCTree jCTree) {
        Name name = TreeInfo.calledMethodName(jCTree);
        if (name != null) {
            Names names = name.table.names;
            return name == names._this || name == names._super;
        }
        return false;
    }

    public static boolean isThisQualifier(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case PARENS: {
                return TreeInfo.isThisQualifier(TreeInfo.skipParens(jCTree));
            }
            case IDENT: {
                JCTree.JCIdent jCIdent = (JCTree.JCIdent)jCTree;
                return jCIdent.name == jCIdent.name.table.names._this;
            }
        }
        return false;
    }

    public static boolean isIdentOrThisDotIdent(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case PARENS: {
                return TreeInfo.isIdentOrThisDotIdent(TreeInfo.skipParens(jCTree));
            }
            case IDENT: {
                return true;
            }
            case SELECT: {
                return TreeInfo.isThisQualifier(((JCTree.JCFieldAccess)jCTree).selected);
            }
        }
        return false;
    }

    public static boolean isSuperCall(JCTree jCTree) {
        Name name = TreeInfo.calledMethodName(jCTree);
        if (name != null) {
            Names names = name.table.names;
            return name == names._super;
        }
        return false;
    }

    public static List<JCTree.JCVariableDecl> recordFields(JCTree.JCClassDecl jCClassDecl) {
        return jCClassDecl.defs.stream().filter(jCTree -> jCTree.hasTag(JCTree.Tag.VARDEF)).map(jCTree -> (JCTree.JCVariableDecl)jCTree).filter(jCVariableDecl -> (jCVariableDecl.getModifiers().flags & 0x2000000000000000L) == 0x2000000000000000L).collect(List.collector());
    }

    public static List<Type> recordFieldTypes(JCTree.JCClassDecl jCClassDecl) {
        return TreeInfo.recordFields(jCClassDecl).stream().map(jCVariableDecl -> jCVariableDecl.type).collect(List.collector());
    }

    public static boolean isInitialConstructor(JCTree jCTree) {
        JCTree.JCMethodInvocation jCMethodInvocation = TreeInfo.firstConstructorCall(jCTree);
        if (jCMethodInvocation == null) {
            return false;
        }
        Name name = TreeInfo.name(jCMethodInvocation.meth);
        return name == null || name != name.table.names._this;
    }

    public static JCTree.JCMethodInvocation firstConstructorCall(JCTree jCTree) {
        if (!jCTree.hasTag(JCTree.Tag.METHODDEF)) {
            return null;
        }
        JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
        Names names = jCMethodDecl.name.table.names;
        if (jCMethodDecl.name != names.init) {
            return null;
        }
        if (jCMethodDecl.body == null) {
            return null;
        }
        List<JCTree.JCStatement> list = jCMethodDecl.body.stats;
        while (list.nonEmpty() && TreeInfo.isSyntheticInit((JCTree)list.head)) {
            list = list.tail;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (!((JCTree.JCStatement)list.head).hasTag(JCTree.Tag.EXEC)) {
            return null;
        }
        JCTree.JCExpressionStatement jCExpressionStatement = (JCTree.JCExpressionStatement)list.head;
        if (!jCExpressionStatement.expr.hasTag(JCTree.Tag.APPLY)) {
            return null;
        }
        return (JCTree.JCMethodInvocation)jCExpressionStatement.expr;
    }

    public static boolean isDiamond(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case TYPEAPPLY: {
                return ((List)((JCTree.JCTypeApply)jCTree).getTypeArguments()).isEmpty();
            }
            case NEWCLASS: {
                return TreeInfo.isDiamond(((JCTree.JCNewClass)jCTree).clazz);
            }
            case ANNOTATED_TYPE: {
                return TreeInfo.isDiamond(((JCTree.JCAnnotatedType)jCTree).underlyingType);
            }
        }
        return false;
    }

    public static boolean isEnumInit(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case VARDEF: {
                return (((JCTree.JCVariableDecl)jCTree).mods.flags & 0x4000L) != 0L;
            }
        }
        return false;
    }

    public static void setPolyKind(JCTree jCTree, JCTree.JCPolyExpression.PolyKind polyKind) {
        switch (jCTree.getTag()) {
            case APPLY: {
                ((JCTree.JCMethodInvocation)jCTree).polyKind = polyKind;
                break;
            }
            case NEWCLASS: {
                ((JCTree.JCNewClass)jCTree).polyKind = polyKind;
                break;
            }
            case REFERENCE: {
                ((JCTree.JCMemberReference)jCTree).refPolyKind = polyKind;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected tree: " + jCTree));
            }
        }
    }

    public static void setVarargsElement(JCTree jCTree, Type type) {
        switch (jCTree.getTag()) {
            case APPLY: {
                ((JCTree.JCMethodInvocation)jCTree).varargsElement = type;
                break;
            }
            case NEWCLASS: {
                ((JCTree.JCNewClass)jCTree).varargsElement = type;
                break;
            }
            case REFERENCE: {
                ((JCTree.JCMemberReference)jCTree).varargsElement = type;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected tree: " + jCTree));
            }
        }
    }

    public static boolean isExpressionStatement(JCTree.JCExpression jCExpression) {
        switch (jCExpression.getTag()) {
            case APPLY: 
            case NEWCLASS: 
            case PREINC: 
            case PREDEC: 
            case POSTINC: 
            case POSTDEC: 
            case ASSIGN: 
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: 
            case ERRONEOUS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStatement(JCTree jCTree) {
        return jCTree instanceof JCTree.JCStatement && !jCTree.hasTag(JCTree.Tag.CLASSDEF) && !jCTree.hasTag(JCTree.Tag.BLOCK) && !jCTree.hasTag(JCTree.Tag.METHODDEF);
    }

    public static boolean isStaticSelector(JCTree jCTree, Names names) {
        if (jCTree == null) {
            return false;
        }
        switch (jCTree.getTag()) {
            case IDENT: {
                JCTree.JCIdent jCIdent = (JCTree.JCIdent)jCTree;
                return jCIdent.name != names._this && jCIdent.name != names._super && TreeInfo.isStaticSym(jCTree);
            }
            case SELECT: {
                return TreeInfo.isStaticSym(jCTree) && TreeInfo.isStaticSelector(((JCTree.JCFieldAccess)jCTree).selected, names);
            }
            case TYPEAPPLY: 
            case TYPEARRAY: {
                return true;
            }
            case ANNOTATED_TYPE: {
                return TreeInfo.isStaticSelector(((JCTree.JCAnnotatedType)jCTree).underlyingType, names);
            }
        }
        return false;
    }

    private static boolean isStaticSym(JCTree jCTree) {
        Symbol symbol = TreeInfo.symbol(jCTree);
        return symbol.kind == Kinds.Kind.TYP || symbol.kind == Kinds.Kind.PCK;
    }

    public static boolean isNull(JCTree jCTree) {
        if (!jCTree.hasTag(JCTree.Tag.LITERAL)) {
            return false;
        }
        JCTree.JCLiteral jCLiteral = (JCTree.JCLiteral)jCTree;
        return jCLiteral.typetag == TypeTag.BOT;
    }

    public static boolean isInAnnotation(Env<?> env, JCTree jCTree) {
        TreePath treePath = TreePath.getPath(env.toplevel, (Tree)jCTree);
        if (treePath != null) {
            for (Tree tree : treePath) {
                if (tree.getKind() != Tree.Kind.ANNOTATION) continue;
                return true;
            }
        }
        return false;
    }

    public static String getCommentText(Env<?> env, JCTree jCTree) {
        DocCommentTable docCommentTable = jCTree.hasTag(JCTree.Tag.TOPLEVEL) ? ((JCTree.JCCompilationUnit)jCTree).docComments : env.toplevel.docComments;
        return docCommentTable == null ? null : docCommentTable.getCommentText(jCTree);
    }

    public static DCTree.DCDocComment getCommentTree(Env<?> env, JCTree jCTree) {
        DocCommentTable docCommentTable = jCTree.hasTag(JCTree.Tag.TOPLEVEL) ? ((JCTree.JCCompilationUnit)jCTree).docComments : env.toplevel.docComments;
        return docCommentTable == null ? null : docCommentTable.getCommentTree(jCTree);
    }

    public static int firstStatPos(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.BLOCK) && ((JCTree.JCBlock)jCTree).stats.nonEmpty()) {
            return ((JCTree.JCStatement)((JCTree.JCBlock)jCTree).stats.head).pos;
        }
        return jCTree.pos;
    }

    public static int endPos(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.BLOCK) && ((JCTree.JCBlock)jCTree).endpos != -1) {
            return ((JCTree.JCBlock)jCTree).endpos;
        }
        if (jCTree.hasTag(JCTree.Tag.SYNCHRONIZED)) {
            return TreeInfo.endPos(((JCTree.JCSynchronized)jCTree).body);
        }
        if (jCTree.hasTag(JCTree.Tag.TRY)) {
            JCTree.JCTry jCTry = (JCTree.JCTry)jCTree;
            return TreeInfo.endPos(jCTry.finalizer != null ? jCTry.finalizer : (jCTry.catchers.nonEmpty() ? jCTry.catchers.last().body : jCTry.body));
        }
        if (jCTree.hasTag(JCTree.Tag.SWITCH) && ((JCTree.JCSwitch)jCTree).endpos != -1) {
            return ((JCTree.JCSwitch)jCTree).endpos;
        }
        if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION) && ((JCTree.JCSwitchExpression)jCTree).endpos != -1) {
            return ((JCTree.JCSwitchExpression)jCTree).endpos;
        }
        return jCTree.pos;
    }

    public static int getStartPos(JCTree jCTree) {
        if (jCTree == null) {
            return -1;
        }
        switch (jCTree.getTag()) {
            case MODULEDEF: {
                JCTree.JCModuleDecl jCModuleDecl = (JCTree.JCModuleDecl)jCTree;
                return jCModuleDecl.mods.annotations.isEmpty() ? jCModuleDecl.pos : ((JCTree.JCAnnotation)jCModuleDecl.mods.annotations.head).pos;
            }
            case PACKAGEDEF: {
                JCTree.JCPackageDecl jCPackageDecl = (JCTree.JCPackageDecl)jCTree;
                return jCPackageDecl.annotations.isEmpty() ? jCPackageDecl.pos : ((JCTree.JCAnnotation)jCPackageDecl.annotations.head).pos;
            }
            case APPLY: {
                return TreeInfo.getStartPos(((JCTree.JCMethodInvocation)jCTree).meth);
            }
            case ASSIGN: {
                return TreeInfo.getStartPos(((JCTree.JCAssign)jCTree).lhs);
            }
            case POSTINC: 
            case POSTDEC: 
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: 
            case OR: 
            case AND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case EQ: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case SL: 
            case SR: 
            case USR: 
            case PLUS: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                return TreeInfo.getStartPos(((JCTree.JCOperatorExpression)jCTree).getOperand(JCTree.JCOperatorExpression.OperandPos.LEFT));
            }
            case CLASSDEF: {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
                if (jCClassDecl.mods.pos == -1) break;
                return jCClassDecl.mods.pos;
            }
            case CONDEXPR: {
                return TreeInfo.getStartPos(((JCTree.JCConditional)jCTree).cond);
            }
            case EXEC: {
                return TreeInfo.getStartPos(((JCTree.JCExpressionStatement)jCTree).expr);
            }
            case INDEXED: {
                return TreeInfo.getStartPos(((JCTree.JCArrayAccess)jCTree).indexed);
            }
            case METHODDEF: {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                if (jCMethodDecl.mods.pos != -1) {
                    return jCMethodDecl.mods.pos;
                }
                if (jCMethodDecl.typarams.nonEmpty()) {
                    return TreeInfo.getStartPos((JCTree)jCMethodDecl.typarams.head);
                }
                return jCMethodDecl.restype == null ? jCMethodDecl.pos : TreeInfo.getStartPos(jCMethodDecl.restype);
            }
            case SELECT: {
                return TreeInfo.getStartPos(((JCTree.JCFieldAccess)jCTree).selected);
            }
            case TYPEAPPLY: {
                return TreeInfo.getStartPos(((JCTree.JCTypeApply)jCTree).clazz);
            }
            case TYPEARRAY: {
                return TreeInfo.getStartPos(((JCTree.JCArrayTypeTree)jCTree).elemtype);
            }
            case TYPETEST: {
                return TreeInfo.getStartPos(((JCTree.JCInstanceOf)jCTree).expr);
            }
            case ANNOTATED_TYPE: {
                JCTree.JCAnnotatedType jCAnnotatedType = (JCTree.JCAnnotatedType)jCTree;
                if (jCAnnotatedType.annotations.nonEmpty()) {
                    if (jCAnnotatedType.underlyingType.hasTag(JCTree.Tag.TYPEARRAY) || jCAnnotatedType.underlyingType.hasTag(JCTree.Tag.SELECT)) {
                        return TreeInfo.getStartPos(jCAnnotatedType.underlyingType);
                    }
                    return TreeInfo.getStartPos((JCTree)jCAnnotatedType.annotations.head);
                }
                return TreeInfo.getStartPos(jCAnnotatedType.underlyingType);
            }
            case NEWCLASS: {
                JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)jCTree;
                if (jCNewClass.encl == null) break;
                return TreeInfo.getStartPos(jCNewClass.encl);
            }
            case VARDEF: {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)jCTree;
                if (jCVariableDecl.startPos != -1) {
                    return jCVariableDecl.startPos;
                }
                if (jCVariableDecl.mods.pos != -1) {
                    return jCVariableDecl.mods.pos;
                }
                if (jCVariableDecl.vartype == null || jCVariableDecl.vartype.pos == -1) {
                    return jCVariableDecl.pos;
                }
                return TreeInfo.getStartPos(jCVariableDecl.vartype);
            }
            case BINDINGPATTERN: {
                JCTree.JCBindingPattern jCBindingPattern = (JCTree.JCBindingPattern)jCTree;
                return TreeInfo.getStartPos(jCBindingPattern.var);
            }
            case ERRONEOUS: {
                int n;
                JCTree.JCErroneous jCErroneous = (JCTree.JCErroneous)jCTree;
                if (jCErroneous.errs == null || !jCErroneous.errs.nonEmpty() || (n = TreeInfo.getStartPos((JCTree)jCErroneous.errs.head)) == -1) break;
                return n;
            }
        }
        return jCTree.pos;
    }

    public static int getEndPos(JCTree jCTree, EndPosTable endPosTable) {
        if (jCTree == null) {
            return -1;
        }
        if (endPosTable == null) {
            return TreeInfo.endPos(jCTree);
        }
        int n = endPosTable.getEndPos(jCTree);
        if (n != -1) {
            return n;
        }
        switch (jCTree.getTag()) {
            case PREINC: 
            case PREDEC: 
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: 
            case OR: 
            case AND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case EQ: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case SL: 
            case SR: 
            case USR: 
            case PLUS: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: 
            case POS: 
            case NEG: 
            case NOT: 
            case COMPL: {
                return TreeInfo.getEndPos(((JCTree.JCOperatorExpression)jCTree).getOperand(JCTree.JCOperatorExpression.OperandPos.RIGHT), endPosTable);
            }
            case CASE: {
                return TreeInfo.getEndPos(((JCTree.JCCase)jCTree).stats.last(), endPosTable);
            }
            case CATCH: {
                return TreeInfo.getEndPos(((JCTree.JCCatch)jCTree).body, endPosTable);
            }
            case CONDEXPR: {
                return TreeInfo.getEndPos(((JCTree.JCConditional)jCTree).falsepart, endPosTable);
            }
            case FORLOOP: {
                return TreeInfo.getEndPos(((JCTree.JCForLoop)jCTree).body, endPosTable);
            }
            case FOREACHLOOP: {
                return TreeInfo.getEndPos(((JCTree.JCEnhancedForLoop)jCTree).body, endPosTable);
            }
            case IF: {
                JCTree.JCIf jCIf = (JCTree.JCIf)jCTree;
                if (jCIf.elsepart == null) {
                    return TreeInfo.getEndPos(jCIf.thenpart, endPosTable);
                }
                return TreeInfo.getEndPos(jCIf.elsepart, endPosTable);
            }
            case LABELLED: {
                return TreeInfo.getEndPos(((JCTree.JCLabeledStatement)jCTree).body, endPosTable);
            }
            case MODIFIERS: {
                return TreeInfo.getEndPos(((JCTree.JCModifiers)jCTree).annotations.last(), endPosTable);
            }
            case SYNCHRONIZED: {
                return TreeInfo.getEndPos(((JCTree.JCSynchronized)jCTree).body, endPosTable);
            }
            case TOPLEVEL: {
                return TreeInfo.getEndPos(((JCTree.JCCompilationUnit)jCTree).defs.last(), endPosTable);
            }
            case TRY: {
                JCTree.JCTry jCTry = (JCTree.JCTry)jCTree;
                if (jCTry.finalizer != null) {
                    return TreeInfo.getEndPos(jCTry.finalizer, endPosTable);
                }
                if (!jCTry.catchers.isEmpty()) {
                    return TreeInfo.getEndPos(jCTry.catchers.last(), endPosTable);
                }
                return TreeInfo.getEndPos(jCTry.body, endPosTable);
            }
            case WILDCARD: {
                return TreeInfo.getEndPos(((JCTree.JCWildcard)jCTree).inner, endPosTable);
            }
            case TYPECAST: {
                return TreeInfo.getEndPos(((JCTree.JCTypeCast)jCTree).expr, endPosTable);
            }
            case TYPETEST: {
                return TreeInfo.getEndPos(((JCTree.JCInstanceOf)jCTree).pattern, endPosTable);
            }
            case WHILELOOP: {
                return TreeInfo.getEndPos(((JCTree.JCWhileLoop)jCTree).body, endPosTable);
            }
            case ANNOTATED_TYPE: {
                return TreeInfo.getEndPos(((JCTree.JCAnnotatedType)jCTree).underlyingType, endPosTable);
            }
            case PARENTHESIZEDPATTERN: {
                JCTree.JCParenthesizedPattern jCParenthesizedPattern = (JCTree.JCParenthesizedPattern)jCTree;
                return TreeInfo.getEndPos(jCParenthesizedPattern.pattern, endPosTable);
            }
            case ERRONEOUS: {
                JCTree.JCErroneous jCErroneous = (JCTree.JCErroneous)jCTree;
                if (jCErroneous.errs == null || !jCErroneous.errs.nonEmpty()) break;
                return TreeInfo.getEndPos(jCErroneous.errs.last(), endPosTable);
            }
        }
        return -1;
    }

    public static JCDiagnostic.DiagnosticPosition diagEndPos(final JCTree jCTree) {
        final int n = TreeInfo.endPos(jCTree);
        return new JCDiagnostic.DiagnosticPosition(){

            @Override
            public JCTree getTree() {
                return jCTree;
            }

            @Override
            public int getStartPosition() {
                return TreeInfo.getStartPos(jCTree);
            }

            @Override
            public int getPreferredPosition() {
                return n;
            }

            @Override
            public int getEndPosition(EndPosTable endPosTable) {
                return TreeInfo.getEndPos(jCTree, endPosTable);
            }
        };
    }

    public static int finalizerPos(JCTree jCTree, PosKind posKind) {
        if (jCTree.hasTag(JCTree.Tag.TRY)) {
            JCTree.JCTry jCTry = (JCTree.JCTry)jCTree;
            Assert.checkNonNull(jCTry.finalizer);
            return posKind.toPos(jCTry.finalizer);
        }
        if (jCTree.hasTag(JCTree.Tag.SYNCHRONIZED)) {
            return TreeInfo.endPos(((JCTree.JCSynchronized)jCTree).body);
        }
        throw new AssertionError();
    }

    public static int positionFor(Symbol symbol, JCTree jCTree) {
        JCTree jCTree2;
        return ((jCTree2 = TreeInfo.declarationFor((Symbol)symbol, (JCTree)jCTree)) != null ? jCTree2 : jCTree).pos;
    }

    public static JCDiagnostic.DiagnosticPosition diagnosticPositionFor(Symbol symbol, JCTree jCTree) {
        return TreeInfo.diagnosticPositionFor(symbol, jCTree, false);
    }

    public static JCDiagnostic.DiagnosticPosition diagnosticPositionFor(Symbol symbol, JCTree jCTree, boolean bl) {
        class DiagScanner
        extends DeclScanner {
            DiagScanner(Symbol symbol) {
                super(symbol);
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                if (jCIdent.sym == this.sym) {
                    this.result = jCIdent;
                } else {
                    super.visitIdent(jCIdent);
                }
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
                if (jCFieldAccess.sym == this.sym) {
                    this.result = jCFieldAccess;
                } else {
                    super.visitSelect(jCFieldAccess);
                }
            }
        }
        DiagScanner diagScanner = new DiagScanner(symbol);
        jCTree.accept(diagScanner);
        JCTree jCTree2 = diagScanner.result;
        if (jCTree2 == null && bl) {
            return null;
        }
        return (jCTree2 != null ? jCTree2 : jCTree).pos();
    }

    public static JCDiagnostic.DiagnosticPosition diagnosticPositionFor(Symbol symbol, List<? extends JCTree> list) {
        return list.stream().map(jCTree -> TreeInfo.diagnosticPositionFor(symbol, jCTree)).filter(diagnosticPosition -> diagnosticPosition != null).findFirst().get();
    }

    public static JCTree declarationFor(Symbol symbol, JCTree jCTree) {
        DeclScanner declScanner = new DeclScanner(symbol);
        jCTree.accept(declScanner);
        return declScanner.result;
    }

    public static JCTree referencedStatement(JCTree.JCLabeledStatement jCLabeledStatement) {
        JCTree.JCStatement jCStatement = jCLabeledStatement;
        while ((jCStatement = ((JCTree.JCLabeledStatement)jCStatement).body).hasTag(JCTree.Tag.LABELLED)) {
        }
        switch (jCStatement.getTag()) {
            case FORLOOP: 
            case FOREACHLOOP: 
            case WHILELOOP: 
            case DOLOOP: 
            case SWITCH: {
                return jCStatement;
            }
        }
        return jCLabeledStatement;
    }

    public static JCTree.JCExpression skipParens(JCTree.JCExpression jCExpression) {
        while (jCExpression.hasTag(JCTree.Tag.PARENS)) {
            jCExpression = ((JCTree.JCParens)jCExpression).expr;
        }
        return jCExpression;
    }

    public static JCTree skipParens(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.PARENS)) {
            return TreeInfo.skipParens((JCTree.JCParens)jCTree);
        }
        return jCTree;
    }

    public static List<Type> types(List<? extends JCTree> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            listBuffer.append(((JCTree)list2.head).type);
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    public static Name name(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case IDENT: {
                return ((JCTree.JCIdent)jCTree).name;
            }
            case SELECT: {
                return ((JCTree.JCFieldAccess)jCTree).name;
            }
            case TYPEAPPLY: {
                return TreeInfo.name(((JCTree.JCTypeApply)jCTree).clazz);
            }
        }
        return null;
    }

    public static Name fullName(JCTree jCTree) {
        jCTree = TreeInfo.skipParens(jCTree);
        switch (jCTree.getTag()) {
            case IDENT: {
                return ((JCTree.JCIdent)jCTree).name;
            }
            case SELECT: {
                Name name = TreeInfo.fullName(((JCTree.JCFieldAccess)jCTree).selected);
                return name == null ? null : name.append('.', TreeInfo.name(jCTree));
            }
        }
        return null;
    }

    public static Symbol symbolFor(JCTree jCTree) {
        Symbol symbol = TreeInfo.symbolForImpl(jCTree);
        return symbol != null ? symbol.baseSymbol() : null;
    }

    private static Symbol symbolForImpl(JCTree jCTree) {
        jCTree = TreeInfo.skipParens(jCTree);
        switch (jCTree.getTag()) {
            case TOPLEVEL: {
                JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)jCTree;
                JCTree.JCModuleDecl jCModuleDecl = jCCompilationUnit.getModuleDecl();
                if (TreeInfo.isModuleInfo(jCCompilationUnit) && jCModuleDecl != null) {
                    return TreeInfo.symbolFor(jCModuleDecl);
                }
                return jCCompilationUnit.packge;
            }
            case MODULEDEF: {
                return ((JCTree.JCModuleDecl)jCTree).sym;
            }
            case PACKAGEDEF: {
                return ((JCTree.JCPackageDecl)jCTree).packge;
            }
            case CLASSDEF: {
                return ((JCTree.JCClassDecl)jCTree).sym;
            }
            case METHODDEF: {
                return ((JCTree.JCMethodDecl)jCTree).sym;
            }
            case VARDEF: {
                return ((JCTree.JCVariableDecl)jCTree).sym;
            }
            case IDENT: {
                return ((JCTree.JCIdent)jCTree).sym;
            }
            case SELECT: {
                return ((JCTree.JCFieldAccess)jCTree).sym;
            }
            case REFERENCE: {
                return ((JCTree.JCMemberReference)jCTree).sym;
            }
            case NEWCLASS: {
                return ((JCTree.JCNewClass)jCTree).constructor;
            }
            case APPLY: {
                return TreeInfo.symbolFor(((JCTree.JCMethodInvocation)jCTree).meth);
            }
            case TYPEAPPLY: {
                return TreeInfo.symbolFor(((JCTree.JCTypeApply)jCTree).clazz);
            }
            case ANNOTATION: 
            case TYPE_ANNOTATION: 
            case TYPEPARAMETER: {
                if (jCTree.type != null) {
                    return jCTree.type.tsym;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isDeclaration(JCTree jCTree) {
        jCTree = TreeInfo.skipParens(jCTree);
        switch (jCTree.getTag()) {
            case VARDEF: 
            case PACKAGEDEF: 
            case CLASSDEF: 
            case METHODDEF: {
                return true;
            }
        }
        return false;
    }

    public static Symbol symbol(JCTree jCTree) {
        jCTree = TreeInfo.skipParens(jCTree);
        switch (jCTree.getTag()) {
            case IDENT: {
                return ((JCTree.JCIdent)jCTree).sym;
            }
            case SELECT: {
                return ((JCTree.JCFieldAccess)jCTree).sym;
            }
            case TYPEAPPLY: {
                return TreeInfo.symbol(((JCTree.JCTypeApply)jCTree).clazz);
            }
            case ANNOTATED_TYPE: {
                return TreeInfo.symbol(((JCTree.JCAnnotatedType)jCTree).underlyingType);
            }
            case REFERENCE: {
                return ((JCTree.JCMemberReference)jCTree).sym;
            }
        }
        return null;
    }

    public static JCTree.JCModifiers getModifiers(JCTree jCTree) {
        jCTree = TreeInfo.skipParens(jCTree);
        switch (jCTree.getTag()) {
            case VARDEF: {
                return ((JCTree.JCVariableDecl)jCTree).mods;
            }
            case METHODDEF: {
                return ((JCTree.JCMethodDecl)jCTree).mods;
            }
            case CLASSDEF: {
                return ((JCTree.JCClassDecl)jCTree).mods;
            }
            case MODULEDEF: {
                return ((JCTree.JCModuleDecl)jCTree).mods;
            }
        }
        return null;
    }

    public static boolean nonstaticSelect(JCTree jCTree) {
        if (!(jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.SELECT)) {
            return false;
        }
        JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCTree;
        Symbol symbol = TreeInfo.symbol(jCFieldAccess.selected);
        return symbol == null || symbol.kind != Kinds.Kind.PCK && symbol.kind != Kinds.Kind.TYP;
    }

    public static void setSymbol(JCTree jCTree, Symbol symbol) {
        jCTree = TreeInfo.skipParens(jCTree);
        switch (jCTree.getTag()) {
            case IDENT: {
                ((JCTree.JCIdent)jCTree).sym = symbol;
                break;
            }
            case SELECT: {
                ((JCTree.JCFieldAccess)jCTree).sym = symbol;
                break;
            }
        }
    }

    public static long flags(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case VARDEF: {
                return ((JCTree.JCVariableDecl)jCTree).mods.flags;
            }
            case METHODDEF: {
                return ((JCTree.JCMethodDecl)jCTree).mods.flags;
            }
            case CLASSDEF: {
                return ((JCTree.JCClassDecl)jCTree).mods.flags;
            }
            case BLOCK: {
                return ((JCTree.JCBlock)jCTree).flags;
            }
        }
        return 0L;
    }

    public static long firstFlag(long l) {
        long l2 = 1L;
        while ((l2 & l) == 0L) {
            l2 <<= 1;
        }
        return l2;
    }

    public static String flagNames(long l) {
        return Flags.toString(l & 0xC000080000000FFFL).trim();
    }

    public static int opPrec(JCTree.Tag tag) {
        switch (tag) {
            case PREINC: 
            case PREDEC: 
            case POS: 
            case NEG: 
            case NOT: 
            case COMPL: {
                return 14;
            }
            case POSTINC: 
            case POSTDEC: 
            case NULLCHK: {
                return 15;
            }
            case ASSIGN: {
                return 1;
            }
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: {
                return 2;
            }
            case OR: {
                return 4;
            }
            case AND: {
                return 5;
            }
            case EQ: 
            case NE: {
                return 9;
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: {
                return 10;
            }
            case BITOR: {
                return 6;
            }
            case BITXOR: {
                return 7;
            }
            case BITAND: {
                return 8;
            }
            case SL: 
            case SR: 
            case USR: {
                return 11;
            }
            case PLUS: 
            case MINUS: {
                return 12;
            }
            case MUL: 
            case DIV: 
            case MOD: {
                return 13;
            }
            case TYPETEST: {
                return 10;
            }
        }
        throw new AssertionError();
    }

    static Tree.Kind tagToKind(JCTree.Tag tag) {
        switch (tag) {
            case POSTINC: {
                return Tree.Kind.POSTFIX_INCREMENT;
            }
            case POSTDEC: {
                return Tree.Kind.POSTFIX_DECREMENT;
            }
            case PREINC: {
                return Tree.Kind.PREFIX_INCREMENT;
            }
            case PREDEC: {
                return Tree.Kind.PREFIX_DECREMENT;
            }
            case POS: {
                return Tree.Kind.UNARY_PLUS;
            }
            case NEG: {
                return Tree.Kind.UNARY_MINUS;
            }
            case COMPL: {
                return Tree.Kind.BITWISE_COMPLEMENT;
            }
            case NOT: {
                return Tree.Kind.LOGICAL_COMPLEMENT;
            }
            case MUL: {
                return Tree.Kind.MULTIPLY;
            }
            case DIV: {
                return Tree.Kind.DIVIDE;
            }
            case MOD: {
                return Tree.Kind.REMAINDER;
            }
            case PLUS: {
                return Tree.Kind.PLUS;
            }
            case MINUS: {
                return Tree.Kind.MINUS;
            }
            case SL: {
                return Tree.Kind.LEFT_SHIFT;
            }
            case SR: {
                return Tree.Kind.RIGHT_SHIFT;
            }
            case USR: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
            }
            case LT: {
                return Tree.Kind.LESS_THAN;
            }
            case GT: {
                return Tree.Kind.GREATER_THAN;
            }
            case LE: {
                return Tree.Kind.LESS_THAN_EQUAL;
            }
            case GE: {
                return Tree.Kind.GREATER_THAN_EQUAL;
            }
            case EQ: {
                return Tree.Kind.EQUAL_TO;
            }
            case NE: {
                return Tree.Kind.NOT_EQUAL_TO;
            }
            case BITAND: {
                return Tree.Kind.AND;
            }
            case BITXOR: {
                return Tree.Kind.XOR;
            }
            case BITOR: {
                return Tree.Kind.OR;
            }
            case AND: {
                return Tree.Kind.CONDITIONAL_AND;
            }
            case OR: {
                return Tree.Kind.CONDITIONAL_OR;
            }
            case MUL_ASG: {
                return Tree.Kind.MULTIPLY_ASSIGNMENT;
            }
            case DIV_ASG: {
                return Tree.Kind.DIVIDE_ASSIGNMENT;
            }
            case MOD_ASG: {
                return Tree.Kind.REMAINDER_ASSIGNMENT;
            }
            case PLUS_ASG: {
                return Tree.Kind.PLUS_ASSIGNMENT;
            }
            case MINUS_ASG: {
                return Tree.Kind.MINUS_ASSIGNMENT;
            }
            case SL_ASG: {
                return Tree.Kind.LEFT_SHIFT_ASSIGNMENT;
            }
            case SR_ASG: {
                return Tree.Kind.RIGHT_SHIFT_ASSIGNMENT;
            }
            case USR_ASG: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT;
            }
            case BITAND_ASG: {
                return Tree.Kind.AND_ASSIGNMENT;
            }
            case BITXOR_ASG: {
                return Tree.Kind.XOR_ASSIGNMENT;
            }
            case BITOR_ASG: {
                return Tree.Kind.OR_ASSIGNMENT;
            }
            case NULLCHK: {
                return Tree.Kind.OTHER;
            }
            case ANNOTATION: {
                return Tree.Kind.ANNOTATION;
            }
            case TYPE_ANNOTATION: {
                return Tree.Kind.TYPE_ANNOTATION;
            }
            case EXPORTS: {
                return Tree.Kind.EXPORTS;
            }
            case OPENS: {
                return Tree.Kind.OPENS;
            }
        }
        return null;
    }

    public static JCTree.JCExpression typeIn(JCTree.JCExpression jCExpression) {
        switch (jCExpression.getTag()) {
            case ANNOTATED_TYPE: {
                return ((JCTree.JCAnnotatedType)jCExpression).underlyingType;
            }
            case IDENT: 
            case SELECT: 
            case TYPEAPPLY: 
            case ERRONEOUS: 
            case TYPEARRAY: 
            case WILDCARD: 
            case TYPEPARAMETER: 
            case TYPEIDENT: {
                return jCExpression;
            }
        }
        throw new AssertionError((Object)("Unexpected type tree: " + jCExpression));
    }

    public static JCTree innermostType(JCTree jCTree, boolean bl) {
        JCTree jCTree2 = null;
        JCTree jCTree3 = jCTree;
        block5: while (true) {
            switch (jCTree3.getTag()) {
                case TYPEARRAY: {
                    jCTree2 = null;
                    jCTree3 = ((JCTree.JCArrayTypeTree)jCTree3).elemtype;
                    continue block5;
                }
                case WILDCARD: {
                    jCTree2 = null;
                    jCTree3 = ((JCTree.JCWildcard)jCTree3).inner;
                    continue block5;
                }
                case ANNOTATED_TYPE: {
                    jCTree2 = jCTree3;
                    jCTree3 = ((JCTree.JCAnnotatedType)jCTree3).underlyingType;
                    continue block5;
                }
            }
            break;
        }
        if (!bl && jCTree2 != null) {
            return jCTree2;
        }
        return jCTree3;
    }

    public static boolean containsTypeAnnotation(JCTree jCTree) {
        TypeAnnotationFinder typeAnnotationFinder = new TypeAnnotationFinder();
        typeAnnotationFinder.scan(jCTree);
        return typeAnnotationFinder.foundTypeAnno;
    }

    public static boolean isModuleInfo(JCTree.JCCompilationUnit jCCompilationUnit) {
        return jCCompilationUnit.sourcefile.isNameCompatible("module-info", JavaFileObject.Kind.SOURCE) && jCCompilationUnit.getModuleDecl() != null;
    }

    public static JCTree.JCModuleDecl getModule(JCTree.JCCompilationUnit jCCompilationUnit) {
        JCTree jCTree;
        if (jCCompilationUnit.defs.nonEmpty() && (jCTree = (JCTree)jCCompilationUnit.defs.head).hasTag(JCTree.Tag.MODULEDEF)) {
            return (JCTree.JCModuleDecl)jCTree;
        }
        return null;
    }

    public static boolean isPackageInfo(JCTree.JCCompilationUnit jCCompilationUnit) {
        return jCCompilationUnit.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
    }

    public static boolean isErrorEnumSwitch(JCTree.JCExpression jCExpression2, List<JCTree.JCCase> list) {
        return jCExpression2.type.tsym.kind == Kinds.Kind.ERR && list.stream().flatMap(jCCase -> jCCase.labels.stream()).filter(jCCaseLabel -> jCCaseLabel.hasTag(JCTree.Tag.CONSTANTCASELABEL)).map(jCCaseLabel -> ((JCTree.JCConstantCaseLabel)jCCaseLabel).expr).allMatch(jCExpression -> jCExpression.hasTag(JCTree.Tag.IDENT));
    }

    public static Type primaryPatternType(JCTree jCTree) {
        Type type;
        switch (jCTree.getTag()) {
            case BINDINGPATTERN: {
                type = jCTree.type;
                break;
            }
            case PARENTHESIZEDPATTERN: {
                type = TreeInfo.primaryPatternType(((JCTree.JCParenthesizedPattern)jCTree).pattern);
                break;
            }
            case RECORDPATTERN: {
                type = ((JCTree.JCRecordPattern)jCTree).type;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return type;
    }

    public static JCTree primaryPatternTypeTree(JCTree jCTree) {
        JCTree jCTree2;
        switch (jCTree.getTag()) {
            case BINDINGPATTERN: {
                jCTree2 = ((JCTree.JCBindingPattern)jCTree).var.vartype;
                break;
            }
            case PARENTHESIZEDPATTERN: {
                jCTree2 = TreeInfo.primaryPatternTypeTree(((JCTree.JCParenthesizedPattern)jCTree).pattern);
                break;
            }
            case RECORDPATTERN: {
                jCTree2 = ((JCTree.JCRecordPattern)jCTree).deconstructor;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return jCTree2;
    }

    public static boolean expectedExhaustive(JCTree.JCSwitch jCSwitch) {
        return jCSwitch.patternSwitch || jCSwitch.cases.stream().flatMap(jCCase -> jCCase.labels.stream()).anyMatch(jCCaseLabel -> TreeInfo.isNullCaseLabel(jCCaseLabel));
    }

    public static boolean unguardedCaseLabel(JCTree.JCCaseLabel jCCaseLabel) {
        if (!jCCaseLabel.hasTag(JCTree.Tag.PATTERNCASELABEL)) {
            return true;
        }
        JCTree.JCExpression jCExpression = ((JCTree.JCPatternCaseLabel)jCCaseLabel).guard;
        if (jCExpression == null) {
            return true;
        }
        return TreeInfo.isBooleanWithValue(jCExpression, 1);
    }

    public static boolean isBooleanWithValue(JCTree.JCExpression jCExpression, int n) {
        Object object = jCExpression.type.constValue();
        return object != null && jCExpression.type.hasTag(TypeTag.BOOLEAN) && (Integer)object == n;
    }

    public static boolean isNullCaseLabel(JCTree.JCCaseLabel jCCaseLabel) {
        return jCCaseLabel.hasTag(JCTree.Tag.CONSTANTCASELABEL) && TreeInfo.isNull(((JCTree.JCConstantCaseLabel)jCCaseLabel).expr);
    }

    public static enum PosKind {
        START_POS(TreeInfo::getStartPos),
        FIRST_STAT_POS(TreeInfo::firstStatPos),
        END_POS(TreeInfo::endPos);

        final ToIntFunction<JCTree> posFunc;

        private PosKind(ToIntFunction<JCTree> toIntFunction) {
            this.posFunc = toIntFunction;
        }

        int toPos(JCTree jCTree) {
            return this.posFunc.applyAsInt(jCTree);
        }
    }

    private static class DeclScanner
    extends TreeScanner {
        final Symbol sym;
        JCTree result = null;

        DeclScanner(Symbol symbol) {
            this.sym = symbol;
        }

        @Override
        public void scan(JCTree jCTree) {
            if (jCTree != null && this.result == null) {
                jCTree.accept(this);
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
            if (jCCompilationUnit.packge == this.sym) {
                this.result = jCCompilationUnit;
            } else {
                super.visitTopLevel(jCCompilationUnit);
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
            if (jCModuleDecl.sym == this.sym) {
                this.result = jCModuleDecl;
            }
        }

        @Override
        public void visitPackageDef(JCTree.JCPackageDecl jCPackageDecl) {
            if (jCPackageDecl.packge == this.sym) {
                this.result = jCPackageDecl;
            } else {
                super.visitPackageDef(jCPackageDecl);
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == this.sym) {
                this.result = jCClassDecl;
            } else {
                super.visitClassDef(jCClassDecl);
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.sym == this.sym) {
                this.result = jCMethodDecl;
            } else {
                super.visitMethodDef(jCMethodDecl);
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (jCVariableDecl.sym == this.sym) {
                this.result = jCVariableDecl;
            } else {
                super.visitVarDef(jCVariableDecl);
            }
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
            if (jCTypeParameter.type != null && jCTypeParameter.type.tsym == this.sym) {
                this.result = jCTypeParameter;
            } else {
                super.visitTypeParameter(jCTypeParameter);
            }
        }
    }

    private static class TypeAnnotationFinder
    extends TreeScanner {
        public boolean foundTypeAnno = false;

        private TypeAnnotationFinder() {
        }

        @Override
        public void scan(JCTree jCTree) {
            if (this.foundTypeAnno || jCTree == null) {
                return;
            }
            super.scan(jCTree);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
            this.foundTypeAnno = this.foundTypeAnno || jCAnnotation.hasTag(JCTree.Tag.TYPE_ANNOTATION);
        }
    }
}

