/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteBuffer {
    public byte[] elems;
    public int length;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int n) {
        this.elems = new byte[n];
        this.length = 0;
    }

    public void appendByte(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length);
        this.elems[this.length++] = (byte)n;
    }

    public void appendBytes(byte[] byArray, int n, int n2) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + n2);
        System.arraycopy(byArray, n, this.elems, this.length, n2);
        this.length += n2;
    }

    public void appendBytes(byte[] byArray) {
        this.appendBytes(byArray, 0, byArray.length);
    }

    public void appendChar(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + 1);
        this.elems[this.length] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 1] = (byte)(n & 0xFF);
        this.length += 2;
    }

    public void appendInt(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + 3);
        this.elems[this.length] = (byte)(n >> 24 & 0xFF);
        this.elems[this.length + 1] = (byte)(n >> 16 & 0xFF);
        this.elems[this.length + 2] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 3] = (byte)(n & 0xFF);
        this.length += 4;
    }

    public void appendLong(long l) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendFloat(float f) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeFloat(f);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 4);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendDouble(double d) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeDouble(d);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendName(Name name) {
        this.appendBytes(name.getByteArray(), name.getByteOffset(), name.getByteLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendStream(InputStream inputStream) throws IOException {
        try {
            int n = this.length;
            int n2 = inputStream.available();
            this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + n2);
            int n3 = inputStream.read(this.elems, n, n2);
            int n4 = n;
            while (n3 != -1) {
                this.elems = ArrayUtils.ensureCapacity(this.elems, n4 += n3);
                n3 = inputStream.read(this.elems, n4, this.elems.length - n4);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int getInt(int n) {
        return ((this.elems[n] & 0xFF) << 24) + ((this.elems[n + 1] & 0xFF) << 16) + ((this.elems[n + 2] & 0xFF) << 8) + (this.elems[n + 3] & 0xFF);
    }

    public long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.elems, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.elems, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.elems, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public char getChar(int n) {
        return (char)(((this.elems[n] & 0xFF) << 8) + (this.elems[n + 1] & 0xFF));
    }

    public byte getByte(int n) {
        return this.elems[n];
    }

    public void reset() {
        this.length = 0;
    }

    public Name toName(Names names) {
        return names.fromUtf(this.elems, 0, this.length);
    }
}

