/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class GraphUtils {
    public static <D, N extends TarjanNode<D, N>> List<? extends List<? extends N>> tarjan(Iterable<? extends N> iterable) {
        Tarjan tarjan = new Tarjan();
        return tarjan.findSCC(iterable);
    }

    public static <D, N extends DottableNode<D, N>> String toDot(Collection<? extends N> collection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("digraph %s {\n", string));
        stringBuilder.append(String.format("label = %s;\n", DotVisitor.wrap(string2)));
        DotVisitor dotVisitor = new DotVisitor();
        dotVisitor.visit((Collection)collection, stringBuilder);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private static class Tarjan<D, N extends TarjanNode<D, N>> {
        int index = 0;
        ListBuffer<List<N>> sccs = new ListBuffer();
        ListBuffer<N> stack = new ListBuffer();

        private Tarjan() {
        }

        private List<? extends List<? extends N>> findSCC(Iterable<? extends N> iterable) {
            for (TarjanNode tarjanNode : iterable) {
                if (tarjanNode.index != -1) continue;
                this.findSCC(tarjanNode);
            }
            return this.sccs.toList();
        }

        private void findSCC(N n) {
            this.visitNode(n);
            for (TarjanNode tarjanNode : ((TarjanNode)n).getAllDependencies()) {
                if (tarjanNode.index == -1) {
                    this.findSCC(tarjanNode);
                    ((TarjanNode)n).lowlink = Math.min(((TarjanNode)n).lowlink, tarjanNode.lowlink);
                    continue;
                }
                if (!this.stack.contains(tarjanNode)) continue;
                ((TarjanNode)n).lowlink = Math.min(((TarjanNode)n).lowlink, tarjanNode.index);
            }
            if (((TarjanNode)n).lowlink == ((TarjanNode)n).index) {
                this.addSCC(n);
            }
        }

        private void visitNode(N n) {
            ((TarjanNode)n).index = this.index;
            ((TarjanNode)n).lowlink = this.index++;
            this.stack.prepend(n);
            ((TarjanNode)n).active = true;
        }

        private void addSCC(N n) {
            TarjanNode tarjanNode;
            ListBuffer<TarjanNode> listBuffer = new ListBuffer<TarjanNode>();
            do {
                tarjanNode = (TarjanNode)this.stack.remove();
                tarjanNode.active = false;
                listBuffer.add(tarjanNode);
            } while (tarjanNode != n);
            this.sccs.add(listBuffer.toList());
        }
    }

    public static class DotVisitor<D, N extends DottableNode<D, N>>
    extends NodeVisitor<D, N, StringBuilder> {
        @Override
        public void visitDependency(DependencyKind dependencyKind, N n, N n2, StringBuilder stringBuilder) {
            stringBuilder.append(String.format("%s -> %s", n.hashCode(), n2.hashCode()));
            stringBuilder.append(this.formatProperties(n.dependencyAttributes(n2, dependencyKind)));
            stringBuilder.append('\n');
        }

        @Override
        public void visitNode(N n, StringBuilder stringBuilder) {
            stringBuilder.append(String.format("%s ", n.hashCode()));
            stringBuilder.append(this.formatProperties(n.nodeAttributes()));
            stringBuilder.append('\n');
        }

        protected String formatProperties(Properties properties) {
            return properties.toString().replaceAll(",", " ").replaceAll("\\{", "[").replaceAll("\\}", "]");
        }

        protected static String wrap(String string) {
            String string2 = "\"" + string + "\"";
            return string2.replaceAll("\n", "");
        }
    }

    public static abstract class TarjanNode<D, N extends TarjanNode<D, N>>
    extends AbstractNode<D, N>
    implements Comparable<N> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D d) {
            super(d);
        }

        public abstract Iterable<? extends N> getAllDependencies();

        @Override
        public int compareTo(N n) {
            return Integer.compare(this.index, ((TarjanNode)n).index);
        }
    }

    public static abstract class AbstractNode<D, N extends AbstractNode<D, N>>
    implements Node<D, N> {
        public final D data;

        public AbstractNode(D d) {
            this.data = d;
        }

        public abstract DependencyKind[] getSupportedDependencyKinds();

        public abstract Collection<? extends N> getDependenciesByKind(DependencyKind var1);

        public String toString() {
            return this.data.toString();
        }

        @Override
        public <A> void accept(NodeVisitor<D, N, A> nodeVisitor, A a) {
            nodeVisitor.visitNode(this, a);
            for (DependencyKind dependencyKind : this.getSupportedDependencyKinds()) {
                for (AbstractNode abstractNode : new ArrayList<N>(this.getDependenciesByKind(dependencyKind))) {
                    nodeVisitor.visitDependency(dependencyKind, this, abstractNode, a);
                }
            }
        }
    }

    public static interface DottableNode<D, N extends DottableNode<D, N>>
    extends Node<D, N> {
        public Properties nodeAttributes();

        public Properties dependencyAttributes(N var1, DependencyKind var2);
    }

    static abstract class NodeVisitor<D, N extends Node<D, N>, A> {
        NodeVisitor() {
        }

        public abstract void visitNode(N var1, A var2);

        public abstract void visitDependency(DependencyKind var1, N var2, N var3, A var4);

        public void visit(Collection<? extends N> collection, A a) {
            for (Node node : new ArrayList<N>(collection)) {
                node.accept(this, a);
            }
        }
    }

    public static interface Node<D, N extends Node<D, N>> {
        public <A> void accept(NodeVisitor<D, N, A> var1, A var2);
    }

    public static interface DependencyKind {
    }
}

