/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.tools.JavaFileObject;

public class MandatoryWarningHandler {
    private final Log log;
    private final Source source;
    private final boolean verbose;
    private final String prefix;
    private Set<JavaFileObject> sourcesWithReportedWarnings;
    private DeferredDiagnosticKind deferredDiagnosticKind;
    private JavaFileObject deferredDiagnosticSource;
    private Object deferredDiagnosticArg;
    private final boolean enforceMandatory;
    private final Lint.LintCategory lintCategory;

    public MandatoryWarningHandler(Log log, Source source, boolean bl, boolean bl2, String string, Lint.LintCategory lintCategory) {
        this.log = log;
        this.source = source;
        this.verbose = bl;
        this.prefix = string;
        this.enforceMandatory = bl2;
        this.lintCategory = lintCategory;
    }

    public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Warning warning) {
        JavaFileObject javaFileObject = this.log.currentSourceFile();
        if (this.verbose) {
            if (this.sourcesWithReportedWarnings == null) {
                this.sourcesWithReportedWarnings = new HashSet<JavaFileObject>();
            }
            if (this.log.nwarnings < this.log.MaxWarnings) {
                this.logMandatoryWarning(diagnosticPosition, warning);
                this.sourcesWithReportedWarnings.add(javaFileObject);
            } else if (this.deferredDiagnosticKind == null) {
                this.deferredDiagnosticKind = this.sourcesWithReportedWarnings.contains(javaFileObject) ? DeferredDiagnosticKind.ADDITIONAL_IN_FILE : DeferredDiagnosticKind.IN_FILE;
                this.deferredDiagnosticSource = javaFileObject;
                this.deferredDiagnosticArg = javaFileObject;
            } else if (!(this.deferredDiagnosticKind != DeferredDiagnosticKind.IN_FILE && this.deferredDiagnosticKind != DeferredDiagnosticKind.ADDITIONAL_IN_FILE || Objects.equals(this.deferredDiagnosticSource, javaFileObject))) {
                this.deferredDiagnosticKind = DeferredDiagnosticKind.ADDITIONAL_IN_FILES;
                this.deferredDiagnosticArg = null;
            }
        } else if (this.deferredDiagnosticKind == null) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILE;
            this.deferredDiagnosticSource = javaFileObject;
            this.deferredDiagnosticArg = javaFileObject;
        } else if (this.deferredDiagnosticKind == DeferredDiagnosticKind.IN_FILE && !Objects.equals(this.deferredDiagnosticSource, javaFileObject)) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILES;
            this.deferredDiagnosticArg = null;
        }
    }

    public void reportDeferredDiagnostic() {
        if (this.deferredDiagnosticKind != null) {
            if (this.deferredDiagnosticArg == null) {
                if (this.source != null) {
                    this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[]{this.source});
                } else {
                    this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[0]);
                }
            } else if (this.source != null) {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[]{this.deferredDiagnosticArg, this.source});
            } else {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), this.deferredDiagnosticArg);
            }
            if (!this.verbose) {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.prefix + ".recompile", new Object[0]);
            }
        }
    }

    private void logMandatoryWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Warning warning) {
        if (this.enforceMandatory) {
            this.log.mandatoryWarning(this.lintCategory, diagnosticPosition, warning);
        } else {
            this.log.warning(this.lintCategory, diagnosticPosition, warning);
        }
    }

    private void logMandatoryNote(JavaFileObject javaFileObject, String string, Object ... objectArray) {
        if (this.enforceMandatory) {
            this.log.mandatoryNote(javaFileObject, new JCDiagnostic.Note("compiler", string, objectArray));
        } else {
            this.log.note(javaFileObject, new JCDiagnostic.Note("compiler", string, objectArray));
        }
    }

    public void clear() {
        this.sourcesWithReportedWarnings = null;
        this.deferredDiagnosticKind = null;
        this.deferredDiagnosticSource = null;
        this.deferredDiagnosticArg = null;
    }

    private static enum DeferredDiagnosticKind {
        IN_FILE(".filename"),
        ADDITIONAL_IN_FILE(".filename.additional"),
        IN_FILES(".plural"),
        ADDITIONAL_IN_FILES(".plural.additional");

        private final String value;

        private DeferredDiagnosticKind(String string2) {
            this.value = string2;
        }

        String getKey(String string) {
            return string + this.value;
        }
    }
}

