/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.AbstractDiagnosticFormatter;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.StringUtils;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.frgaal.CollectionShims;

public final class RawDiagnosticFormatter
extends AbstractDiagnosticFormatter {
    RawDiagnosticPosHelper rawDiagnosticPosHelper;
    private static final Set<String> CODES_NEEDING_SOURCE_NORMALIZATION = CollectionShims.set("compiler.note.preview.filename", "compiler.note.preview.plural");

    public RawDiagnosticFormatter(Options options) {
        super(null, new AbstractDiagnosticFormatter.SimpleConfiguration(options, EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatDiagnostic(JCDiagnostic jCDiagnostic, Locale locale) {
        try {
            this.rawDiagnosticPosHelper = new RawDiagnosticPosHelper(jCDiagnostic);
            StringBuilder stringBuilder = new StringBuilder();
            if (jCDiagnostic.getPosition() != -1L) {
                stringBuilder.append(this.formatSource(jCDiagnostic, false, (Locale)null));
                stringBuilder.append(':');
                stringBuilder.append(this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.LINE, (Locale)null));
                stringBuilder.append(':');
                stringBuilder.append(this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.COLUMN, (Locale)null));
                stringBuilder.append(':');
            } else if (jCDiagnostic.getSource() != null && jCDiagnostic.getSource().getKind() == JavaFileObject.Kind.CLASS) {
                stringBuilder.append(this.formatSource(jCDiagnostic, false, (Locale)null));
                stringBuilder.append(":-:-:");
            } else {
                stringBuilder.append('-');
            }
            stringBuilder.append(' ');
            stringBuilder.append(this.formatMessage(jCDiagnostic, (Locale)null));
            if (this.displaySource(jCDiagnostic)) {
                stringBuilder.append("\n");
                stringBuilder.append(this.formatSourceLine(jCDiagnostic, 0));
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (Exception exception) {
            String string = null;
            return string;
        }
        finally {
            this.rawDiagnosticPosHelper = null;
        }
    }

    @Override
    public String formatMessage(JCDiagnostic jCDiagnostic, Locale locale) {
        List<String> list;
        StringBuilder stringBuilder = new StringBuilder();
        Collection<String> collection = this.formatArguments(jCDiagnostic, locale);
        stringBuilder.append(this.localize(null, jCDiagnostic.getCode(), collection.toArray()));
        if (jCDiagnostic.isMultiline() && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS) && (list = this.formatSubdiagnostics(jCDiagnostic, null)).nonEmpty()) {
            String string = "";
            stringBuilder.append(",{");
            for (String string2 : this.formatSubdiagnostics(jCDiagnostic, null)) {
                stringBuilder.append(string);
                stringBuilder.append("(");
                stringBuilder.append(string2);
                stringBuilder.append(")");
                string = ",";
            }
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    @Override
    protected String formatArgument(JCDiagnostic jCDiagnostic, Object object, Locale locale) {
        String string;
        if (object instanceof Formattable) {
            string = object.toString();
        } else if (object instanceof JCTree.JCExpression) {
            JCTree.JCExpression jCExpression = (JCTree.JCExpression)object;
            Assert.checkNonNull(this.rawDiagnosticPosHelper);
            string = "@" + this.rawDiagnosticPosHelper.getPosition(jCExpression);
        } else if (object instanceof PathFileObject) {
            PathFileObject pathFileObject = (PathFileObject)object;
            string = pathFileObject.getShortName();
        } else if (object instanceof JCTree.Tag) {
            JCTree.Tag tag = (JCTree.Tag)((Object)object);
            string = "compiler.misc.tree.tag." + StringUtils.toLowerCase(tag.name());
        } else {
            string = object instanceof Source && object == Source.DEFAULT && CODES_NEEDING_SOURCE_NORMALIZATION.contains(jCDiagnostic.getCode()) ? "DEFAULT" : super.formatArgument(jCDiagnostic, object, null);
        }
        return object instanceof JCDiagnostic ? "(" + string + ")" : string;
    }

    @Override
    protected String localize(Locale locale, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        String string2 = ": ";
        for (Object object : objectArray) {
            stringBuilder.append(string2);
            stringBuilder.append(object);
            string2 = ", ";
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isRaw() {
        return true;
    }

    static class RawDiagnosticPosHelper {
        private final JCDiagnostic diag;

        RawDiagnosticPosHelper(JCDiagnostic jCDiagnostic) {
            this.diag = jCDiagnostic;
        }

        String getPosition(JCTree.JCExpression jCExpression) {
            DiagnosticSource diagnosticSource = this.diag.getDiagnosticSource();
            long l = this.diag.getLineNumber();
            long l2 = diagnosticSource.getLineNumber(jCExpression.pos);
            long l3 = diagnosticSource.getColumnNumber(jCExpression.pos, false);
            return l2 == l ? String.valueOf(l3) : l2 + ":" + l3;
        }
    }
}

