/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.ref.SoftReference;

public class SharedNameTable
extends Name.Table {
    private static List<SoftReference<SharedNameTable>> freelist = List.nil();
    private NameImpl[] hashes;
    public byte[] bytes;
    private int hashMask;
    private int nc = 0;

    public static synchronized SharedNameTable create(Names names) {
        while (freelist.nonEmpty()) {
            SharedNameTable sharedNameTable = (SharedNameTable)((SoftReference)SharedNameTable.freelist.head).get();
            freelist = SharedNameTable.freelist.tail;
            if (sharedNameTable == null) continue;
            return sharedNameTable;
        }
        return new SharedNameTable(names);
    }

    private static synchronized void dispose(SharedNameTable sharedNameTable) {
        freelist = freelist.prepend(new SoftReference<SharedNameTable>(sharedNameTable));
    }

    public SharedNameTable(Names names, int n, int n2) {
        super(names);
        this.hashMask = n - 1;
        this.hashes = new NameImpl[n];
        this.bytes = new byte[n2];
    }

    public SharedNameTable(Names names) {
        this(names, 32768, 131072);
    }

    @Override
    public Name fromChars(char[] cArray, int n, int n2) {
        int n3 = this.nc;
        this.bytes = ArrayUtils.ensureCapacity(this.bytes, n3 + n2 * 3);
        byte[] byArray = this.bytes;
        int n4 = Convert.chars2utf(cArray, n, byArray, n3, n2) - n3;
        int n5 = SharedNameTable.hashValue(byArray, n3, n4) & this.hashMask;
        NameImpl nameImpl = this.hashes[n5];
        while (!(nameImpl == null || nameImpl.getByteLength() == n4 && SharedNameTable.equals(byArray, nameImpl.index, byArray, n3, n4))) {
            nameImpl = nameImpl.next;
        }
        if (nameImpl == null) {
            nameImpl = new NameImpl(this);
            nameImpl.index = n3;
            nameImpl.length = n4;
            nameImpl.next = this.hashes[n5];
            this.hashes[n5] = nameImpl;
            this.nc = n3 + n4;
            if (n4 == 0) {
                ++this.nc;
            }
        }
        return nameImpl;
    }

    @Override
    public Name fromUtf(byte[] byArray, int n, int n2) {
        int n3 = SharedNameTable.hashValue(byArray, n, n2) & this.hashMask;
        NameImpl nameImpl = this.hashes[n3];
        byte[] byArray2 = this.bytes;
        while (!(nameImpl == null || nameImpl.getByteLength() == n2 && SharedNameTable.equals(byArray2, nameImpl.index, byArray, n, n2))) {
            nameImpl = nameImpl.next;
        }
        if (nameImpl == null) {
            int n4 = this.nc;
            byArray2 = this.bytes = ArrayUtils.ensureCapacity(byArray2, n4 + n2);
            System.arraycopy(byArray, n, byArray2, n4, n2);
            nameImpl = new NameImpl(this);
            nameImpl.index = n4;
            nameImpl.length = n2;
            nameImpl.next = this.hashes[n3];
            this.hashes[n3] = nameImpl;
            this.nc = n4 + n2;
            if (n2 == 0) {
                ++this.nc;
            }
        }
        return nameImpl;
    }

    @Override
    public void dispose() {
        SharedNameTable.dispose(this);
    }

    static class NameImpl
    extends Name {
        NameImpl next;
        int index;
        int length;

        NameImpl(SharedNameTable sharedNameTable) {
            super(sharedNameTable);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getByteLength() {
            return this.length;
        }

        @Override
        public byte getByteAt(int n) {
            return this.getByteArray()[this.index + n];
        }

        @Override
        public byte[] getByteArray() {
            return ((SharedNameTable)this.table).bytes;
        }

        @Override
        public int getByteOffset() {
            return this.index;
        }

        @Override
        public int hashCode() {
            return this.index;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Name)) return false;
            Name name = (Name)object;
            if (this.table != name.table) return false;
            if (this.index != name.getIndex()) return false;
            return true;
        }
    }
}

