/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.shellsupport.doc;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public abstract class JavadocHelper
implements AutoCloseable {
    private static final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public static JavadocHelper create(JavacTask javacTask, Collection<? extends Path> collection) {
        StandardJavaFileManager standardJavaFileManager = compiler.getStandardFileManager(null, null, null);
        try {
            standardJavaFileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, collection);
            return new OnDemandJavadocHelper(javacTask, standardJavaFileManager);
        }
        catch (IOException iOException) {
            try {
                standardJavaFileManager.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return new JavadocHelper(){

                @Override
                public String getResolvedDocComment(Element element) throws IOException {
                    return null;
                }

                @Override
                public Element getSourceElement(Element element) throws IOException {
                    return element;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    public abstract String getResolvedDocComment(Element var1) throws IOException;

    public abstract Element getSourceElement(Element var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    private static final class OnDemandJavadocHelper
    extends JavadocHelper {
        private final JavacTask mainTask;
        private final JavaFileManager baseFileManager;
        private final StandardJavaFileManager fm;
        private final Map<String, Pair<JavacTask, TreePath>> signature2Source = new HashMap<String, Pair<JavacTask, TreePath>>();

        private OnDemandJavadocHelper(JavacTask javacTask, StandardJavaFileManager standardJavaFileManager) {
            this.mainTask = javacTask;
            this.baseFileManager = ((JavacTaskImpl)javacTask).getContext().get(JavaFileManager.class);
            this.fm = standardJavaFileManager;
        }

        @Override
        public String getResolvedDocComment(Element element) throws IOException {
            Pair<JavacTask, TreePath> pair = this.getSourceElement(this.mainTask, element);
            if (pair == null) {
                return null;
            }
            return this.getResolvedDocComment((JavacTask)pair.fst, (TreePath)pair.snd);
        }

        @Override
        public Element getSourceElement(Element element) throws IOException {
            Pair<JavacTask, TreePath> pair = this.getSourceElement(this.mainTask, element);
            if (pair == null) {
                return element;
            }
            Element element2 = Trees.instance((JavaCompiler.CompilationTask)pair.fst).getElement((TreePath)pair.snd);
            if (element2 == null) {
                return element;
            }
            return element2;
        }

        private String getResolvedDocComment(final JavacTask javacTask, final TreePath treePath) throws IOException {
            Object object;
            Object object2;
            Object object4;
            Object object5;
            Object object6;
            DocTrees docTrees = DocTrees.instance(javacTask);
            final Element element = docTrees.getElement(treePath);
            String string = docTrees.getDocComment(treePath);
            if (string == null && element.getKind() == ElementKind.METHOD) {
                object6 = (ExecutableElement)element;
                object5 = () -> this.superTypeForInheritDoc(javacTask, element.getEnclosingElement()).iterator();
                Iterator iterator = object5.iterator();
                while (iterator.hasNext()) {
                    object4 = (Element)iterator.next();
                    for (ExecutableElement object32 : ElementFilter.methodsIn(object4.getEnclosedElements())) {
                        Object object3;
                        object2 = (TypeElement)object6.getEnclosingElement();
                        if (!javacTask.getElements().overrides((ExecutableElement)object6, object32, (TypeElement)object2) || (object = this.getSourceElement(javacTask, object32)) == null || (object3 = this.getResolvedDocComment((JavacTask)((Pair)object).fst, (TreePath)((Pair)object).snd)) == null) continue;
                        return object3;
                    }
                }
            }
            if (string == null) {
                return null;
            }
            object6 = this.parseDocComment(javacTask, string);
            object5 = (DocCommentTree)((Pair)object6).fst;
            final int n = (Integer)((Pair)object6).snd;
            object4 = new IOException[1];
            Comparator comparator = (nArray, nArray2) -> nArray[0] != nArray2[0] ? nArray2[0] - nArray[0] : nArray2[1] - nArray[0];
            TreeMap treeMap = new TreeMap(comparator);
            object2 = docTrees.getSourcePositions();
            new DocTreeScanner<Void, Void>((DocCommentTree)object5, (IOException[])object4, (DocSourcePositions)object2, treeMap, string){
                private Stack<DocTree> interestingParent = new Stack();
                private DocCommentTree dcTree;
                private String inherited;
                private JavacTask inheritedJavacTask;
                private TreePath inheritedTreePath;
                private Map<DocTree, String> syntheticTrees = new IdentityHashMap<DocTree, String>();
                private long insertPos = n;
                private boolean inSynthetic;
                private final List<DocTree.Kind> tagOrder = Arrays.asList(DocTree.Kind.PARAM, DocTree.Kind.THROWS, DocTree.Kind.RETURN);
                final /* synthetic */ DocCommentTree val$docCommentTree;
                final /* synthetic */ IOException[] val$exception;
                final /* synthetic */ DocSourcePositions val$sp;
                final /* synthetic */ Map val$replace;
                final /* synthetic */ String val$docComment;
                {
                    this.val$docCommentTree = docCommentTree;
                    this.val$exception = iOExceptionArray;
                    this.val$sp = docSourcePositions;
                    this.val$replace = map;
                    this.val$docComment = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitDocComment(DocCommentTree docCommentTree, Void void_) {
                    this.dcTree = docCommentTree;
                    this.interestingParent.push(docCommentTree);
                    try {
                        Object object;
                        if (docCommentTree.getFullBody().isEmpty()) {
                            object = (DocCommentTree)((OnDemandJavadocHelper)this).parseDocComment((JavacTask)javacTask, (String)"{@inheritDoc}").fst;
                            this.syntheticTrees.put((DocTree)object, "*\n");
                            this.interestingParent.push((DocTree)object);
                            boolean bl = this.inSynthetic;
                            try {
                                this.inSynthetic = true;
                                this.scan(object.getFirstSentence(), void_);
                                this.scan(object.getBody(), void_);
                            }
                            finally {
                                this.inSynthetic = bl;
                                this.interestingParent.pop();
                            }
                        } else {
                            this.scan(docCommentTree.getFirstSentence(), void_);
                            this.scan(docCommentTree.getBody(), void_);
                        }
                        object = new ArrayList<DocTree>(docCommentTree.getBlockTags());
                        if (element.getKind() == ElementKind.METHOD) {
                            DocTree docTree;
                            ExecutableElement executableElement = (ExecutableElement)element;
                            List<String> list = executableElement.getParameters().stream().map(variableElement -> variableElement.getSimpleName().toString()).collect(Collectors.toList());
                            List<String> list2 = executableElement.getThrownTypes().stream().map(TypeMirror::toString).collect(Collectors.toList());
                            HashSet hashSet = new HashSet(list);
                            HashSet hashSet2 = new HashSet(list2);
                            boolean bl = false;
                            Object object2 = object.iterator();
                            while (object2.hasNext()) {
                                Object object3 = (DocTree)object2.next();
                                switch (object3.getKind()) {
                                    case PARAM: {
                                        hashSet.remove(((ParamTree)object3).getName().getName().toString());
                                        break;
                                    }
                                    case THROWS: {
                                        hashSet2.remove(this.getThrownException(javacTask, treePath, this.val$docCommentTree, (ThrowsTree)object3));
                                        break;
                                    }
                                    case RETURN: {
                                        bl = true;
                                    }
                                }
                            }
                            for (Object object3 : hashSet) {
                                docTree = this.parseBlockTag(javacTask, "@param " + (String)object3 + " {@inheritDoc}");
                                this.syntheticTrees.put(docTree, "@param " + (String)object3 + " *\n");
                                this.insertTag((List<DocTree>)object, docTree, list, list2);
                            }
                            for (Object object3 : hashSet2) {
                                docTree = this.parseBlockTag(javacTask, "@throws " + (String)object3 + " {@inheritDoc}");
                                this.syntheticTrees.put(docTree, "@throws " + (String)object3 + " *\n");
                                this.insertTag((List<DocTree>)object, docTree, list, list2);
                            }
                            if (!bl) {
                                object2 = this.parseBlockTag(javacTask, "@return {@inheritDoc}");
                                this.syntheticTrees.put((DocTree)object2, "@return *\n");
                                this.insertTag((List<DocTree>)object, (DocTree)object2, list, list2);
                            }
                        }
                        this.scan((Iterable<DocTree>)object, void_);
                        Void void_2 = null;
                        return void_2;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitParam(ParamTree paramTree, Void void_) {
                    this.interestingParent.push(paramTree);
                    try {
                        Void void_2 = (Void)super.visitParam(paramTree, void_);
                        return void_2;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitThrows(ThrowsTree throwsTree, Void void_) {
                    this.interestingParent.push(throwsTree);
                    try {
                        Void void_2 = (Void)super.visitThrows(throwsTree, void_);
                        return void_2;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitReturn(ReturnTree returnTree, Void void_) {
                    this.interestingParent.push(returnTree);
                    try {
                        Void void_2 = (Void)super.visitReturn(returnTree, void_);
                        return void_2;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                @Override
                public Void visitInheritDoc(InheritDocTree inheritDocTree, Void void_) {
                    String string;
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    block15: {
                        if (this.inherited == null) {
                            try {
                                if (element.getKind() != ElementKind.METHOD) break block15;
                                object4 = (ExecutableElement)element;
                                object3 = () -> this.lambda$visitInheritDoc$1(javacTask, (ExecutableElement)object4);
                                Iterator iterator = object3.iterator();
                                while (iterator.hasNext()) {
                                    object2 = (Element)iterator.next();
                                    object = this.getSourceElement(javacTask, (Element)object2);
                                    if (object == null || (string = this.getResolvedDocComment((JavacTask)((Pair)object).fst, (TreePath)((Pair)object).snd)) == null) continue;
                                    this.inheritedJavacTask = (JavacTask)((Pair)object).fst;
                                    this.inheritedTreePath = (TreePath)((Pair)object).snd;
                                    this.inherited = string;
                                    break;
                                }
                            }
                            catch (IOException iOException) {
                                this.val$exception[0] = iOException;
                                return null;
                            }
                        }
                    }
                    if (this.inherited == null) {
                        return null;
                    }
                    object4 = this.parseDocComment(this.inheritedJavacTask, this.inherited);
                    object3 = (DocCommentTree)((Pair)object4).fst;
                    int n2 = (Integer)((Pair)object4).snd;
                    object2 = new ArrayList();
                    object = this.interestingParent.peek();
                    switch (object.getKind()) {
                        case DOC_COMMENT: {
                            object2.add(object3.getFullBody());
                            break;
                        }
                        case PARAM: {
                            string = ((ParamTree)object).getName().getName().toString();
                            new DocTreeScanner<Void, Void>((List)object2){
                                final /* synthetic */ List val$inheritedText;
                                {
                                    this.val$inheritedText = list;
                                }

                                @Override
                                public Void visitParam(ParamTree paramTree, Void void_) {
                                    if (paramTree.getName().getName().contentEquals(string)) {
                                        this.val$inheritedText.add(paramTree.getDescription());
                                    }
                                    return (Void)super.visitParam(paramTree, void_);
                                }
                            }.scan((DocTree)object3, null);
                            break;
                        }
                        case THROWS: {
                            String string2 = this.getThrownException(javacTask, treePath, this.val$docCommentTree, (ThrowsTree)object);
                            new DocTreeScanner<Void, Void>((DocCommentTree)object3, string2, (List)object2){
                                final /* synthetic */ DocCommentTree val$inheritedDocTree;
                                final /* synthetic */ String val$thrownName;
                                final /* synthetic */ List val$inheritedText;
                                {
                                    this.val$inheritedDocTree = docCommentTree;
                                    this.val$thrownName = string;
                                    this.val$inheritedText = list;
                                }

                                @Override
                                public Void visitThrows(ThrowsTree throwsTree, Void void_) {
                                    if (Objects.equals(this.getThrownException(inheritedJavacTask, inheritedTreePath, this.val$inheritedDocTree, throwsTree), this.val$thrownName)) {
                                        this.val$inheritedText.add(throwsTree.getDescription());
                                    }
                                    return (Void)super.visitThrows(throwsTree, void_);
                                }
                            }.scan((DocTree)object3, null);
                            break;
                        }
                        case RETURN: {
                            new DocTreeScanner<Void, Void>((List)object2){
                                final /* synthetic */ List val$inheritedText;
                                {
                                    this.val$inheritedText = list;
                                }

                                @Override
                                public Void visitReturn(ReturnTree returnTree, Void void_) {
                                    this.val$inheritedText.add(returnTree.getDescription());
                                    return (Void)super.visitReturn(returnTree, void_);
                                }
                            }.scan((DocTree)object3, null);
                        }
                    }
                    if (!object2.isEmpty()) {
                        Object object5;
                        long l = Long.MAX_VALUE;
                        long l2 = Long.MIN_VALUE;
                        Object object6 = ((List)object2.get(0)).iterator();
                        while (object6.hasNext()) {
                            object5 = (DocTree)object6.next();
                            l = Math.min(l, this.val$sp.getStartPosition(null, (DocCommentTree)object3, (DocTree)object5) - (long)n2);
                            l2 = Math.max(l2, this.val$sp.getEndPosition(null, (DocCommentTree)object3, (DocTree)object5) - (long)n2);
                        }
                        Object object7 = object6 = l2 >= 0L ? this.inherited.substring((int)l, (int)l2) : "";
                        if (this.syntheticTrees.containsKey(object)) {
                            object5 = new int[]{(int)this.insertPos, (int)this.insertPos};
                            this.val$replace.computeIfAbsent(object5, nArray -> new ArrayList()).add(this.syntheticTrees.get(object).replace("*", (CharSequence)object6));
                        } else {
                            long l3 = this.val$sp.getStartPosition(null, this.dcTree, inheritDocTree);
                            long l4 = this.val$sp.getEndPosition(null, this.dcTree, inheritDocTree);
                            int[] nArray2 = new int[]{(int)l3, (int)l4};
                            this.val$replace.computeIfAbsent(nArray2, nArray -> new ArrayList()).add(object6);
                        }
                    }
                    return (Void)super.visitInheritDoc(inheritDocTree, void_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void scan(DocTree docTree, Void void_) {
                    if (this.val$exception[0] != null) {
                        return null;
                    }
                    boolean bl = this.inSynthetic;
                    try {
                        this.inSynthetic |= this.syntheticTrees.containsKey(docTree);
                        Void void_2 = (Void)super.scan(docTree, void_);
                        return void_2;
                    }
                    finally {
                        long l;
                        if (!this.inSynthetic && docTree != null && (l = this.val$sp.getEndPosition(null, this.dcTree, docTree)) >= (long)n) {
                            if (l - (long)n + 1L < (long)this.val$docComment.length() && this.val$docComment.charAt((int)(l - (long)n + 1L)) == '\n') {
                                ++l;
                            }
                            this.insertPos = l - (long)n < (long)this.val$docComment.length() ? l + 1L : l;
                        }
                        this.inSynthetic = bl;
                    }
                }

                private void insertTag(List<DocTree> list, DocTree docTree, List<String> list2, List<String> list3) {
                    Comparator comparator = (docTree2, docTree3) -> {
                        if (docTree2.getKind() == docTree3.getKind()) {
                            switch (docTree.getKind()) {
                                case PARAM: {
                                    ParamTree paramTree = (ParamTree)docTree2;
                                    ParamTree paramTree2 = (ParamTree)docTree3;
                                    int n5 = list2.indexOf(paramTree.getName().getName().toString());
                                    int n2 = list2.indexOf(paramTree2.getName().getName().toString());
                                    return n5 - n2;
                                }
                                case THROWS: {
                                    ThrowsTree throwsTree = (ThrowsTree)docTree2;
                                    ThrowsTree throwsTree2 = (ThrowsTree)docTree3;
                                    int n6 = list3.indexOf(this.getThrownException(javacTask, treePath, this.val$docCommentTree, throwsTree));
                                    int n3 = list3.indexOf(this.getThrownException(javacTask, treePath, this.val$docCommentTree, throwsTree2));
                                    return n6 - n3;
                                }
                            }
                        }
                        int n7 = this.tagOrder.indexOf((Object)docTree2.getKind());
                        int n4 = this.tagOrder.indexOf((Object)docTree3.getKind());
                        return n7 - n4;
                    };
                    for (int i = 0; i < list.size(); ++i) {
                        if (comparator.compare(list.get(i), docTree) < 0) continue;
                        list.add(i, docTree);
                        return;
                    }
                    list.add(docTree);
                }

                private /* synthetic */ Iterator lambda$visitInheritDoc$1(JavacTask javacTask2, ExecutableElement executableElement) {
                    return this.superMethodsForInheritDoc(javacTask2, executableElement).iterator();
                }
            }.scan((DocTree)object5, (Void)null);
            if (treeMap.isEmpty()) {
                return string;
            }
            object = new StringBuilder(string);
            for (Map.Entry entry : treeMap.entrySet()) {
                ((StringBuilder)object).delete(((int[])entry.getKey())[0] - n, ((int[])entry.getKey())[1] - n);
                ((StringBuilder)object).insert(((int[])entry.getKey())[0] - n, ((List)entry.getValue()).stream().collect(Collectors.joining("")));
            }
            return ((StringBuilder)object).toString();
        }

        private Stream<ExecutableElement> superMethodsForInheritDoc(JavacTask javacTask, ExecutableElement executableElement) {
            TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
            return this.superTypeForInheritDoc(javacTask, typeElement).flatMap(element -> ElementFilter.methodsIn(element.getEnclosedElements()).stream()).filter(executableElement2 -> javacTask.getElements().overrides(executableElement, (ExecutableElement)executableElement2, typeElement));
        }

        private Stream<Element> superTypeForInheritDoc(JavacTask javacTask, Element element2) {
            TypeElement typeElement = (TypeElement)element2;
            Stream<Element> stream = this.interfaces(typeElement);
            stream = Stream.concat(stream, this.interfaces(typeElement).flatMap(element -> this.superTypeForInheritDoc(javacTask, (Element)element)));
            if (typeElement.getSuperclass().getKind() == TypeKind.DECLARED) {
                Element element3 = ((DeclaredType)typeElement.getSuperclass()).asElement();
                stream = Stream.concat(stream, Stream.of(element3));
                stream = Stream.concat(stream, this.superTypeForInheritDoc(javacTask, element3));
            }
            return stream;
        }

        private Stream<Element> interfaces(TypeElement typeElement) {
            return typeElement.getInterfaces().stream().filter(typeMirror -> typeMirror.getKind() == TypeKind.DECLARED).map(typeMirror -> ((DeclaredType)typeMirror).asElement());
        }

        private DocTree parseBlockTag(JavacTask javacTask, String string) {
            DocCommentTree docCommentTree = (DocCommentTree)this.parseDocComment((JavacTask)javacTask, (String)string).fst;
            return docCommentTree.getBlockTags().get(0);
        }

        private Pair<DocCommentTree, Integer> parseDocComment(JavacTask javacTask, final String string) {
            DocTrees docTrees = DocTrees.instance(javacTask);
            try {
                SimpleJavaFileObject simpleJavaFileObject = new SimpleJavaFileObject(new URI("mem://doc.html"), JavaFileObject.Kind.HTML){

                    @Override
                    public CharSequence getCharContent(boolean bl) throws IOException {
                        return "<body>" + string + "</body>";
                    }
                };
                DocCommentTree docCommentTree = docTrees.getDocCommentTree(simpleJavaFileObject);
                int n = (int)docTrees.getSourcePositions().getStartPosition(null, docCommentTree, docCommentTree);
                return Pair.of(docCommentTree, n += "<body>".length());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalStateException(uRISyntaxException);
            }
        }

        private String getThrownException(JavacTask javacTask, TreePath treePath, DocCommentTree docCommentTree, ThrowsTree throwsTree) {
            DocTrees docTrees = DocTrees.instance(javacTask);
            Element element = docTrees.getElement(new DocTreePath(new DocTreePath(treePath, docCommentTree), throwsTree.getExceptionName()));
            return element != null ? element.toString() : null;
        }

        private Pair<JavacTask, TreePath> getSourceElement(JavacTask javacTask, Element element) throws IOException {
            String string = this.elementSignature(element);
            Pair<JavacTask, TreePath> pair = this.signature2Source.get(string);
            if (pair != null) {
                return pair.fst != null ? pair : null;
            }
            TypeElement typeElement = this.topLevelType(element);
            if (typeElement == null) {
                return null;
            }
            Elements elements = javacTask.getElements();
            String string2 = elements.getBinaryName(typeElement).toString();
            ModuleElement moduleElement = elements.getModuleOf(typeElement);
            String string3 = moduleElement == null || moduleElement.isUnnamed() ? null : moduleElement.getQualifiedName().toString();
            Pair<JavacTask, CompilationUnitTree> pair2 = this.findSource(string3, string2);
            if (pair2 == null) {
                return null;
            }
            this.fillElementCache((JavacTask)pair2.fst, (CompilationUnitTree)pair2.snd);
            pair = this.signature2Source.get(string);
            if (pair != null) {
                return pair;
            }
            this.signature2Source.put(string, Pair.of(null, null));
            return null;
        }

        private String elementSignature(Element element) {
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case RECORD: {
                    return ((TypeElement)element).getQualifiedName().toString();
                }
                case FIELD: {
                    return this.elementSignature(element.getEnclosingElement()) + "." + element.getSimpleName() + ":" + element.asType();
                }
                case ENUM_CONSTANT: {
                    return this.elementSignature(element.getEnclosingElement()) + "." + element.getSimpleName();
                }
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case PARAMETER: 
                case RESOURCE_VARIABLE: {
                    return element.getSimpleName() + ":" + element.asType();
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.elementSignature(element.getEnclosingElement()));
                    if (element.getKind() == ElementKind.METHOD) {
                        stringBuilder.append(".");
                        stringBuilder.append(element.getSimpleName());
                    }
                    stringBuilder.append("(");
                    String string = "";
                    ExecutableElement executableElement = (ExecutableElement)element;
                    for (VariableElement variableElement : executableElement.getParameters()) {
                        stringBuilder.append(string);
                        stringBuilder.append(variableElement.asType());
                        string = ", ";
                    }
                    stringBuilder.append(")");
                    return stringBuilder.toString();
                }
                case PACKAGE: 
                case STATIC_INIT: 
                case INSTANCE_INIT: 
                case TYPE_PARAMETER: 
                case OTHER: 
                case MODULE: 
                case RECORD_COMPONENT: 
                case BINDING_VARIABLE: {
                    return element.toString();
                }
            }
            throw Assert.error(element.getKind().name());
        }

        private TypeElement topLevelType(Element element) {
            if (element.getKind() == ElementKind.PACKAGE) {
                return null;
            }
            while (element != null && element.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                element = element.getEnclosingElement();
            }
            return element != null && (element.getKind().isClass() || element.getKind().isInterface()) ? (TypeElement)element : null;
        }

        private void fillElementCache(final JavacTask javacTask, CompilationUnitTree compilationUnitTree) throws IOException {
            final Trees trees = Trees.instance(javacTask);
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitMethod(MethodTree methodTree, Void void_) {
                    this.handleDeclaration();
                    return null;
                }

                @Override
                public Void visitClass(ClassTree classTree, Void void_) {
                    this.handleDeclaration();
                    return (Void)super.visitClass(classTree, void_);
                }

                @Override
                public Void visitVariable(VariableTree variableTree, Void void_) {
                    this.handleDeclaration();
                    return (Void)super.visitVariable(variableTree, void_);
                }

                private void handleDeclaration() {
                    Element element = trees.getElement(this.getCurrentPath());
                    if (element != null) {
                        signature2Source.put(this.elementSignature(element), Pair.of(javacTask, this.getCurrentPath()));
                    }
                }
            }.scan(compilationUnitTree, null);
        }

        private Pair<JavacTask, CompilationUnitTree> findSource(String string, String string2) throws IOException {
            JavaFileObject javaFileObject = this.fm.getJavaFileForInput(StandardLocation.SOURCE_PATH, string2, JavaFileObject.Kind.SOURCE);
            if (javaFileObject == null) {
                return null;
            }
            List<JavaFileObject> list = Arrays.asList(javaFileObject);
            JavaFileManager javaFileManager = string != null ? new PatchModuleFileManager(this.baseFileManager, javaFileObject, string) : this.baseFileManager;
            JavacTaskImpl javacTaskImpl = (JavacTaskImpl)compiler.getTask(null, javaFileManager, diagnostic -> {}, null, null, list);
            Iterable<? extends CompilationUnitTree> iterable = javacTaskImpl.parse();
            javacTaskImpl.enter();
            return Pair.of(javacTaskImpl, iterable.iterator().next());
        }

        @Override
        public void close() throws IOException {
            this.fm.close();
        }

        private static final class PatchModuleFileManager
        extends ForwardingJavaFileManager<JavaFileManager> {
            private final JavaFileObject file;
            private final String moduleName;
            private static final JavaFileManager.Location PATCH_LOCATION = new JavaFileManager.Location(){

                @Override
                public String getName() {
                    return "PATCH_LOCATION";
                }

                @Override
                public boolean isOutputLocation() {
                    return false;
                }

                @Override
                public boolean isModuleOrientedLocation() {
                    return false;
                }
            };

            public PatchModuleFileManager(JavaFileManager javaFileManager, JavaFileObject javaFileObject, String string) {
                super(javaFileManager);
                this.file = javaFileObject;
                this.moduleName = string;
            }

            @Override
            public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject javaFileObject) throws IOException {
                return javaFileObject == this.file ? PATCH_LOCATION : super.getLocationForModule(location, javaFileObject);
            }

            @Override
            public String inferModuleName(JavaFileManager.Location location) throws IOException {
                return location == PATCH_LOCATION ? this.moduleName : super.inferModuleName(location);
            }

            @Override
            public boolean hasLocation(JavaFileManager.Location location) {
                return location == StandardLocation.PATCH_MODULE_PATH || super.hasLocation(location);
            }
        }
    }
}

