/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclint;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.SummaryTree;
import com.sun.source.doctree.SystemPropertyTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.DocPretty;
import com.sun.tools.javac.util.Assert;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import jdk.javadoc.internal.doclint.Env;
import jdk.javadoc.internal.doclint.HtmlTag;
import jdk.javadoc.internal.doclint.Messages;
import org.frgaal.StringShims;

public class Checker
extends DocTreePathScanner<Void, Void> {
    final Env env;
    Set<Element> foundParams = new HashSet<Element>();
    Set<TypeMirror> foundThrows = new HashSet<TypeMirror>();
    Map<Element, Set<String>> foundAnchors = new HashMap<Element, Set<String>>();
    boolean foundInheritDoc = false;
    boolean foundReturn = false;
    boolean hasNonWhitespaceText = false;
    private final Deque<TagStackItem> tagStack;
    private HtmlTag currHeadingTag;
    private int implicitHeadingRank;
    private boolean inIndex;
    private boolean inLink;
    private boolean inSummary;
    private static final Pattern validId = Pattern.compile("[^\\s]+");
    private static final Pattern validNumber = Pattern.compile("-?[0-9]+");
    private static final Pattern docRoot = Pattern.compile("(?i)(\\{@docRoot *}/?)?(.*)");

    Checker(Env env) {
        this.env = Assert.checkNonNull(env);
        this.tagStack = new LinkedList<TagStackItem>();
    }

    public Void scan(DocCommentTree docCommentTree, TreePath treePath) {
        int n;
        this.env.initTypes();
        this.env.setCurrent(treePath, docCommentTree);
        boolean bl = !this.env.currOverriddenMethods.isEmpty();
        JavaFileObject javaFileObject = treePath.getCompilationUnit().getSourceFile();
        if (treePath.getLeaf().getKind() == Tree.Kind.PACKAGE) {
            boolean bl2 = javaFileObject.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            if (docCommentTree == null) {
                if (bl2) {
                    this.reportMissing("dc.missing.comment", new Object[0]);
                }
                return null;
            }
            if (!bl2) {
                this.reportReference("dc.unexpected.comment", new Object[0]);
            }
        } else if (docCommentTree != null && javaFileObject.isNameCompatible("package", JavaFileObject.Kind.HTML)) {
            if (docCommentTree.getFullBody().isEmpty()) {
                this.reportMissing("dc.missing.comment", new Object[0]);
                return null;
            }
        } else {
            if (docCommentTree == null) {
                if (this.isDefaultConstructor()) {
                    if (this.isNormalClass(treePath.getParentPath())) {
                        this.reportMissing("dc.default.constructor", new Object[0]);
                    }
                } else if (!(bl || this.isSynthetic() || this.isAnonymous() || this.isRecordComponentOrField())) {
                    this.reportMissing("dc.missing.comment", new Object[0]);
                }
                return null;
            }
            if (docCommentTree.getFirstSentence().isEmpty() && !bl && !this.pseudoElement(treePath)) {
                if (docCommentTree.getBlockTags().isEmpty()) {
                    this.reportMissing("dc.empty.comment", new Object[0]);
                    return null;
                }
                if (docCommentTree.getBlockTags().stream().allMatch(docTree -> docTree.getKind() != DocTree.Kind.DEPRECATED)) {
                    this.env.messages.report(Messages.Group.MISSING, Diagnostic.Kind.WARNING, docCommentTree, "dc.empty.main.description", new Object[0]);
                }
            }
        }
        this.tagStack.clear();
        this.currHeadingTag = null;
        this.foundParams.clear();
        this.foundThrows.clear();
        this.foundInheritDoc = false;
        this.foundReturn = false;
        this.hasNonWhitespaceText = false;
        switch (treePath.getLeaf().getKind()) {
            case MODULE: 
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case RECORD: {
                n = 1;
                break;
            }
            case COMPILATION_UNIT: {
                if (javaFileObject.isNameCompatible("package", JavaFileObject.Kind.HTML)) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case METHOD: 
            case VARIABLE: {
                n = 3;
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected tree kind: " + (Object)((Object)treePath.getLeaf().getKind()) + " " + javaFileObject));
            }
        }
        this.implicitHeadingRank = n;
        this.scan(new DocTreePath(treePath, docCommentTree), null);
        if (this.isDeclaredType()) {
            TypeElement typeElement = (TypeElement)this.env.currElement;
            this.checkParamsDocumented(typeElement.getTypeParameters());
            this.checkParamsDocumented(typeElement.getRecordComponents());
        } else if (this.isExecutable() && !bl) {
            ExecutableElement executableElement = (ExecutableElement)this.env.currElement;
            if (!this.isCanonicalRecordConstructor(executableElement)) {
                this.checkParamsDocumented(executableElement.getTypeParameters());
                this.checkParamsDocumented(executableElement.getParameters());
            }
            switch (executableElement.getReturnType().getKind()) {
                case VOID: 
                case NONE: {
                    break;
                }
                default: {
                    if (this.foundReturn || this.foundInheritDoc || this.env.types.isSameType(executableElement.getReturnType(), this.env.java_lang_Void)) break;
                    this.reportMissing("dc.missing.return", new Object[0]);
                }
            }
            this.checkThrowsDocumented(executableElement.getThrownTypes());
        }
        return null;
    }

    private boolean isCanonicalRecordConstructor(ExecutableElement executableElement) {
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        if (typeElement.getKind() != ElementKind.RECORD) {
            return false;
        }
        List<? extends RecordComponentElement> list = typeElement.getRecordComponents();
        List<? extends VariableElement> list2 = executableElement.getParameters();
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<? extends RecordComponentElement> iterator = list.iterator();
        Iterator<? extends VariableElement> iterator2 = list2.iterator();
        while (iterator2.hasNext() && iterator.hasNext()) {
            VariableElement variableElement = iterator2.next();
            RecordComponentElement recordComponentElement = iterator.next();
            if (Objects.equals(variableElement.getSimpleName(), recordComponentElement.getSimpleName()) && this.env.types.isSameType(variableElement.asType(), recordComponentElement.asType())) continue;
            return false;
        }
        return true;
    }

    private boolean pseudoElement(TreePath treePath) {
        return treePath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && treePath.getCompilationUnit().getSourceFile().getKind() == JavaFileObject.Kind.HTML;
    }

    private void reportMissing(String string, Object ... objectArray) {
        this.env.messages.report(Messages.Group.MISSING, Diagnostic.Kind.WARNING, this.env.currPath.getLeaf(), string, objectArray);
    }

    private void reportReference(String string, Object ... objectArray) {
        this.env.messages.report(Messages.Group.REFERENCE, Diagnostic.Kind.WARNING, this.env.currPath.getLeaf(), string, objectArray);
    }

    @Override
    public Void visitDocComment(DocCommentTree docCommentTree, Void void_) {
        this.scan(docCommentTree.getFirstSentence(), void_);
        this.scan(docCommentTree.getBody(), void_);
        this.checkTagStack();
        for (DocTree docTree : docCommentTree.getBlockTags()) {
            this.tagStack.clear();
            this.scan(docTree, void_);
            this.checkTagStack();
        }
        return null;
    }

    private void checkTagStack() {
        for (TagStackItem tagStackItem : this.tagStack) {
            this.warnIfEmpty(tagStackItem, null);
            if (tagStackItem.tree.getKind() != DocTree.Kind.START_ELEMENT || tagStackItem.tag.endKind != HtmlTag.EndKind.REQUIRED) continue;
            StartElementTree startElementTree = (StartElementTree)tagStackItem.tree;
            this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.closed", startElementTree.getName());
        }
    }

    @Override
    public Void visitText(TextTree textTree, Void void_) {
        this.hasNonWhitespaceText = this.hasNonWhitespace(textTree);
        if (this.hasNonWhitespaceText) {
            this.checkAllowsText(textTree);
            this.markEnclosingTag(Flag.HAS_TEXT);
        }
        return null;
    }

    @Override
    public Void visitEntity(EntityTree entityTree, Void void_) {
        this.checkAllowsText(entityTree);
        this.markEnclosingTag(Flag.HAS_TEXT);
        String string = this.env.trees.getCharacters(entityTree);
        if (string == null) {
            this.env.messages.error(Messages.Group.HTML, entityTree, "dc.entity.invalid", entityTree.getName());
        }
        return null;
    }

    void checkAllowsText(DocTree docTree) {
        TagStackItem tagStackItem = this.tagStack.peek();
        if (tagStackItem != null && tagStackItem.tree.getKind() == DocTree.Kind.START_ELEMENT && !tagStackItem.tag.acceptsText() && tagStackItem.flags.add(Flag.REPORTED_BAD_INLINE)) {
            this.env.messages.error(Messages.Group.HTML, docTree, "dc.text.not.allowed", ((StartElementTree)tagStackItem.tree).getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitStartElement(StartElementTree startElementTree, Void void_) {
        Name name = startElementTree.getName();
        HtmlTag htmlTag = HtmlTag.get(name);
        if (htmlTag == null) {
            this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.unknown", name);
        } else if (htmlTag.elemKind == HtmlTag.ElemKind.HTML4) {
            this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.supported.html5", name);
        } else {
            boolean bl = false;
            for (TagStackItem tagStackItem : this.tagStack) {
                if (tagStackItem.tag.accepts(htmlTag)) {
                    while (this.tagStack.peek() != tagStackItem) {
                        this.warnIfEmpty(this.tagStack.peek(), null);
                        this.tagStack.pop();
                    }
                    bl = true;
                    break;
                }
                if (tagStackItem.tag.endKind == HtmlTag.EndKind.OPTIONAL) continue;
                bl = true;
                break;
            }
            if (!bl && HtmlTag.BODY.accepts(htmlTag)) {
                while (!this.tagStack.isEmpty()) {
                    this.warnIfEmpty(this.tagStack.peek(), null);
                    this.tagStack.pop();
                }
            }
            this.markEnclosingTag(Flag.HAS_ELEMENT);
            this.checkStructure(startElementTree, htmlTag);
            switch (htmlTag) {
                case H1: 
                case H2: 
                case H3: 
                case H4: 
                case H5: 
                case H6: {
                    this.checkHeading(startElementTree, htmlTag);
                }
            }
            if (htmlTag.flags.contains((Object)HtmlTag.Flag.NO_NEST)) {
                for (TagStackItem tagStackItem : this.tagStack) {
                    if (htmlTag != tagStackItem.tag) continue;
                    this.env.messages.warning(Messages.Group.HTML, startElementTree, "dc.tag.nested.not.allowed", name);
                    break;
                }
            }
            if (startElementTree.isSelfClosing() && !this.isSelfClosingAllowed(htmlTag)) {
                this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.self.closing", name);
            }
        }
        try {
            TagStackItem tagStackItem;
            TagStackItem tagStackItem2 = this.tagStack.peek();
            Iterator<TagStackItem> iterator = new TagStackItem(startElementTree, htmlTag);
            this.tagStack.push((TagStackItem)((Object)iterator));
            super.visitStartElement(startElementTree, void_);
            if (htmlTag != null) {
                switch (htmlTag) {
                    case CAPTION: {
                        if (tagStackItem2 == null || tagStackItem2.tag != HtmlTag.TABLE) break;
                        tagStackItem2.flags.add(Flag.TABLE_HAS_CAPTION);
                        break;
                    }
                    case H1: 
                    case H2: 
                    case H3: 
                    case H4: 
                    case H5: 
                    case H6: {
                        if (tagStackItem2 == null || tagStackItem2.tag != HtmlTag.SECTION && tagStackItem2.tag != HtmlTag.ARTICLE) break;
                        tagStackItem2.flags.add(Flag.HAS_HEADING);
                        break;
                    }
                    case IMG: {
                        if (((TagStackItem)((Object)iterator)).attrs.contains((Object)HtmlTag.Attr.ALT)) break;
                        this.env.messages.error(Messages.Group.ACCESSIBILITY, startElementTree, "dc.no.alt.attr.for.image", new Object[0]);
                    }
                }
            }
            tagStackItem = null;
            return tagStackItem;
        }
        finally {
            if (htmlTag == null || htmlTag.endKind == HtmlTag.EndKind.NONE) {
                this.tagStack.pop();
            }
        }
    }

    private boolean isSelfClosingAllowed(HtmlTag htmlTag) {
        return htmlTag.endKind == HtmlTag.EndKind.NONE;
    }

    private void checkStructure(StartElementTree startElementTree, HtmlTag htmlTag) {
        Name name = startElementTree.getName();
        TagStackItem tagStackItem = this.tagStack.peek();
        switch (htmlTag.blockType) {
            case BLOCK: {
                if (tagStackItem == null || tagStackItem.tag.accepts(htmlTag)) {
                    return;
                }
                switch (tagStackItem.tree.getKind()) {
                    case START_ELEMENT: {
                        if (tagStackItem.tag.blockType != HtmlTag.BlockType.INLINE) break;
                        Name name2 = ((StartElementTree)tagStackItem.tree).getName();
                        this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.allowed.inline.element", name, name2);
                        return;
                    }
                    case LINK: 
                    case LINK_PLAIN: {
                        String string = tagStackItem.tree.getKind().tagName;
                        this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.allowed.inline.tag", name, string);
                        return;
                    }
                }
                break;
            }
            case INLINE: {
                if (tagStackItem != null && !tagStackItem.tag.accepts(htmlTag)) break;
                return;
            }
            case LIST_ITEM: 
            case TABLE_ITEM: {
                if (tagStackItem == null) break;
                tagStackItem.flags.remove((Object)Flag.REPORTED_BAD_INLINE);
                if (!tagStackItem.tag.accepts(htmlTag)) break;
                return;
            }
            case OTHER: {
                switch (htmlTag) {
                    case SCRIPT: {
                        break;
                    }
                    default: {
                        this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.allowed", name);
                    }
                }
                return;
            }
        }
        this.env.messages.error(Messages.Group.HTML, startElementTree, "dc.tag.not.allowed.here", name);
    }

    private void checkHeading(StartElementTree startElementTree, HtmlTag htmlTag) {
        if (this.getHeadingRank(htmlTag) > this.getHeadingRank(this.currHeadingTag) + 1) {
            if (this.currHeadingTag == null) {
                this.env.messages.error(Messages.Group.ACCESSIBILITY, startElementTree, "dc.tag.heading.sequence.1", new Object[]{htmlTag, this.implicitHeadingRank});
            } else {
                this.env.messages.error(Messages.Group.ACCESSIBILITY, startElementTree, "dc.tag.heading.sequence.2", new Object[]{htmlTag, this.currHeadingTag});
            }
        } else if (this.getHeadingRank(htmlTag) <= this.implicitHeadingRank) {
            this.env.messages.error(Messages.Group.ACCESSIBILITY, startElementTree, "dc.tag.heading.sequence.3", new Object[]{htmlTag, this.implicitHeadingRank});
        }
        this.currHeadingTag = htmlTag;
    }

    private int getHeadingRank(HtmlTag htmlTag) {
        int n;
        if (htmlTag == null) {
            n = this.implicitHeadingRank;
        } else {
            switch (htmlTag) {
                case H1: {
                    n = 1;
                    break;
                }
                case H2: {
                    n = 2;
                    break;
                }
                case H3: {
                    n = 3;
                    break;
                }
                case H4: {
                    n = 4;
                    break;
                }
                case H5: {
                    n = 5;
                    break;
                }
                case H6: {
                    n = 6;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return n;
    }

    @Override
    public Void visitEndElement(EndElementTree endElementTree, Void void_) {
        Name name = endElementTree.getName();
        HtmlTag htmlTag = HtmlTag.get(name);
        if (htmlTag == null) {
            this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.unknown", name);
        } else if (htmlTag.endKind == HtmlTag.EndKind.NONE) {
            this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.end.not.permitted", name);
        } else {
            boolean bl = false;
            while (!this.tagStack.isEmpty()) {
                TagStackItem tagStackItem = this.tagStack.peek();
                if (htmlTag == tagStackItem.tag) {
                    switch (htmlTag) {
                        case TABLE: {
                            if (tagStackItem.flags.contains((Object)Flag.TABLE_IS_PRESENTATION) || tagStackItem.attrs.contains((Object)HtmlTag.Attr.SUMMARY) || tagStackItem.flags.contains((Object)Flag.TABLE_HAS_CAPTION)) break;
                            this.env.messages.error(Messages.Group.ACCESSIBILITY, endElementTree, "dc.no.summary.or.caption.for.table", new Object[0]);
                            break;
                        }
                        case SECTION: 
                        case ARTICLE: {
                            if (tagStackItem.flags.contains((Object)Flag.HAS_HEADING)) break;
                            this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.requires.heading", name);
                        }
                    }
                    this.warnIfEmpty(tagStackItem, endElementTree);
                    this.tagStack.pop();
                    bl = true;
                    break;
                }
                if (tagStackItem.tag == null || tagStackItem.tag.endKind != HtmlTag.EndKind.REQUIRED) {
                    this.warnIfEmpty(tagStackItem, null);
                    this.tagStack.pop();
                    continue;
                }
                boolean bl2 = false;
                for (TagStackItem tagStackItem2 : this.tagStack) {
                    if (tagStackItem2.tag != htmlTag) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && tagStackItem.tree.getKind() == DocTree.Kind.START_ELEMENT) {
                    this.env.messages.error(Messages.Group.HTML, tagStackItem.tree, "dc.tag.start.unmatched", ((StartElementTree)tagStackItem.tree).getName());
                    this.tagStack.pop();
                    continue;
                }
                this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.end.unexpected", name);
                bl = true;
                break;
            }
            if (!bl && this.tagStack.isEmpty()) {
                this.env.messages.error(Messages.Group.HTML, endElementTree, "dc.tag.end.unexpected", name);
            }
        }
        return (Void)super.visitEndElement(endElementTree, void_);
    }

    void warnIfEmpty(TagStackItem tagStackItem, DocTree docTree) {
        DocTree docTree2;
        if (tagStackItem.tag != null && (docTree2 = tagStackItem.tree) instanceof StartElementTree) {
            StartElementTree startElementTree = (StartElementTree)docTree2;
            if (tagStackItem.tag.flags.contains((Object)HtmlTag.Flag.EXPECT_CONTENT) && !tagStackItem.flags.contains((Object)Flag.HAS_TEXT) && !tagStackItem.flags.contains((Object)Flag.HAS_ELEMENT) && !tagStackItem.flags.contains((Object)Flag.HAS_INLINE_TAG) && tagStackItem.tag.elemKind != HtmlTag.ElemKind.HTML4) {
                docTree2 = docTree != null ? docTree : startElementTree;
                Name name = startElementTree.getName();
                this.env.messages.warning(Messages.Group.HTML, docTree2, "dc.tag.empty", name);
            }
        }
    }

    @Override
    public Void visitAttribute(AttributeTree attributeTree, Void void_) {
        if (this.getParentKind() != DocTree.Kind.START_ELEMENT) {
            return null;
        }
        HtmlTag htmlTag = this.tagStack.peek().tag;
        if (htmlTag != null && htmlTag.elemKind != HtmlTag.ElemKind.HTML4) {
            boolean bl;
            Name name = attributeTree.getName();
            HtmlTag.Attr attr = htmlTag.getAttr(name);
            if (attr != null && !(bl = this.tagStack.peek().attrs.add(attr))) {
                this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.repeated", name);
            }
            if (!name.toString().startsWith("on")) {
                HtmlTag.AttrKind attrKind = htmlTag.getAttrKind(name);
                switch (attrKind) {
                    case OK: {
                        break;
                    }
                    case OBSOLETE: {
                        this.env.messages.warning(Messages.Group.HTML, attributeTree, "dc.attr.obsolete", name);
                        break;
                    }
                    case HTML4: {
                        this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.not.supported.html5", name);
                        break;
                    }
                    case INVALID: {
                        this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.unknown", name);
                    }
                }
            }
            if (attr != null) {
                switch (attr) {
                    case ID: {
                        String string = this.getAttrValue(attributeTree);
                        if (string == null) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.anchor.value.missing", new Object[0]);
                            break;
                        }
                        if (!validId.matcher(string).matches()) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.invalid.anchor", string);
                        }
                        if (this.checkAnchor(string)) break;
                        this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.anchor.already.defined", string);
                        break;
                    }
                    case HREF: {
                        if (htmlTag != HtmlTag.A) break;
                        String string = this.getAttrValue(attributeTree);
                        if (string == null || string.isEmpty()) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.lacks.value", new Object[0]);
                            break;
                        }
                        Matcher matcher = docRoot.matcher(string);
                        if (matcher.matches()) {
                            String string2 = matcher.group(2);
                            if (string2.isEmpty()) break;
                            this.checkURI(attributeTree, string2);
                            break;
                        }
                        this.checkURI(attributeTree, string);
                        break;
                    }
                    case VALUE: {
                        if (htmlTag != HtmlTag.LI) break;
                        String string = this.getAttrValue(attributeTree);
                        if (string == null || string.isEmpty()) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.lacks.value", new Object[0]);
                            break;
                        }
                        if (validNumber.matcher(string).matches()) break;
                        this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.not.number", new Object[0]);
                        break;
                    }
                    case BORDER: {
                        if (htmlTag == HtmlTag.TABLE) {
                            String string = this.getAttrValue(attributeTree);
                            try {
                                if (string != null && (string.isEmpty() || Integer.parseInt(string) == 1)) break;
                                this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.table.border.not.valid", new Object[]{attr});
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.table.border.not.number", new Object[]{attr});
                            }
                            break;
                        }
                        if (htmlTag != HtmlTag.IMG) break;
                        String string = this.getAttrValue(attributeTree);
                        try {
                            if (string != null && (string.isEmpty() || Integer.parseInt(string) == 0)) break;
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.img.border.not.valid", new Object[]{attr});
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.attr.img.border.not.number", new Object[]{attr});
                        }
                        break;
                    }
                    case ROLE: {
                        String string;
                        if (htmlTag != HtmlTag.TABLE || !Objects.equals(string = this.getAttrValue(attributeTree), "presentation")) break;
                        this.tagStack.peek().flags.add(Flag.TABLE_IS_PRESENTATION);
                    }
                }
            }
        }
        return null;
    }

    private boolean checkAnchor(String string) {
        Element element2 = this.getEnclosingPackageOrClass(this.env.currElement);
        return element2 == null || this.foundAnchors.computeIfAbsent(element2, element -> new HashSet()).add(string);
    }

    private Element getEnclosingPackageOrClass(Element element) {
        while (element != null) {
            if (element.getKind().isDeclaredType() || element.getKind() == ElementKind.PACKAGE) {
                return element;
            }
            element = element.getEnclosingElement();
        }
        return element;
    }

    private String getAttrValue(AttributeTree attributeTree) {
        if (attributeTree.getValue() == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            new DocPretty(stringWriter).print(attributeTree.getValue());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private void checkURI(AttributeTree attributeTree, String string) {
        if (string.startsWith("javascript:")) {
            return;
        }
        try {
            new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.env.messages.error(Messages.Group.HTML, attributeTree, "dc.invalid.uri", string);
        }
    }

    @Override
    public Void visitAuthor(AuthorTree authorTree, Void void_) {
        this.warnIfEmpty(authorTree, authorTree.getName());
        return (Void)super.visitAuthor(authorTree, void_);
    }

    @Override
    public Void visitDocRoot(DocRootTree docRootTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        return (Void)super.visitDocRoot(docRootTree, void_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitIndex(IndexTree indexTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        if (this.inIndex) {
            this.env.messages.warning(Messages.Group.HTML, indexTree, "dc.tag.nested.tag", "@" + indexTree.getTagName());
        }
        for (TagStackItem object : this.tagStack) {
            if (object.tag != HtmlTag.A) continue;
            this.env.messages.warning(Messages.Group.HTML, indexTree, "dc.tag.a.within.a", "{@" + indexTree.getTagName() + "}");
            break;
        }
        boolean bl = this.inIndex;
        try {
            this.inIndex = true;
            Void void_2 = (Void)super.visitIndex(indexTree, void_);
            return void_2;
        }
        finally {
            this.inIndex = bl;
        }
    }

    @Override
    public Void visitInheritDoc(InheritDocTree inheritDocTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        this.foundInheritDoc = true;
        return (Void)super.visitInheritDoc(inheritDocTree, void_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitLink(LinkTree linkTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        if (this.inLink) {
            this.env.messages.warning(Messages.Group.HTML, linkTree, "dc.tag.nested.tag", "@" + linkTree.getTagName());
        }
        boolean bl = this.inLink;
        HtmlTag htmlTag = linkTree.getKind() == DocTree.Kind.LINK ? HtmlTag.CODE : HtmlTag.SPAN;
        this.tagStack.push(new TagStackItem(linkTree, htmlTag));
        try {
            this.inLink = true;
            Void void_2 = (Void)super.visitLink(linkTree, void_);
            return void_2;
        }
        finally {
            this.tagStack.pop();
            this.inLink = bl;
        }
    }

    @Override
    public Void visitLiteral(LiteralTree literalTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        if (literalTree.getKind() == DocTree.Kind.CODE) {
            for (TagStackItem tagStackItem : this.tagStack) {
                if (tagStackItem.tag != HtmlTag.CODE) continue;
                this.env.messages.warning(Messages.Group.HTML, literalTree, "dc.tag.code.within.code", new Object[0]);
                break;
            }
        }
        return (Void)super.visitLiteral(literalTree, void_);
    }

    @Override
    public Void visitParam(ParamTree paramTree, Void void_) {
        Element element;
        boolean bl = paramTree.isTypeParameter();
        IdentifierTree identifierTree = paramTree.getName();
        Element element2 = element = identifierTree != null ? this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), identifierTree)) : null;
        if (element == null) {
            switch (this.env.currElement.getKind()) {
                case CLASS: 
                case INTERFACE: {
                    if (bl) {
                        this.env.messages.error(Messages.Group.REFERENCE, identifierTree, "dc.param.name.not.found", new Object[0]);
                        break;
                    }
                    this.env.messages.error(Messages.Group.REFERENCE, paramTree, "dc.invalid.param", new Object[0]);
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: 
                case RECORD: {
                    this.env.messages.error(Messages.Group.REFERENCE, identifierTree, "dc.param.name.not.found", new Object[0]);
                    break;
                }
                default: {
                    this.env.messages.error(Messages.Group.REFERENCE, paramTree, "dc.invalid.param", new Object[0]);
                    break;
                }
            }
        } else {
            boolean bl2 = this.foundParams.add(element);
            if (!bl2) {
                this.env.messages.warning(Messages.Group.REFERENCE, paramTree, "dc.exists.param", identifierTree);
            }
        }
        this.warnIfEmpty(paramTree, paramTree.getDescription());
        return (Void)super.visitParam(paramTree, void_);
    }

    private void checkParamsDocumented(List<? extends Element> list) {
        if (this.foundInheritDoc) {
            return;
        }
        for (Element element : list) {
            if (this.foundParams.contains(element)) continue;
            Name name = element.getKind() == ElementKind.TYPE_PARAMETER ? "<" + element.getSimpleName() + ">" : element.getSimpleName();
            this.reportMissing("dc.missing.param", name);
        }
    }

    @Override
    public Void visitProvides(ProvidesTree providesTree, Void void_) {
        Element element = this.env.trees.getElement(this.env.currPath);
        if (element.getKind() != ElementKind.MODULE) {
            this.env.messages.error(Messages.Group.REFERENCE, providesTree, "dc.invalid.provides", new Object[0]);
        }
        ReferenceTree referenceTree = providesTree.getServiceType();
        Element element2 = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), referenceTree));
        if (element2 == null) {
            this.env.messages.error(Messages.Group.REFERENCE, providesTree, "dc.service.not.found", new Object[0]);
        }
        return (Void)super.visitProvides(providesTree, void_);
    }

    @Override
    public Void visitReference(ReferenceTree referenceTree, Void void_) {
        Element element = this.env.trees.getElement(this.getCurrentPath());
        if (element == null) {
            this.reportBadReference(referenceTree);
        }
        return (Void)super.visitReference(referenceTree, void_);
    }

    private void reportBadReference(ReferenceTree referenceTree) {
        ModuleElement moduleElement;
        String string;
        String string2;
        int n;
        if (!this.env.strictReferenceChecks && (n = (string2 = referenceTree.getSignature()).indexOf("/")) > 0 && SourceVersion.isName(string = string2.substring(0, n)) && (moduleElement = this.env.elements.getModuleElement(string)) == null) {
            this.env.messages.warning(Messages.Group.REFERENCE, referenceTree, "dc.ref.in.missing.module", string);
            return;
        }
        this.env.messages.error(Messages.Group.REFERENCE, referenceTree, "dc.ref.not.found", new Object[0]);
    }

    @Override
    public Void visitReturn(ReturnTree returnTree, Void void_) {
        Object object;
        if (this.foundReturn) {
            this.env.messages.warning(Messages.Group.REFERENCE, returnTree, "dc.exists.return", new Object[0]);
        }
        if (returnTree.isInline() && ((object = this.getCurrentPath().getDocComment()).getFirstSentence().isEmpty() || returnTree != object.getFirstSentence().get(0))) {
            this.env.messages.warning(Messages.Group.SYNTAX, returnTree, "dc.return.not.first", new Object[0]);
        }
        if ((object = this.env.trees.getElement(this.env.currPath)).getKind() != ElementKind.METHOD || ((ExecutableElement)object).getReturnType().getKind() == TypeKind.VOID) {
            this.env.messages.error(Messages.Group.REFERENCE, returnTree, "dc.invalid.return", new Object[0]);
        }
        this.foundReturn = true;
        this.warnIfEmpty(returnTree, returnTree.getDescription());
        return (Void)super.visitReturn(returnTree, void_);
    }

    @Override
    public Void visitSerialData(SerialDataTree serialDataTree, Void void_) {
        this.warnIfEmpty(serialDataTree, serialDataTree.getDescription());
        return (Void)super.visitSerialData(serialDataTree, void_);
    }

    @Override
    public Void visitSerialField(SerialFieldTree serialFieldTree, Void void_) {
        this.warnIfEmpty(serialFieldTree, serialFieldTree.getDescription());
        return (Void)super.visitSerialField(serialFieldTree, void_);
    }

    @Override
    public Void visitSince(SinceTree sinceTree, Void void_) {
        this.warnIfEmpty(sinceTree, sinceTree.getBody());
        return (Void)super.visitSince(sinceTree, void_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSummary(SummaryTree summaryTree, Void void_) {
        int n;
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        if (this.inSummary) {
            this.env.messages.warning(Messages.Group.HTML, summaryTree, "dc.tag.nested.tag", "@" + summaryTree.getTagName());
        }
        if ((n = this.env.currDocComment.getFullBody().indexOf(summaryTree)) == 1 && this.hasNonWhitespaceText || n > 1) {
            this.env.messages.warning(Messages.Group.SYNTAX, summaryTree, "dc.invalid.summary", summaryTree.getTagName());
        }
        boolean bl = this.inSummary;
        try {
            this.inSummary = true;
            Void void_2 = (Void)super.visitSummary(summaryTree, void_);
            return void_2;
        }
        finally {
            this.inSummary = bl;
        }
    }

    @Override
    public Void visitSystemProperty(SystemPropertyTree systemPropertyTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        for (TagStackItem tagStackItem : this.tagStack) {
            if (tagStackItem.tag != HtmlTag.A) continue;
            this.env.messages.warning(Messages.Group.HTML, systemPropertyTree, "dc.tag.a.within.a", "{@" + systemPropertyTree.getTagName() + "}");
            break;
        }
        return (Void)super.visitSystemProperty(systemPropertyTree, void_);
    }

    @Override
    public Void visitThrows(ThrowsTree throwsTree, Void void_) {
        block5: {
            block6: {
                Element element;
                ReferenceTree referenceTree;
                block4: {
                    referenceTree = throwsTree.getExceptionName();
                    element = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), referenceTree));
                    if (element != null) break block4;
                    this.env.messages.error(Messages.Group.REFERENCE, throwsTree, "dc.ref.not.found", new Object[0]);
                    break block5;
                }
                if (!this.isThrowable(element.asType())) break block6;
                switch (this.env.currElement.getKind()) {
                    case METHOD: 
                    case CONSTRUCTOR: {
                        if (this.isCheckedException(element.asType())) {
                            ExecutableElement executableElement = (ExecutableElement)this.env.currElement;
                            this.checkThrowsDeclared(referenceTree, element.asType(), executableElement.getThrownTypes());
                            break;
                        }
                        break block5;
                    }
                    default: {
                        this.env.messages.error(Messages.Group.REFERENCE, throwsTree, "dc.invalid.throws", new Object[0]);
                        break;
                    }
                }
                break block5;
            }
            this.env.messages.error(Messages.Group.REFERENCE, throwsTree, "dc.invalid.throws", new Object[0]);
        }
        this.warnIfEmpty(throwsTree, throwsTree.getDescription());
        return (Void)this.scan(throwsTree.getDescription(), void_);
    }

    private boolean isThrowable(TypeMirror typeMirror) {
        boolean bl;
        switch (typeMirror.getKind()) {
            case DECLARED: 
            case TYPEVAR: {
                bl = this.env.types.isAssignable(typeMirror, this.env.java_lang_Throwable);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private void checkThrowsDeclared(ReferenceTree referenceTree, TypeMirror typeMirror, List<? extends TypeMirror> list) {
        boolean bl = false;
        for (TypeMirror typeMirror2 : list) {
            if (!this.env.types.isAssignable(typeMirror, typeMirror2)) continue;
            this.foundThrows.add(typeMirror2);
            bl = true;
        }
        if (!bl) {
            this.env.messages.error(Messages.Group.REFERENCE, referenceTree, "dc.exception.not.thrown", typeMirror);
        }
    }

    private void checkThrowsDocumented(List<? extends TypeMirror> list) {
        if (this.foundInheritDoc) {
            return;
        }
        for (TypeMirror typeMirror : list) {
            if (!this.isCheckedException(typeMirror) || this.foundThrows.contains(typeMirror)) continue;
            this.reportMissing("dc.missing.throws", typeMirror);
        }
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, Void void_) {
        this.checkUnknownTag(unknownBlockTagTree, unknownBlockTagTree.getTagName());
        return (Void)super.visitUnknownBlockTag(unknownBlockTagTree, void_);
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, Void void_) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        this.checkUnknownTag(unknownInlineTagTree, unknownInlineTagTree.getTagName());
        return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, void_);
    }

    private void checkUnknownTag(DocTree docTree, String string) {
        if (this.env.customTags != null && !this.env.customTags.contains(string)) {
            this.env.messages.error(Messages.Group.SYNTAX, docTree, "dc.tag.unknown", string);
        }
    }

    @Override
    public Void visitUses(UsesTree usesTree, Void void_) {
        Element element = this.env.trees.getElement(this.env.currPath);
        if (element.getKind() != ElementKind.MODULE) {
            this.env.messages.error(Messages.Group.REFERENCE, usesTree, "dc.invalid.uses", new Object[0]);
        }
        ReferenceTree referenceTree = usesTree.getServiceType();
        Element element2 = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), referenceTree));
        if (element2 == null) {
            this.env.messages.error(Messages.Group.REFERENCE, usesTree, "dc.service.not.found", new Object[0]);
        }
        return (Void)super.visitUses(usesTree, void_);
    }

    @Override
    public Void visitValue(ValueTree valueTree, Void void_) {
        ReferenceTree referenceTree = valueTree.getReference();
        if (referenceTree == null || referenceTree.getSignature().isEmpty()) {
            if (!this.isConstant(this.env.currElement)) {
                this.env.messages.error(Messages.Group.REFERENCE, valueTree, "dc.value.not.allowed.here", new Object[0]);
            }
        } else {
            Element element = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), referenceTree));
            if (!this.isConstant(element)) {
                this.env.messages.error(Messages.Group.REFERENCE, valueTree, "dc.value.not.a.constant", new Object[0]);
            }
        }
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        return (Void)super.visitValue(valueTree, void_);
    }

    private boolean isConstant(Element element) {
        if (element != null && element.getKind() == ElementKind.FIELD) {
            Object object = ((VariableElement)element).getConstantValue();
            return object != null;
        }
        return false;
    }

    @Override
    public Void visitVersion(VersionTree versionTree, Void void_) {
        this.warnIfEmpty(versionTree, versionTree.getBody());
        return (Void)super.visitVersion(versionTree, void_);
    }

    @Override
    public Void visitErroneous(ErroneousTree erroneousTree, Void void_) {
        this.env.messages.error(Messages.Group.SYNTAX, erroneousTree, null, erroneousTree.getDiagnostic().getMessage(null));
        return null;
    }

    private DocTree.Kind getParentKind() {
        return this.getCurrentPath().getParentPath().getLeaf().getKind();
    }

    private boolean isCheckedException(TypeMirror typeMirror) {
        return !this.env.types.isAssignable(typeMirror, this.env.java_lang_Error) && !this.env.types.isAssignable(typeMirror, this.env.java_lang_RuntimeException);
    }

    private boolean isSynthetic() {
        return this.env.elements.getOrigin(this.env.currElement) == Elements.Origin.SYNTHETIC;
    }

    private boolean isAnonymous() {
        TypeElement typeElement;
        Element element = this.env.currElement;
        return element instanceof TypeElement && (typeElement = (TypeElement)element).getNestingKind() == NestingKind.ANONYMOUS;
    }

    private boolean isDefaultConstructor() {
        if (this.env.currElement.getKind() == ElementKind.CONSTRUCTOR) {
            TreePath treePath = this.env.currPath;
            return this.env.getPos(treePath) == this.env.getPos(treePath.getParentPath());
        }
        return false;
    }

    private boolean isDeclaredType() {
        ElementKind elementKind = this.env.currElement.getKind();
        return elementKind.isClass() || elementKind.isInterface();
    }

    private boolean isExecutable() {
        boolean bl;
        ElementKind elementKind = this.env.currElement.getKind();
        switch (elementKind) {
            case METHOD: 
            case CONSTRUCTOR: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isRecordComponentOrField() {
        return this.env.currElement.getKind() == ElementKind.RECORD_COMPONENT || this.env.currElement.getEnclosingElement() != null && this.env.currElement.getEnclosingElement().getKind() == ElementKind.RECORD && this.env.currElement.getKind() == ElementKind.FIELD;
    }

    private boolean isNormalClass(TreePath treePath) {
        boolean bl;
        switch (treePath.getLeaf().getKind()) {
            case ENUM: 
            case RECORD: {
                bl = false;
                break;
            }
            case CLASS: {
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(treePath.getLeaf().getKind().name());
            }
        }
        return bl;
    }

    void markEnclosingTag(Flag flag) {
        TagStackItem tagStackItem = this.tagStack.peek();
        if (tagStackItem != null) {
            tagStackItem.flags.add(flag);
        }
    }

    String toString(TreePath treePath) {
        StringBuilder stringBuilder = new StringBuilder("TreePath[");
        this.toString(treePath, stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    void toString(TreePath treePath, StringBuilder stringBuilder) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            this.toString(treePath2, stringBuilder);
            stringBuilder.append(",");
        }
        stringBuilder.append((Object)treePath.getLeaf().getKind()).append(":").append(this.env.getPos(treePath)).append(":S").append(this.env.getStartPos(treePath));
    }

    void warnIfEmpty(DocTree docTree, List<? extends DocTree> list) {
        for (DocTree docTree2 : list) {
            if (docTree2.getKind() == DocTree.Kind.TEXT && !this.hasNonWhitespace((TextTree)docTree2)) continue;
            return;
        }
        this.env.messages.warning(Messages.Group.MISSING, docTree, "dc.empty", docTree.getKind().tagName);
    }

    boolean hasNonWhitespace(TextTree textTree) {
        return !StringShims.isBlank(textTree.getBody());
    }

    static class TagStackItem {
        final DocTree tree;
        final HtmlTag tag;
        final Set<HtmlTag.Attr> attrs;
        final Set<Flag> flags;

        TagStackItem(DocTree docTree, HtmlTag htmlTag) {
            this.tree = docTree;
            this.tag = htmlTag;
            this.attrs = EnumSet.noneOf(HtmlTag.Attr.class);
            this.flags = EnumSet.noneOf(Flag.class);
        }

        public String toString() {
            return String.valueOf((Object)this.tag);
        }
    }

    public static enum Flag {
        TABLE_HAS_CAPTION,
        TABLE_IS_PRESENTATION,
        HAS_ELEMENT,
        HAS_HEADING,
        HAS_INLINE_TAG,
        HAS_TEXT,
        REPORTED_BAD_INLINE;

    }
}

