/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclint;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.MatchingUtils;
import com.sun.tools.javac.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import jdk.javadoc.internal.doclint.Messages;
import org.frgaal.CollectionShims;

public class Env {
    final Messages messages;
    Set<String> customTags;
    Set<Pattern> includePackages;
    Set<Pattern> excludePackages;
    boolean strictReferenceChecks = false;
    DocTrees trees;
    Elements elements;
    Types types;
    TypeMirror java_lang_Error;
    TypeMirror java_lang_RuntimeException;
    TypeMirror java_lang_SuppressWarnings;
    TypeMirror java_lang_Throwable;
    TypeMirror java_lang_Void;
    TreePath currPath;
    Element currElement;
    DocCommentTree currDocComment;
    AccessKind currAccess;
    Set<? extends ExecutableElement> currOverriddenMethods;
    Map<Element, Set<Messages.Group>> suppressWarnings = new HashMap<Element, Set<Messages.Group>>();

    Env() {
        this.messages = new Messages(this);
    }

    void init(JavacTask javacTask) {
        this.init(DocTrees.instance(javacTask), javacTask.getElements(), javacTask.getTypes());
    }

    void init(DocTrees docTrees, Elements elements, Types types) {
        this.trees = docTrees;
        this.elements = elements;
        this.types = types;
    }

    void initTypes() {
        if (this.java_lang_Error != null) {
            return;
        }
        this.java_lang_Error = this.elements.getTypeElement("java.lang.Error").asType();
        this.java_lang_RuntimeException = this.elements.getTypeElement("java.lang.RuntimeException").asType();
        this.java_lang_SuppressWarnings = this.elements.getTypeElement("java.lang.SuppressWarnings").asType();
        this.java_lang_Throwable = this.elements.getTypeElement("java.lang.Throwable").asType();
        this.java_lang_Void = this.elements.getTypeElement("java.lang.Void").asType();
    }

    void setCustomTags(String string) {
        this.customTags = new LinkedHashSet<String>();
        for (String string2 : string.split(",")) {
            if (string2.isEmpty()) continue;
            this.customTags.add(string2);
        }
    }

    void setCheckPackages(String string) {
        this.includePackages = new HashSet<Pattern>();
        this.excludePackages = new HashSet<Pattern>();
        for (String string2 : string.split(",")) {
            boolean bl = false;
            if (string2.startsWith("-")) {
                string2 = string2.substring(1);
                bl = true;
            }
            if (string2.isEmpty()) continue;
            Pattern pattern = MatchingUtils.validImportStringToPattern(string2);
            if (bl) {
                this.excludePackages.add(pattern);
                continue;
            }
            this.includePackages.add(pattern);
        }
    }

    static boolean validatePackages(String string) {
        for (String string2 : string.split(",")) {
            if (string2.startsWith("-")) {
                string2 = string2.substring(1);
            }
            if (string2.isEmpty() || MatchingUtils.isValidImportString(string2)) continue;
            return false;
        }
        return true;
    }

    void setCurrent(TreePath treePath, DocCommentTree docCommentTree) {
        this.currPath = treePath;
        this.currDocComment = docCommentTree;
        this.currElement = this.trees.getElement(this.currPath);
        this.currOverriddenMethods = ((JavacTypes)this.types).getOverriddenMethods(this.currElement);
        AccessKind accessKind = AccessKind.PUBLIC;
        for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
            Element element = this.trees.getElement(treePath2);
            if (element == null || element.getKind() == ElementKind.PACKAGE || element.getKind() == ElementKind.MODULE) continue;
            accessKind = this.min(accessKind, AccessKind.of(element.getModifiers()));
        }
        this.currAccess = accessKind;
    }

    AccessKind getAccessKind() {
        return this.currAccess;
    }

    long getPos(TreePath treePath) {
        return ((JCTree)treePath.getLeaf()).pos;
    }

    long getStartPos(TreePath treePath) {
        DocSourcePositions docSourcePositions = this.trees.getSourcePositions();
        return docSourcePositions.getStartPosition(treePath.getCompilationUnit(), treePath.getLeaf());
    }

    boolean shouldCheck(CompilationUnitTree compilationUnitTree) {
        String string;
        if (this.includePackages == null) {
            return true;
        }
        String string2 = string = compilationUnitTree.getPackageName() != null ? compilationUnitTree.getPackageName().toString() : "";
        if (!this.includePackages.isEmpty()) {
            boolean bl = false;
            for (Pattern pattern : this.includePackages) {
                if (!pattern.matcher(string).matches()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        for (Pattern pattern : this.excludePackages) {
            if (!pattern.matcher(string).matches()) continue;
            return false;
        }
        return true;
    }

    boolean suppressWarnings(Messages.Group group) {
        return this.suppressWarnings(this.currElement, group);
    }

    boolean suppressWarnings(Element element, Messages.Group group) {
        Element element2 = element.getEnclosingElement();
        if (element2 != null && element2.asType().getKind() == TypeKind.DECLARED && this.suppressWarnings(element2, group)) {
            return true;
        }
        return this.suppressWarnings.computeIfAbsent(element, this::getSuppressedGroups).contains((Object)group);
    }

    private Set<Messages.Group> getSuppressedGroups(Element element) {
        Map map = Arrays.stream(Messages.Group.values()).collect(Collectors.toMap(Messages.Group::optName, Function.identity()));
        EnumSet<Messages.Group> enumSet = EnumSet.noneOf(Messages.Group.class);
        for (String string : this.getSuppressWarningsValue(element)) {
            if (string.equals("doclint")) {
                enumSet = EnumSet.allOf(Messages.Group.class);
                break;
            }
            if (!string.startsWith("doclint:")) continue;
            int n = "doclint:".length();
            for (String string2 : string.substring(n).split(",")) {
                Messages.Group group = (Messages.Group)((Object)map.get(string2));
                if (group == null) continue;
                enumSet.add(group);
            }
        }
        return enumSet;
    }

    private List<String> getSuppressWarningsValue(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            if (!this.types.isSameType(declaredType, this.java_lang_SuppressWarnings)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                AnnotationValue annotationValue;
                ArrayList<String> arrayList;
                if (!entry.getKey().getSimpleName().contentEquals("value") || !((arrayList = (annotationValue = entry.getValue()).getValue()) instanceof List)) continue;
                List list = arrayList;
                arrayList = new ArrayList<String>();
                for (Object e : list) {
                    AnnotationValue annotationValue2;
                    Object object;
                    if (!(e instanceof AnnotationValue) || !((object = (annotationValue2 = (AnnotationValue)e).getValue()) instanceof String)) continue;
                    String string = (String)object;
                    arrayList.add(string);
                }
                return arrayList;
            }
        }
        return CollectionShims.list(new String[0]);
    }

    private <T extends Comparable<T>> T min(T t, T t2) {
        return t == null ? t2 : (t2 == null ? t : (t.compareTo(t2) <= 0 ? t : t2));
    }

    public static enum AccessKind {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC;


        static boolean accepts(String string) {
            for (AccessKind accessKind : AccessKind.values()) {
                if (!string.equals(StringUtils.toLowerCase(accessKind.name()))) continue;
                return true;
            }
            return false;
        }

        static AccessKind of(Set<Modifier> set) {
            if (set.contains((Object)Modifier.PUBLIC)) {
                return PUBLIC;
            }
            if (set.contains((Object)Modifier.PROTECTED)) {
                return PROTECTED;
            }
            if (set.contains((Object)Modifier.PRIVATE)) {
                return PRIVATE;
            }
            return PACKAGE;
        }
    }
}

