/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclint;

import com.sun.tools.javac.util.StringUtils;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Name;
import org.frgaal.CollectionShims;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum HtmlTag {
    A(BlockType.INLINE, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.OK, Attr.HREF, Attr.TARGET, Attr.ID), HtmlTag.attrs(AttrKind.HTML4, Attr.REV, Attr.CHARSET, Attr.SHAPE, Attr.COORDS, Attr.NAME)),
    ABBR(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    ACRONYM(ElemKind.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    ADDRESS(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    ARTICLE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    ASIDE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    B(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    BDI(BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]),
    BIG(ElemKind.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    BLOCKQUOTE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    BODY(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    BR(BlockType.INLINE, EndKind.NONE, HtmlTag.attrs(AttrKind.HTML4, Attr.CLEAR)),
    CAPTION(BlockType.TABLE_ITEM, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    CENTER(ElemKind.HTML4, BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    CITE(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    CODE(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    COL(BlockType.TABLE_ITEM, EndKind.NONE, HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN, Attr.WIDTH)),
    COLGROUP(BlockType.TABLE_ITEM, EndKind.REQUIRED, new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN, Attr.WIDTH)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == COL;
        }
    }
    ,
    DD(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), new AttrMap[0]),
    DEL(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), HtmlTag.attrs(AttrKind.OK, Attr.CITE, Attr.DATETIME)),
    DFN(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    DIV(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    DL(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.COMPACT)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == DT || htmlTag == DD;
        }
    }
    ,
    DT(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_INLINE, Flag.EXPECT_CONTENT), new AttrMap[0]),
    EM(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.NO_NEST), new AttrMap[0]),
    FONT(ElemKind.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), HtmlTag.attrs(AttrKind.HTML4, Attr.SIZE, Attr.COLOR, Attr.FACE)),
    FOOTER(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            switch (htmlTag) {
                case HEADER: 
                case FOOTER: 
                case MAIN: {
                    return false;
                }
            }
            return htmlTag.blockType == BlockType.BLOCK || htmlTag.blockType == BlockType.INLINE;
        }
    }
    ,
    FIGURE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    FIGCAPTION(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    FRAME(ElemKind.HTML4, BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    FRAMESET(ElemKind.HTML4, BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    H1(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    H2(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    H3(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    H4(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    H5(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    H6(BlockType.BLOCK, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    HEAD(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    HEADER(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            switch (htmlTag) {
                case HEADER: 
                case FOOTER: 
                case MAIN: {
                    return false;
                }
            }
            return htmlTag.blockType == BlockType.BLOCK || htmlTag.blockType == BlockType.INLINE;
        }
    }
    ,
    HR(BlockType.BLOCK, EndKind.NONE, HtmlTag.attrs(AttrKind.HTML4, Attr.WIDTH, Attr.ALIGN, Attr.NOSHADE, Attr.SIZE)),
    HTML(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    I(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    IFRAME(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    IMG(BlockType.INLINE, EndKind.NONE, HtmlTag.attrs(AttrKind.OK, Attr.SRC, Attr.ALT, Attr.HEIGHT, Attr.WIDTH, Attr.CROSSORIGIN), HtmlTag.attrs(AttrKind.HTML4, Attr.NAME, Attr.ALIGN, Attr.HSPACE, Attr.VSPACE, Attr.BORDER)),
    INS(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), HtmlTag.attrs(AttrKind.OK, Attr.CITE, Attr.DATETIME)),
    KBD(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    LI(BlockType.LIST_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.OK, Attr.VALUE), HtmlTag.attrs(AttrKind.HTML4, Attr.TYPE)),
    LINK(BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    MAIN(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    MARK(BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]),
    MENU(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == LI;
        }
    }
    ,
    META(BlockType.OTHER, EndKind.NONE, new AttrMap[0]),
    NAV(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    NOFRAMES(ElemKind.HTML4, BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    NOSCRIPT(BlockType.BLOCK, EndKind.REQUIRED, new AttrMap[0]),
    OL(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.START, Attr.TYPE, Attr.REVERSED), HtmlTag.attrs(AttrKind.HTML4, Attr.COMPACT)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == LI;
        }
    }
    ,
    P(BlockType.BLOCK, EndKind.OPTIONAL, EnumSet.of(Flag.EXPECT_CONTENT), HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN)),
    PRE(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.WIDTH)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            switch (htmlTag) {
                case IMG: 
                case BIG: 
                case SMALL: 
                case SUB: 
                case SUP: {
                    return false;
                }
            }
            return htmlTag.blockType == BlockType.INLINE;
        }
    }
    ,
    Q(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    S(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    SAMP(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    SCRIPT(BlockType.OTHER, EndKind.REQUIRED, HtmlTag.attrs(AttrKind.OK, Attr.SRC)),
    SECTION(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    SMALL(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    SPAN(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    STRIKE(ElemKind.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    STRONG(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[0]),
    STYLE(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    SUB(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    SUP(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    TABLE(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.OK, Attr.BORDER), HtmlTag.attrs(AttrKind.HTML4, Attr.SUMMARY, Attr.CELLPADDING, Attr.CELLSPACING, Attr.FRAME, Attr.RULES, Attr.WIDTH, Attr.ALIGN, Attr.BGCOLOR)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            switch (htmlTag) {
                case CAPTION: 
                case COLGROUP: 
                case THEAD: 
                case TBODY: 
                case TFOOT: 
                case TR: {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    TBODY(BlockType.TABLE_ITEM, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.VALIGN, Attr.CHAR, Attr.CHAROFF)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == TR;
        }
    }
    ,
    TD(BlockType.TABLE_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.OK, Attr.COLSPAN, Attr.ROWSPAN, Attr.HEADERS), HtmlTag.attrs(AttrKind.HTML4, Attr.AXIS, Attr.ABBR, Attr.SCOPE, Attr.ALIGN, Attr.VALIGN, Attr.CHAR, Attr.CHAROFF, Attr.WIDTH, Attr.BGCOLOR, Attr.HEIGHT, Attr.NOWRAP)),
    TEMPLATE(BlockType.BLOCK, EndKind.REQUIRED, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), new AttrMap[0]),
    TFOOT(BlockType.TABLE_ITEM, EndKind.REQUIRED, new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.VALIGN, Attr.CHAR, Attr.CHAROFF)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == TR;
        }
    }
    ,
    TH(BlockType.TABLE_ITEM, EndKind.OPTIONAL, EnumSet.of(Flag.ACCEPTS_BLOCK, Flag.ACCEPTS_INLINE), HtmlTag.attrs(AttrKind.OK, Attr.COLSPAN, Attr.ROWSPAN, Attr.HEADERS, Attr.SCOPE, Attr.ABBR), HtmlTag.attrs(AttrKind.HTML4, Attr.WIDTH, Attr.BGCOLOR, Attr.HEIGHT, Attr.NOWRAP, Attr.AXIS, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.VALIGN)),
    THEAD(BlockType.TABLE_ITEM, EndKind.REQUIRED, new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.VALIGN, Attr.CHAR, Attr.CHAROFF)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == TR;
        }
    }
    ,
    TIME(BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]),
    TITLE(BlockType.OTHER, EndKind.REQUIRED, new AttrMap[0]),
    TR(BlockType.TABLE_ITEM, EndKind.OPTIONAL, new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.ALIGN, Attr.CHAR, Attr.CHAROFF, Attr.BGCOLOR, Attr.VALIGN)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == TH || htmlTag == TD;
        }
    }
    ,
    TT(ElemKind.HTML4, BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    U(BlockType.INLINE, EndKind.REQUIRED, EnumSet.of(Flag.EXPECT_CONTENT, Flag.NO_NEST), new AttrMap[0]),
    UL(BlockType.BLOCK, EndKind.REQUIRED, (Set)EnumSet.of(Flag.EXPECT_CONTENT), new AttrMap[]{HtmlTag.attrs(AttrKind.HTML4, Attr.COMPACT, Attr.TYPE)}){

        @Override
        public boolean accepts(HtmlTag htmlTag) {
            return htmlTag == LI;
        }
    }
    ,
    WBR(BlockType.INLINE, EndKind.NONE, new AttrMap[0]),
    VAR(BlockType.INLINE, EndKind.REQUIRED, new AttrMap[0]);

    public final ElemKind elemKind;
    public final BlockType blockType;
    public final EndKind endKind;
    public final Set<Flag> flags;
    private final Map<Attr, AttrKind> attrs;
    private static final Map<String, HtmlTag> index;

    private HtmlTag(BlockType blockType, EndKind endKind, AttrMap ... attrMapArray) {
        this(ElemKind.OK, blockType, endKind, CollectionShims.set(new Flag[0]), attrMapArray);
    }

    private HtmlTag(ElemKind elemKind, BlockType blockType, EndKind endKind, AttrMap ... attrMapArray) {
        this(elemKind, blockType, endKind, CollectionShims.set(new Flag[0]), attrMapArray);
    }

    private HtmlTag(BlockType blockType, EndKind endKind, Set<Flag> set, AttrMap ... attrMapArray) {
        this(ElemKind.OK, blockType, endKind, set, attrMapArray);
    }

    private HtmlTag(ElemKind elemKind, BlockType blockType, EndKind endKind, Set<Flag> set, AttrMap ... attrMapArray) {
        this.elemKind = elemKind;
        this.blockType = blockType;
        this.endKind = endKind;
        this.flags = set;
        this.attrs = new EnumMap<Attr, AttrKind>(Attr.class);
        for (AttrMap attrMap : attrMapArray) {
            this.attrs.putAll(attrMap);
        }
        this.attrs.put(Attr.CLASS, AttrKind.OK);
        this.attrs.put(Attr.ID, AttrKind.OK);
        this.attrs.put(Attr.STYLE, AttrKind.OK);
        this.attrs.put(Attr.ROLE, AttrKind.OK);
        this.attrs.put(Attr.ARIA_ACTIVEDESCENDANT, AttrKind.OK);
        this.attrs.put(Attr.ARIA_CONTROLS, AttrKind.OK);
        this.attrs.put(Attr.ARIA_DESCRIBEDBY, AttrKind.OK);
        this.attrs.put(Attr.ARIA_EXPANDED, AttrKind.OK);
        this.attrs.put(Attr.ARIA_LABEL, AttrKind.OK);
        this.attrs.put(Attr.ARIA_LABELLEDBY, AttrKind.OK);
        this.attrs.put(Attr.ARIA_LEVEL, AttrKind.OK);
        this.attrs.put(Attr.ARIA_MULTISELECTABLE, AttrKind.OK);
        this.attrs.put(Attr.ARIA_OWNS, AttrKind.OK);
        this.attrs.put(Attr.ARIA_POSINSET, AttrKind.OK);
        this.attrs.put(Attr.ARIA_READONLY, AttrKind.OK);
        this.attrs.put(Attr.ARIA_REQUIRED, AttrKind.OK);
        this.attrs.put(Attr.ARIA_SELECTED, AttrKind.OK);
        this.attrs.put(Attr.ARIA_SETSIZE, AttrKind.OK);
        this.attrs.put(Attr.ARIA_SORT, AttrKind.OK);
    }

    public boolean accepts(HtmlTag htmlTag) {
        if (this.flags.contains((Object)Flag.ACCEPTS_BLOCK) && this.flags.contains((Object)Flag.ACCEPTS_INLINE)) {
            return htmlTag.blockType == BlockType.BLOCK || htmlTag.blockType == BlockType.INLINE;
        }
        if (this.flags.contains((Object)Flag.ACCEPTS_BLOCK)) {
            return htmlTag.blockType == BlockType.BLOCK;
        }
        if (this.flags.contains((Object)Flag.ACCEPTS_INLINE)) {
            return htmlTag.blockType == BlockType.INLINE;
        }
        switch (this.blockType) {
            case BLOCK: 
            case INLINE: {
                return htmlTag.blockType == BlockType.INLINE;
            }
            case OTHER: {
                return true;
            }
        }
        throw new AssertionError((Object)((Object)((Object)this) + ":" + (Object)((Object)htmlTag)));
    }

    public boolean acceptsText() {
        return this.accepts(B);
    }

    public String getText() {
        return StringUtils.toLowerCase(this.name());
    }

    public Attr getAttr(Name name) {
        return Attr.index.get(StringUtils.toLowerCase(name.toString()));
    }

    public AttrKind getAttrKind(Name name) {
        AttrKind attrKind = this.attrs.get((Object)this.getAttr(name));
        return attrKind == null ? AttrKind.INVALID : attrKind;
    }

    private static AttrMap attrs(AttrKind attrKind, Attr ... attrArray) {
        AttrMap attrMap = new AttrMap();
        for (Attr attr : attrArray) {
            attrMap.put(attr, attrKind);
        }
        return attrMap;
    }

    public static HtmlTag get(Name name) {
        return index.get(StringUtils.toLowerCase(name.toString()));
    }

    static {
        index = new HashMap<String, HtmlTag>();
        for (HtmlTag htmlTag : HtmlTag.values()) {
            index.put(htmlTag.getText(), htmlTag);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum BlockType {
        BLOCK,
        INLINE,
        LIST_ITEM,
        TABLE_ITEM,
        OTHER;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum EndKind {
        NONE,
        OPTIONAL,
        REQUIRED;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AttrMap
    extends EnumMap<Attr, AttrKind> {
        private static final long serialVersionUID = 0L;

        AttrMap() {
            super(Attr.class);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum ElemKind {
        OK,
        INVALID,
        OBSOLETE,
        HTML4;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Flag {
        ACCEPTS_BLOCK,
        ACCEPTS_INLINE,
        EXPECT_CONTENT,
        NO_NEST;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Attr {
        ABBR,
        ALIGN,
        ALINK,
        ALT,
        ARIA_ACTIVEDESCENDANT,
        ARIA_CONTROLS,
        ARIA_DESCRIBEDBY,
        ARIA_EXPANDED,
        ARIA_LABEL,
        ARIA_LABELLEDBY,
        ARIA_LEVEL,
        ARIA_MULTISELECTABLE,
        ARIA_OWNS,
        ARIA_POSINSET,
        ARIA_SETSIZE,
        ARIA_READONLY,
        ARIA_REQUIRED,
        ARIA_SELECTED,
        ARIA_SORT,
        AXIS,
        BACKGROUND,
        BGCOLOR,
        BORDER,
        CELLSPACING,
        CELLPADDING,
        CHAR,
        CHAROFF,
        CHARSET,
        CITE,
        CLEAR,
        CLASS,
        COLOR,
        COLSPAN,
        COMPACT,
        COORDS,
        CROSSORIGIN,
        DATETIME,
        FACE,
        FRAME,
        FRAMEBORDER,
        HEADERS,
        HEIGHT,
        HREF,
        HSPACE,
        ID,
        LINK,
        LONGDESC,
        MARGINHEIGHT,
        MARGINWIDTH,
        NAME,
        NOSHADE,
        NOWRAP,
        PROFILE,
        REV,
        REVERSED,
        ROLE,
        ROWSPAN,
        RULES,
        SCHEME,
        SCOPE,
        SCROLLING,
        SHAPE,
        SIZE,
        SPACE,
        SRC,
        START,
        STYLE,
        SUMMARY,
        TARGET,
        TEXT,
        TYPE,
        VALIGN,
        VALUE,
        VERSION,
        VLINK,
        VSPACE,
        WIDTH;

        private final String name = StringUtils.toLowerCase(this.name().replace("_", "-"));
        static final Map<String, Attr> index;

        public String getText() {
            return this.name;
        }

        static {
            index = new HashMap<String, Attr>();
            for (Attr attr : Attr.values()) {
                index.put(attr.getText(), attr);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum AttrKind {
        OK,
        INVALID,
        OBSOLETE,
        HTML4;

    }
}

