/*
 * Decompiled with CFR 0.152.
 */
package org.frgaal;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;

public class AbstractMain {
    private static ClassLoader FRGAAL_CL;

    protected static int doRun(Run run) {
        System.setProperty("frgaal.disable.java.class.path", "true");
        try {
            return run.run(AbstractMain.getFrgaalCL());
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            System.err.println("An internal error occurred, please report a bug:");
            exception.printStackTrace();
            return 1;
        }
    }

    private static synchronized ClassLoader getFrgaalCL() {
        if (FRGAAL_CL == null) {
            Object object;
            URL uRL;
            CodeSource codeSource = AbstractMain.class.getProtectionDomain().getCodeSource();
            URL uRL2 = uRL = codeSource != null ? codeSource.getLocation() : null;
            if (uRL == null) {
                throw new IllegalStateException("Cannot find frgaal compiler, stopping.");
            }
            ArrayList<URL> arrayList = new ArrayList<URL>();
            arrayList.add(uRL);
            try {
                object = Class.forName("org.frgaal.javadoc.Main", false, AbstractMain.class.getClassLoader());
                codeSource = ((Class)object).getProtectionDomain().getCodeSource();
                URL uRL3 = uRL = codeSource != null ? codeSource.getLocation() : null;
                if (uRL != null) {
                    arrayList.add(uRL);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            object = AbstractMain.class.getClassLoader().getParent();
            FRGAAL_CL = new URLClassLoader(arrayList.toArray(new URL[0]), (ClassLoader)new FilteringCL((ClassLoader)object));
        }
        return FRGAAL_CL;
    }

    public static interface Run {
        public int run(ClassLoader var1) throws ReflectiveOperationException;
    }

    private static final class FilteringCL
    extends ClassLoader {
        FilteringCL(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (string.startsWith("javax.annotation.processing") || string.startsWith("javax.lang.model.") || string.startsWith("javax.tools.") || string.startsWith("com.sun.source.") || string.startsWith("com.sun.tools.javac.") || string.startsWith("com.sun.tools.doclint.") || string.startsWith("jdk.javadoc.") || string.startsWith("sun.reflect.annotation.")) {
                throw new ClassNotFoundException();
            }
            return super.loadClass(string, bl);
        }
    }
}

