/*
 * Decompiled with CFR 0.152.
 */
package org.frgaal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CollectionShims {
    @SafeVarargs
    public static <T> List<T> list(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static <T> List<T> listCopyOf(List<T> list) {
        return CollectionShims.list(list.toArray());
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... TArray) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(TArray)));
    }

    public static <T> Set<T> setCopyOf(Set<? extends T> set) {
        return CollectionShims.set(set.toArray());
    }

    public static <K, V> Map<K, V> map() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> map(K k, V v) {
        return Collections.singletonMap(k, v);
    }

    public static <K, V> Map<K, V> mapCopyOf(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    public static <K, V> Map.Entry<K, V> mapEntry(K k, V v) {
        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        final class EntryImpl<K, V>
        implements Map.Entry<K, V> {
            private final K k;
            private final V v;

            public EntryImpl(K k, V v) {
                Objects.requireNonNull(k);
                Objects.requireNonNull(v);
                this.k = k;
                this.v = v;
            }

            @Override
            public K getKey() {
                return this.k();
            }

            @Override
            public V getValue() {
                return this.v();
            }

            @Override
            public V setValue(V v) {
                throw new UnsupportedOperationException();
            }

            public final String toString() {
                return "EntryImpl[" + "k=" + Objects.toString(this.k) + ", v=" + Objects.toString(this.v) + "]";
            }

            @Override
            public final int hashCode() {
                return 31 * (31 * 0 + Objects.hashCode(this.k)) + Objects.hashCode(this.v);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final boolean equals(Object object) {
                if (!(object instanceof EntryImpl)) return false;
                EntryImpl entryImpl = (EntryImpl)object;
                if (!Objects.equals(this.v, entryImpl.v)) return false;
                if (!Objects.equals(this.k, entryImpl.k)) return false;
                return true;
            }

            public K k() {
                return this.k;
            }

            public V v() {
                return this.v;
            }
        }
        return new EntryImpl<K, V>(k, v);
    }
}

