/*
 * Decompiled with CFR 0.152.
 */
package org.frgaal;

import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StringShims {
    public static String stripIndent(String string2) {
        int n = string2.length();
        if (n == 0) {
            return "";
        }
        char c = string2.charAt(n - 1);
        boolean bl = c == '\n' || c == '\r';
        List<String> list = StringShims.lines(string2).collect(Collectors.toList());
        int n2 = bl ? 0 : StringShims.outdent(list);
        return list.stream().map(string -> {
            int n2 = StringShims.indexOfNonWhitespace(string);
            int n3 = StringShims.lastIndexOfNonWhitespace(string);
            int n4 = Math.min(n2, n2);
            return n2 > n3 ? "" : string.substring(n4, n3);
        }).collect(Collectors.joining("\n", "", bl ? "\n" : ""));
    }

    private static int outdent(List<String> list) {
        int n = Integer.MAX_VALUE;
        for (String string : list) {
            int n2 = StringShims.indexOfNonWhitespace(string);
            if (n2 == string.length()) continue;
            n = Integer.min(n, n2);
        }
        String string = list.get(list.size() - 1);
        if (StringShims.isBlank(string)) {
            n = Integer.min(n, string.length());
        }
        return n;
    }

    public static String translateEscapes(String string) {
        if (string.isEmpty()) {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        block12: while (n2 < n) {
            char c;
            if ((c = cArray[n2++]) == '\\') {
                c = n2 < n ? cArray[n2++] : (char)'\u0000';
                switch (c) {
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 's': {
                        c = ' ';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int n4 = Integer.min(n2 + (c <= '3' ? 2 : 1), n);
                        int n5 = c - 48;
                        while (n2 < n4 && (c = cArray[n2]) >= '0' && '7' >= c) {
                            ++n2;
                            n5 = n5 << 3 | c - 48;
                        }
                        c = (char)n5;
                        break;
                    }
                    case '\n': {
                        continue block12;
                    }
                    case '\r': {
                        if (n2 >= n || cArray[n2] != '\n') continue block12;
                        ++n2;
                        continue block12;
                    }
                    default: {
                        String string2 = String.format("Invalid escape sequence: \\%c \\\\u%04X", Character.valueOf(c), (int)c);
                        throw new IllegalArgumentException(string2);
                    }
                }
            }
            cArray[n3++] = c;
        }
        return new String(cArray, 0, n3);
    }

    private static int indexOfNonWhitespace(String string) {
        return StringShims.indexOfNonWhitespace(string.toCharArray());
    }

    private static int lastIndexOfNonWhitespace(String string) {
        return StringShims.lastIndexOfNonWhitespace(string.toCharArray());
    }

    public static boolean isBlank(String string) {
        return StringShims.indexOfNonWhitespace(string) == string.length();
    }

    public static String stripLeading(String string) {
        String string2 = StringShims.stripLeading(string.toCharArray());
        return string2 == null ? string : string2;
    }

    public static String stripLeading(char[] cArray) {
        int n = cArray.length;
        int n2 = StringShims.indexOfNonWhitespace(cArray);
        if (n2 == n) {
            return "";
        }
        return n2 != 0 ? StringShims.newString(cArray, n2, n - n2) : null;
    }

    public static String stripTrailing(String string) {
        String string2 = StringShims.stripTrailing(string.toCharArray());
        return string2 == null ? string : string2;
    }

    public static String stripTrailing(char[] cArray) {
        int n = cArray.length >>> 1;
        int n2 = StringShims.lastIndexOfNonWhitespace(cArray);
        return n2 != n ? StringShims.newString(cArray, 0, n2) : null;
    }

    public static int indexOfNonWhitespace(char[] cArray) {
        int n;
        int n2;
        int n3 = cArray.length;
        for (n = 0; n < n3 && ((n2 = StringShims.codePointAt(cArray, n, n3)) == 32 || n2 == 9 || Character.isWhitespace(n2)); n += Character.charCount(n2)) {
        }
        return n;
    }

    private static int codePointAt(char[] cArray, int n, int n2, boolean bl) {
        char c;
        assert (n < n2);
        if (bl) {
            StringShims.checkIndex(n, cArray);
        }
        if (Character.isHighSurrogate(c = StringShims.getChar(cArray, n)) && ++n < n2) {
            char c2;
            if (bl) {
                StringShims.checkIndex(n, cArray);
            }
            if (Character.isLowSurrogate(c2 = StringShims.getChar(cArray, n))) {
                return Character.toCodePoint(c, c2);
            }
        }
        return c;
    }

    public static int codePointAt(char[] cArray, int n, int n2) {
        return StringShims.codePointAt(cArray, n, n2, false);
    }

    public static int lastIndexOfNonWhitespace(char[] cArray) {
        int n;
        int n2;
        int n3;
        for (n2 = n = cArray.length; 0 < n2 && ((n3 = StringShims.codePointBefore(cArray, n2)) == 32 || n3 == 9 || Character.isWhitespace(n3)); n2 -= Character.charCount(n3)) {
        }
        return n2;
    }

    public static int codePointBefore(char[] cArray, int n) {
        return StringShims.codePointBefore(cArray, n, false);
    }

    private static int codePointBefore(char[] cArray, int n, boolean bl) {
        char c;
        --n;
        if (bl) {
            StringShims.checkIndex(n, cArray);
        }
        if (Character.isLowSurrogate(c = StringShims.getChar(cArray, n)) && n > 0) {
            char c2;
            --n;
            if (bl) {
                StringShims.checkIndex(n, cArray);
            }
            if (Character.isHighSurrogate(c2 = StringShims.getChar(cArray, n))) {
                return Character.toCodePoint(c2, c);
            }
        }
        return c;
    }

    public static void checkIndex(int n, char[] cArray) {
        StringShims.checkIndex(n, StringShims.length(cArray));
    }

    static void checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new StringIndexOutOfBoundsException("index " + n + ",length " + n2);
        }
    }

    static char getChar(char[] cArray, int n) {
        assert (n >= 0 && n < StringShims.length(cArray)) : "Trusted caller missed bounds check";
        return cArray[n];
    }

    public static int length(char[] cArray) {
        return cArray.length;
    }

    public static String newString(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static Stream<String> lines(String string) {
        return StringShims.lines(string.toCharArray());
    }

    static Stream<String> lines(char[] cArray) {
        return StreamSupport.stream(LinesSpliterator.spliterator(cArray), false);
    }

    public static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String strip(String string) {
        return StringShims.stripLeading(StringShims.stripTrailing(string));
    }

    private static final class LinesSpliterator
    implements Spliterator<String> {
        private char[] value;
        private int index;
        private final int fence;

        private LinesSpliterator(char[] cArray, int n, int n2) {
            this.value = cArray;
            this.index = n;
            this.fence = n + n2;
        }

        private int indexOfLineSeparator(int n) {
            for (int i = n; i < this.fence; ++i) {
                char c = StringShims.getChar(this.value, i);
                if (c != '\n' && c != '\r') continue;
                return i;
            }
            return this.fence;
        }

        private int skipLineSeparator(int n) {
            if (n < this.fence) {
                int n2;
                if (StringShims.getChar(this.value, n) == '\r' && (n2 = n + 1) < this.fence && StringShims.getChar(this.value, n2) == '\n') {
                    return n2 + 1;
                }
                return n + 1;
            }
            return this.fence;
        }

        private String next() {
            int n = this.index;
            int n2 = this.indexOfLineSeparator(n);
            this.index = this.skipLineSeparator(n2);
            return StringShims.newString(this.value, n, n2 - n);
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> consumer) {
            if (consumer == null) {
                throw new NullPointerException("tryAdvance action missing");
            }
            if (this.index != this.fence) {
                consumer.accept(this.next());
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super String> consumer) {
            if (consumer == null) {
                throw new NullPointerException("forEachRemaining action missing");
            }
            while (this.index != this.fence) {
                consumer.accept(this.next());
            }
        }

        @Override
        public Spliterator<String> trySplit() {
            int n = this.fence + this.index >>> 1;
            int n2 = this.skipLineSeparator(this.indexOfLineSeparator(n));
            if (n2 < this.fence) {
                int n3 = this.index;
                this.index = n2;
                return new LinesSpliterator(this.value, n3, n2 - n3);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index + 1;
        }

        @Override
        public int characteristics() {
            return 1296;
        }

        static LinesSpliterator spliterator(char[] cArray) {
            return new LinesSpliterator(cArray, 0, cArray.length);
        }
    }
}

