/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.AnnotationTypeMismatchExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;

class AnnotationInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 6182022883658399397L;
    private final Class<? extends Annotation> type;
    private final Map<String, Object> memberValues;
    private volatile transient Method[] memberMethods;

    AnnotationInvocationHandler(Class<? extends Annotation> clazz, Map<String, Object> map) {
        Class<?>[] classArray = clazz.getInterfaces();
        if (!clazz.isAnnotation() || classArray.length != 1 || classArray[0] != Annotation.class) {
            throw new AnnotationFormatError("Attempt to create proxy for a non-annotation type.");
        }
        this.type = clazz;
        this.memberValues = map;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        int n = method.getParameterCount();
        if (n == 1 && string == "equals" && method.getParameterTypes()[0] == Object.class) {
            return this.equalsImpl(object, objectArray[0]);
        }
        if (n != 0) {
            throw new AssertionError((Object)"Too many parameters for an annotation method");
        }
        if (string == "toString") {
            return this.toStringImpl();
        }
        if (string == "hashCode") {
            return this.hashCodeImpl();
        }
        if (string == "annotationType") {
            return this.type;
        }
        Object object2 = this.memberValues.get(string);
        if (object2 == null) {
            throw new IncompleteAnnotationException(this.type, string);
        }
        if (object2 instanceof ExceptionProxy) {
            throw ((ExceptionProxy)object2).generateException();
        }
        if (object2.getClass().isArray() && Array.getLength(object2) != 0) {
            object2 = this.cloneArray(object2);
        }
        return object2;
    }

    private Object cloneArray(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            byte[] byArray = (byte[])object;
            return byArray.clone();
        }
        if (clazz == char[].class) {
            char[] cArray = (char[])object;
            return cArray.clone();
        }
        if (clazz == double[].class) {
            double[] dArray = (double[])object;
            return dArray.clone();
        }
        if (clazz == float[].class) {
            float[] fArray = (float[])object;
            return fArray.clone();
        }
        if (clazz == int[].class) {
            int[] nArray = (int[])object;
            return nArray.clone();
        }
        if (clazz == long[].class) {
            long[] lArray = (long[])object;
            return lArray.clone();
        }
        if (clazz == short[].class) {
            short[] sArray = (short[])object;
            return sArray.clone();
        }
        if (clazz == boolean[].class) {
            boolean[] blArray = (boolean[])object;
            return blArray.clone();
        }
        Object[] objectArray = (Object[])object;
        return objectArray.clone();
    }

    private String toStringImpl() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('@');
        stringBuilder.append(this.type.getName());
        stringBuilder.append('(');
        boolean bl = true;
        Set<Map.Entry<String, Object>> set = this.memberValues.entrySet();
        boolean bl2 = set.size() == 1;
        for (Map.Entry<String, Object> entry : set) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = entry.getKey();
            if (!bl2 || !"value".equals(string)) {
                stringBuilder.append(string);
                stringBuilder.append('=');
            }
            bl2 = false;
            stringBuilder.append(AnnotationInvocationHandler.memberValueToString(entry.getValue()));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String memberValueToString(Object object) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            if (clazz == Class.class) {
                return AnnotationInvocationHandler.toSourceString((Class)object);
            }
            if (clazz == String.class) {
                return AnnotationInvocationHandler.toSourceString((String)object);
            }
            if (clazz == Character.class) {
                return AnnotationInvocationHandler.toSourceString(((Character)object).charValue());
            }
            if (clazz == Double.class) {
                return AnnotationInvocationHandler.toSourceString((Double)object);
            }
            if (clazz == Float.class) {
                return AnnotationInvocationHandler.toSourceString(((Float)object).floatValue());
            }
            if (clazz == Long.class) {
                return AnnotationInvocationHandler.toSourceString((Long)object);
            }
            if (clazz == Byte.class) {
                return AnnotationInvocationHandler.toSourceString((Byte)object);
            }
            return object.toString();
        }
        Stream<String> stream = clazz == byte[].class ? AnnotationInvocationHandler.convert((byte[])object) : (clazz == char[].class ? AnnotationInvocationHandler.convert((char[])object) : (clazz == double[].class ? DoubleStream.of((double[])object).mapToObj(AnnotationInvocationHandler::toSourceString) : (clazz == float[].class ? AnnotationInvocationHandler.convert((float[])object) : (clazz == int[].class ? IntStream.of((int[])object).mapToObj(String::valueOf) : (clazz == long[].class ? LongStream.of((long[])object).mapToObj(AnnotationInvocationHandler::toSourceString) : (clazz == short[].class ? AnnotationInvocationHandler.convert((short[])object) : (clazz == boolean[].class ? AnnotationInvocationHandler.convert((boolean[])object) : (clazz == Class[].class ? Arrays.stream((Class[])object).map(AnnotationInvocationHandler::toSourceString) : (clazz == String[].class ? Arrays.stream((String[])object).map(AnnotationInvocationHandler::toSourceString) : Arrays.stream((Object[])object).map(Objects::toString))))))))));
        return AnnotationInvocationHandler.stringStreamToString(stream);
    }

    private static String toSourceString(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        StringBuilder stringBuilder = new StringBuilder();
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            stringBuilder.append("[]");
        }
        return clazz2.getName() + stringBuilder.toString() + ".class";
    }

    private static String toSourceString(float f) {
        if (Float.isFinite(f)) {
            return Float.toString(f) + "f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        return "0.0f/0.0f";
    }

    private static String toSourceString(double d) {
        if (Double.isFinite(d)) {
            return Double.toString(d);
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        return "0.0/0.0";
    }

    private static String toSourceString(char c) {
        StringBuilder stringBuilder = new StringBuilder(4);
        stringBuilder.append('\'');
        stringBuilder.append(AnnotationInvocationHandler.quote(c));
        return stringBuilder.append('\'').toString();
    }

    private static String quote(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return AnnotationInvocationHandler.isPrintableAscii(c) ? String.valueOf(c) : String.format("\\u%04x", c);
    }

    private static boolean isPrintableAscii(char c) {
        return c >= ' ' && c <= '~';
    }

    private static String toSourceString(byte by) {
        return String.format("(byte)0x%02x", by);
    }

    private static String toSourceString(long l) {
        return String.valueOf(l) + "L";
    }

    private static String toSourceString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(AnnotationInvocationHandler.quote(string.charAt(i)));
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private static Stream<String> convert(byte[] byArray) {
        ArrayList<String> arrayList = new ArrayList<String>(byArray.length);
        for (byte by : byArray) {
            arrayList.add(AnnotationInvocationHandler.toSourceString(by));
        }
        return arrayList.stream();
    }

    private static Stream<String> convert(char[] cArray) {
        ArrayList<String> arrayList = new ArrayList<String>(cArray.length);
        for (char c : cArray) {
            arrayList.add(AnnotationInvocationHandler.toSourceString(c));
        }
        return arrayList.stream();
    }

    private static Stream<String> convert(float[] fArray) {
        ArrayList<String> arrayList = new ArrayList<String>(fArray.length);
        for (float f : fArray) {
            arrayList.add(AnnotationInvocationHandler.toSourceString(f));
        }
        return arrayList.stream();
    }

    private static Stream<String> convert(short[] sArray) {
        ArrayList<String> arrayList = new ArrayList<String>(sArray.length);
        for (short s : sArray) {
            arrayList.add(Short.toString(s));
        }
        return arrayList.stream();
    }

    private static Stream<String> convert(boolean[] blArray) {
        ArrayList<String> arrayList = new ArrayList<String>(blArray.length);
        for (boolean bl : blArray) {
            arrayList.add(Boolean.toString(bl));
        }
        return arrayList.stream();
    }

    private static String stringStreamToString(Stream<String> stream) {
        return stream.collect(Collectors.joining(", ", "{", "}"));
    }

    private Boolean equalsImpl(Object object, Object object2) {
        if (object2 == object) {
            return true;
        }
        if (!this.type.isInstance(object2)) {
            return false;
        }
        for (Method method : this.getMemberMethods()) {
            String string = method.getName();
            Object object3 = this.memberValues.get(string);
            Object object4 = null;
            AnnotationInvocationHandler annotationInvocationHandler = this.asOneOfUs(object2);
            if (annotationInvocationHandler != null) {
                object4 = annotationInvocationHandler.memberValues.get(string);
            } else {
                try {
                    object4 = method.invoke(object2, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
            }
            if (AnnotationInvocationHandler.memberValueEquals(object3, object4)) continue;
            return false;
        }
        return true;
    }

    private AnnotationInvocationHandler asOneOfUs(Object object) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof AnnotationInvocationHandler) {
            return (AnnotationInvocationHandler)invocationHandler;
        }
        return null;
    }

    private static boolean memberValueEquals(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object.equals(object2);
        }
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        if (object2.getClass() != clazz) {
            return false;
        }
        if (clazz == byte[].class) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (clazz == char[].class) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (clazz == double[].class) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (clazz == float[].class) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (clazz == int[].class) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (clazz == long[].class) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (clazz == short[].class) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        assert (clazz == boolean[].class);
        return Arrays.equals((boolean[])object, (boolean[])object2);
    }

    private Method[] getMemberMethods() {
        Method[] methodArray = this.memberMethods;
        if (methodArray == null) {
            methodArray = this.computeMemberMethods();
            this.memberMethods = methodArray;
        }
        return methodArray;
    }

    private Method[] computeMemberMethods() {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                AccessibleObject[] accessibleObjectArray = AnnotationInvocationHandler.this.type.getDeclaredMethods();
                AnnotationInvocationHandler.this.validateAnnotationMethods((Method[])accessibleObjectArray);
                AccessibleObject.setAccessible(accessibleObjectArray, true);
                return accessibleObjectArray;
            }
        });
    }

    private void validateAnnotationMethods(Method[] methodArray) {
        boolean bl = true;
        for (Method method : methodArray) {
            if (method.getModifiers() != 1025 || method.isDefault() || method.getParameterCount() != 0 || method.getExceptionTypes().length != 0) {
                bl = false;
                break;
            }
            Class<?> clazz = method.getReturnType();
            if (clazz.isArray() && (clazz = clazz.getComponentType()).isArray()) {
                bl = false;
                break;
            }
            if (!(clazz.isPrimitive() && clazz != Void.TYPE || clazz == String.class || clazz == Class.class || clazz.isEnum() || clazz.isAnnotation())) {
                bl = false;
                break;
            }
            String string = method.getName();
            if (!(string.equals("toString") && clazz == String.class || string.equals("hashCode") && clazz == Integer.TYPE) && (!string.equals("annotationType") || clazz != Class.class)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        throw new AnnotationFormatError("Malformed method on an annotation type");
    }

    private int hashCodeImpl() {
        int n = 0;
        for (Map.Entry<String, Object> entry : this.memberValues.entrySet()) {
            n += 127 * entry.getKey().hashCode() ^ AnnotationInvocationHandler.memberValueHashCode(entry.getValue());
        }
        return n;
    }

    private static int memberValueHashCode(Object object) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object.hashCode();
        }
        if (clazz == byte[].class) {
            return Arrays.hashCode((byte[])object);
        }
        if (clazz == char[].class) {
            return Arrays.hashCode((char[])object);
        }
        if (clazz == double[].class) {
            return Arrays.hashCode((double[])object);
        }
        if (clazz == float[].class) {
            return Arrays.hashCode((float[])object);
        }
        if (clazz == int[].class) {
            return Arrays.hashCode((int[])object);
        }
        if (clazz == long[].class) {
            return Arrays.hashCode((long[])object);
        }
        if (clazz == short[].class) {
            return Arrays.hashCode((short[])object);
        }
        if (clazz == boolean[].class) {
            return Arrays.hashCode((boolean[])object);
        }
        return Arrays.hashCode((Object[])object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Class clazz = (Class)getField.get("type", null);
        Map map = (Map)getField.get("memberValues", null);
        AnnotationType annotationType = null;
        try {
            annotationType = AnnotationType.getInstance(clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException("Non-annotation type in annotation serial stream");
        }
        Map<String, Class<?>> map2 = annotationType.memberTypes();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object object = null;
            Class<?> clazz2 = map2.get(string);
            if (clazz2 != null && !clazz2.isInstance(object = (Object)entry.getValue()) && !(object instanceof ExceptionProxy)) {
                object = new AnnotationTypeMismatchExceptionProxy(object.getClass() + "[" + object + "]").setMember(annotationType.members().get(string));
            }
            linkedHashMap.put(string, object);
        }
        UnsafeAccessor.setType(this, clazz);
        UnsafeAccessor.setMemberValues(this, linkedHashMap);
    }

    private static class UnsafeAccessor {
        private UnsafeAccessor() {
        }

        static void setType(AnnotationInvocationHandler annotationInvocationHandler, Class<? extends Annotation> clazz) {
            try {
                Field field = AnnotationInvocationHandler.class.getDeclaredField("type");
                field.setAccessible(true);
                field.set(annotationInvocationHandler, clazz);
            }
            catch (ReflectiveOperationException | SecurityException exception) {
                throw new IllegalStateException();
            }
        }

        static void setMemberValues(AnnotationInvocationHandler annotationInvocationHandler, Map<String, Object> map) {
            try {
                Field field = AnnotationInvocationHandler.class.getDeclaredField("memberValues");
                field.setAccessible(true);
                field.set(annotationInvocationHandler, map);
            }
            catch (ReflectiveOperationException | SecurityException exception) {
                throw new IllegalStateException();
            }
        }
    }
}

