/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.serialver;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import sun.tools.serialver.Res;

public class SerialVer {
    static URLClassLoader loader = null;

    static void initializeLoader(String string) throws IOException {
        String[] stringArray = string.split(File.pathSeparator);
        int n = stringArray.length;
        URL[] uRLArray = new URL[n];
        for (int i = 0; i < n; ++i) {
            uRLArray[i] = Paths.get(stringArray[i], new String[0]).toUri().toURL();
        }
        loader = new URLClassLoader(uRLArray);
    }

    static String serialSyntax(String string) throws ClassNotFoundException {
        String string2 = null;
        boolean bl = false;
        if (string.indexOf(36) != -1) {
            string2 = SerialVer.resolveClass(string);
        } else {
            try {
                string2 = SerialVer.resolveClass(string);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!bl) {
                int n;
                StringBuilder stringBuilder = new StringBuilder(string);
                String string3 = stringBuilder.toString();
                while ((n = string3.lastIndexOf(46)) != -1 && !bl) {
                    stringBuilder.setCharAt(n, '$');
                    try {
                        string3 = stringBuilder.toString();
                        string2 = SerialVer.resolveClass(string3);
                        bl = true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            if (!bl) {
                throw new ClassNotFoundException();
            }
        }
        return string2;
    }

    static String resolveClass(String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string, false, loader);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return "    private static final long serialVersionUID = " + objectStreamClass.getSerialVersionUID() + "L;";
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = 0;
        if (stringArray.length == 0) {
            SerialVer.usage();
            System.exit(1);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-classpath")) {
                if (n + 1 == stringArray.length || stringArray[n + 1].startsWith("-")) {
                    System.err.println(Res.getText("error.missing.classpath"));
                    SerialVer.usage();
                    System.exit(1);
                }
                string = new String(stringArray[n + 1]);
                ++n;
                continue;
            }
            if (!stringArray[n].startsWith("-")) break;
            System.err.println(Res.getText("invalid.flag", stringArray[n]));
            SerialVer.usage();
            System.exit(1);
        }
        if (string == null && (string = System.getProperty("env.class.path")) == null) {
            string = ".";
        }
        try {
            SerialVer.initializeLoader(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(Res.getText("error.parsing.classpath", string));
            System.exit(2);
        }
        catch (IOException iOException) {
            System.err.println(Res.getText("error.parsing.classpath", string));
            System.exit(3);
        }
        if (n == stringArray.length) {
            SerialVer.usage();
            System.exit(1);
        }
        boolean bl = false;
        while (n < stringArray.length) {
            try {
                String string2 = SerialVer.serialSyntax(stringArray[n]);
                if (string2 != null) {
                    System.out.println(stringArray[n] + ":" + string2);
                } else {
                    System.err.println(Res.getText("NotSerializable", stringArray[n]));
                    bl = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(Res.getText("ClassNotFound", stringArray[n]));
                bl = true;
            }
            ++n;
        }
        if (bl) {
            System.exit(1);
        }
    }

    public static void usage() {
        System.err.println(Res.getText("usage"));
    }
}

