/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy;

import jakarta.ejb.EJBException;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.validation.ConstraintViolationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Util.class.getName());

    public static <T> T setEnumsFromString(String inputString, T objectWithEnums) {
        new Scanner(inputString).forEachRemaining(t -> {
            boolean set = false;
            if (inputString.indexOf(46) > 0) {
                String enumName = t.substring(0, t.indexOf(46));
                String enumValue = t.substring(t.indexOf(46) + 1);
                for (Method m : objectWithEnums.getClass().getMethods()) {
                    if (!m.getName().equalsIgnoreCase("set" + enumName)) continue;
                    Class<?> clazz = m.getParameterTypes()[0];
                    for (Enum e : (Enum[])clazz.getEnumConstants()) {
                        if (!e.name().equalsIgnoreCase(enumValue)) continue;
                        try {
                            m.invoke(objectWithEnums, e);
                            set = true;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                            throw new EJBException(ex);
                        }
                    }
                }
            }
            if (!set) {
                throw new IllegalArgumentException(t + " not found in " + objectWithEnums);
            }
        });
        return objectWithEnums;
    }

    public static boolean hasSetterForEnumString(String t, Object objectWithEnums) {
        if (t.indexOf(46) > 0) {
            String enumName = t.substring(0, t.indexOf(46));
            String enumValue = t.substring(t.indexOf(46) + 1);
            for (Method m : objectWithEnums.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase("set" + enumName)) continue;
                Class<?> clazz = m.getParameterTypes()[0];
                for (Enum e : (Enum[])clazz.getEnumConstants()) {
                    if (!e.name().equalsIgnoreCase(enumValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> T setEnum(Enum e, T objectWithEnums) {
        for (Method m : objectWithEnums.getClass().getMethods()) {
            if (!m.getName().equals("set" + e.getClass().getSimpleName())) continue;
            try {
                m.invoke(objectWithEnums, e);
                return objectWithEnums;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new EJBException(ex);
            }
        }
        throw new IllegalArgumentException(e + " not found in " + objectWithEnums);
    }

    public static Enum getEnumWithValue(Object objectWithEnums) {
        for (Method m : objectWithEnums.getClass().getMethods()) {
            if (!m.getReturnType().isEnum() || m.getParameterCount() != 0) continue;
            try {
                Object o = m.invoke(objectWithEnums, new Object[0]);
                if (o == null) continue;
                return (Enum)o;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new EJBException(ex);
            }
        }
        return null;
    }

    public static List<Enum> listEnums(Class clazz) {
        return Arrays.stream(clazz.getMethods()).map(Method::getReturnType).filter(Class::isEnum).map(c -> (Enum[])c.getEnumConstants()).flatMap(Arrays::stream).collect(Collectors.toCollection(() -> new ArrayList(100)));
    }

    public static Enum findInClass(Class clazz, String e) {
        return e.indexOf(46) > 0 ? (Enum)Arrays.stream(clazz.getMethods()).filter(m -> m.getReturnType().isEnum() && m.getParameterCount() == 0).map(Method::getReturnType).filter(c -> c.getSimpleName().equalsIgnoreCase(e.substring(0, e.indexOf(46)))).flatMap(c -> Arrays.stream((Enum[])c.getEnumConstants())).filter(en -> en.name().equalsIgnoreCase(e.substring(e.indexOf(46) + 1))).findFirst().orElse(null) : null;
    }

    public static String toString(Enum e) {
        return e.getClass().getSimpleName() + "." + e.name();
    }

    public static String toString(List<Enum> l) {
        return "[" + l.stream().map(Util::toString).collect(Collectors.joining(", ")) + "]";
    }

    public static String split(String toSplit, int index) {
        return Util.split(toSplit, index, false);
    }

    public static String split(String toSplit, int index, boolean ignorePatternAfterIndex) {
        return Util.split(toSplit, ": ?", index, ignorePatternAfterIndex);
    }

    public static String split(String toSplit, String regex, int index, boolean ignorePatternAfterIndex) {
        if (toSplit == null) {
            return toSplit;
        }
        String[] split = toSplit.split(regex, ignorePatternAfterIndex ? index + 1 : -1);
        return index < split.length ? split[index] : null;
    }

    public static Throwable deepestCause(Throwable t) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("only retaining deepest cause of stacktrace!", t);
        }
        if (t.getCause() != null) {
            return Util.deepestCause(t.getCause());
        }
        return t;
    }

    public static boolean isIndex(String input, char c, int pos) {
        return !Util.nullOrEmpty(input) && input.length() > pos && input.charAt(pos) == c;
    }

    private static Set<Bean<?>> checkBeans(Set<Bean<?>> beans) {
        if (beans.isEmpty()) {
            throw new IllegalArgumentException("No beans found");
        }
        if (beans.size() > 1) {
            throw new IllegalArgumentException("Multiple beans found");
        }
        return beans;
    }

    public static <T> T getBean(Class<T> clazz, String name) {
        BeanManager beanManager = CDI.current().getBeanManager();
        Bean<?> contextual = Util.checkBeans(beanManager.getBeans(name)).iterator().next();
        CreationalContext ctx = beanManager.createCreationalContext(contextual);
        Object bean = beanManager.getReference(contextual, clazz, ctx);
        return (T)bean;
    }

    public static List<String> formatConstraintException(ConstraintViolationException cve) {
        return cve.getConstraintViolations().stream().map(cv -> cv.getRootBeanClass().getSimpleName() + "." + cv.getPropertyPath() + " " + cv.getMessage()).collect(Collectors.toList());
    }

    public static boolean nullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean bothNullOrEmpty(String s, String t) {
        return Util.nullOrEmpty(s) && Util.nullOrEmpty(t);
    }
}

