/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.Objects;
import org.fryske_akademy.jpa.EntityInterface;

@MappedSuperclass
@Access(value=AccessType.PROPERTY)
public class AbstractEntity
implements EntityInterface {
    private Integer id;
    private int version = -1;

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Version
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int hashCode() {
        return 39 + (this.id != null ? this.id.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEntity other = (AbstractEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    @Override
    @Transient
    public boolean isTransient() {
        return this.version < 0 || this.id == null;
    }
}

