/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import jakarta.security.enterprise.SecurityContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.fryske_akademy.jpa.EntityException;
import org.fryske_akademy.jpa.EntityInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JpaUtil.class.getName());
    private static final Map<String, EntityManagerFactory> emFacts = new ConcurrentHashMap<String, EntityManagerFactory>(5){

        @Override
        public EntityManagerFactory get(Object key) {
            if (!this.containsKey(key) || !((EntityManagerFactory)super.get(key)).isOpen()) {
                this.put(String.valueOf(key), Persistence.createEntityManagerFactory((String)String.valueOf(key)));
            }
            return (EntityManagerFactory)super.get(key);
        }
    };

    public static EntityManagerFactory getEntityManagerFactory(String name) {
        return emFacts.get(name);
    }

    public static Principal findPrincipal() throws IllegalStateException {
        return ((SecurityContext)CDI.current().select(SecurityContext.class, new Annotation[0]).get()).getCallerPrincipal();
    }

    public static <T> List<T> findAll(Class<T> type, EntityManager entityManager) {
        CriteriaQuery cq = entityManager.getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(type));
        return entityManager.createQuery(cq).getResultList();
    }

    public static Optional<EntityInterface> fromException(Throwable ex) {
        if (ex instanceof EntityException) {
            return EntityException.fromException(ex);
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)ex;
            if (!((ConstraintViolationException)ex).getConstraintViolations().isEmpty()) {
                Object rootBean = ((ConstraintViolation)((ConstraintViolationException)ex).getConstraintViolations().iterator().next()).getRootBean();
                return rootBean instanceof EntityInterface ? Optional.of((EntityInterface)rootBean) : Optional.empty();
            }
        }
        return Optional.empty();
    }
}

