/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import jakarta.inject.Singleton;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.fryske_akademy.jpa.DefaultJpqlBuilder;
import org.fryske_akademy.jpa.JpqlBuilder;
import org.fryske_akademy.jpa.OPERATOR;
import org.fryske_akademy.jpa.Param;
import org.fryske_akademy.services.CrudReadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@DefaultJpqlBuilder
public class JpqlBuilderImpl
implements JpqlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JpqlBuilderImpl.class.getName());
    public static final String ENTITY_PREFIX = " e.";

    private static boolean isNum(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private static boolean containsKey(Query q, String key) {
        boolean num = JpqlBuilderImpl.isNum(key);
        Integer i = num ? Integer.parseInt(key) : 0;
        return q.getParameters().stream().anyMatch(p -> key.equals(p.getName()) || num && i.equals(p.getPosition()));
    }

    private static boolean isNamedParameter(Query q, String key) {
        return q.getParameters().stream().anyMatch(p -> key.equals(p.getName()));
    }

    @Override
    public String orderClause(Map<String, CrudReadService.SORTORDER> sort) {
        if (sort != null && !sort.isEmpty()) {
            StringBuilder srt = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, CrudReadService.SORTORDER> entry : sort.entrySet()) {
                String sortField = entry.getKey();
                if (sortField == null || entry.getValue() == CrudReadService.SORTORDER.NONE) continue;
                srt.append(first ? " order by" : ",").append(ENTITY_PREFIX).append(sortField).append(" ").append((Object)entry.getValue());
                first = false;
            }
            return srt.toString();
        }
        return "";
    }

    @Override
    public String whereClause(List<Param> params) {
        if (params != null && !params.isEmpty()) {
            if (params.stream().mapToInt(Param::getGroupStarts).sum() != params.stream().mapToInt(Param::getGroupEnds).sum()) {
                throw new PersistenceException(String.format("unbalanced grouping: %d group start tags, %d end group tags", params.stream().mapToInt(Param::getGroupStarts).sum(), params.stream().mapToInt(Param::getGroupEnds).sum()));
            }
            StringBuilder where = new StringBuilder();
            boolean first = true;
            for (Param param : params) {
                int i;
                Object startGroup = "";
                Object endGroups = "";
                for (i = 0; i < param.getGroupStarts(); ++i) {
                    startGroup = (String)startGroup + " (";
                }
                for (i = 0; i < param.getGroupEnds(); ++i) {
                    endGroups = (String)endGroups + ") ";
                }
                where.append(first ? " where" : param.getAndOr()).append((String)startGroup).append(this.whereCondition(param)).append((String)endGroups);
                first = false;
            }
            return where.toString();
        }
        return "";
    }

    @Override
    public String whereCondition(Param param) {
        switch (param.getOperator()) {
            case MEMBEROF: {
                if (param.getParamValue() instanceof Collection) {
                    if (!((Collection)param.getParamValue()).isEmpty()) {
                        StringBuilder rv = new StringBuilder(" (");
                        AtomicBoolean first = new AtomicBoolean(true);
                        AtomicInteger i = new AtomicInteger();
                        ((Collection)param.getParamValue()).forEach(t -> {
                            if (first.get()) {
                                first.set(false);
                            } else {
                                rv.append(" or ");
                            }
                            rv.append(":").append(param.getParamKey()).append(i.getAndIncrement()).append(param.getNot()).append((Object)param.getOperator()).append(ENTITY_PREFIX).append(param.getPropertyPath());
                        });
                        return rv.append(')').toString();
                    }
                    return "";
                }
                return " :" + param.getParamKey() + param.getNot() + param.getOperator() + ENTITY_PREFIX + param.getPropertyPath();
            }
            case BETWEEN: {
                return ENTITY_PREFIX + param.getPropertyPath() + param.getNot() + param.getOperator() + " :" + param.getParamKey() + "Min AND :" + param.getParamKey() + "Max";
            }
            case IN: {
                return ENTITY_PREFIX + param.getPropertyPath() + param.getNot() + param.getOperator() + "( :" + param.getParamKey() + " )";
            }
            case ISNULL: 
            case ISNOTNULL: 
            case ISBLANK: 
            case ISNOTBLANK: 
            case ISEMPTY: 
            case ISNOTEMPTY: {
                return ENTITY_PREFIX + param.getPropertyPath() + param.getOperator();
            }
        }
        return param.isCaseInsensitive() && String.class.equals((Object)param.getParamType()) ? param.getNot() + "lower( e." + param.getPropertyPath() + ")" + param.getOperator() + "lower(:" + param.getParamKey() + ")" : param.getNot() + ENTITY_PREFIX + param.getPropertyPath() + param.getOperator() + ":" + param.getParamKey();
    }

    @Override
    public void setWhereParams(Query q, List<Param> params) {
        if (params != null && !params.isEmpty()) {
            params.forEach(param -> this.setParam(q, (Param)param));
        }
    }

    protected void set(Query q, String key, Object value) {
        Object v = value;
        if (value instanceof OPERATOR) {
            v = ((OPERATOR)((Object)value)).getUserInput();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s is an OPERATOR using %s as value", key, ((OPERATOR)((Object)value)).getUserInput()));
            }
        }
        if (JpqlBuilderImpl.isNamedParameter(q, key)) {
            q.setParameter(key, v);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s not found in query, assuming positional parameter with value %s", key, value));
            }
            q.setParameter((int)Short.parseShort(key), v);
        }
    }

    @Override
    public void setParam(Query q, Param param) {
        if (!JpqlBuilderImpl.containsKey(q, param.getParamKey()) && param.getOperator() != OPERATOR.MEMBEROF && param.getParamValue() instanceof Collection) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("parameter not found in query, skipping %s", param));
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("trying to set: " + param);
        }
        switch (param.getOperator()) {
            case ISNULL: 
            case ISNOTNULL: 
            case ISBLANK: 
            case ISNOTBLANK: 
            case ISEMPTY: 
            case ISNOTEMPTY: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("parameter value ignored for %s", new Object[]{param.getOperator()}));
                }
                return;
            }
        }
        if (param.getOperator() == OPERATOR.MEMBEROF && param.getParamValue() instanceof Collection) {
            AtomicInteger i = new AtomicInteger();
            ((Collection)param.getParamValue()).forEach(t -> this.set(q, param.getParamKey() + i.getAndIncrement(), t));
        } else if (param.getOperator() == OPERATOR.BETWEEN) {
            this.set(q, param.getParamKey() + "Min", param.getParamValue());
            this.set(q, param.getParamKey() + "Max", param.getMaxValue());
        } else {
            if (param.getParamValue() instanceof Collection && param.getOperator() != OPERATOR.IN && LOGGER.isDebugEnabled()) {
                LOGGER.debug("value for " + param.getParamKey() + " is a collection, you may want to use the \"in\" or \"member of\" operator");
            }
            this.set(q, param.getParamKey(), param.getParamValue());
        }
    }
}

