/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.fryske_akademy.Util;

public enum OPERATOR {
    EQ("=", null),
    GT(">", ">"),
    LT("<", "<"),
    GE(">=", ">="),
    LE("<=", "<="),
    IN("IN", null),
    LIKE("LIKE", null),
    NE("<>", null),
    MEMBEROF("MEMBER OF", null),
    BETWEEN("BETWEEN", " <=> "),
    ISNULL("IS NULL", "IS NULL"),
    ISNOTNULL("IS NOT NULL", "!IS NULL"),
    ISBLANK("= ''", "IS BLANK"),
    ISNOTBLANK("<> ''", "!IS BLANK"),
    ISEMPTY("IS EMPTY", "IS EMPTY"),
    ISNOTEMPTY("IS NOT EMPTY", "!IS EMPTY"),
    AND("AND", " AND "),
    OR("OR", " OR ");

    public static final char NEGATION = '!';
    private final String token;
    private final String userInput;

    private OPERATOR(String token, String userInput) {
        this.token = token;
        this.userInput = userInput == null ? null : (this.name().equals("AND") || this.name().equals("OR") ? userInput : userInput.toLowerCase());
    }

    public static boolean negation(String value) {
        return Util.isIndex(value, '!', 0);
    }

    public static String stripSyntax(String value) {
        int syntaxChars = 0;
        if (OPERATOR.negation(value)) {
            ++syntaxChars;
        }
        if (OPERATOR.smaller(value) || OPERATOR.greater(value)) {
            ++syntaxChars;
        }
        if (OPERATOR.eq(value)) {
            ++syntaxChars;
        }
        return value.substring(syntaxChars);
    }

    public static boolean eq(String value) {
        boolean b;
        boolean bl = b = OPERATOR.smaller(value) || OPERATOR.greater(value);
        if (b) {
            return OPERATOR.negation(value) ? Util.isIndex(value, OPERATOR.EQ.token.charAt(0), 2) : Util.isIndex(value, OPERATOR.EQ.token.charAt(0), 1);
        }
        return false;
    }

    public static boolean greater(String value) {
        return Util.isIndex(value, OPERATOR.GT.token.charAt(0), 0) || OPERATOR.negation(value) && Util.isIndex(value, OPERATOR.GT.token.charAt(0), 1);
    }

    public static boolean smaller(String value) {
        return Util.isIndex(value, OPERATOR.LT.token.charAt(0), 0) || OPERATOR.negation(value) && Util.isIndex(value, OPERATOR.LT.token.charAt(0), 1);
    }

    public static boolean valueIsOperator(String s, boolean syntaxInValue) {
        return syntaxInValue && (OPERATOR.nullComp(s) || OPERATOR.emptyComp(s) || OPERATOR.blankComp(s));
    }

    private static boolean nullComp(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        return s.equalsIgnoreCase(OPERATOR.ISNULL.userInput) || s.equalsIgnoreCase(OPERATOR.ISNOTNULL.userInput);
    }

    private static boolean blankComp(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        return s.equalsIgnoreCase(OPERATOR.ISBLANK.userInput) || s.equalsIgnoreCase(OPERATOR.ISNOTBLANK.userInput);
    }

    private static boolean emptyComp(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        return s.equalsIgnoreCase(OPERATOR.ISEMPTY.userInput) || s.equalsIgnoreCase(OPERATOR.ISNOTEMPTY.userInput);
    }

    public static boolean isBetween(String value) {
        return value != null && value.split(OPERATOR.BETWEEN.userInput).length == 2;
    }

    public static boolean isAnd(String value) {
        return value != null && value.contains(OPERATOR.AND.userInput) && (!value.contains(OPERATOR.OR.userInput) || value.indexOf(OPERATOR.AND.userInput) < value.indexOf(OPERATOR.OR.userInput)) && value.split(OPERATOR.AND.userInput, 2).length == 2;
    }

    public static boolean isOr(String value) {
        return value != null && value.contains(OPERATOR.OR.userInput) && (!value.contains(OPERATOR.AND.userInput) || value.indexOf(OPERATOR.OR.userInput) < value.indexOf(OPERATOR.AND.userInput)) && value.split(OPERATOR.OR.userInput, 2).length == 2;
    }

    public static OPERATOR operator(String operator, String value, boolean syntaxInValue) {
        if (syntaxInValue) {
            return OPERATOR.operatorInUserInput(value) ? OPERATOR.fromUserInput(value) : OPERATOR.fromToken(operator);
        }
        return OPERATOR.fromToken(operator);
    }

    public String toString() {
        return " " + this.token + " ";
    }

    public String getToken() {
        return this.token;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public boolean isOperatorInUserInput(String input) {
        switch (this) {
            case GT: {
                return OPERATOR.greater(input) && !OPERATOR.eq(input);
            }
            case GE: {
                return OPERATOR.greater(input) && OPERATOR.eq(input);
            }
            case LT: {
                return OPERATOR.smaller(input) && !OPERATOR.eq(input);
            }
            case LE: {
                return OPERATOR.smaller(input) && OPERATOR.eq(input);
            }
        }
        return input.equalsIgnoreCase(this.userInput);
    }

    public static OPERATOR fromToken(String token) {
        return Arrays.stream(OPERATOR.values()).filter(operator -> token.equalsIgnoreCase(operator.token)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("%s invalid, only %s supported", token, Arrays.asList(OPERATOR.values()))));
    }

    public static OPERATOR fromUserInput(String input) {
        return Arrays.stream(OPERATOR.values()).filter(t -> t.isOperatorInUserInput(input)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("%s invalid, only %s supported", input, Arrays.stream(OPERATOR.values()).map(o -> o.userInput).collect(Collectors.toList()))));
    }

    public static boolean operatorInUserInput(String input) {
        return Arrays.stream(OPERATOR.values()).anyMatch(t -> t.isOperatorInUserInput(input));
    }
}

