/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import com.vectorprint.StringConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.fryske_akademy.Util;
import org.fryske_akademy.jpa.OPERATOR;
import org.fryske_akademy.services.CrudReadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Param {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Param.class.getName());
    private final String propertyPath;
    private final String paramKey;
    private final OPERATOR operator;
    private final Object paramValue;
    private final String not;
    private final AndOr andOr;
    private final boolean caseInsensitive;
    private final Object maxValue;
    private int groupStarts;
    private int groupEnds;

    public static List<Param> one(String key, Object value) {
        return Param.one(key, key, value, true, Builder.DEFAULT_MAPPING, false);
    }

    public static List<Param> one(String key, OPERATOR operator, Object value) {
        return new Builder().add(key, key, operator, value, false, false, null).build();
    }

    public static List<Param> one(String propertyPath, String key, Object value) {
        return Param.one(propertyPath, key, value, true, Builder.DEFAULT_MAPPING, false);
    }

    public static List<Param> one(String key, String value, StringConverter converter) {
        return new Builder().add(key, value, converter).build();
    }

    public static List<Param> one(String propertyPath, String key, Object value, boolean syntaxSupport, Builder.WildcardMapping wildcardMapping, boolean caseInsensitive) {
        List<Param> params = new Builder(syntaxSupport, wildcardMapping, caseInsensitive).add(propertyPath, key, value, false).build();
        if (params.size() > 1) {
            LOGGER.warn(String.format("Syntax support yielded %d parameters! This is only supported in dynamic queries (%s).", params.size(), CrudReadService.class.getSimpleName() + "#*Dynamic"));
        }
        return params;
    }

    private Param(String propertyPath, String paramKey, OPERATOR operator, Object paramValue, boolean not, boolean or, boolean caseInsensitive, Object maxValue) {
        switch (operator) {
            case ISNOTEMPTY: 
            case ISEMPTY: 
            case ISNOTNULL: 
            case ISNULL: {
                break;
            }
            case BETWEEN: {
                if (maxValue == null) {
                    throw new IllegalArgumentException(paramKey + ": maxValue may not be null for BETWEEN");
                }
                if (!maxValue.getClass().isInstance(paramValue)) {
                    throw new IllegalArgumentException(paramKey + ": maxValue and paramValue must be the same class for BETWEEN");
                }
                if (paramValue instanceof String && (Util.nullOrEmpty(String.valueOf(paramValue).trim()) || Util.nullOrEmpty(String.valueOf(maxValue).trim()))) {
                    throw new IllegalArgumentException(paramKey + ": trimmed maxValue and paramValue may not be empty for BETWEEN");
                }
            }
            default: {
                if (paramValue != null) break;
                throw new IllegalArgumentException(paramKey + ": paramValue may not be null");
            }
        }
        this.propertyPath = propertyPath + " ";
        this.paramKey = paramKey;
        this.operator = operator;
        this.paramValue = paramValue;
        this.not = not ? " NOT " : " ";
        this.andOr = AndOr.fromBool(or);
        this.caseInsensitive = caseInsensitive;
        this.maxValue = maxValue;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public OPERATOR getOperator() {
        return this.operator;
    }

    public Object getParamValue() {
        return this.paramValue;
    }

    public String getNot() {
        return this.not;
    }

    public AndOr getAndOr() {
        return this.andOr;
    }

    public Class getParamType() {
        return this.paramValue.getClass();
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public int getGroupStarts() {
        return this.groupStarts;
    }

    public int getGroupEnds() {
        return this.groupEnds;
    }

    public void setGroupStarts(int groupStarts) {
        this.groupStarts = groupStarts;
    }

    public void setGroupEnds(int groupEnds) {
        this.groupEnds = groupEnds;
    }

    public String toString() {
        return "Param{propertyPath='" + this.propertyPath + "', paramKey='" + this.paramKey + "', operator='" + this.operator + "', paramValue=" + this.paramValue + ", not='" + this.not + "', andOr=" + this.andOr + ", caseInsensitive=" + this.caseInsensitive + ", startGroup=" + this.groupStarts + ", endGroup=" + this.groupEnds + ", maxValue=" + this.maxValue + "}";
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.paramKey);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Param other = (Param)obj;
        return Objects.equals(this.paramKey, other.paramKey);
    }

    public static class Builder {
        public static final WildcardMapping DEFAULT_MAPPING = new DefaultWildcardMapping();
        private final List<Param> params = new ArrayList<Param>(3);
        private final boolean syntaxInValue;
        private final WildcardMapping wildcardMapping;
        private final boolean caseInsensitive;

        public Builder(boolean syntaxInValue, WildcardMapping wildcardMapping, boolean caseInsensitive) {
            this.syntaxInValue = syntaxInValue;
            this.wildcardMapping = wildcardMapping;
            this.caseInsensitive = caseInsensitive;
        }

        public Builder() {
            this(true, null, false);
        }

        public Builder(boolean caseInsensitive) {
            this(true, null, caseInsensitive);
        }

        public Builder add(String paramKey, Object paramValue) {
            return this.add(paramKey, paramValue, false);
        }

        public Builder add(String paramKey, Object paramValue, boolean or) {
            return this.add(paramKey, paramKey, paramValue, or);
        }

        public Builder add(String propertyPath, String paramKey, Object paramValue, boolean or) {
            if (paramValue instanceof String) {
                return this.add(propertyPath, paramKey, "like", (String)paramValue, or, null);
            }
            return this.add(propertyPath, paramKey, OPERATOR.EQ, paramValue, false, or, null);
        }

        public Builder add(String paramKey, String paramValue, StringConverter converter) {
            return this.add(paramKey, paramKey, paramValue, converter);
        }

        public Builder add(String propertyPath, String paramKey, String paramValue, StringConverter converter) {
            return this.add(propertyPath, paramKey, converter == null ? "like" : "=", paramValue, false, converter);
        }

        public Builder add(String paramKey, String paramValue, boolean or, StringConverter converter) {
            return this.add(paramKey, paramKey, converter == null ? "like" : "=", paramValue, or, converter);
        }

        public Builder add(String paramKey, String paramValue, String operator, boolean or, StringConverter converter) {
            return this.add(paramKey, paramKey, operator, paramValue, or, converter);
        }

        private List<AndOrTerms> splitTerms(String value, List<AndOrTerms> andOrTerms, boolean or) {
            OPERATOR andOr = OPERATOR.isAnd(value) ? OPERATOR.AND : OPERATOR.OR;
            String[] terms = value.split(andOr.getUserInput(), 2);
            andOrTerms.add(new AndOrTerms(terms[0], or, andOrTerms.size()));
            if (OPERATOR.isAnd(terms[1]) || OPERATOR.isOr(terms[1])) {
                return this.splitTerms(terms[1], andOrTerms, andOr == OPERATOR.OR);
            }
            andOrTerms.add(new AndOrTerms(terms[1], andOr == OPERATOR.OR, andOrTerms.size()));
            return andOrTerms;
        }

        public Builder add(String propertyPath, String paramKey, String operator, String paramValue, boolean or, StringConverter converter) {
            if (OPERATOR.isAnd(paramValue) || OPERATOR.isOr(paramValue)) {
                this.splitTerms(paramValue, new ArrayList<AndOrTerms>(2), or).forEach(term -> {
                    this.add(propertyPath, paramKey + term.n, operator, term.term, term.or, converter);
                    if (term.n == 0) {
                        this.setGroupStartsLastParam(1);
                    }
                });
                this.setGroupEndsLastParam(1);
            } else if (OPERATOR.isBetween(paramValue)) {
                String[] minMax = paramValue.split(OPERATOR.BETWEEN.getUserInput());
                Object min = this.getValue(minMax[0], converter);
                Object max = this.getValue(minMax[1], converter);
                if (min != null && max != null) {
                    this.add(propertyPath, paramKey, OPERATOR.BETWEEN, min, this.isNegation(paramValue), or, max);
                } else {
                    LOGGER.warn(String.format("skip adding param, min or max is null, probably %s cannot be converted by %s", min + " or " + max, converter));
                }
            } else {
                Object value = this.getValue(paramValue, converter);
                if (value != null) {
                    this.add(propertyPath, paramKey, OPERATOR.operator(operator, paramValue, this.syntaxInValue), value, this.isNegation(paramValue), or, null);
                } else {
                    LOGGER.warn(String.format("skip adding param, value is null, perhaps %s cannot be converted by %s", paramValue, converter));
                }
            }
            return this;
        }

        public Builder checkNotNull(String propertyPath) {
            return this.add(propertyPath, propertyPath, OPERATOR.ISNOTNULL, (Object)"", false, false, null);
        }

        public Builder setGroupStartsLastParam(int group) {
            return this.setGroupStartsParam(group, this.params.size() - 1);
        }

        public Builder setGroupStartsParam(int group, String key) {
            this.params.stream().filter(p -> p.getParamKey().equals(key)).findFirst().ifPresent(p -> p.setGroupStarts(group));
            return this;
        }

        public Builder setGroupStartsParam(int group, int paramIndex) {
            if (this.params.size() > paramIndex) {
                this.params.get(paramIndex).setGroupStarts(group);
            }
            return this;
        }

        public Builder setGroupEndsLastParam(int group) {
            return this.setGroupEndsParam(group, this.params.size() - 1);
        }

        public Builder setGroupEndsParam(int group, int paramIndex) {
            if (this.params.size() > paramIndex) {
                this.params.get(paramIndex).setGroupEnds(group);
            }
            return this;
        }

        public Builder setGroupEndsParam(int group, String key) {
            this.params.stream().filter(p -> p.getParamKey().equals(key)).findFirst().ifPresent(p -> p.setGroupEnds(group));
            return this;
        }

        private Object getValue(String value, StringConverter converter) {
            if (OPERATOR.valueIsOperator(value, this.syntaxInValue)) {
                return "";
            }
            if (converter == null) {
                return this.replaceWildcards(OPERATOR.stripSyntax(value));
            }
            return converter.convert(OPERATOR.stripSyntax(value));
        }

        public Builder add(String propertyPath, String paramKey, OPERATOR operator, Object paramValue, boolean not, boolean or, Object maxValue) {
            this.add(new Param(propertyPath, paramKey, operator, paramValue, not, or, this.caseInsensitive, maxValue));
            return this;
        }

        public Builder add(String propertyPath, String paramKey, OPERATOR operator, Object paramValue, boolean not, boolean or) {
            this.add(propertyPath, paramKey, operator, paramValue, not, or, null);
            return this;
        }

        public Builder add(String propertyPath, String paramKey, String operator, Object paramValue, boolean not, boolean or, Object maxValue) {
            this.add(new Param(propertyPath, paramKey, OPERATOR.fromToken(operator), paramValue, not, or, this.caseInsensitive, maxValue));
            return this;
        }

        public Builder add(String propertyPath, String paramKey, String operator, Object paramValue, boolean not, boolean or) {
            this.add(propertyPath, paramKey, operator, paramValue, not, or, null);
            return this;
        }

        private void add(Param param) {
            if (this.params.stream().anyMatch(p -> p.paramKey.equals(param.paramKey))) {
                throw new IllegalArgumentException(String.format("builder already contains %s", param.paramKey));
            }
            this.params.add(param);
        }

        public Builder remove(String paramKey) {
            if (this.params.stream().anyMatch(p -> p.paramKey.equals(paramKey))) {
                Iterator<Param> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    Param next = iterator.next();
                    if (!next.paramKey.equals(paramKey)) continue;
                    iterator.remove();
                    break;
                }
            }
            return this;
        }

        public Builder clear() {
            this.params.clear();
            return this;
        }

        public boolean isNegation(String value) {
            return this.syntaxInValue && OPERATOR.negation(value);
        }

        private String replaceWildcards(String value) {
            return this.wildcardMapping == null ? value : value.replace(this.wildcardMapping.getZeroOrMoreInput(), this.wildcardMapping.getZeroOrMoreOutput()).replace(this.wildcardMapping.getZeroOrOneInput(), this.wildcardMapping.getZeroOrOneOutput());
        }

        public Builder addParam(List<Param> p) {
            p.forEach(this::add);
            return this;
        }

        public Builder addParam(Param ... p) {
            Stream.of(p).forEach(this::add);
            return this;
        }

        public List<Param> build() {
            return this.params;
        }

        public boolean isSyntaxInValue() {
            return this.syntaxInValue;
        }

        public boolean containsKey(String key) {
            return this.params.stream().anyMatch(t -> t.getParamKey().equals(key));
        }

        public static interface WildcardMapping {
            public char getZeroOrMoreInput();

            public char getZeroOrMoreOutput();

            public char getZeroOrOneInput();

            public char getZeroOrOneOutput();
        }

        private record AndOrTerms(String term, boolean or, int n) {
        }

        public static class DefaultWildcardMapping
        implements WildcardMapping {
            @Override
            public char getZeroOrMoreInput() {
                return '*';
            }

            @Override
            public char getZeroOrMoreOutput() {
                return '%';
            }

            @Override
            public char getZeroOrOneInput() {
                return '?';
            }

            @Override
            public char getZeroOrOneOutput() {
                return '_';
            }
        }
    }

    public static enum AndOr {
        AND,
        OR;


        private static AndOr fromBool(boolean or) {
            return or ? OR : AND;
        }

        public String toString() {
            return " " + this.name() + " ";
        }
    }
}

