/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.services;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.fryske_akademy.jpa.DefaultJpqlBuilder;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.JpqlBuilder;
import org.fryske_akademy.jpa.Param;
import org.fryske_akademy.services.CrudReadService;
import org.fryske_akademy.services.CrudWriteService;
import org.fryske_akademy.services.PreventEJBLoggingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeclareRoles(value={"editor"})
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public abstract class AbstractCrudService
implements CrudWriteService,
CrudReadService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractCrudService.class.getName());
    public static final int DEFAULT_PAGE_SIZE = 30;
    public static final String EDITORROLE = "editor";
    private JpqlBuilder jpqlBuilder;

    @Override
    public <T> T find(Serializable id, Class<T> type) {
        return (T)this.getEntityManager().find(type, (Object)id);
    }

    @Override
    public <T> List<T> findAll(Class<T> type) {
        return this.list((Query)this.all(type), type);
    }

    private <T> TypedQuery<T> all(Class<T> type) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(type));
        return this.getEntityManager().createQuery(cq);
    }

    private <T> List<T> list(Query q, Class<T> type) {
        return q.getResultList();
    }

    private <T> Stream<T> stream(Query q, Class<T> type) {
        return q.getResultStream();
    }

    @Override
    public <T> List<T> findDynamic(Integer first, Integer max, Map<String, CrudReadService.SORTORDER> sort, List<Param> params, Class<T> type) {
        return this.list((Query)this.dyn(first, max, sort, params, type), type);
    }

    private String getEntityName(Class type) {
        Metamodel model = this.getEntityManager().getEntityManagerFactory().getMetamodel();
        return model.entity(type).getName();
    }

    private <T> TypedQuery<T> dyn(Integer first, Integer max, Map<String, CrudReadService.SORTORDER> sort, List<Param> params, Class<T> type) {
        String jpql = "from " + this.getEntityName(type) + " e" + this.jpqlBuilder.whereClause(params) + this.jpqlBuilder.orderClause(sort);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(jpql);
        }
        TypedQuery q = this.getEntityManager().createQuery(jpql, type);
        this.jpqlBuilder.setWhereParams((Query)q, params);
        q.setFirstResult(first == null ? 0 : first);
        if (max == null || max >= 0) {
            q.setMaxResults(max == null ? this.getDefaultPageSize() : max.intValue());
        }
        return q;
    }

    @Override
    public int countDynamic(List<Param> params, Class type) {
        String jpql = "select count(e) from " + this.getEntityName(type) + " e" + this.jpqlBuilder.whereClause(params);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(jpql);
        }
        return this.doCount((Query)this.getEntityManager().createQuery(jpql, Long.class), params);
    }

    @Override
    public <T> List<T> find(String namedQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doFind((Query)this.getEntityManager().createNamedQuery(namedQuery, type), params, first, max);
    }

    @Override
    public <T> List<T> findNative(String namedNativeQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doFind(this.getEntityManager().createNamedQuery(namedNativeQuery), params, first, max);
    }

    @Override
    public int count(String namedQuery, List<Param> params) {
        return this.doCount(this.getEntityManager().createNamedQuery(namedQuery), params);
    }

    @Override
    public int getDefaultPageSize() {
        return 30;
    }

    private <T> T findOne(String namedQuery, List<Param> params, Class<T> type, boolean exactly) {
        TypedQuery q = this.getEntityManager().createNamedQuery(namedQuery, type);
        this.jpqlBuilder.setWhereParams((Query)q, params);
        try {
            return (T)q.getSingleResult();
        }
        catch (NoResultException e) {
            if (exactly) {
                throw new PreventEJBLoggingException(e);
            }
            return null;
        }
    }

    @Override
    public <T> T findOne(String namedQuery, List<Param> params, Class<T> type) {
        return this.findOne(namedQuery, params, type, false);
    }

    @Override
    public <T> T findExactlyOne(String namedQuery, List<Param> params, Class<T> type) throws PreventEJBLoggingException {
        return this.findOne(namedQuery, params, type, true);
    }

    @Override
    public <T> List<T> findJpql(String jpql, Class<T> clazz) {
        return this.getEntityManager().createQuery(jpql, clazz).getResultList();
    }

    @Override
    public <T> List<T> findNative(String sql, Class<T> clazz) {
        return this.getEntityManager().createNativeQuery(sql, clazz).getResultList();
    }

    @Override
    public List findNative(String sql) {
        return this.getEntityManager().createNativeQuery(sql).getResultList();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T> T create(T t) {
        this.getEntityManager().persist(t);
        return t;
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T extends EntityInterface> T save(T t) {
        if (t.isTransient()) {
            return this.create(t);
        }
        return this.update(t);
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T> T update(T t) {
        return (T)this.getEntityManager().merge(t);
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public void delete(EntityInterface t) {
        this.getEntityManager().remove(this.getEntityManager().find(t.getClass(), (Object)t.getId()));
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T extends EntityInterface> Stream<T> batchSave(Collection<T> entities, Integer flushCount) {
        EntityManager em = this.getEntityManager();
        AtomicInteger i = new AtomicInteger();
        return entities.parallelStream().map(t -> {
            if (flushCount != null && i.incrementAndGet() % flushCount == 0) {
                em.flush();
            }
            return this.save(t);
        });
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public int batchDelete(Collection<? extends EntityInterface> t, Integer flushCount) {
        EntityManager em = this.getEntityManager();
        AtomicInteger i = new AtomicInteger();
        t.parallelStream().forEach(e -> {
            em.remove(em.merge(e));
            int inc = i.incrementAndGet();
            if (flushCount != null && inc % flushCount == 0) {
                em.flush();
                em.clear();
            }
        });
        return i.get();
    }

    @Override
    public <T> Stream<T> streamAll(Class<T> type) {
        return this.stream((Query)this.all(type), type);
    }

    @Override
    public <T> Stream<T> streamDynamic(Integer first, Integer max, Map<String, CrudReadService.SORTORDER> sort, List<Param> params, Class<T> type) {
        return this.stream((Query)this.dyn(first, max, sort, params, type), type);
    }

    @Override
    public <T> Stream<T> stream(String namedQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doStream(this.getEntityManager().createNamedQuery(namedQuery), params, first, max);
    }

    @Override
    public <T> Stream<T> streamNative(String namedNativeQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doStream(this.getEntityManager().createNamedQuery(namedNativeQuery), params, first, max);
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T> T refresh(T t) {
        this.getEntityManager().refresh(t);
        return t;
    }

    private List doFind(Query q, List<Param> params, Integer first, Integer max) {
        return this.findQuery(q, params, first, max).getResultList();
    }

    private Query findQuery(Query q, List<Param> params, Integer first, Integer max) {
        Set parameters = q.getParameters();
        if (parameters != null && params != null && parameters.size() != params.size()) {
            LOGGER.warn(String.format("number of parameters in query: %d differs from number of supplied parameters: %d. Possibly due to syntax support in Param for dynamic queries.", parameters.size(), params.size()));
        }
        this.jpqlBuilder.setWhereParams(q, params);
        if (params != null && params.stream().anyMatch(t -> t.getNot().equals(" NOT "))) {
            LOGGER.warn("negations in value (!) not supported for named queries!");
        }
        q.setFirstResult(first == null ? 0 : first);
        if (max != null) {
            if (max >= 0) {
                q.setMaxResults(max.intValue());
            }
        } else {
            q.setMaxResults(this.getDefaultPageSize());
        }
        return q;
    }

    private Stream doStream(Query q, List<Param> params, Integer first, Integer max) {
        return this.findQuery(q, params, first, max).getResultStream();
    }

    private int doCount(Query q, List<Param> params) {
        this.jpqlBuilder.setWhereParams(q, params);
        return Integer.parseInt(String.valueOf(q.getSingleResult()));
    }

    @Inject
    protected void setJpqlBuilder(@DefaultJpqlBuilder JpqlBuilder jpqlBuilder) {
        this.jpqlBuilder = jpqlBuilder;
    }

    protected JpqlBuilder getJpqlBuilder() {
        return this.jpqlBuilder;
    }
}

