/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.services;

import jakarta.persistence.EntityManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jpa.RevisionInfo;
import org.fryske_akademy.services.AbstractCrudService;
import org.fryske_akademy.services.Auditing;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.IdentifierEqAuditExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCrudServiceEnvers
extends AbstractCrudService
implements Auditing {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractCrudServiceEnvers.class.getName());

    @Override
    public <T> T getRevision(Number n, Class<T> type) {
        if (!type.isAnnotationPresent(Audited.class)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No @Audited annotation on " + type.getName());
            }
            return null;
        }
        return (T)AuditReaderFactory.get((EntityManager)this.getEntityManager()).createQuery().forEntitiesAtRevision(type, n).getSingleResult();
    }

    @Override
    public <T> List<RevInfo<T>> getRevisionInfo(Serializable id, Integer max, Class<T> type) {
        ArrayList<RevInfo<T>> result = new ArrayList<RevInfo<T>>(5);
        if (!type.isAnnotationPresent(Audited.class)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No @Audited annotation on " + type.getName());
            }
            return result;
        }
        if (id == null) {
            return result;
        }
        AuditQuery query = AuditReaderFactory.get((EntityManager)this.getEntityManager()).createQuery().forRevisionsOfEntity(type, false, true).addOrder(AuditEntity.revisionNumber().desc());
        query.add((AuditCriterion)new IdentifierEqAuditExpression(null, (Object)id, true)).setMaxResults(max == null ? 5 : max);
        List resultList = query.getResultList();
        if (resultList.isEmpty()) {
            return result;
        }
        for (Object[] object : resultList) {
            RevisionType rt = (RevisionType)object[2];
            switch (rt) {
                case ADD: {
                    result.add(new RevInfo<Object>(object[0], RevInfo.TYPE.CREATE, (RevisionInfo)((Object)object[1])));
                    break;
                }
                case MOD: {
                    result.add(new RevInfo<Object>(object[0], RevInfo.TYPE.UPDATE, (RevisionInfo)((Object)object[1])));
                    break;
                }
                case DEL: {
                    result.add(new RevInfo<Object>(object[0], RevInfo.TYPE.DELETE, (RevisionInfo)((Object)object[1])));
                }
            }
        }
        return result;
    }

    @Override
    public <T> List<Number> getRevisionNumbers(Serializable id, Class<T> type) {
        if (!type.isAnnotationPresent(Audited.class)) {
            return Collections.emptyList();
        }
        return AuditReaderFactory.get((EntityManager)this.getEntityManager()).getRevisions(type, (Object)id);
    }

    @Override
    public <T extends EntityInterface> T previousState(Serializable id, Class<T> type, int stepsBack) {
        List<RevInfo<T>> revisionInfo = this.getRevisionInfo(id, stepsBack + 1, type);
        return (T)(revisionInfo.size() == 2 ? (EntityInterface)revisionInfo.get(stepsBack).entity() : null);
    }

    @Override
    public <E> List<RevInfo<E>> changes(E e, Integer max) {
        return this.getRevisionInfo(((EntityInterface)e).getId(), max, e.getClass()).stream().map(ri -> new RevInfo(ri.entity(), ri.type(), ri.revisionInfo())).collect(Collectors.toList());
    }
}

