/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.cfg.xml.CustomListCatalogConfig;
import org.fugerit.java.core.cfg.xml.GenericListCatalogConfig;
import org.fugerit.java.core.cfg.xml.XmlBeanHelper;
import org.fugerit.java.core.io.helper.StreamHelper;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.core.util.collection.ListMapStringKey;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenCatalogRelation;
import org.fugerit.java.daogen.base.config.DaogenGeneratorCatalog;
import org.fugerit.java.daogen.base.config.DaogenTypeMapper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DaogenCatalogConfig
extends CustomListCatalogConfig<DaogenCatalogField, DaogenCatalogEntity> {
    public static final String ATT_DAOGEN_ROOT = "daogen-config";
    public static final String ATT_DAOGEN_ENTITY = "entity";
    public static final String ATT_DAOGEN_FIELD = "field";
    public static final String ATT_DAOGEN_RELATION = "relation";
    private static final long serialVersionUID = 5491328999494021347L;
    private ListMapStringKey<DaogenCatalogRelation> relations;
    public static final String DEFAULT_LINE_SEPARATOR = "\r\n";
    private Properties classConfig;
    private DaogenTypeMapper typeMapper;
    private List<DaogenGeneratorCatalog> generatorCatalogs;
    private DaogenGeneratorCatalog decoratorCatalog;
    private String lineSeparator;

    public DaogenCatalogConfig() {
        super(ATT_DAOGEN_ENTITY, ATT_DAOGEN_FIELD);
        this.getGeneralProps().setProperty("type", DaogenCatalogField.class.getName());
        this.getGeneralProps().setProperty("list-type", DaogenCatalogEntity.class.getName());
        this.classConfig = new Properties();
        this.relations = new ListMapStringKey();
        this.generatorCatalogs = new ArrayList<DaogenGeneratorCatalog>();
        this.lineSeparator = DEFAULT_LINE_SEPARATOR;
    }

    public String getGeneralProp(String key) {
        return this.getGeneralProps().getProperty(key);
    }

    public String getGeneralProp(String key, String defValue) {
        return this.getGeneralProps().getProperty(key, defValue);
    }

    public static DaogenCatalogConfig loadConfig(InputStream input) throws ConfigException {
        return DaogenCatalogConfig.loadConfig(input, DaogenCatalogConfig.class, null);
    }

    public static DaogenCatalogConfig loadConfig(InputStream input, Properties overrideProperties) throws ConfigException {
        return DaogenCatalogConfig.loadConfig(input, DaogenCatalogConfig.class, overrideProperties);
    }

    private static void loadGeneratorCatalog(DaogenCatalogConfig config, Class<?> c) throws ConfigException {
        block14: {
            String pathGeneratorCatalog = config.getGeneralProps().getProperty("generator-catalog", "cl://config/default-generator-catalog.xml");
            try (InputStream is = StreamHelper.resolveStream((String)pathGeneratorCatalog, null, c);){
                String extendsDefault;
                DaogenGeneratorCatalog generatorCatalog = new DaogenGeneratorCatalog();
                DaogenCatalogConfig.load((InputStream)is, (GenericListCatalogConfig)generatorCatalog);
                config.getGeneratorCatalogs().add(generatorCatalog);
                if ("cl://config/default-generator-catalog.xml".equalsIgnoreCase(pathGeneratorCatalog) || !"true".equalsIgnoreCase(extendsDefault = generatorCatalog.getGeneralProps().getProperty("extends-default"))) break block14;
                try (InputStream isDef = StreamHelper.resolveStream((String)"cl://config/default-generator-catalog.xml", null, c);){
                    DaogenGeneratorCatalog generatorCatalogDef = new DaogenGeneratorCatalog();
                    DaogenCatalogConfig.load((InputStream)isDef, (GenericListCatalogConfig)generatorCatalogDef);
                    config.getGeneratorCatalogs().add(generatorCatalogDef);
                }
            }
            catch (Exception e) {
                throw ConfigException.convertExMethod((String)"loadGeneratorCatalog", (Exception)e);
            }
        }
    }

    public static DaogenCatalogConfig loadConfig(InputStream input, Class<?> c) throws ConfigException {
        return DaogenCatalogConfig.loadConfig(input, c, null);
    }

    public static DaogenCatalogConfig loadConfig(InputStream input, Class<?> c, Properties overrideProperties) throws ConfigException {
        DaogenCatalogConfig config = new DaogenCatalogConfig();
        try {
            DaogenCatalogConfig.load((InputStream)input, (GenericListCatalogConfig)config);
            if (overrideProperties != null) {
                config.getLogger().info("override properties -> {}", (Object)overrideProperties);
                for (Object k2 : overrideProperties.keySet()) {
                    String key = k2.toString();
                    String value = overrideProperties.getProperty(key);
                    config.getLogger().info("ovverride {} -> {}", (Object)key, (Object)value);
                    config.getGeneralProps().setProperty(key, value);
                }
                config.getGeneralProps().keySet().stream().sorted().forEach(k -> config.getLogger().info("prop key : {} value : {}", k, (Object)config.getGeneralProps().getProperty(k.toString())));
            }
            String classConfigPath = config.getGeneralProps().getProperty("class-config", "cl://config/daogen_default_class_config.xml");
            try (InputStream is = StreamHelper.resolveStream((String)classConfigPath, null, c);){
                config.classConfig.loadFromXML(is);
            }
            String typeMapperClass = config.getGeneralProps().getProperty("type-mapper", "org.fugerit.java.daogen.base.config.DaogenTypeMapper");
            DaogenTypeMapper typeMapper = (DaogenTypeMapper)ClassHelper.newInstance((String)typeMapperClass);
            typeMapper.init(config);
            config.typeMapper = typeMapper;
            String pathDecoratorCatalog = config.getGeneralProps().getProperty("decorator-catalog", "cl://config/default-decorator-catalog.xml");
            DaogenGeneratorCatalog daogenDecoratorCatalog = new DaogenGeneratorCatalog();
            if (pathDecoratorCatalog != null) {
                try (InputStream is = StreamHelper.resolveStream((String)pathDecoratorCatalog, null, c);){
                    daogenDecoratorCatalog.configureXML(is);
                }
            }
            config.setDecoratorCatalog(daogenDecoratorCatalog);
            DaogenCatalogConfig.loadGeneratorCatalog(config, c);
        }
        catch (Exception e) {
            throw ConfigException.convertExMethod((String)"loadConfig", (Exception)e);
        }
        return config;
    }

    private void finishingTouch() {
        this.getIdSet().forEach(entityId -> ((DaogenCatalogEntity)((Object)((Object)this.getListMap((String)entityId)))).finishingTouch());
    }

    public void configure(Element tag) throws ConfigException {
        super.configure(tag);
        NodeList relationTags = tag.getElementsByTagName(ATT_DAOGEN_RELATION);
        for (int k = 0; k < relationTags.getLength(); ++k) {
            Element relationTag = (Element)relationTags.item(k);
            DaogenCatalogRelation relation = new DaogenCatalogRelation();
            try {
                XmlBeanHelper.setFromElement((Object)((Object)relation), (Element)relationTag);
                this.getRelations().add((Object)relation);
                DaogenCatalogEntity entity = (DaogenCatalogEntity)((Object)this.getListMap(relation.getFrom()));
                entity.getRelations().add((Object)relation);
                continue;
            }
            catch (Exception e) {
                throw new ConfigException((Throwable)e);
            }
        }
        this.finishingTouch();
    }

    public Properties getClassConfig() {
        return this.classConfig;
    }

    public DaogenTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public Collection<DaogenGeneratorCatalog> getGeneratorCatalogs() {
        return this.generatorCatalogs;
    }

    public ListMapStringKey<DaogenCatalogRelation> getRelations() {
        return this.relations;
    }

    public DaogenGeneratorCatalog getDecoratorCatalog() {
        return this.decoratorCatalog;
    }

    public void setDecoratorCatalog(DaogenGeneratorCatalog decoratorCatalog) {
        this.decoratorCatalog = decoratorCatalog;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }
}

