/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.config;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.db.connect.ConnectionFactory;
import org.fugerit.java.core.db.metadata.ColumnModel;
import org.fugerit.java.core.db.metadata.DataBaseModel;
import org.fugerit.java.core.db.metadata.ForeignKeyModel;
import org.fugerit.java.core.db.metadata.IndexModel;
import org.fugerit.java.core.db.metadata.MetaDataUtils;
import org.fugerit.java.core.db.metadata.TableId;
import org.fugerit.java.core.db.metadata.TableModel;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.core.util.collection.ListMapStringKey;
import org.fugerit.java.core.xml.dom.DOMIO;
import org.fugerit.java.daogen.base.config.DaogenCatalogRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DaogenConfigDump {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DaogenConfigDump.class);
    public static final String PARAM_TABLE_LIST = "table-list";
    public static final String PARAM_TABLE_LIST_ALL = "*";
    public static final String PARAM_CATALOG = "catalog";
    public static final String PARAM_SCHEMA = "schema";
    public static final String PARAM_ENTITY_TYPE = "entity-types";
    public static final String PARAM_ENTITY_TYPE_ALL = "all";
    public static final String PARAM_ENTITY_TYPE_DEFAULT = "all";

    private DaogenConfigDump() {
    }

    private static void addIfNotEmpty(String attName, String attValue, Element tag) {
        if (StringUtils.isNotEmpty((String)attValue)) {
            tag.setAttribute(attName, attValue);
        }
    }

    public static void dumpConfig(ConnectionFactory cf, Properties params, Writer writer, List<String> tableNameList) throws ConfigException {
        DaogenConfigDump.dumpConfig(cf, params, writer, tableNameList, new Properties());
    }

    private static void dumpConfigFK(TableModel tableModel, Element currentEntityTag, ListMapStringKey<DaogenCatalogRelation> relations) {
        ArrayList<String> fk = new ArrayList<String>();
        for (ForeignKeyModel foreignKeyModel : tableModel.getForeignKeyList()) {
            log.info("foreign key : {}", (Object)foreignKeyModel);
            fk.add(foreignKeyModel.getForeignTableId().toIdString());
            DaogenCatalogRelation relation = new DaogenCatalogRelation();
            relation.setName(tableModel.getTableId().getTableName() + "_" + foreignKeyModel.getForeignTableId().getTableName());
            relation.setMode("one");
            relation.setFrom(tableModel.getTableId().toIdString());
            relation.setTo(foreignKeyModel.getForeignTableId().toIdString());
            relation.setId(relation.getFrom() + "_" + relation.getTo());
            relation.setComment("Dump generated relation");
            relations.add((Object)relation);
            ArrayList<String> currentKey = new ArrayList<String>();
            for (ColumnModel col : foreignKeyModel.internalColumnList(tableModel)) {
                currentKey.add(col.getName());
            }
            relation.setKey(StringUtils.concat((String)",", currentKey));
        }
        if (!fk.isEmpty()) {
            currentEntityTag.setAttribute("foreignKeys", StringUtils.concat((String)",", fk));
        }
    }

    private static void dumpConfigColumns(TableModel tableModel, Element currentEntityTag, Document doc) {
        for (ColumnModel columnModel : tableModel.getColumnList()) {
            log.info("column : {} ({})", (Object)columnModel, (Object)columnModel.getComment());
            Element currentFieldTag = doc.createElement("field");
            currentFieldTag.setAttribute("id", columnModel.getName());
            currentFieldTag.setAttribute("comments", columnModel.getComment());
            currentFieldTag.setAttribute("sqlType", String.valueOf(columnModel.getTypeSql()));
            currentFieldTag.setAttribute("sqlTypeName", columnModel.getTypeName());
            currentFieldTag.setAttribute("size", String.valueOf(columnModel.getSize()));
            String nullable = "unknown";
            if (columnModel.getNullable() == 1) {
                nullable = "yes";
            } else if (columnModel.getNullable() == 0) {
                nullable = "no";
            }
            currentFieldTag.setAttribute("nullable", nullable);
            currentFieldTag.setAttribute("javaType", columnModel.getJavaType());
            currentEntityTag.appendChild(currentFieldTag);
        }
    }

    private static void dumpRelations(ListMapStringKey<DaogenCatalogRelation> relations, Document doc, Element root) {
        for (DaogenCatalogRelation rel : relations) {
            Element currentRelationTag = doc.createElement("relation");
            currentRelationTag.setAttribute("id", rel.getId());
            currentRelationTag.setAttribute("name", rel.getName());
            currentRelationTag.setAttribute("from", rel.getFrom());
            currentRelationTag.setAttribute("to", rel.getTo());
            currentRelationTag.setAttribute("key", rel.getKey());
            currentRelationTag.setAttribute("mode", rel.getMode());
            currentRelationTag.setAttribute("comment", rel.getComment());
            root.appendChild(currentRelationTag);
        }
    }

    public static void dumpConfigWorker(DataBaseModel dbModel, Document doc, Element root, Properties mapToTables) throws ConfigException {
        ListMapStringKey relations = new ListMapStringKey();
        for (TableModel tableModel : dbModel.getTableList()) {
            Element currentEntityTag = doc.createElement("entity");
            String tableName = tableModel.getName();
            String mapToTable = mapToTables.getProperty(tableName);
            if (mapToTable != null) {
                TableId tableId = tableModel.getTableId();
                tableId.setTableName(mapToTable);
                DaogenConfigDump.addIfNotEmpty("mapToTable", tableName, currentEntityTag);
            }
            currentEntityTag.setAttribute("id", tableModel.getTableId().toIdString());
            DaogenConfigDump.addIfNotEmpty("name", tableModel.getName(), currentEntityTag);
            DaogenConfigDump.addIfNotEmpty(PARAM_SCHEMA, tableModel.getSchema(), currentEntityTag);
            DaogenConfigDump.addIfNotEmpty(PARAM_CATALOG, tableModel.getCatalog(), currentEntityTag);
            DaogenConfigDump.addIfNotEmpty("comments", tableModel.getComment(), currentEntityTag);
            root.appendChild(currentEntityTag);
            log.info("current table : {} ({})", (Object)tableModel, (Object)tableModel.getComment());
            IndexModel primaryKey = tableModel.getPrimaryKey();
            if (primaryKey != null) {
                log.info("primary key : {} - {}", (Object)primaryKey, (Object)primaryKey.getColumnList().size());
                ArrayList<String> temp = new ArrayList<String>();
                for (ColumnModel columnModel : primaryKey.getColumnList()) {
                    temp.add(columnModel.getName());
                }
                currentEntityTag.setAttribute("primaryKey", StringUtils.concat((String)",", temp));
            }
            for (IndexModel indexModel : tableModel.getIndexList()) {
                log.info("index : {}", (Object)indexModel);
            }
            DaogenConfigDump.dumpConfigFK(tableModel, currentEntityTag, (ListMapStringKey<DaogenCatalogRelation>)relations);
            DaogenConfigDump.dumpConfigColumns(tableModel, currentEntityTag, doc);
        }
        DaogenConfigDump.dumpRelations((ListMapStringKey<DaogenCatalogRelation>)relations, doc, root);
    }

    public static void dumpConfig(ConnectionFactory cf, Properties params, Writer writer, List<String> tableNameList, Properties mapToTables) throws ConfigException {
        try {
            String catalog = params.getProperty(PARAM_CATALOG);
            String schema = params.getProperty(PARAM_SCHEMA);
            String paramEntityType = params.getProperty(PARAM_ENTITY_TYPE, "all");
            String[] types = new String[]{paramEntityType};
            if ("all".equalsIgnoreCase(paramEntityType)) {
                types = MetaDataUtils.typesAll();
            }
            DataBaseModel dbModel = MetaDataUtils.createModel((ConnectionFactory)cf, (String)catalog, (String)schema, tableNameList, (String[])types);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("daogen-config");
            DaogenConfigDump.dumpConfigWorker(dbModel, doc, root, mapToTables);
            DOMIO.writeDOMIndent((Node)root, (Writer)writer);
        }
        catch (Exception e) {
            throw ConfigException.convertExMethod((String)"dumpConfig", (Exception)e);
        }
    }
}

