/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.cfg.xml.FactoryType;
import org.fugerit.java.core.javagen.JavaGenerator;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenGeneratorCatalog;
import org.fugerit.java.daogen.base.gen.DaogenBasicDecorator;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaogenFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DaogenFacade.class);

    private DaogenFacade() {
    }

    private static void generageFile(JavaGenerator gen) throws IOException {
        log.debug("Generating : {} START", (Object)gen);
        gen.generate();
        gen.write();
        log.debug("Generating : {} END", (Object)gen);
    }

    private static void handleCurrentGenerator(DaogenBasicGenerator generator, DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity, FactoryType dataType) throws ConfigException, IOException, ClassNotFoundException, NoSuchMethodException {
        if (generator.isGenerate(daogenConfig, entity)) {
            Collection decorators = daogenConfig.getDecoratorCatalog().getDataList(dataType.getId());
            if (decorators != null) {
                for (FactoryType decoratorType : decorators) {
                    DaogenBasicDecorator decorator = (DaogenBasicDecorator)ClassHelper.newInstance((String)decoratorType.getType());
                    decorator.init(generator);
                }
            }
            generator.init(daogenConfig, entity);
            DaogenFacade.generageFile((JavaGenerator)generator);
        }
    }

    private static void handleGenerators(DaogenCatalogConfig daogenConfig, DaogenGeneratorCatalog generatorCatalog, DaogenCatalogEntity entity) throws ConfigException, IOException, ClassNotFoundException, NoSuchMethodException {
        if (generatorCatalog.getEntityGenerators(daogenConfig) != null) {
            for (FactoryType dataType : generatorCatalog.getEntityGenerators(daogenConfig)) {
                log.info("generator : {} -> {}", (Object)dataType.getInfo(), (Object)dataType.getType());
                if (!daogenConfig.getGeneralProps().containsKey(dataType.getInfo())) continue;
                DaogenFacade.handleCurrentGenerator((DaogenBasicGenerator)((Object)ClassHelper.newInstance((String)dataType.getType())), daogenConfig, entity, dataType);
            }
        }
    }

    private static void generate(DaogenCatalogConfig daogenConfig, DaogenGeneratorCatalog generatorCatalog) throws ConfigException, IOException, ClassNotFoundException, NoSuchMethodException {
        ArrayList entityIdList = new ArrayList(daogenConfig.getIdSet());
        Collections.sort(entityIdList);
        for (String entityId : entityIdList) {
            DaogenCatalogEntity entity = (DaogenCatalogEntity)((Object)daogenConfig.getListMap(entityId));
            log.info("Describe : {} -> {}", (Object)entity.getId(), (Object)entity.describe());
            DaogenFacade.handleGenerators(daogenConfig, generatorCatalog, entity);
        }
        if (generatorCatalog.getFactoryGenerators(daogenConfig) != null) {
            for (FactoryType dataType : generatorCatalog.getFactoryGenerators(daogenConfig)) {
                if (!daogenConfig.getGeneralProps().containsKey(dataType.getInfo())) continue;
                DaogenBasicGenerator generator = (DaogenBasicGenerator)((Object)ClassHelper.newInstance((String)dataType.getType()));
                generator.init(daogenConfig, null);
                DaogenFacade.generageFile((JavaGenerator)generator);
            }
        }
    }

    public static void generate(InputStream fis, Properties overrideProperties) throws ConfigException {
        try {
            DaogenCatalogConfig daogenConfig = DaogenCatalogConfig.loadConfig(fis, overrideProperties);
            for (DaogenGeneratorCatalog generatorCatalog : daogenConfig.getGeneratorCatalogs()) {
                DaogenFacade.generate(daogenConfig, generatorCatalog);
            }
        }
        catch (IOException | ClassNotFoundException | NoSuchMethodException e) {
            throw ConfigException.convertEx((String)"Error during DAO generation", (Exception)e);
        }
    }

    public static void generate(InputStream fis) throws ConfigException {
        DaogenFacade.generate(fis, null);
    }
}

