/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.config;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.io.helper.StreamHelper;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaogenTypeMapper
implements Serializable {
    private static final long serialVersionUID = -9010791577199355112L;
    protected static Logger logger = LoggerFactory.getLogger(DaogenTypeMapper.class);
    private static final String PREFIX_MODEL = "model_";
    private DaogenCatalogConfig config;
    private Properties typeMapConfig = new Properties();
    private boolean ngMode;
    private String testAltPrefix;

    public void init(DaogenCatalogConfig config) throws ConfigException {
        this.ngMode = "enabled".equalsIgnoreCase(config.getGeneralProps().getProperty("type-mapper-time-ng", "disabled"));
        this.testAltPrefix = this.ngMode ? "ng_" : "";
        String path = config.getGeneralProps().getProperty("type-map-config", "cl://config/daogen_default_type_mapping.xml");
        try (InputStream is = StreamHelper.resolveStream((String)path);){
            this.getTypeMapConfig().loadFromXML(is);
        }
        catch (Exception e) {
            throw new ConfigException((Throwable)e);
        }
    }

    public Properties getTypeMapConfig() {
        return this.typeMapConfig;
    }

    protected DaogenCatalogConfig getConfig() {
        return this.config;
    }

    public String mapForModel(DaogenCatalogField field) {
        String type = field.getJavaType();
        type = this.ngMode ? this.getTypeMapConfig().getProperty(PREFIX_MODEL + this.testAltPrefix + type, this.getTypeMapConfig().getProperty(PREFIX_MODEL + type, type)) : this.getTypeMapConfig().getProperty(PREFIX_MODEL + type, type);
        return type;
    }
}

