/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenHelperGenerator;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;

public abstract class DaogenBasicHelperGenerator
extends DaogenBasicGenerator {
    public static final int MODE_FULL = 1;
    public static final int MODE_REAL = 2;
    public static final int MODE_HELPER = 3;
    private int mode = 1;

    protected DaogenBasicHelperGenerator() {
    }

    @Override
    public void init(String sourceFolder, String fullObjectBName, String javaStyle, DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        super.init(sourceFolder, fullObjectBName, javaStyle, daogenConfig, entity);
        if (this.getMode() == 2) {
            this.setNoCustomComment(true);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isModeFull() {
        return this.getMode() == 1;
    }

    public boolean isModeReal() {
        return this.getMode() == 2;
    }

    public boolean isModeHelper() {
        return this.getMode() == 3;
    }

    public boolean isModeFullOrReal() {
        return this.isModeFull() || this.isModeReal();
    }

    public boolean isModeFullOrHelper() {
        return this.isModeFull() || this.isModeHelper();
    }

    protected void configRealClass() throws ConfigException {
        this.setExtendsClass(DaogenHelperGenerator.toHelperClassName(this.getJavaName()));
        try {
            this.checkSkipRealClass();
        }
        catch (IOException e) {
            throw new ConfigException((Throwable)e);
        }
    }

    protected void generateRealClass() throws IOException {
        this.println("\t// [HELPER/IMPL MODEL] this class is a stub and can be modified as you see fit (it will not been overwritten)");
    }
}

