/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.stream.Stream;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.config.DaogenCustomCode;
import org.fugerit.java.daogen.base.config.DaogenHelperGenerator;
import org.fugerit.java.daogen.base.gen.DaogenBasicHelperGenerator;
import org.fugerit.java.daogen.base.gen.GeneratorKeyHelper;
import org.fugerit.java.daogen.base.gen.util.FacadeGeneratorUtils;

public class FacadeDefGenerator
extends DaogenBasicHelperGenerator {
    public static final String KEY = FacadeDefGenerator.class.getSimpleName();
    public static final String PRIMARY_KEY = "primary key";
    public static final String METHOD_LOAD_BY_PK = "loadById";
    public static final String METHOD_DELETE_BY_PK = "deleteById";
    public static final String METHOD_UPDATE_BY_PK = "updateById";
    private static final String FOR_ENTITY_LIT = " for entity : ";
    private static final String PARAM_CONTEXT_LIT = " * @param context";

    public String getKey() {
        return KEY;
    }

    @Override
    public boolean isGenerate(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) {
        return FacadeGeneratorUtils.isFacadeGenerate(entity);
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        if (this.isModeHelper()) {
            super.init(DaogenHelperGenerator.toHelperSourceFolder(daogenConfig), DaogenHelperGenerator.toHelperClassName(FacadeDefGenerator.fullObjectName(daogenConfig.getGeneralProp("package-facade-def"), DaogenCatalogConstants.facadeDefName(entity))), "interface", daogenConfig, entity);
        } else {
            super.init(daogenConfig.getGeneralProp("src-main-java"), FacadeDefGenerator.fullObjectName(daogenConfig.getGeneralProp("package-facade-def"), DaogenCatalogConstants.facadeDefName(entity)), "interface", daogenConfig, entity);
        }
        if (this.isModeReal()) {
            this.configRealClass();
        } else {
            this.setClassDaogenContext(DaogenClassConfigHelper.addImport(daogenConfig, "dao.context", this.getImportList()));
            this.setClassDaoException(DaogenClassConfigHelper.addImport(daogenConfig, "dao.exception", this.getImportList()));
            this.setClassBaseResult(DaogenClassConfigHelper.addImport(daogenConfig, "dao.result", this.getImportList()));
            this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + this.getEntityModelName());
            this.getImportList().add(Stream.class.getName());
            if (StringUtils.isNotEmpty((String)this.getCurrentEntity().getPrimaryKey())) {
                this.getImportList().add(Optional.class.getName());
            }
        }
    }

    private void methodByKey(GeneratorKeyHelper keyHelper, String methodName, String returnType, String returnJavadoc, String comment) {
        this.getWriter().println("\t/**");
        this.getWriter().println("\t * " + comment);
        this.getWriter().println("\t *");
        this.getWriter().println("\t * @param context\tDAO Context");
        this.getWriter().println(keyHelper.getJavadocParams());
        this.getWriter().println("\t *");
        this.getWriter().println("\t * @return " + returnJavadoc);
        this.getWriter().println("\t * @throws " + this.getClassDaoException() + "\t\t\t" + "in case of errors");
        this.getWriter().println("\t */");
        this.getWriter().println("\t" + returnType + " " + methodName + "( " + this.getClassDaogenContext() + " context, " + keyHelper.getKeyParams() + " ) throws " + this.getClassDaoException() + ";");
        this.getWriter().println();
    }

    private void loadAllCommentHelper(boolean stream) {
        String addOn = "";
        if (stream) {
            addOn = " (as a stream)";
        }
        this.getWriter().println("\t/**");
        this.getWriter().println("\t * Method to load all the items for entity : " + this.getEntityModelName() + addOn);
        this.getWriter().println("\t *");
        this.getWriter().println("\t * @param context\tDAOContext");
        this.getWriter().println("\t * @param finder\tthe finder encapsulating search params");
        this.getWriter().println("\t *");
        if (stream) {
            this.getWriter().println("\t * @return stream on the result");
        } else {
            this.getWriter().println("\t * @return search result");
        }
        this.getWriter().println("\t * @throws " + this.getClassDaoException() + "\t\t\t" + "in case of errors");
        this.getWriter().println("\t */");
    }

    @Override
    public void generateDaogenBody() throws IOException {
        if (this.isModeReal()) {
            this.generateRealClass();
        } else {
            this.getWriter().println("\t/*");
            this.getWriter().println("\t * NOTE: It is advised to use a finder for encapsulating search params, except searches for primary key.");
            this.getWriter().println("\t */");
            this.getWriter().println();
            this.getWriter().println("\t/**");
            this.getWriter().println("\t * Method to load all the items for entity : " + this.getEntityModelName());
            this.getWriter().println("\t *");
            this.getWriter().println("\t * @param context\tDAOContext");
            this.getWriter().println("\t *");
            this.getWriter().println("\t * @return search result");
            this.getWriter().println("\t * @throws " + this.getClassDaoException() + "\t\t\t" + "in case of errors");
            this.getWriter().println("\t */");
            this.getWriter().println("\t" + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> loadAll( " + this.getClassDaogenContext() + " context ) throws " + this.getClassDaoException() + ";");
            this.getWriter().println();
            this.loadAllCommentHelper(false);
            this.getWriter().println("\t" + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> loadAllByFinder( " + this.getClassDaogenContext() + " context, " + this.getEntityFinderName() + " finder ) throws " + this.getClassDaoException() + ";");
            this.getWriter().println();
            this.loadAllCommentHelper(true);
            this.getWriter().println("\t" + Stream.class.getSimpleName() + "<" + this.getEntityModelName() + "> loadAllByFinderStream( " + this.getClassDaogenContext() + " context, " + this.getEntityFinderName() + " finder ) throws " + this.getClassDaoException() + ";");
            this.getWriter().println();
            if (StringUtils.isNotEmpty((String)this.getCurrentEntity().getPrimaryKey())) {
                GeneratorKeyHelper primaryKeyHelper = new GeneratorKeyHelper(this.getDaogenConfig(), this.getCurrentEntity(), this.getCurrentEntity().getPrimaryKey());
                this.methodByKey(primaryKeyHelper.setForLoadInterface(), METHOD_LOAD_BY_PK, this.getEntityModelName(), "The found object or <code>null</code>", "Load method by primary key for entity : " + this.getEntityModelName());
                this.methodByKey(primaryKeyHelper.setForLoadInterface(), METHOD_LOAD_BY_PK + Optional.class.getSimpleName(), Optional.class.getSimpleName() + "<" + this.getEntityModelName() + ">", "The found object or <code>null</code>", "Load method by primary key for entity : " + this.getEntityModelName());
                if (FacadeGeneratorUtils.isFacadeModeInsert(this.getCurrentEntity())) {
                    DaogenCustomCode.addCommentFacadeDef("facade.def.create", DaogenCustomCode.INDENT_1, (PrintWriter)this.getWriter(), this.getEntityModelName());
                    this.getWriter().println("\t" + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> create( " + this.getClassDaogenContext() + " context, " + this.getEntityModelName() + " model ) throws " + this.getClassDaoException() + ";");
                    this.getWriter().println();
                }
                if (FacadeGeneratorUtils.isFacadeModeDelete(this.getCurrentEntity())) {
                    this.methodByKey(primaryKeyHelper.setForLoadInterface(), METHOD_DELETE_BY_PK, this.getEntityBaseResult(), "Delete result (resultCode=0, delete ok)", "Delete method by primary key for entity : " + this.getEntityModelName());
                }
                if (FacadeGeneratorUtils.isFacadeModeUpdate(this.getCurrentEntity())) {
                    this.methodByKey(primaryKeyHelper.setForUpdateInterface(), METHOD_UPDATE_BY_PK, this.getEntityBaseResult(), "Update result (resultCode=0, update ok)", "Delete method by primary key for entity : " + this.getEntityModelName());
                }
            }
        }
    }
}

