/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.config.DaogenHelperGenerator;
import org.fugerit.java.daogen.base.gen.DaogenBasicHelperGenerator;
import org.fugerit.java.daogen.base.gen.GeneratorKeyHelper;
import org.fugerit.java.daogen.base.gen.util.FacadeGeneratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacadeImplDataGenerator
extends DaogenBasicHelperGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacadeImplDataGenerator.class);
    public static final String KEY = FacadeImplDataGenerator.class.getSimpleName();

    public String getKey() {
        return KEY;
    }

    @Override
    public boolean isGenerate(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) {
        return FacadeGeneratorUtils.isFacadeGenerate(entity);
    }

    private void initConfigHelperMode(DaogenCatalogConfig daogenConfig) {
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + this.getEntityModelName());
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-rse") + "." + this.getEntityRSEName());
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-facade-def") + "." + this.getEntityFinderName());
        this.setClassDaogenContext(DaogenClassConfigHelper.addImport(daogenConfig, "dao.context", this.getImportList()));
        this.setClassDaoHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.daohelper", this.getImportList()));
        this.setClassDataFacade(DaogenClassConfigHelper.addImport(daogenConfig, "dao.datafacade", this.getImportList()));
        this.setClassSelectHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.selecthelper", this.getImportList()));
        if (StringUtils.isNotEmpty((String)this.getCurrentEntity().getPrimaryKey())) {
            if (FacadeGeneratorUtils.isFacadeModeInsert(this.getCurrentEntity())) {
                this.setClassInsertHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.inserthelper", this.getImportList()));
            }
            if (FacadeGeneratorUtils.isFacadeModeUpdate(this.getCurrentEntity())) {
                this.setClassUpdateHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.updatehelper", this.getImportList()));
            }
            if (FacadeGeneratorUtils.isFacadeModeDelete(this.getCurrentEntity())) {
                this.setClassDeleteHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.deletehelper", this.getImportList()));
            }
        }
        this.setClassDaoException(DaogenClassConfigHelper.addImport(daogenConfig, "dao.exception", this.getImportList()));
        this.setClassBaseResult(DaogenClassConfigHelper.addImport(daogenConfig, "dao.result", this.getImportList()));
        if (this.isModeFull()) {
            this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-facade-def") + "." + this.getEntityFacadeDefName());
            this.setImplementsInterface(this.getEntityFacadeDefName());
        } else {
            this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-facade-def") + "." + DaogenHelperGenerator.toHelperClassName(this.getEntityFacadeDefName()));
            this.setImplementsInterface(DaogenHelperGenerator.toHelperClassName(this.getEntityFacadeDefName()));
        }
        this.getImportList().add(Stream.class.getName());
        if (StringUtils.isNotEmpty((String)this.getCurrentEntity().getPrimaryKey())) {
            this.getImportList().add(Optional.class.getName());
        }
        this.setExtendsClass(this.getClassDataFacade() + "<" + this.getEntityModelName() + ">");
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        if (this.isModeHelper()) {
            super.init(DaogenHelperGenerator.toHelperSourceFolder(daogenConfig), DaogenHelperGenerator.toHelperClassName(FacadeImplDataGenerator.fullObjectName(daogenConfig.getGeneralProp("package-facade-data-impl"), DaogenCatalogConstants.facadeImplDataName(entity))), "class", daogenConfig, entity);
        } else {
            super.init(daogenConfig.getGeneralProp("src-main-java"), FacadeImplDataGenerator.fullObjectName(daogenConfig.getGeneralProp("package-facade-data-impl"), DaogenCatalogConstants.facadeImplDataName(entity)), "class", daogenConfig, entity);
        }
        if (this.isModeReal()) {
            this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-facade-def") + "." + this.getEntityFacadeDefName());
            this.setImplementsInterface(this.getEntityFacadeDefName());
            this.setExtendsClass(DaogenHelperGenerator.toHelperClassName(this.getJavaName()));
            this.configRealClass();
        } else {
            this.initConfigHelperMode(daogenConfig);
        }
    }

    private static String columnConstantName(String col) {
        return "COL_" + col.toUpperCase();
    }

    public static String toFullTableName(DaogenCatalogEntity entity) {
        String tableName = entity.getName();
        if (StringUtils.isNotEmpty((String)entity.getMapToTable())) {
            tableName = entity.getMapToTable();
        }
        if (StringUtils.isNotEmpty((String)entity.getSchema())) {
            tableName = entity.getSchema() + "." + tableName;
        }
        if (StringUtils.isNotEmpty((String)entity.getCatalog())) {
            tableName = entity.getCatalog() + "." + tableName;
        }
        return tableName;
    }

    private String generateHelperClassSetupAndSequenceName() {
        String superType = this.getEntityFacadeDataImplName();
        if (this.isModeHelper()) {
            superType = DaogenHelperGenerator.toHelperClassName(superType);
        }
        String fullTableName = FacadeImplDataGenerator.toFullTableName(this.getCurrentEntity());
        this.getWriter().println("\tprivate static final String TABLE_NAME = \"" + fullTableName + "\";");
        this.getWriter().println();
        String queryViewInit = null;
        if (StringUtils.isNotEmpty((String)this.getCurrentEntity().getQueryView())) {
            this.getWriter().println("\tprivate static final String QUERY_VIEW = \"" + this.getCurrentEntity().getQueryView() + "\";");
            this.getWriter().println();
            queryViewInit = "QUERY_VIEW";
        }
        this.getWriter().println("\tpublic " + superType + "() {");
        String rseCreate = this.getEntityRSEName() + ".DEFAULT";
        String disableSingleton = this.getDaogenConfig().getGeneralProp("disable-singleton", "disabled");
        log.info("{} -> {}", (Object)"disable-singleton", (Object)disableSingleton);
        if ("enabled".equalsIgnoreCase(disableSingleton)) {
            rseCreate = "new " + this.getEntityRSEName() + "()";
        }
        this.getWriter().println("\t\tsuper( TABLE_NAME, " + rseCreate + ", " + queryViewInit + " );");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\tpublic " + superType + "( String tableName, String queryView ) {");
        this.getWriter().println("\t\tsuper( tableName, " + rseCreate + ", queryView );");
        this.getWriter().println("\t}");
        this.getWriter().println();
        String sequenceName = this.getDaogenConfig().getGeneralProp("default-sequence");
        if (StringUtils.isNotEmpty((String)this.getCurrentEntity().getSequenceName())) {
            sequenceName = this.getCurrentEntity().getSequenceName();
        }
        if (StringUtils.isNotEmpty((String)sequenceName)) {
            this.getWriter().println(" \tpublic static final String SEQUENCE_NAME = \"" + sequenceName + "\";");
            this.getWriter().println();
            this.getWriter().println(" \t@Override");
            this.getWriter().println(" \tpublic String getSequenceName() {");
            this.getWriter().println(" \t\treturn SEQUENCE_NAME;");
            this.getWriter().println(" \t}");
            this.getWriter().println();
        }
        return sequenceName;
    }

    private String generateHelperClassSetupAndDefaultOrderBy() {
        String defaultOrderBy = this.getCurrentEntity().getOrderBy();
        if (StringUtils.isNotEmpty((String)defaultOrderBy)) {
            this.getWriter().println("\t\tprotected static final String DEFAULT_ORDER_BY = \"" + defaultOrderBy + "\";");
            this.getWriter().println();
        }
        Iterator iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
            this.getWriter().println("\tpublic static final String " + FacadeImplDataGenerator.columnConstantName(field.getId()) + " = \"" + field.getId() + "\";");
        }
        this.getWriter().println();
        return defaultOrderBy;
    }

    private void generateHelperClassLoadAll(String defaultOrderBy) {
        this.getWriter().println("\t/* loadAll( context ) is inherited from BasicDataFacade */");
        this.getWriter().println();
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic " + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> loadAllByFinder( " + this.getClassDaogenContext() + " context, " + this.getEntityFinderName() + " finder ) throws DAOException {");
        this.getWriter().println("\t\t" + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> result = new " + this.getClassBaseResult() + "<>();");
        this.getWriter().println("\t\t" + this.getClassDaoHelper() + "<" + this.getEntityModelName() + ">" + " daoHelper = new " + this.getClassDaoHelper() + "<>( context );");
        this.getWriter().println("\t\tSelectHelper query = daoHelper.newSelectHelper( this.getQueryView(), this.getTableName() );");
        if (this.getCurrentEntity().containsDefaultId()) {
            this.getWriter().println("\t\tquery.andEqualParam( COL_ID, finder.getId() );");
        }
        this.getWriter().println("\t\tif ( finder.getModel() != null ) {");
        this.getWriter().println("\t\t\t" + this.getEntityModelName() + " model = finder.getModel();");
        Iterator iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
            this.getWriter().println("\t\t\tquery.andEqualParam( " + FacadeImplDataGenerator.columnConstantName(field.getId()) + ", model.get" + GeneratorNameHelper.toClassName((String)field.getId()) + "() );");
        }
        this.getWriter().println("\t\t}");
        if (StringUtils.isNotEmpty((String)defaultOrderBy)) {
            this.getWriter().println("\t\tquery.addOrderBy( DEFAULT_ORDER_BY );");
        }
        this.getWriter().println("\t\tdaoHelper.loadAllHelper( result.getList(), query, this.getRse() ); ");
        this.getWriter().println("\t\tresult.evaluateResultFromList(); ");
        this.getWriter().println("\t\treturn result;");
        this.getWriter().println("\t}");
        this.getWriter().println();
    }

    private void generateHelperClassLoadAllStream() {
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic " + Stream.class.getSimpleName() + "<" + this.getEntityModelName() + "> loadAllByFinderStream( " + this.getClassDaogenContext() + " context, " + this.getEntityFinderName() + " finder ) throws DAOException {");
        this.getWriter().println("\t\treturn this.loadAllByFinder( context, finder ).stream();");
        this.getWriter().println("\t}");
        this.getWriter().println();
    }

    private void generateHelperClassInsertColumnHandler(DaogenCatalogField colData, DaogenCatalogField colDataUpdate) {
        if (colData != null || colDataUpdate != null) {
            this.getWriter().println("\t\tjava.sql.Timestamp currentTime = new java.sql.Timestamp( System.currentTimeMillis() );");
        }
        if (colData != null) {
            this.getWriter().println("\t\t//  default-column-time-insert : true - i will set insert time");
            this.getWriter().println("\t\tmodel.set" + GeneratorNameHelper.toClassName((String)colData.getId()) + "( currentTime ); ");
        }
        if (colDataUpdate != null) {
            this.getWriter().println("\t\t//  default-column-time-update : true - i will set update time");
            this.getWriter().println("\t\tmodel.set" + GeneratorNameHelper.toClassName((String)colDataUpdate.getId()) + "( currentTime ); ");
        }
        this.getWriter().println("\t\tInsertHelper query = daoHelper.newInsertHelper( this.getTableName() );");
        Iterator iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
            if (!BooleanUtils.isTrue((String)field.getSelectOnly())) {
                this.getWriter().println("\t\tquery.addParam( " + FacadeImplDataGenerator.columnConstantName(field.getId()) + ", model.get" + GeneratorNameHelper.toClassName((String)field.getId()) + "() );");
                continue;
            }
            this.getWriter().println("\t\t// skipping selectOnly field : " + field.getId());
        }
    }

    private void generateHelperClassInsert(DaogenCatalogField colData, DaogenCatalogField colDataUpdate, String sequenceName, GeneratorKeyHelper primaryKeyHelper) {
        if (FacadeGeneratorUtils.isFacadeModeInsert(this.getCurrentEntity())) {
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic " + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> create( " + this.getClassDaogenContext() + " context, " + this.getEntityModelName() + " model ) throws DAOException {");
            this.getWriter().println("\t\t" + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> result = new " + this.getClassBaseResult() + "<>();");
            this.getWriter().println("\t\t" + this.getClassDaoHelper() + "<" + this.getEntityModelName() + ">" + " daoHelper = new " + this.getClassDaoHelper() + "<>( context );");
            if (sequenceName != null) {
                for (String currentField : primaryKeyHelper.getKeyFields()) {
                    DaogenCatalogField field = (DaogenCatalogField)((Object)this.getCurrentEntity().get(currentField));
                    if (!field.getJavaType().equals("java.math.BigDecimal") && !field.getJavaType().equals("java.lang.Long")) continue;
                    String className = GeneratorNameHelper.toClassName((String)currentField);
                    this.getWriter().println("\t\tif ( model.get" + className + "() == null ) { ");
                    this.getWriter().println("\t\t\tmodel.set" + className + "( this.generateId( context ) ); ");
                    this.getWriter().println("\t\t} ");
                }
            }
            this.generateHelperClassInsertColumnHandler(colData, colDataUpdate);
            this.getWriter().println("\t\tint res = daoHelper.update( query );");
            this.getWriter().println("\t\tthis.evaluteSqlUpdateResult(res, model, result);");
            this.getWriter().println("\t\treturn result;");
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
    }

    private void generateHelperClassLoadPk(GeneratorKeyHelper primaryKeyHelper) {
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic " + this.getEntityModelName() + " " + "loadById" + "( " + this.getClassDaogenContext() + " context, " + primaryKeyHelper.setForLoadInterface().getKeyParams() + " ) throws " + this.getClassDaoException() + " {");
        this.getWriter().println("\t\t" + this.getEntityModelName() + " result = null;");
        this.getWriter().println("\t\t" + this.getClassDaoHelper() + "<" + this.getEntityModelName() + ">" + " daoHelper = new " + this.getClassDaoHelper() + "<>( context );");
        this.getWriter().println("\t\tSelectHelper query = daoHelper.newSelectHelper( this.getQueryView(), this.getTableName() );");
        StringBuilder checkKey = new StringBuilder();
        int keyCount = 0;
        for (String currentField : primaryKeyHelper.getKeyFields()) {
            if (keyCount != 0) {
                checkKey.append(" || ");
            }
            checkKey.append(GeneratorNameHelper.toPropertyName((String)currentField));
            checkKey.append(" == null ");
            ++keyCount;
        }
        this.getWriter().println("\t\tif ( " + checkKey + " ) { ");
        this.getWriter().println("\t\t\t throw new DAOException( \"Null parameter in key " + primaryKeyHelper.getKeyParams() + "\" );");
        this.getWriter().println("\t\t} else { ");
        for (String currentField : primaryKeyHelper.getKeyFields()) {
            this.getWriter().println("\t\t\tquery.andEqualParam( COL_" + currentField.toUpperCase() + ", " + GeneratorNameHelper.toPropertyName((String)currentField) + " );");
        }
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\tresult = daoHelper.loadOneHelper( query, this.getRse() );");
        this.getWriter().println("\t\treturn result;");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic " + Optional.class.getSimpleName() + "<" + this.getEntityModelName() + "> " + "loadById" + "Optional( " + this.getClassDaogenContext() + " context, " + primaryKeyHelper.setForLoadInterface().getKeyParams() + " ) throws " + this.getClassDaoException() + " {");
        this.getWriter().println("\t\treturn " + Optional.class.getSimpleName() + ".ofNullable( " + "loadById" + "(" + " context, " + primaryKeyHelper.getFieldNames() + ") );");
        this.getWriter().println("\t}");
        this.getWriter().println();
    }

    private void generateHelperClassDelete(GeneratorKeyHelper primaryKeyHelper) {
        if (FacadeGeneratorUtils.isFacadeModeDelete(this.getCurrentEntity())) {
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic " + this.getEntityBaseResult() + " " + "deleteById" + "( " + this.getClassDaogenContext() + " context, " + primaryKeyHelper.setForLoadInterface().getKeyParams() + " ) throws " + this.getClassDaoException() + " {");
            this.getWriter().println("\t\t" + this.getEntityBaseResult() + " result = new " + this.getClassBaseResult() + "<>();");
            this.getWriter().println("\t\t" + this.getClassDaoHelper() + "<" + this.getEntityModelName() + ">" + " daoHelper = new " + this.getClassDaoHelper() + "<>( context );");
            this.getWriter().println("\t\tDeleteHelper query = daoHelper.newDeleteHelper( this.getTableName() );");
            for (String currentField : primaryKeyHelper.getKeyFields()) {
                this.getWriter().println("\t\tquery.andWhereParam( COL_" + currentField.toUpperCase() + ", " + GeneratorNameHelper.toPropertyName((String)currentField) + " );");
            }
            this.getWriter().println("\t\tint res = daoHelper.update( query );");
            this.getWriter().println("\t\tthis.evaluteSqlUpdateResult(res, null, result);");
            this.getWriter().println("\t\treturn result;");
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
    }

    private void generateHelperClassUpdate(DaogenCatalogField colDataUpdate, GeneratorKeyHelper primaryKeyHelper) {
        if (FacadeGeneratorUtils.isFacadeModeUpdate(this.getCurrentEntity())) {
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic " + this.getEntityBaseResult() + " " + "updateById" + "( " + this.getClassDaogenContext() + " context, " + this.getEntityModelName() + " model ) throws " + this.getClassDaoException() + " {");
            this.getWriter().println("\t\t" + this.getEntityBaseResult() + " result = new " + this.getClassBaseResult() + "<>();");
            this.getWriter().println("\t\t" + this.getClassDaoHelper() + "<" + this.getEntityModelName() + ">" + " daoHelper = new " + this.getClassDaoHelper() + "<>( context );");
            if (colDataUpdate != null) {
                this.getWriter().println("\t\t//  default-column-time-update : true - i will set update time");
                this.getWriter().println("\t\tmodel.set" + GeneratorNameHelper.toClassName((String)colDataUpdate.getId()) + "( new java.sql.Timestamp( System.currentTimeMillis() ) ); ");
            }
            this.getWriter().println("\t\tUpdateHelper query = daoHelper.newUpdateHelper( this.getTableName() );");
            Iterator<String> iterator = this.getCurrentEntity().iterator();
            while (iterator.hasNext()) {
                DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
                if (primaryKeyHelper.getKeyFields().contains(field.getId())) continue;
                if (!BooleanUtils.isTrue((String)field.getSelectOnly())) {
                    this.getWriter().println("\t\tquery.addSetParam( " + FacadeImplDataGenerator.columnConstantName(field.getId()) + ", model.get" + GeneratorNameHelper.toClassName((String)field.getId()) + "() );");
                    continue;
                }
                this.getWriter().println("\t\t// skipping selectOnly field : " + field.getId());
            }
            for (String currentField : primaryKeyHelper.getKeyFields()) {
                this.getWriter().println("\t\tquery.andWhereParam( COL_" + currentField.toUpperCase() + ", model.get" + GeneratorNameHelper.toClassName((String)currentField) + "() );");
            }
            this.getWriter().println("\t\tint res = daoHelper.update( query );");
            this.getWriter().println("\t\tthis.evaluteSqlUpdateResult(res, model, result);");
            this.getWriter().println("\t\treturn result;");
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
    }

    private void generateHelperClass() {
        String autoSetDateInsert = this.getDaogenConfig().getGeneralProps().getProperty("default-column-time-insert");
        String autoSetDateUpdate = this.getDaogenConfig().getGeneralProps().getProperty("default-column-time-update");
        String sequenceName = this.generateHelperClassSetupAndSequenceName();
        String defaultOrderBy = this.generateHelperClassSetupAndDefaultOrderBy();
        this.generateHelperClassLoadAll(defaultOrderBy);
        this.generateHelperClassLoadAllStream();
        if (StringUtils.isNotEmpty((String)this.getCurrentEntity().getPrimaryKey())) {
            GeneratorKeyHelper primaryKeyHelper = new GeneratorKeyHelper(this.getDaogenConfig(), this.getCurrentEntity(), this.getCurrentEntity().getPrimaryKey());
            DaogenCatalogField colData = null;
            DaogenCatalogField colDataUpdate = null;
            if (autoSetDateInsert != null) {
                colData = (DaogenCatalogField)((Object)this.getCurrentEntity().get(autoSetDateInsert));
            }
            if (autoSetDateUpdate != null) {
                colDataUpdate = (DaogenCatalogField)((Object)this.getCurrentEntity().get(autoSetDateUpdate));
            }
            this.generateHelperClassInsert(colData, colDataUpdate, sequenceName, primaryKeyHelper);
            this.generateHelperClassLoadPk(primaryKeyHelper);
            this.generateHelperClassDelete(primaryKeyHelper);
            this.generateHelperClassUpdate(colDataUpdate, primaryKeyHelper);
        }
    }

    @Override
    public void generateDaogenBody() throws IOException {
        this.addSerialVerUID();
        if (this.isModeReal()) {
            this.generateRealClass();
        } else {
            this.generateHelperClass();
        }
    }
}

