/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import java.util.Iterator;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.config.DaogenHelperGenerator;
import org.fugerit.java.daogen.base.gen.DaogenBasicHelperGenerator;
import org.fugerit.java.daogen.base.gen.util.FacadeGeneratorUtils;

public class FactoryDataImplGenerator
extends DaogenBasicHelperGenerator {
    public static final String KEY = FactoryDataImplGenerator.class.getSimpleName();

    public String getKey() {
        return KEY;
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        if (this.isModeHelper()) {
            super.init(DaogenHelperGenerator.toHelperSourceFolder(daogenConfig), DaogenHelperGenerator.toHelperClassName(daogenConfig.getGeneralProp("factory-data-impl")), "class", daogenConfig, null);
        } else {
            super.init(daogenConfig.getGeneralProp("src-main-java"), daogenConfig.getGeneralProp("factory-data-impl"), "class", daogenConfig, null);
        }
        String baseName = this.getDaogenConfig().getGeneralProp("factory-def");
        if (this.isModeReal()) {
            this.configRealClass();
        } else {
            String packageFacade = this.getDaogenConfig().getGeneralProp("package-facade-def");
            this.setClassDaoException(DaogenClassConfigHelper.addImport(daogenConfig, "dao.exception", this.getImportList()));
            for (String currentId : this.getDaogenConfig().getIdSet()) {
                DaogenCatalogEntity current = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(currentId));
                if (!FacadeGeneratorUtils.isFacadeGenerate(current)) continue;
                this.getImportList().add(packageFacade + "." + DaogenCatalogConstants.facadeDefName(current));
            }
            if (this.isModeHelper()) {
                baseName = DaogenHelperGenerator.toHelperClassName(this.getDaogenConfig().getGeneralProp("factory-def"));
            }
        }
        this.setImplementsInterface(baseName + ", java.io.Serializable");
    }

    @Override
    public void generateDaogenBody() throws IOException {
        if (this.isModeReal()) {
            this.addSerialVerUID();
            this.generateRealClass();
        } else {
            String facadeName;
            DaogenCatalogEntity current;
            this.addSerialVerUID();
            this.getWriter().println();
            this.getWriter().println("\tpublic " + this.getJavaName() + "() {");
            Iterator itEntity = this.getDaogenConfig().getIdSet().iterator();
            String packageFacadeImpl = this.getDaogenConfig().getGeneralProp("package-facade-data-impl");
            while (itEntity.hasNext()) {
                String currentId = (String)itEntity.next();
                current = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(currentId));
                if (!FacadeGeneratorUtils.isFacadeGenerate(current)) continue;
                facadeName = DaogenCatalogConstants.facadeDefName(current);
                String facadeNameImpl = packageFacadeImpl + "." + DaogenCatalogConstants.facadeImplDataName(current);
                String propertyName = GeneratorNameHelper.toPropertyName((String)facadeName);
                this.getWriter().println("\t\tthis." + propertyName + " = new " + facadeNameImpl + "();");
            }
            this.getWriter().println("\t}");
            this.getWriter().println();
            for (String currentId : this.getDaogenConfig().getIdSet()) {
                current = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(currentId));
                if (!FacadeGeneratorUtils.isFacadeGenerate(current)) continue;
                facadeName = DaogenCatalogConstants.facadeDefName(current);
                String propertyName = GeneratorNameHelper.toPropertyName((String)facadeName);
                this.getWriter().println("\tprivate " + facadeName + " " + propertyName + ";");
                this.getWriter().println();
                this.getWriter().println("\t@Override");
                this.getWriter().println("\tpublic " + facadeName + " get" + facadeName + "() throws " + this.getClassDaoException() + " {");
                this.getWriter().println("\t\treturn this." + propertyName + ";");
                this.getWriter().println("\t}");
                this.getWriter().println();
                this.getWriter().println("\tprotected void set" + facadeName + "( " + facadeName + " facade ) throws " + this.getClassDaoException() + " {");
                this.getWriter().println("\t\tthis." + propertyName + " = facade;");
                this.getWriter().println("\t}");
                this.getWriter().println();
            }
        }
    }
}

