/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.config.DaogenHelperGenerator;
import org.fugerit.java.daogen.base.gen.DaogenBasicHelperGenerator;
import org.fugerit.java.daogen.base.gen.util.FacadeGeneratorUtils;

public class FactoryDefGenerator
extends DaogenBasicHelperGenerator {
    public static final String KEY = FactoryDefGenerator.class.getSimpleName();

    public String getKey() {
        return KEY;
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        if (this.isModeHelper()) {
            super.init(DaogenHelperGenerator.toHelperSourceFolder(daogenConfig), DaogenHelperGenerator.toHelperClassName(daogenConfig.getGeneralProp("factory-def")), "interface", daogenConfig, null);
        } else {
            super.init(daogenConfig.getGeneralProp("src-main-java"), daogenConfig.getGeneralProp("factory-def"), "interface", daogenConfig, null);
        }
        if (this.isModeReal()) {
            this.configRealClass();
        } else {
            this.setClassDaoException(DaogenClassConfigHelper.addImport(daogenConfig, "dao.exception", this.getImportList()));
        }
    }

    @Override
    public void generateDaogenBody() throws IOException {
        if (this.isModeReal()) {
            this.generateRealClass();
        } else {
            this.getWriter().println("\tpublic static final String ATT_NAME = \"" + this.getJavaName() + "\";");
            this.getWriter().println();
            for (String currentId : this.getDaogenConfig().getIdSet()) {
                DaogenCatalogEntity current = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(currentId));
                if (!FacadeGeneratorUtils.isFacadeGenerate(current)) continue;
                String facadeName = DaogenCatalogConstants.facadeDefName(current);
                String packageFacade = this.getDaogenConfig().getGeneralProp("package-facade-def");
                this.getWriter().println("\t/**");
                this.getWriter().println("\t * Facade encapsulating persistance for entity : " + current.getName());
                this.getWriter().println("\t *");
                this.getWriter().println("\t * @return\tthe facade");
                this.getWriter().println("\t * @throws " + this.getClassDaoException() + "\t" + "in case of problems");
                this.getWriter().println("\t */");
                this.getWriter().println("\t" + packageFacade + "." + facadeName + " get" + facadeName + "() throws " + this.getClassDaoException() + ";");
                this.getWriter().println();
            }
        }
    }
}

