/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import java.math.BigDecimal;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.fugerit.java.daogen.base.gen.util.FacadeGeneratorUtils;

public class FinderGenerator
extends DaogenBasicGenerator {
    public static final String KEY = "FinderGenerator";

    public String getKey() {
        return KEY;
    }

    @Override
    public boolean isGenerate(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) {
        return FacadeGeneratorUtils.isFacadeGenerate(entity);
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        super.init(daogenConfig.getGeneralProp("src-main-java"), FinderGenerator.fullObjectName(daogenConfig.getGeneralProp("package-facade-def"), DaogenCatalogConstants.finderlName(entity)), "interface", daogenConfig, entity);
        this.setJavaStyle("class");
        String daoFinderNgMode = daogenConfig.getGeneralProp("dao-finder-ng-mode", "disabled");
        logger.info("{} -> {}", (Object)"dao-finder-ng-mode", (Object)daoFinderNgMode);
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + this.getEntityModelName());
        if ("disabled".equalsIgnoreCase(daoFinderNgMode)) {
            DaogenCatalogField idField = (DaogenCatalogField)((Object)entity.get("ID"));
            if (idField == null || this.getDaogenConfig().getTypeMapper().mapForModel(idField).equalsIgnoreCase(BigDecimal.class.getName())) {
                this.setClassBaseFinder(DaogenClassConfigHelper.addImport(daogenConfig, "dao.basefinder", this.getImportList()));
                this.setExtendsClass(this.getClassBaseFinder());
            } else {
                String type = this.getDaogenConfig().getTypeMapper().mapForModel(idField);
                this.setClassBaseFinder(DaogenClassConfigHelper.addImport(daogenConfig, "dao.genericfinder", this.getImportList()));
                this.setExtendsClass(this.getClassBaseFinder() + "<" + type + ">");
            }
        } else if ("enabled".equalsIgnoreCase(daoFinderNgMode)) {
            String finderNgClass = DaogenClassConfigHelper.findClassConfigProp(daogenConfig, "dao.finder.ng", "class");
            if (StringUtils.isNotEmpty((String)finderNgClass)) {
                this.setClassBaseHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.finder.ng", this.getImportList()));
                this.setExtendsClass(this.getClassBaseHelper());
            }
        } else {
            throw new ConfigException("Invalid dao-finder-ng-mode parameter : " + daoFinderNgMode);
        }
    }

    @Override
    public void generateDaogenBody() throws IOException {
        String daoFinderNgMode = this.getDaogenConfig().getGeneralProp("dao-finder-ng-mode", "disabled");
        this.generateSerial("disabled".equalsIgnoreCase(daoFinderNgMode));
        this.getWriter().println("\tprivate " + this.getEntityModelName() + " model;");
        this.getWriter().println();
        this.getWriter().println("\tpublic void setModel( " + this.getEntityModelName() + " model ) {");
        this.getWriter().println("\t\tthis.model = model;");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\tpublic " + this.getEntityModelName() + " getModel() {");
        this.getWriter().println("\t\treturn this.model;");
        this.getWriter().println("\t}");
        this.getWriter().println();
        if (this.getCurrentEntity().containsDefaultId()) {
            DaogenCatalogField idField = (DaogenCatalogField)((Object)this.getCurrentEntity().get("ID"));
            String type = this.getDaogenConfig().getTypeMapper().mapForModel(idField);
            this.getWriter().println("\t/**");
            this.getWriter().println("\t *Factory method to create a new finder ");
            this.getWriter().println("\t *");
            this.getWriter().println("\t * @param id\t\tid to wrap in the finder");
            this.getWriter().println("\t *");
            this.getWriter().println("\t * @return\tthe finder");
            this.getWriter().println("\t */");
            this.getWriter().println("\tpublic static " + this.getEntityFinderName() + " newInstance( " + type + " id ) { ");
            this.getWriter().println("\t\t" + this.getEntityFinderName() + " finder = new " + this.getEntityFinderName() + "();");
            this.getWriter().println("\t\tfinder.setId( id );");
            this.getWriter().println("\t\treturn finder;");
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
        this.getWriter().println("\t/**");
        this.getWriter().println("\t * Factory method to create a new finder ");
        this.getWriter().println("\t *");
        this.getWriter().println("\t * @param model\t\tthe model to wrap in the finder");
        this.getWriter().println("\t *");
        this.getWriter().println("\t * @return\tthe finder");
        this.getWriter().println("\t */");
        this.getWriter().println("\tpublic static " + this.getEntityFinderName() + " newInstance( " + this.getEntityModelName() + " model ) { ");
        this.getWriter().println("\t\t" + this.getEntityFinderName() + " finder = new " + this.getEntityFinderName() + "();");
        if (this.getCurrentEntity().containsDefaultId()) {
            this.getWriter().println("\t\tfinder.setId( model.getId() );");
        } else {
            this.getWriter().println("\t\t// default id not available for this entity");
        }
        this.getWriter().println("\t\tfinder.setModel( model );");
        this.getWriter().println("\t\treturn finder;");
        this.getWriter().println("\t}");
        this.getWriter().println();
    }
}

