/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.fugerit.java.nhg.GenerateReflectConfig;
import org.fugerit.java.nhg.reflect.config.Entry;
import org.fugerit.java.nhg.reflect.config.EntryMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraalVMReflectConfigGenerator
extends DaogenBasicGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraalVMReflectConfigGenerator.class);
    public static final String KEY = GraalVMReflectConfigGenerator.class.getSimpleName();

    public String getKey() {
        return KEY;
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        String sourceFolder = daogenConfig.getGeneralProp("src-main-resources");
        String jsonFile = daogenConfig.getGeneralProp("graalvm-reflect-config");
        super.setDaogenConfig(daogenConfig);
        super.init(sourceFolder, jsonFile, "class", daogenConfig, entity);
        File path = new File(new File(daogenConfig.getGeneralProp("base-src-folder"), sourceFolder), jsonFile);
        log.info("path : {}", (Object)path);
        this.setJavaFile(path);
    }

    @Override
    public void generateDaogenBody() throws IOException {
    }

    private void handleEntity(DaogenCatalogEntity entity, List<Entry> reflectConfig) {
        String[] entryNames;
        for (String name : entryNames = new String[]{GraalVMReflectConfigGenerator.fullObjectName(this.getDaogenConfig().getGeneralProp("package-model"), DaogenCatalogConstants.modelName(entity)), GraalVMReflectConfigGenerator.fullObjectName(this.getDaogenConfig().getGeneralProp("package-helper"), DaogenCatalogConstants.helperName(entity)), GraalVMReflectConfigGenerator.fullObjectName(this.getDaogenConfig().getGeneralProp("package-helper"), DaogenCatalogConstants.wrapperName(entity))}) {
            Entry entry = new Entry();
            log.info("name : {}", (Object)name);
            entry.setName(name);
            reflectConfig.add(entry);
            ArrayList<EntryMethod> methods = new ArrayList<EntryMethod>();
            methods.add(new EntryMethod("<init>"));
            methods.addAll(entity.getAllFields().stream().map(field -> {
                EntryMethod m = new EntryMethod();
                m.setName("get" + GeneratorNameHelper.toClassName((String)field.getId()));
                return m;
            }).collect(Collectors.toList()));
            methods.addAll(entity.getRelations().stream().map(relation -> {
                EntryMethod m = new EntryMethod();
                m.setName("get" + GeneratorNameHelper.toClassName((String)relation.getName()));
                return m;
            }).collect(Collectors.toList()));
            methods.add(new EntryMethod("isEmpty"));
            entry.setMethods(methods);
        }
    }

    public void generate() throws IOException {
        ArrayList entityIdList = new ArrayList(this.getDaogenConfig().getIdSet());
        Collections.sort(entityIdList);
        ArrayList<Entry> reflectConfig = new ArrayList<Entry>();
        for (String entityId : entityIdList) {
            DaogenCatalogEntity entity = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(entityId));
            log.info("native config for : {} -> {}", (Object)entity.getId(), (Object)entity.describe());
            this.handleEntity(entity, reflectConfig);
        }
        GenerateReflectConfig generateReflectConfig = new GenerateReflectConfig();
        generateReflectConfig.generate((Writer)this.getWriter(), reflectConfig);
    }
}

