/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.core.lang.compare.CheckEmptyHelper;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenCatalogRelation;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;

public class HelperGenerator
extends DaogenBasicGenerator {
    public static final String KEY = "HelperGenerator";

    public String getKey() {
        return KEY;
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        super.init(daogenConfig.getGeneralProp("src-main-java"), HelperGenerator.fullObjectName(daogenConfig.getGeneralProp("package-helper"), DaogenCatalogConstants.helperName(entity)), "class", daogenConfig, entity);
        String daoHelperNgMode = daogenConfig.getGeneralProp("dao-helper-ng-mode", "disabled");
        logger.info("{} -> {}", (Object)"dao-helper-ng-mode", (Object)daoHelperNgMode);
        if ("disabled".equalsIgnoreCase(daoHelperNgMode)) {
            this.setClassBaseHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.helper", this.getImportList()));
            this.setExtendsClass(this.getClassBaseHelper());
        } else if ("enabled".equalsIgnoreCase(daoHelperNgMode)) {
            String helperNgClass = DaogenClassConfigHelper.findClassConfigProp(daogenConfig, "dao.helper.ng", "class");
            if (StringUtils.isNotEmpty((String)helperNgClass)) {
                this.setClassBaseHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.helper.ng", this.getImportList()));
                this.setExtendsClass(this.getClassBaseHelper());
            }
        } else {
            throw new ConfigException("Invalid dao-helper-ng-mode parameter : " + daoHelperNgMode);
        }
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + this.getEntityModelName());
        this.setImplementsInterface(this.getEntityModelName());
        for (DaogenCatalogRelation relation : this.getCurrentEntity().getRelations()) {
            DaogenCatalogEntity entityTo = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(relation.getTo()));
            this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + DaogenCatalogConstants.modelName(entityTo));
        }
    }

    private void generateRelations() {
        if (!this.getCurrentEntity().getRelations().isEmpty()) {
            this.getWriter().println("\t/*");
            this.getWriter().println("\t * fields generated for relations ");
            this.getWriter().println("\t */");
            this.getWriter().println();
            for (DaogenCatalogRelation relation : this.getCurrentEntity().getRelations()) {
                DaogenCatalogEntity entityTo = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(relation.getTo()));
                String baseType = DaogenCatalogConstants.modelName(entityTo);
                String className = GeneratorNameHelper.toClassName((String)relation.getName());
                String propertyName = GeneratorNameHelper.toPropertyName((String)relation.getName());
                if ("many".equalsIgnoreCase(relation.getMode())) {
                    baseType = "java.util.List<" + baseType + ">";
                }
                this.getWriter().println("\tprivate " + baseType + " " + propertyName + ";");
                this.getWriter().println();
                this.getWriter().println("\t@Override");
                this.getWriter().println("\tpublic void set" + className + "( " + baseType + " value ) {");
                this.getWriter().println("\t\tthis." + propertyName + " = value;");
                this.getWriter().println("\t}");
                this.getWriter().println();
                this.getWriter().println("\t@Override");
                this.getWriter().println("\tpublic " + baseType + " get" + className + "() {");
                this.getWriter().println("\t\treturn this." + propertyName + ";");
                this.getWriter().println("\t}");
                this.getWriter().println();
            }
        }
    }

    @Override
    public void generateDaogenBody() throws IOException {
        String javaSuffix;
        String daoHelperNgMode = this.getDaogenConfig().getGeneralProp("dao-helper-ng-mode", "disabled");
        this.generateSerial("disabled".equalsIgnoreCase(daoHelperNgMode));
        boolean relationLast = "true".equalsIgnoreCase(this.getDaogenConfig().getGeneralProp("relations-last"));
        if (!relationLast) {
            this.generateRelations();
        }
        this.getWriter().println("\t/*");
        this.getWriter().println("\t * fields generated for entity attributes ");
        this.getWriter().println("\t */");
        for (Object field : this.getCurrentEntity().getAllFields()) {
            String javaProperty = GeneratorNameHelper.toPropertyName((String)field.getId());
            String javaSuffix2 = GeneratorNameHelper.toClassName((String)field.getId());
            String realJavaType = this.getDaogenConfig().getTypeMapper().mapForModel((DaogenCatalogField)((Object)field));
            this.getWriter().println("\tprivate " + realJavaType + " " + javaProperty + ";");
            this.getWriter().println();
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic void set" + javaSuffix2 + "( " + realJavaType + " value ) {");
            this.getWriter().println("\t\tthis." + javaProperty + " = value;");
            this.getWriter().println("\t}");
            this.getWriter().println();
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic " + realJavaType + " get" + javaSuffix2 + "() {");
            this.getWriter().println("\t\treturn this." + javaProperty + ";");
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
        if (relationLast) {
            this.generateRelations();
        }
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic String toString() {");
        this.getWriter().println("\t\tStringBuilder buffer = new StringBuilder();");
        this.getWriter().println("\t\tbuffer.append( this.getClass().getSimpleName() );");
        boolean firstColumn = true;
        for (DaogenCatalogField field : this.getCurrentEntity().getAllFields()) {
            String javaProperty = GeneratorNameHelper.toPropertyName((String)field.getId());
            javaSuffix = GeneratorNameHelper.toClassName((String)field.getId());
            if (firstColumn) {
                this.getWriter().println("\t\tbuffer.append( \"[" + javaProperty + "=\" );");
                firstColumn = false;
            } else {
                this.getWriter().println("\t\tbuffer.append( \"," + javaProperty + "=\" );");
            }
            this.getWriter().println("\t\tbuffer.append( this.get" + javaSuffix + "() );");
        }
        this.getWriter().println("\t\tbuffer.append( \"]\" );");
        this.getWriter().println("\t\treturn buffer.toString();");
        this.getWriter().println("\t}");
        this.getWriter().println();
        if (BooleanUtils.isTrue((String)this.getDaogenConfig().getGeneralProp("check-empty-interface"))) {
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic boolean isEmpty() {");
            String start = "";
            String end = "";
            for (int k = 0; k < this.getCurrentEntity().size(); ++k) {
                javaSuffix = GeneratorNameHelper.toClassName((String)((DaogenCatalogField)((Object)this.getCurrentEntity().get(k))).getId());
                if (k == 0) {
                    start = "return ";
                } else if (k == this.getCurrentEntity().size() - 1) {
                    start = " && ";
                    end = ";";
                } else {
                    start = " && ";
                }
                this.getWriter().println("\t\t" + start + " ( " + CheckEmptyHelper.class.getName() + ".isEmpty( this.get" + javaSuffix + "() ) )" + end);
            }
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
    }
}

