/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.io.helper.HelperIOException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.core.lang.compare.CheckEmpty;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenCatalogRelation;
import org.fugerit.java.daogen.base.config.DaogenCustomCode;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGenerator
extends DaogenBasicGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelGenerator.class);
    public static final String KEY = ModelGenerator.class.getSimpleName();

    public String getKey() {
        return KEY;
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        super.init(daogenConfig.getGeneralProp("src-main-java"), ModelGenerator.fullObjectName(daogenConfig.getGeneralProp("package-model"), DaogenCatalogConstants.modelName(entity)), "interface", daogenConfig, entity);
        if (BooleanUtils.isTrue((String)daogenConfig.getGeneralProp("check-empty-interface"))) {
            this.setExtendsClass(CheckEmpty.class.getName());
        }
    }

    private void generateRelations() throws IOException {
        for (DaogenCatalogRelation relation : this.getCurrentEntity().getRelations()) {
            DaogenCatalogEntity entityTo = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(relation.getTo()));
            try {
                String baseType = DaogenCatalogConstants.modelName(entityTo);
                String className = GeneratorNameHelper.toClassName((String)relation.getName());
                String propertyName = GeneratorNameHelper.toClassName((String)relation.getName());
                if ("many".equalsIgnoreCase(relation.getMode())) {
                    baseType = List.class.getName() + "<" + baseType + ">";
                }
                DaogenCustomCode.addCommentCommon("comments.common.getter", DaogenCustomCode.INDENT_1, (PrintWriter)this.getWriter(), propertyName, "yes", "relation to entity : " + entityTo.getName());
                this.println("\t" + baseType + " get" + className + "();");
                this.println();
                DaogenCustomCode.addCommentCommon("comments.common.setter", DaogenCustomCode.INDENT_1, (PrintWriter)this.getWriter(), propertyName, "yes", "relation to entity : " + entityTo.getName());
                this.println("\tvoid set" + className + "( " + baseType + " value );");
                this.println();
            }
            catch (Exception e) {
                log.error("error on relation : {}", (Object)relation.getId());
                throw HelperIOException.convertEx((Exception)e);
            }
        }
    }

    @Override
    public void generateDaogenBody() throws IOException {
        String valueRelationLast = this.getDaogenConfig().getGeneralProp("relations-last");
        boolean relationLast = BooleanUtils.isTrue((String)valueRelationLast);
        if (!relationLast) {
            this.generateRelations();
        }
        for (DaogenCatalogField field : this.getCurrentEntity().getAllFields()) {
            String propertyName = GeneratorNameHelper.toPropertyName((String)field.getId());
            String className = GeneratorNameHelper.toClassName((String)field.getId());
            String type = this.getDaogenConfig().getTypeMapper().mapForModel(field);
            DaogenCustomCode.addCommentCommon("comments.common.getter", DaogenCustomCode.INDENT_1, (PrintWriter)this.getWriter(), propertyName, field.getNullable(), field.getComments());
            this.println("\t" + type + " get" + className + "();");
            this.println();
            DaogenCustomCode.addCommentCommon("comments.common.setter", DaogenCustomCode.INDENT_1, (PrintWriter)this.getWriter(), propertyName, field.getNullable(), field.getComments());
            this.println("\tvoid set" + className + "( " + type + " value );");
            this.println();
        }
        if (relationLast) {
            this.generateRelations();
        }
    }
}

